/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.factory.vpi.custom.methods;

public enum XVPIBaseConverter {
    BIN_STR(1, 2, "'b"),
    DEC_STR(3, 10, "'d"),
    HEX_STR(4, 16, "'h"),
    OCT_STR(2, 8, "'o"),
    DEC_VAL(6, 10, "'d"),
    SCALAR_VAL(5, 2, "'b"),
    STRING_VAL(8, 2, "'b"),
    VECTOR_VAL(9, 9, "'b");

    private final int vpiConst;
    private final int radix;
    private String vlogBase;

    private XVPIBaseConverter(int vpiConst, int radix, String vlogBase) {
        this.vpiConst = vpiConst;
        this.radix = radix;
        this.vlogBase = vlogBase;
    }

    public static XVPIBaseConverter getBaseByVPIConst(int vpiConst) {
        XVPIBaseConverter[] values = XVPIBaseConverter.values();
        int i = 0;
        while (i < values.length) {
            if (values[i].vpiConst == vpiConst) {
                return values[i];
            }
            ++i;
        }
        return null;
    }

    public static XVPIBaseConverter getBaseByRadix(int radix) {
        XVPIBaseConverter[] values = XVPIBaseConverter.values();
        int i = 0;
        while (i < values.length) {
            if (values[i].radix == radix) {
                return values[i];
            }
            ++i;
        }
        return null;
    }

    public int getVpiConst() {
        return this.vpiConst;
    }

    public int getRadix() {
        return this.radix;
    }

    public String getVlogBase() {
        return this.vlogBase;
    }
}

