/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.factory.vpi.custom.methods;

import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XArrayValueHolder;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.interpreter.dpi.XAbstractCAPIType;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownMethodEvaluationException;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.dvt.utils.VlogRealNumber;
import ro.amiq.dvt.utils.XGlobalCache;
import ro.amiq.vlogdt.interpreter.factory.XVlogValueHolderFactory;
import ro.amiq.vlogdt.interpreter.factory.dpi.XVlogDPICTypeMapperManager;
import ro.amiq.vlogdt.interpreter.factory.systemc.XCPipeProtocol;
import ro.amiq.vlogdt.interpreter.factory.systemc.vpi.XVPIEntity;
import ro.amiq.vlogdt.interpreter.factory.vpi.custom.methods.XAbstractVPIUserMethod;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfScalarType;

public class XVPIGet
extends XAbstractVPIUserMethod {
    public static final String VPI_GET = "vpi_get";

    public XVPIGet(XVlogValueHolderFactory factoryContributor, XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope, int exportIdRequest) {
        super(factoryContributor, xAssociatedType, enclosing, instanceScope, exportIdRequest);
    }

    @Override
    public String getName() {
        return VPI_GET;
    }

    @Override
    public IELParamValue internalExecute(XValueHolder currentScopeEvaluator, HidEvalCenter.MethodCallStatement parentMethodCallStatement) throws Exception {
        XCPipeProtocol pipe = this.getCurrentPipe();
        if (!this.systemCFactory.hasNextInServerPipe()) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        int property = pipe.unpacker.unpackInt();
        if (!this.systemCFactory.hasNextInServerPipe()) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        int vpiHandleType = pipe.unpacker.unpackInt();
        if (!this.systemCFactory.hasNextInServerPipe()) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        int vpiHandleId = pipe.unpacker.unpackInt();
        XVPIEntity vpiEntity = this.systemCFactory.getVPIEntity(vpiHandleId);
        int propertyValue = this.body(property, vpiEntity);
        pipe.packer.packString("dvt_command_result_export_function").packInt(this.exportIdEvaluation).packInt(property).packInt(vpiHandleType).packInt(vpiHandleId).flush();
        pipe.packer.packInt(propertyValue).flush();
        return currentScopeEvaluator;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int body(int property, XVPIEntity vpiValue) {
        try {
            ELParamValueScope valueScope = vpiValue == null ? null : vpiValue.getValueScope();
            IELParamValue value = XUtils.getValue((ELParamValueScope)valueScope);
            IHidEvaluator scope = XUtils.getScope((ELParamValueScope)valueScope);
            String name = XUtils.getElementName((ELParamValueScope)valueScope);
            switch (property) {
                case 2: {
                    IELParamValue handleValue = XUtils.getValue((ELParamValueScope)valueScope);
                    XGlobalCache.TimeScale timeScale = null;
                    if (handleValue instanceof XValueHolder) {
                        scope = ((XValueHolder)handleValue).getInstanceScope();
                        timeScale = XUtils.getTimeScale((XValueHolder)((XValueHolder)scope));
                    } else {
                        int smallestScaleExponent = Integer.MAX_VALUE;
                        Map instanceValueHolders = this.factory.getInstanceValueHolders();
                        Iterator iterator = instanceValueHolders.entrySet().iterator();
                        while (true) {
                            if (!iterator.hasNext()) {
                                timeScale = XUtils.getTimeScale((XValueHolder)((XValueHolder)scope));
                                break;
                            }
                            Map.Entry instanceEntry = iterator.next();
                            XInstValueHolder instance = (XInstValueHolder)instanceEntry.getValue();
                            XGlobalCache.TimeScale internalTimeScale = XUtils.getTimeScale((XValueHolder)instance);
                            if (smallestScaleExponent <= internalTimeScale.scaleExponent) continue;
                            timeScale = internalTimeScale;
                            smallestScaleExponent = internalTimeScale.scaleExponent;
                            scope = instance;
                        }
                    }
                    BigDecimal currentSimTime = this.factory.getCurrentSimTime();
                    BigDecimal bigDecimalValue = currentSimTime.divide(timeScale.unit);
                    if (bigDecimalValue.scale() >= 1) return currentSimTime.intValue();
                    bigDecimalValue = bigDecimalValue.setScale(1);
                    return currentSimTime.intValue();
                }
                case 4: {
                    if (value instanceof ELParamValues.ParamValueNumber) {
                        return ((ELParamValues.ParamValueNumber)value).getDVTNumber().getSize();
                    }
                    if (!(value instanceof XArrayValueHolder)) throw new UnknownMethodEvaluationException("Cannot size of value " + value);
                    return ((XArrayValueHolder)value).size();
                }
                case 40: {
                    XAbstractCAPIType cType;
                    XAbstractCAPIType typeEq;
                    RfNamedElement associatedType;
                    boolean isParameterNoData;
                    IRfNamedElement element = value.getElement();
                    if (element == null) {
                        IRfNamedElement namedElement = ((XInstValueHolder)scope).getElInstance().getBinding(false);
                        List<RfField> parameters = ((RfModule)namedElement).getParametersWithPrefix(name, 384, 1, 1);
                        if (parameters == null) throw new UnknownMethodEvaluationException("Multiple parameters found with name " + name + " inside instance " + namedElement.getName());
                        if (parameters.size() != 1) {
                            throw new UnknownMethodEvaluationException("Multiple parameters found with name " + name + " inside instance " + namedElement.getName());
                        }
                        element = parameters.get(0);
                    }
                    boolean bl = isParameterNoData = element instanceof RfField && ((RfField)element).isParameterNoDataType();
                    if (isParameterNoData) {
                        DVTNumber dvtNumber = value.getDVTNumber();
                        if (dvtNumber instanceof VlogBitVector) {
                            if (!((VlogBitVector)dvtNumber).isString()) return 3;
                            return 6;
                        }
                        if (dvtNumber instanceof VlogRealNumber) {
                            return 2;
                        }
                    } else if (element instanceof RfField && (associatedType = LintUtils.getAssociatedFinalType((RfField)element)) instanceof RfScalarType && (typeEq = XVlogDPICTypeMapperManager.VLOG_TO_API_TYPE_AS_NUMBER.get(associatedType)) != null) {
                        return typeEq.getVpiConstType();
                    }
                    if ((cType = XVlogDPICTypeMapperManager.getInstance().mapTypeStub((IRfAssociatedTypeElement)element)) != null) return cType.getVpiConstType();
                    throw new UnknownMethodEvaluationException("Unable to compute equivalent c type of element " + element.getName());
                }
                case 78: {
                    if (vpiValue == null) throw new UnknownMethodEvaluationException("Unable to compute vpiIndex property for vpiHandle null");
                    int index = vpiValue.getArrayIndex();
                    if (index == -1) throw new UnknownMethodEvaluationException("Unable to compute vpiIndex property for vpiHandle null");
                    return index;
                }
                case 11: 
                case 12: {
                    XGlobalCache.TimeScale timeScale = null;
                    if (value instanceof XValueHolder) {
                        timeScale = XUtils.getTimeScale((XValueHolder)((XValueHolder)value).getInstanceScope());
                    } else {
                        int smallestScaleExponent = Integer.MAX_VALUE;
                        Map instanceValueHolders = this.factory.getInstanceValueHolders();
                        for (Map.Entry instanceEntry : instanceValueHolders.entrySet()) {
                            XInstValueHolder instance = (XInstValueHolder)instanceEntry.getValue();
                            XGlobalCache.TimeScale internalTimeScale = XUtils.getTimeScale((XValueHolder)instance);
                            if (smallestScaleExponent <= internalTimeScale.scaleExponent) continue;
                            timeScale = internalTimeScale;
                            smallestScaleExponent = internalTimeScale.scaleExponent;
                        }
                    }
                    if (timeScale == null) {
                        throw new UnknownMethodEvaluationException("Unable to compute timeScale for " + value);
                    }
                    if (property == 11) {
                        if (vpiValue != null) return timeScale.unitExponent - 15;
                        return timeScale.unitExponent - timeScale.scaleExponent - 15;
                    }
                    if (property != 12) throw new UnknownMethodEvaluationException("Unknown property received " + property);
                    return timeScale.unitExponent - timeScale.scaleExponent - 15;
                }
            }
            throw new UnknownMethodEvaluationException("Unknown property received " + property);
        }
        catch (UnknownMethodEvaluationException e) {
            this.factory.logError("Unknown evaluation of vpi_get(" + (vpiValue != null ? vpiValue.getId() : 0) + ", " + property + "). " + e.getMessage());
            return -1;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            this.factory.logError("Unknown evaluation of vpi_get(" + (vpiValue != null ? vpiValue.getId() : 0) + ", " + property + ")");
        }
        return -1;
    }
}

