/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.factory.vpi.custom.methods;

import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.interpreter.dpi.XAbstractCAPIType;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownMethodEvaluationException;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.interpreter.factory.XVlogValueHolderFactory;
import ro.amiq.vlogdt.interpreter.factory.dpi.XCAPIOpenHandlerType;
import ro.amiq.vlogdt.interpreter.factory.dpi.XVlogDPICTypeMapperManager;
import ro.amiq.vlogdt.interpreter.factory.systemc.XCPipeProtocol;
import ro.amiq.vlogdt.interpreter.factory.systemc.vpi.XVPIEntity;
import ro.amiq.vlogdt.interpreter.factory.vpi.custom.methods.XAbstractVPIUserMethod;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

public class XVPIGetStr
extends XAbstractVPIUserMethod {
    public static final String VPI_GET_STR = "vpi_get_str";

    public XVPIGetStr(XVlogValueHolderFactory factoryContributor, XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope, int exportIdRequest) {
        super(factoryContributor, xAssociatedType, enclosing, instanceScope, exportIdRequest);
    }

    @Override
    public String getName() {
        return VPI_GET_STR;
    }

    @Override
    public IELParamValue internalExecute(XValueHolder currentScopeEvaluator, HidEvalCenter.MethodCallStatement parentMethodCallStatement) throws Exception {
        XCPipeProtocol pipe = this.getCurrentPipe();
        if (!this.systemCFactory.hasNextInServerPipe()) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        int property = pipe.unpacker.unpackInt();
        if (!this.systemCFactory.hasNextInServerPipe()) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        pipe.unpacker.unpackInt();
        if (!this.systemCFactory.hasNextInServerPipe()) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        int vpiHandleId = pipe.unpacker.unpackInt();
        XVPIEntity vpiEntity = this.systemCFactory.getVPIEntity(vpiHandleId);
        String result = this.body(property, vpiEntity);
        if (result == null) {
            result = "";
        }
        pipe.packer.packString("dvt_command_result_export_function").packInt(this.exportIdEvaluation).packInt(property).packInt(vpiEntity.getType()).packInt(vpiHandleId).packString(result).flush();
        return currentScopeEvaluator;
    }

    private String body(int property, XVPIEntity vpiEntity) {
        try {
            ELParamValueScope valueScope = vpiEntity != null ? vpiEntity.getValueScope() : null;
            IHidEvaluator scope = XUtils.getScope((ELParamValueScope)valueScope);
            IELParamValue value = XUtils.getValue((ELParamValueScope)valueScope);
            String name = XUtils.getElementName((ELParamValueScope)valueScope);
            if (name == null) {
                throw new UnknownMethodEvaluationException("Unable to compute name for vpiHandle " + vpiEntity);
            }
            switch (property) {
                case 2: {
                    String[] split = DVTStringUtil.split((String)".", (String)name);
                    return split == null || split.length == 0 ? name : split[split.length - 1];
                }
                case 3: {
                    if (value instanceof XInstValueHolder) {
                        ElementPath instancePath = ((XInstValueHolder)value).getInstancePath();
                        return instancePath.toString(".");
                    }
                    if (scope instanceof XInstValueHolder) {
                        ElementPath instancePath = ((XInstValueHolder)scope).getInstancePath();
                        String path = instancePath.toString(".");
                        return DVTStringUtil.appendString((Object[])new Object[]{path, ".", name});
                    }
                    return name;
                }
                case 1: {
                    IRfNamedElement original;
                    IRfNamedElement iRfNamedElement = original = vpiEntity != null ? vpiEntity.getOriginal() : null;
                    if (!(original instanceof IRfAssociatedTypeElement)) break;
                    XAbstractCAPIType cType = XVlogDPICTypeMapperManager.getInstance().mapTypeStub((IRfAssociatedTypeElement)original);
                    if (cType == null) {
                        throw new UnknownMethodEvaluationException("Unable to compute equivalent C type " + original);
                    }
                    if (cType != XCAPIOpenHandlerType.OPEN_HANDLER_EQ) {
                        return cType.getVpiConstName();
                    }
                    if (vpiEntity == null || vpiEntity.getArrayIndex() == -1) break;
                    RfNamedElement associatedType = LintUtils.getAssociatedFinalType((IRfAssociatedTypeElement)original);
                    if (associatedType == null) {
                        throw new UnknownMethodEvaluationException("Unable to compute associated type of " + original.getNameAndEnclosing());
                    }
                    XAbstractCAPIType type = XVlogDPICTypeMapperManager.VLOG_TO_API_TYPE_AS_NUMBER.get(associatedType);
                    if (type == null) break;
                    return type.getVpiConstName();
                }
            }
            throw new UnknownMethodEvaluationException("Unknown property received " + property);
        }
        catch (UnknownMethodEvaluationException e) {
            this.factory.logError("Unknown evaluation of vpi_get_str(" + (vpiEntity != null ? Integer.valueOf(vpiEntity.getId()) : null) + ", " + property + "). " + e.getMessage());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            this.factory.logError("Unknown evaluation of vpi_get_str(" + (vpiEntity != null ? Integer.valueOf(vpiEntity.getId()) : null) + ", " + property + ")");
        }
        return "";
    }
}

