/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.factory.vpi.custom.methods;

import java.math.BigDecimal;
import java.util.Map;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownEvaluationException;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownMethodEvaluationException;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.XGlobalCache;
import ro.amiq.vlogdt.interpreter.factory.XVlogValueHolderFactory;
import ro.amiq.vlogdt.interpreter.factory.systemc.XCPipeProtocol;
import ro.amiq.vlogdt.interpreter.factory.systemc.vpi.XVPIEntity;
import ro.amiq.vlogdt.interpreter.factory.vpi.custom.methods.XAbstractVPIUserMethod;
import ro.amiq.vlogdt.interpreter.factory.vpi.custom.methods.XTypeVPITime;

public class XVPIGetTime
extends XAbstractVPIUserMethod {
    public static final String VPI_GET_TIME = "vpi_get_time";

    public XVPIGetTime(XVlogValueHolderFactory factoryContributor, XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope, int exportIdRequest) {
        super(factoryContributor, xAssociatedType, enclosing, instanceScope, exportIdRequest);
    }

    @Override
    public String getName() {
        return VPI_GET_TIME;
    }

    @Override
    public IELParamValue internalExecute(XValueHolder currentScopeEvaluator, HidEvalCenter.MethodCallStatement parentMethodCallStatement) throws Exception {
        XCPipeProtocol pipe = this.getCurrentPipe();
        if (!this.systemCFactory.hasNextInServerPipe()) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        int vpiHandleType = pipe.unpacker.unpackInt();
        if (!this.systemCFactory.hasNextInServerPipe()) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        int vpiHandleId = pipe.unpacker.unpackInt();
        if (!this.systemCFactory.hasNextInServerPipe()) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        int vpiTimeType = pipe.unpacker.unpackInt();
        if (!this.systemCFactory.hasNextInServerPipe()) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        long vpiTimeHigh = pipe.unpacker.unpackLong();
        if (!this.systemCFactory.hasNextInServerPipe()) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        long vpiTimeLow = pipe.unpacker.unpackLong();
        if (!this.systemCFactory.hasNextInServerPipe()) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        double vpiTimeReal = pipe.unpacker.unpackDouble();
        XTypeVPITime vpiTime = new XTypeVPITime(vpiTimeType, vpiTimeHigh, vpiTimeLow, vpiTimeReal);
        this.body(vpiHandleId, vpiTime);
        pipe.packer.packString("dvt_command_result_export_function").packInt(this.exportIdEvaluation).packInt(vpiHandleType).packInt(vpiHandleId).flush();
        pipe.packer.packInt(vpiTime.type).packLong(vpiTime.high).packLong(vpiTime.low).packDouble(vpiTime.real).flush();
        return currentScopeEvaluator;
    }

    private void body(int vpiHandleId, XTypeVPITime vpiTime) {
        try {
            XVPIEntity vpiEntity = this.systemCFactory.getVPIEntity(vpiHandleId);
            ELParamValueScope valueScope = vpiEntity == null ? null : vpiEntity.getValueScope();
            switch (vpiTime.type) {
                case 1: 
                case 2: {
                    IELParamValue handleValue = XUtils.getValue((ELParamValueScope)valueScope);
                    XInstValueHolder scope = null;
                    XGlobalCache.TimeScale timeScale = null;
                    if (handleValue instanceof XValueHolder) {
                        scope = ((XValueHolder)handleValue).getInstanceScope();
                        timeScale = XUtils.getTimeScale((XValueHolder)scope);
                    } else {
                        int smallestScaleExponent = Integer.MAX_VALUE;
                        Map instanceValueHolders = this.factory.getInstanceValueHolders();
                        for (Map.Entry instanceEntry : instanceValueHolders.entrySet()) {
                            XInstValueHolder instance = (XInstValueHolder)instanceEntry.getValue();
                            XGlobalCache.TimeScale internalTimeScale = XUtils.getTimeScale((XValueHolder)instance);
                            if (smallestScaleExponent <= internalTimeScale.scaleExponent) continue;
                            timeScale = internalTimeScale;
                            smallestScaleExponent = internalTimeScale.scaleExponent;
                            scope = instance;
                        }
                        timeScale = XUtils.getTimeScale((XValueHolder)scope);
                    }
                    BigDecimal currentSimTime = this.factory.getCurrentSimTime();
                    BigDecimal value = currentSimTime.divide(timeScale.unit);
                    if (value.scale() < 1) {
                        value = value.setScale(1);
                    }
                    if (vpiTime.type == 2) {
                        vpiTime.high = vpiTime.low = (long)currentSimTime.intValue();
                        vpiTime.real = currentSimTime.doubleValue();
                    } else if (vpiTime.type == 1) {
                        vpiTime.real = value.doubleValue();
                    }
                    break;
                }
                default: {
                    throw new UnknownMethodEvaluationException("Unknown evaluation for vpi_get_time, specified value is " + vpiTime);
                }
            }
        }
        catch (UnknownEvaluationException e) {
            this.factory.logError("Unknown evaluation of vpi_get_time(" + vpiHandleId + ", " + vpiTime + "). " + e.getMessage());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            this.factory.logError("Unknown evaluation of vpi_get_time(" + vpiHandleId + ", " + vpiTime + ")");
        }
    }
}

