/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.factory.vpi.custom.methods;

import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.IXDVTDPICUtils;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownMethodEvaluationException;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.MaskType;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.dvt.utils.VlogRealNumber;
import ro.amiq.vlogdt.interpreter.factory.XVlogValueHolderFactory;
import ro.amiq.vlogdt.interpreter.factory.dpi.XVlogDPICTypeMapperManager;
import ro.amiq.vlogdt.interpreter.factory.dpi.custom.methods.XDPICSVCustomMethodsUtils;
import ro.amiq.vlogdt.interpreter.factory.systemc.XCPipeProtocol;
import ro.amiq.vlogdt.interpreter.factory.systemc.vpi.XVPIEntity;
import ro.amiq.vlogdt.interpreter.factory.vpi.custom.methods.XAbstractVPIUserMethod;
import ro.amiq.vlogdt.interpreter.factory.vpi.custom.methods.XTypeVPIValue;
import ro.amiq.vlogdt.interpreter.factory.vpi.custom.methods.XVPIBaseConverter;

public class XVPIGetValue
extends XAbstractVPIUserMethod {
    public static final String VPI_GET_VALUE = "vpi_get_value";

    public XVPIGetValue(XVlogValueHolderFactory factoryContributor, XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope, int exportIdRequest) {
        super(factoryContributor, xAssociatedType, enclosing, instanceScope, exportIdRequest);
    }

    @Override
    public String getName() {
        return VPI_GET_VALUE;
    }

    @Override
    public IELParamValue internalExecute(XValueHolder currentScopeEvaluator, HidEvalCenter.MethodCallStatement parentMethodCallStatement) throws Exception {
        XCPipeProtocol pipe = this.getCurrentPipe();
        if (!this.systemCFactory.hasNextInServerPipe()) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        int vpiHandleType = pipe.unpacker.unpackInt();
        if (!this.systemCFactory.hasNextInServerPipe()) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        int vpiHandleId = pipe.unpacker.unpackInt();
        if (!this.systemCFactory.hasNextInServerPipe()) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        XTypeVPIValue vpiValue = new XTypeVPIValue();
        vpiValue.format = pipe.unpacker.unpackInt();
        if (!this.systemCFactory.hasNextInServerPipe()) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        XVPIEntity vpiEntity = this.systemCFactory.getVPIEntity(vpiHandleId);
        ELParamValueScope valueScope = vpiEntity.getValueScope();
        IRfAssociatedTypeElement element = (IRfAssociatedTypeElement)valueScope.getElement();
        try {
            switch (vpiValue.format) {
                case 5: {
                    vpiValue.value.scalar = pipe.unpacker.unpackInt();
                    break;
                }
                case 6: {
                    vpiValue.value.integer = pipe.unpacker.unpackInt();
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 8: {
                    vpiValue.value.str = pipe.unpacker.unpackString();
                    break;
                }
                case 12: {
                    pipe.unpacker.unpackInt();
                    break;
                }
                case 16: {
                    vpiValue.value.real = pipe.unpacker.unpackFloat();
                    break;
                }
                case 7: {
                    vpiValue.value.real = pipe.unpacker.unpackDouble();
                    break;
                }
                case 9: {
                    vpiValue.value.vector = XVlogDPICTypeMapperManager.getInstance().unpackLogicStream(XUtils.getValue((ELParamValueScope)valueScope), element, this.systemCFactory, pipe);
                    break;
                }
                default: {
                    throw new UnknownMethodEvaluationException("Unsupported format " + vpiValue.format);
                }
            }
        }
        catch (UnknownMethodEvaluationException e) {
            this.factory.logError("Unknown evaluation of vpi_get_value(" + vpiHandleId + ", " + vpiValue.format + "). " + e.getMessage());
        }
        catch (Exception exception) {
            this.factory.logError("Unknown evaluation of vpi_get_value(" + vpiHandleId + ", " + vpiValue.format + ")");
        }
        this.body(vpiEntity, vpiValue);
        pipe.packer.packString("dvt_command_result_export_function").packInt(this.exportIdEvaluation).packInt(vpiHandleType).packInt(vpiHandleId).packInt(vpiValue.format).flush();
        try {
            switch (vpiValue.format) {
                case 5: {
                    pipe.packer.packInt(vpiValue.value.scalar).flush();
                    break;
                }
                case 6: {
                    pipe.packer.packInt(vpiValue.value.integer).flush();
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 8: {
                    pipe.packer.packString(vpiValue.value.str).flush();
                    break;
                }
                case 12: {
                    pipe.packer.packInt(vpiValue.value.integer).flush();
                    break;
                }
                case 16: {
                    pipe.packer.packFloat((float)vpiValue.value.real).flush();
                    break;
                }
                case 7: {
                    pipe.packer.packDouble(vpiValue.value.real).flush();
                    break;
                }
                case 9: {
                    XVlogDPICTypeMapperManager.getInstance().packBitVector(vpiValue.value.vector, IXDVTDPICUtils.getRecursiveResolvedType((IRfNamedElement)element.getResolvedType(true)), pipe.packer, true);
                    pipe.packer.flush();
                    break;
                }
                default: {
                    throw new UnknownMethodEvaluationException("Unable to send format " + vpiValue.format);
                }
            }
        }
        catch (UnknownMethodEvaluationException e) {
            this.factory.logError("Unknown evaluation of vpi_get_value(" + vpiHandleId + ", " + vpiValue.format + "). " + e.getMessage());
        }
        catch (Exception exception) {
            this.factory.logError("Unknown evaluation of vpi_get_value(" + vpiHandleId + ", " + vpiValue.format + ")");
        }
        return currentScopeEvaluator;
    }

    private void body(XVPIEntity vpiEntity, XTypeVPIValue vpiValue) {
        ELParamValueScope valueScope = vpiEntity != null ? vpiEntity.getValueScope() : null;
        IELParamValue value = XUtils.getValue((ELParamValueScope)valueScope);
        IHidObject hidObject = XUtils.getHidObject((ELParamValueScope)valueScope);
        DVTNumber dvtNumber = value.getDVTNumber();
        XVPIBaseConverter base = XVPIBaseConverter.getBaseByVPIConst(vpiValue.format);
        try {
            switch (vpiValue.format) {
                case 5: {
                    vpiValue.value.scalar = dvtNumber.hasMask(new MaskType[]{MaskType.X}) ? 3 : (dvtNumber.hasMask(new MaskType[]{MaskType.Z}) ? 2 : XDPICSVCustomMethodsUtils.dvtNumberToVPIScalar(dvtNumber));
                    break;
                }
                case 6: {
                    vpiValue.value.integer = dvtNumber.bigIntegerValue().intValue();
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    vpiValue.value.str = dvtNumber.toBitVector().toString(base.getRadix(), false, true);
                    break;
                }
                case 8: {
                    vpiValue.value.str = ELUtils.valueToString((IELParamValue)value);
                    break;
                }
                case 7: {
                    if (dvtNumber instanceof VlogRealNumber) {
                        vpiValue.value.real = dvtNumber.doubleValue();
                        return;
                    }
                    if (dvtNumber instanceof VlogBitVector) {
                        vpiValue.value.real = ((VlogBitVector)dvtNumber).bigIntegerValue().doubleValue();
                        return;
                    }
                    break;
                }
                case 12: {
                    if (hidObject != null) {
                        if (dvtNumber instanceof VlogRealNumber) {
                            vpiValue.value.integer = 7;
                            return;
                        }
                        switch (hidObject.getHidKind()) {
                            case IMPLICIT: {
                                if (((HidImplicit)hidObject).isStringLiteral()) {
                                    vpiValue.value.integer = 8;
                                    return;
                                }
                                if (((HidImplicit)hidObject).isNumber()) {
                                    String hidName = ((HidImplicit)hidObject).getName();
                                    int tickIndex = hidName.indexOf("'");
                                    if (tickIndex > 0) {
                                        char baseSign = hidName.charAt(tickIndex + 1);
                                        if (baseSign == 's') {
                                            baseSign = hidName.charAt(tickIndex + 2);
                                        }
                                        switch (baseSign) {
                                            case 'B': 
                                            case 'b': {
                                                vpiValue.value.integer = 1;
                                                return;
                                            }
                                            case 'D': 
                                            case 'd': {
                                                vpiValue.value.integer = 3;
                                                return;
                                            }
                                            case 'H': 
                                            case 'h': {
                                                vpiValue.value.integer = 4;
                                                return;
                                            }
                                            case 'O': 
                                            case 'o': {
                                                vpiValue.value.integer = 2;
                                                return;
                                            }
                                        }
                                        break;
                                    }
                                    vpiValue.value.integer = 3;
                                    return;
                                }
                            }
                            case HID: 
                            case ACCESS: 
                            case OPERATOR: {
                                if (!(dvtNumber instanceof VlogBitVector)) break;
                                vpiValue.value.integer = ((VlogBitVector)dvtNumber).isString() ? 8 : 1;
                                return;
                            }
                        }
                    }
                    vpiValue.value.integer = 0;
                    break;
                }
                case 9: {
                    vpiValue.value.vector = value;
                    break;
                }
                default: {
                    throw new UnknownMethodEvaluationException("Unsupported vpiValue format " + vpiValue.format);
                }
            }
        }
        catch (UnknownMethodEvaluationException e) {
            this.factory.logError("Unknown evaluation of vpi_get_value(" + (vpiEntity != null ? Integer.valueOf(vpiEntity.getId()) : null) + ", " + vpiValue.format + "). " + e.getMessage());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            this.factory.logError("Unknown evaluation of vpi_get_value(" + (vpiEntity != null ? Integer.valueOf(vpiEntity.getId()) : null) + ", " + vpiValue.format + ")");
        }
    }
}

