/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.factory.vpi.custom.methods;

import java.math.BigInteger;
import java.util.List;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XArrayValueHolder;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownEvaluationException;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownMethodEvaluationException;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.vlogdt.interpreter.factory.XVlogValueHolderFactory;
import ro.amiq.vlogdt.interpreter.factory.systemc.XCPipeProtocol;
import ro.amiq.vlogdt.interpreter.factory.systemc.vpi.XVPIEntity;
import ro.amiq.vlogdt.interpreter.factory.vpi.custom.methods.XAbstractVPIUserMethod;

public class XVPIHandle
extends XAbstractVPIUserMethod {
    public static final String VPI_HANDLE = "vpi_handle";

    public XVPIHandle(XVlogValueHolderFactory factoryContributor, XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope, int exportIdRequest) {
        super(factoryContributor, xAssociatedType, enclosing, instanceScope, exportIdRequest);
    }

    @Override
    public String getName() {
        return VPI_HANDLE;
    }

    @Override
    public IELParamValue internalExecute(XValueHolder currentScopeEvaluator, HidEvalCenter.MethodCallStatement parentMethodCallStatement) throws Exception {
        XCPipeProtocol pipe = this.getCurrentPipe();
        if (!this.systemCFactory.hasNextInServerPipe()) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        int type = pipe.unpacker.unpackInt();
        if (!this.systemCFactory.hasNextInServerPipe()) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        int vpiHandleType = pipe.unpacker.unpackInt();
        if (!this.systemCFactory.hasNextInServerPipe()) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        int vpiHandleId = pipe.unpacker.unpackInt();
        int id = this.body(vpiHandleId, type);
        if (id == -1) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        pipe.packer.packString("dvt_command_result_export_function").packInt(this.exportIdEvaluation).packInt(type).packInt(vpiHandleType).packInt(vpiHandleId).flush();
        pipe.packer.packInt(type).packInt(id).flush();
        return currentScopeEvaluator;
    }

    private int body(int vpiHandle, int type) {
        try {
            XVPIEntity vpiEntity = this.systemCFactory.getVPIEntity(vpiHandle);
            switch (type) {
                case 78: {
                    ELParamValueScope valueScope = vpiEntity != null ? vpiEntity.getValueScope() : null;
                    IELParamValue value = XUtils.getValue((ELParamValueScope)valueScope);
                    IHidEvaluator scope = XUtils.getScope((ELParamValueScope)valueScope);
                    if (scope instanceof XArrayValueHolder) {
                        List zValues = ((XArrayValueHolder)scope).getZValues();
                        int index = 0;
                        for (IELParamValue zValue : zValues) {
                            if (value == zValue) {
                                IELParamValue indexValue = ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)31, (int)0, (int[])new int[0], (boolean)false, (boolean)false, (BigInteger)BigInteger.valueOf(index)));
                                XVPIEntity registeredEntity = this.systemCFactory.registerVPIEntity(type, ELParamValueScope.of((IELParamValue)indexValue, (IHidEvaluator)value), index);
                                return registeredEntity.id;
                            }
                            ++index;
                        }
                    }
                    throw new UnknownMethodEvaluationException("Unable to compute vpiIndex property for entity " + vpiHandle);
                }
                case 85: {
                    String name = XUtils.getName((IRfNamedElement)this.getNamedElement());
                    return this.systemCFactory.registerVPIEntity((int)type, (ELParamValueScope)ELParamValueScope.of((IELParamValue)this, (IHidEvaluator)this.enclosing, (String)name, null), (int)-1).id;
                }
                case 115: {
                    if (vpiEntity == null) {
                        throw new UnknownMethodEvaluationException("Unable to compute entity for id  " + vpiHandle);
                    }
                    return this.systemCFactory.registerVPIEntity((int)type, (ELParamValueScope)vpiEntity.getValueScope(), (int)-1).id;
                }
                case 79: 
                case 83: {
                    if (vpiEntity == null) {
                        throw new UnknownMethodEvaluationException("Unable to compute entity for id  " + vpiHandle);
                    }
                    IELParamValue value = XUtils.getValue((ELParamValueScope)vpiEntity.getValueScope());
                    DVTNumber dvtNumber = value.getDVTNumber();
                    if (dvtNumber instanceof VlogBitVector) {
                        VlogBitVector bitVector = (VlogBitVector)dvtNumber;
                        int[] dimension = bitVector.getFirstDimension();
                        if (dimension == null || dimension.length != 2) {
                            throw new UnknownMethodEvaluationException("Unable to compute lsb/msb for entity " + vpiHandle);
                        }
                        int range = type == 79 ? dimension[0] : dimension[1];
                        IELParamValue rangeValue = ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)32, (int)0, (BigInteger)BigInteger.valueOf(range)));
                        return this.systemCFactory.registerVPIEntity((int)type, (ELParamValueScope)ELParamValueScope.of((IELParamValue)rangeValue, (IHidEvaluator)value), (int)-1).id;
                    }
                    throw new UnknownMethodEvaluationException("Unable to compute range for entity " + vpiHandle);
                }
                case 84: {
                    if (vpiEntity == null || vpiHandle == 0) {
                        return this.systemCFactory.registerVPIEntity((int)type, (ELParamValueScope)ELParamValueScope.of((IELParamValue)this, (IHidEvaluator)this.enclosing, (String)XUtils.getName((IRfNamedElement)this.getNamedElement()), null), (int)-1).id;
                    }
                    IELParamValue value = XUtils.getValue((ELParamValueScope)vpiEntity.getValueScope());
                    IHidEvaluator enclosingValue = XUtils.getEnclosingEvaluator((IHidEvaluator)value, XVlogValueHolderFactory.VPI_SCOPES);
                    if (!(enclosingValue instanceof XValueHolder)) {
                        throw new UnknownMethodEvaluationException("Unable to compute enclosing scope of " + value);
                    }
                    if (enclosingValue instanceof XInstValueHolder) {
                        IRfInstanceElement member = ((XInstValueHolder)enclosingValue).getElInstance().getDescription();
                        String name = XUtils.getName((IRfNamedElement)member);
                        return this.systemCFactory.registerVPIEntity((int)type, (ELParamValueScope)ELParamValueScope.of((IELParamValue)((IELParamValue)enclosingValue), (IHidEvaluator)((XValueHolder)enclosingValue).getEnclosingValue(), (String)name, null), (int)-1).id;
                    }
                    String name = XUtils.getName((IRfNamedElement)((XValueHolder)enclosingValue).getElement());
                    return this.systemCFactory.registerVPIEntity((int)type, (ELParamValueScope)ELParamValueScope.of((IELParamValue)((IELParamValue)enclosingValue), (IHidEvaluator)((XValueHolder)enclosingValue).getEnclosingValue(), (String)name, null), (int)-1).id;
                }
            }
            throw new UnknownMethodEvaluationException("Unsupported type " + type);
        }
        catch (UnknownEvaluationException e) {
            this.factory.logError("Unknown evaluation of vpi_handle(" + vpiHandle + ", " + type + "). " + e.getMessage());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            this.factory.logError("Unknown evaluation of vpi_handle(" + vpiHandle + ", " + type + ")");
        }
        return -1;
    }
}

