/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.factory.vpi.custom.methods;

import java.util.ArrayList;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XArrayValueHolder;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicitConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownMethodEvaluationException;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.vlogdt.interpreter.factory.XVlogValueHolderFactory;
import ro.amiq.vlogdt.interpreter.factory.systemc.XCPipeProtocol;
import ro.amiq.vlogdt.interpreter.factory.systemc.XSystemCFactory;
import ro.amiq.vlogdt.interpreter.factory.systemc.vpi.XVPIEntity;
import ro.amiq.vlogdt.interpreter.factory.vpi.custom.methods.XAbstractVPIUserMethod;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.STransformer;

public class XVPIHandleByIndex
extends XAbstractVPIUserMethod {
    public static final String VPI_HANDLE_BY_INDEX = "vpi_handle_by_index";

    public XVPIHandleByIndex(XVlogValueHolderFactory factoryContributor, XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope, int exportIdRequest) {
        super(factoryContributor, xAssociatedType, enclosing, instanceScope, exportIdRequest);
    }

    @Override
    public String getName() {
        return VPI_HANDLE_BY_INDEX;
    }

    @Override
    public IELParamValue internalExecute(XValueHolder currentScopeEvaluator, HidEvalCenter.MethodCallStatement parentMethodCallStatement) throws Exception {
        XCPipeProtocol pipe = this.getCurrentPipe();
        if (!this.systemCFactory.hasNextInServerPipe()) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        int vpiHandleType = pipe.unpacker.unpackInt();
        if (!this.systemCFactory.hasNextInServerPipe()) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        int vpiHandleId = pipe.unpacker.unpackInt();
        if (!this.systemCFactory.hasNextInServerPipe()) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        int indx = pipe.unpacker.unpackInt();
        XVPIEntity handle = this.body(this.systemCFactory, vpiHandleId, indx);
        if (handle == null) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        pipe.packer.packString("dvt_command_result_export_function").packInt(this.exportIdEvaluation).packInt(vpiHandleType).packInt(vpiHandleId).packInt(indx).flush();
        pipe.packer.packInt(handle.getType()).packInt(handle.getId()).flush();
        return currentScopeEvaluator;
    }

    private XVPIEntity body(XSystemCFactory systemCFactory, int vpiHandleId, int indx) {
        try {
            XVPIEntity entity = systemCFactory.getVPIEntity(vpiHandleId);
            if (entity == null) {
                throw new UnknownMethodEvaluationException("Unable to find entity with id  " + vpiHandleId);
            }
            ELParamValueScope valueScope = entity.getValueScope();
            IELParamValue value = XUtils.getValue((ELParamValueScope)valueScope);
            String elementName = XUtils.getElementName((ELParamValueScope)valueScope);
            IRfNamedElement original = XUtils.getElement((ELParamValueScope)valueScope);
            String slicedName = DVTStringUtil.appendString((Object[])new Object[]{original != null ? original.getName() : elementName, "[", indx, "]"});
            if (value instanceof XArrayValueHolder) {
                IELParamValue zValue = ((XArrayValueHolder)value).getZValue(indx);
                XVPIEntity newEntity = systemCFactory.registerVPIEntity(78, ELParamValueScope.of((IELParamValue)zValue, (IHidEvaluator)value, (String)slicedName, null), indx);
                newEntity.setOriginal(original);
                return newEntity;
            }
            if (value instanceof ELParamValues.ParamValueNumber && (dvtNumber = ((ELParamValues.ParamValueNumber)value).getDVTNumber()) instanceof VlogBitVector) {
                VlogBitVector range = ((VlogBitVector)dvtNumber).getRange(indx - 1, indx - 1);
                IELParamValue slice = ELParamValues.ParamValueNumber.of((DVTNumber)range);
                IHidObject prevHidObject = XUtils.getHidObject((ELParamValueScope)valueScope);
                ArrayList<HidImplicit> prevSelects = new ArrayList<HidImplicit>();
                if (prevHidObject instanceof HidAccess var16_20) {
                    prevSelects.addAll(prevHidAccess.getSelects());
                    hid = prevHidAccess.getParentHid();
                } else {
                     instanceOfPatternExpressionValue = prevHidObject;
                    hid =  instanceOfPatternExpressionValue instanceof Hid && (var18_23 = (Hid) instanceOfPatternExpressionValue) == (Hid) instanceOfPatternExpressionValue ? prevHid : STransformer.BUILDERS.buildHid(elementName, null, HidOccurrence.DUMMY_OCCURRENCE, -1L);
                }
                prevSelects.add(STransformer.BUILDERS.buildImplicit(String.valueOf(indx), IHidImplicitConstants.ImplicitType.QUA_NUMBER.id));
                XVPIEntity newEntity = systemCFactory.registerVPIEntity(78, ELParamValueScope.of((IELParamValue)slice, (IHidEvaluator)value, (String)slicedName, (IHidObject)STransformer.BUILDERS.buildAccess(hid, null, prevSelects, Integer.MIN_VALUE)), indx);
                newEntity.setOriginal(original);
                return newEntity;
            }
            throw new UnknownMethodEvaluationException("Unsupported vpi_handle_by_index for value " + value);
        }
        catch (UnknownMethodEvaluationException e) {
            this.factory.logError("Unknown evaluation of vpi_handle_by_index(" + vpiHandleId + ", " + indx + "). " + e.getMessage());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            this.factory.logError("Unknown evaluation of vpi_handle_by_index(" + vpiHandleId + ", " + indx + ")");
        }
        return XVPIEntity.DUMMY_ENTITY;
    }
}

