/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.factory.vpi.custom.methods;

import java.util.Arrays;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.IXSim;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicitConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownEvaluationException;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownMethodEvaluationException;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.vlogdt.interpreter.factory.XVlogValueHolderFactory;
import ro.amiq.vlogdt.interpreter.factory.systemc.XCPipeProtocol;
import ro.amiq.vlogdt.interpreter.factory.systemc.XSystemCFactory;
import ro.amiq.vlogdt.interpreter.factory.systemc.vpi.XVPIEntity;
import ro.amiq.vlogdt.interpreter.factory.vpi.custom.methods.XAbstractVPIUserMethod;
import ro.amiq.vlogdt.interpreter.utils.XVlogContributorUtils;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.STransformer;

public class XVPIHandleByName
extends XAbstractVPIUserMethod {
    public static final Pattern SELECT_PATTERN = Pattern.compile("(\\s*\\w+\\s*)\\[(\\s*\\d+\\s*)(?::(\\s*\\d+\\s*))?\\]");
    public static final String VPI_HANDLE_BY_NAME = "vpi_handle_by_name";

    public XVPIHandleByName(XVlogValueHolderFactory factoryContributor, XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope, int exportIdRequest) {
        super(factoryContributor, xAssociatedType, enclosing, instanceScope, exportIdRequest);
    }

    @Override
    public String getName() {
        return VPI_HANDLE_BY_NAME;
    }

    @Override
    public IELParamValue internalExecute(XValueHolder currentScopeEvaluator, HidEvalCenter.MethodCallStatement parentMethodCallStatement) throws Exception {
        XCPipeProtocol pipe = this.getCurrentPipe();
        if (!this.systemCFactory.hasNextInServerPipe()) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        String name = pipe.unpacker.unpackString();
        if (!this.systemCFactory.hasNextInServerPipe()) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        int type = pipe.unpacker.unpackInt();
        if (!this.systemCFactory.hasNextInServerPipe()) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        int vpiHandleScope = pipe.unpacker.unpackInt();
        int id = this.body(this.systemCFactory, currentScopeEvaluator, vpiHandleScope, name);
        pipe.packer.packString("dvt_command_result_export_function").packInt(this.exportIdEvaluation).packString(name).packInt(type).packInt(vpiHandleScope).flush();
        XVPIEntity response = this.systemCFactory.getVPIEntity(id);
        pipe.packer.packInt(response != null ? response.getType() : 0).packInt(id).flush();
        return currentScopeEvaluator;
    }

    private int body(XSystemCFactory systemCFactory, XValueHolder currentScopeEvaluator, int vpiHandle, String name) {
        try {
            XValueHolderFactory factory = currentScopeEvaluator.getFactory();
            ELParamValueScope valueScope = XVPIHandleByName.getValueByName(systemCFactory, name, vpiHandle, (IHidEvaluator)this, factory);
            return systemCFactory.registerVPIEntity((int)Integer.MAX_VALUE, (ELParamValueScope)valueScope, (int)-1).id;
        }
        catch (UnknownEvaluationException e) {
            this.factory.logError("Unknown evaluation of " + this.getName() + "(" + vpiHandle + ", " + name + "). " + e.getMessage());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            this.factory.logError("Unknown evaluation of " + this.getName() + "(" + vpiHandle + ", " + name + ")");
        }
        return 0;
    }

    public static final IHidObject pathToHidObject(XSystemCFactory systemCFactory, String name, int vpiHandle, StringBuilder fullVarName, XValueHolderFactory factory) {
        XVPIEntity startingScope;
        String[] segments = DVTStringUtil.split((String)".", (String)name);
        int segmentsCount = 0;
        XInstValueHolder elementScope = null;
        boolean isLibraryRoot = vpiHandle == 0;
        XVPIEntity xVPIEntity = startingScope = systemCFactory != null ? systemCFactory.getVPIEntity(vpiHandle) : null;
        if (isLibraryRoot) {
            ElementPath elementPath = ElementPath.create(Arrays.asList(segments));
            while ((elementScope = factory.getInstValueHolder(elementPath)) == null) {
                ++segmentsCount;
                if (!(elementPath = elementPath.removeLastSegment()).isEmpty()) continue;
                break;
            }
        } else if (startingScope != null) {
            ++segmentsCount;
            IELParamValue value = XUtils.getValue((ELParamValueScope)startingScope.getValueScope());
            if (!(value instanceof XValueHolder)) {
                factory.logError("Unable to find instance path '" + name + "'");
                return null;
            }
            elementScope = (XValueHolder)value;
        } else {
            factory.logError("Unable to find instance path '" + name + "' (vpiHandle = " + vpiHandle + ")");
            return null;
        }
        if (elementScope instanceof XInstValueHolder.XBBoxValueHolder && factory.simulatorMode() == IXSim.XSimMode.UVM_RUNTIME_ELAB) {
            return Hid.EVALUATE_SKIP_HID;
        }
        if (segmentsCount == 0) {
            final ELParamValueScope valueScope = ELParamValueScope.of((IELParamValue)elementScope);
            return new Hid("[return value]", null, -1, -1, 0L){

                public ELParamValueScope evaluateForSize(IHidEvaluator evaluator, IRfNamedElement origin, IHidEvaluationGuardian guardian) {
                    return valueScope;
                }

                public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
                    return valueScope;
                }
            };
        }
        Object lastHidObject = null;
        RfHidAccess parentAccess = null;
        int i = 0;
        while (i < segmentsCount) {
            Matcher mSelect;
            boolean isLastSegment = segmentsCount - 1 == i;
            String varName = segments[segments.length - segmentsCount + i];
            if (fullVarName != null) {
                if (i != 0) {
                    fullVarName.append(".");
                }
                fullVarName.append(varName);
            }
            if ((mSelect = SELECT_PATTERN.matcher(varName)).find()) {
                varName = mSelect.group(1).trim();
                hid = STransformer.makeStandInHid(varName, null, HidOccurrence.DUMMY_OCCURRENCE, 0L);
                hid.addParentAccess(parentAccess);
                if (i == 0) {
                    hid = new XInstValueHolder.XEvalOverrideHid((XValueHolder)elementScope, (Hid)hid);
                }
                String lhSideText = mSelect.group(2).trim();
                RfHidImplicit lhSideHidObject = null;
                if (DVTStringUtil.isNumber((String)lhSideText)) {
                    lhSideHidObject = STransformer.makeStandInImplicit(lhSideText, IHidImplicitConstants.ImplicitType.QUA_NUMBER.id);
                } else if (DVTStringUtil.isIdentifier((String)lhSideText)) {
                    lhSideHidObject = new XInstValueHolder.XEvalOverrideHid((XValueHolder)elementScope, (Hid)STransformer.makeStandInHid(lhSideText, null, HidOccurrence.DUMMY_OCCURRENCE, 0L));
                } else {
                    throw new UnknownMethodEvaluationException("Unsupported expression in access select to find element with name " + name);
                }
                Object selectOp = lhSideHidObject;
                String rhSideText = mSelect.group(3);
                if (rhSideText != null) {
                    rhSideText = rhSideText.trim();
                    RfHidImplicit rhSideHidObject = null;
                    if (DVTStringUtil.isNumber((String)rhSideText)) {
                        rhSideHidObject = STransformer.makeStandInImplicit(rhSideText, IHidImplicitConstants.ImplicitType.QUA_NUMBER.id);
                    } else if (DVTStringUtil.isIdentifier((String)rhSideText)) {
                        rhSideHidObject = new XInstValueHolder.XEvalOverrideHid((XValueHolder)elementScope, (Hid)STransformer.makeStandInHid(rhSideText, null, HidOccurrence.DUMMY_OCCURRENCE, 0L));
                    } else {
                        throw new UnknownMethodEvaluationException("Unsupported expression in access select to find element with name " + name);
                    }
                    selectOp = STransformer.makeStandInOperator((IHidObject)lhSideHidObject, Collections.singleton(rhSideHidObject), 461, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, ":", HidOperatorOccurrence.DUMMY_OCCURRENCE, HidQualifierCache.IS_RANGE_OR_PART_SELECT_QUALIFIER);
                }
                RfHidAccess hidAccess = STransformer.makeStandInAccess(hid, null, isLastSegment ? Integer.MIN_VALUE : 0);
                hidAccess.addSelect((IHidObject)selectOp);
                parentAccess = hidAccess;
                lastHidObject = hidAccess;
            } else {
                hid = STransformer.makeStandInHid(varName, null, HidOccurrence.DUMMY_OCCURRENCE, 0L);
                hid.addParentAccess(parentAccess);
                if (i == 0) {
                    hid = new XInstValueHolder.XEvalOverrideHid((XValueHolder)elementScope, (Hid)hid);
                }
                lastHidObject = hid;
                parentAccess = STransformer.makeStandInAccess(hid, null, isLastSegment ? Integer.MIN_VALUE : 0);
            }
            ++i;
        }
        return lastHidObject;
    }

    private static final ELParamValueScope getValueByName(XSystemCFactory systemCFactory, String name, int vpiHandle, IHidEvaluator enclosing, XValueHolderFactory factory) {
        Matcher m = DVTStringUtil.COLON_COLON.matcher(name);
        if (m.find()) {
            return XVPIHandleByName.handleColonColonAccess(factory, name, enclosing);
        }
        StringBuilder fullVarName = new StringBuilder();
        IHidObject pathHidObject = XVPIHandleByName.pathToHidObject(systemCFactory, name, vpiHandle, fullVarName, factory);
        if (pathHidObject == null) {
            return ELParamValueScope.UNDEFINED_VALUE;
        }
        if (pathHidObject == Hid.EVALUATE_SKIP_HID) {
            return ELParamValueScope.of((IELParamValue)ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.ONE));
        }
        ELParamValueScope valueScope = ELUtils.evaluate((IHidObject)pathHidObject, (IHidEvaluator)enclosing, null, (IHidEvaluationGuardian)factory.getEvaluationGuardian(true));
        if (ELUtils.isUnsuccessfulEval((ELParamValueScope)valueScope)) {
            return ELParamValueScope.UNDEFINED_VALUE;
        }
        XInstValueHolder instanceScope = XUtils.getInstanceScope((ELParamValueScope)valueScope);
        return ELParamValueScope.of((IELParamValue)XUtils.getValue((ELParamValueScope)valueScope), (IHidEvaluator)instanceScope, (String)fullVarName.toString(), (IHidObject)pathHidObject);
    }

    private static ELParamValueScope handleColonColonAccess(XValueHolderFactory factory, String name, IHidEvaluator enclosing) {
        RfProject rfProject = XVlogContributorUtils.xGetRfProject(factory.getProject());
        if (rfProject == null || !(enclosing instanceof XValueHolder)) {
            throw new UnknownMethodEvaluationException("Unable to find instance with name " + name);
        }
        RfProject enclosingMember = rfProject;
        XValueHolder enclosingValue = (XValueHolder)enclosing;
        ELParamValueScope valueScope = null;
        String[] segments = DVTStringUtil.split((String)"::", (String)name);
        int idx = 0;
        while (idx < segments.length) {
            IRfNamedElement member = enclosingMember.getMember(segments[idx], null, enclosingMember, idx == 0, idx == segments.length - 1, true, false, false);
            if (member == null) {
                throw new UnknownMethodEvaluationException("Unable to find reflection element with name " + segments[idx] + ", in enclosing " + enclosingMember.getName() + " when searching for " + name);
            }
            valueScope = enclosingValue.getValue((IHid)HidUtils.makeStandInHid((String)segments[idx], (IRfNamedElement)member, (HidOccurrence)HidOccurrence.DUMMY_OCCURRENCE, (long)0L), null, factory.getEvaluationGuardian(false));
            IELParamValue value = XUtils.getValue((ELParamValueScope)valueScope);
            if (!(value instanceof XValueHolder)) {
                if (idx == segments.length - 1) break;
                throw new UnknownMethodEvaluationException("Unable to find handle " + name);
            }
            enclosingValue = (XValueHolder)value;
            enclosingMember = member;
            ++idx;
        }
        if (ELUtils.isUnsuccessfulEval(valueScope)) {
            throw new UnknownMethodEvaluationException("Unable to find handle " + name);
        }
        return valueScope;
    }
}

