/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.factory.vpi.custom.methods;

import java.util.Arrays;
import java.util.Collections;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.IXDVTDPICUtils;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XMethodValueHolder;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicitConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownMethodEvaluationException;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.MaskType;
import ro.amiq.vlogdt.interpreter.factory.XVlogValueHolderFactory;
import ro.amiq.vlogdt.interpreter.factory.dpi.XVlogDPICTypeMapperManager;
import ro.amiq.vlogdt.interpreter.factory.dpi.XVlogSystfValueHolder;
import ro.amiq.vlogdt.interpreter.factory.dpi.custom.methods.XDPICSVCustomMethodsUtils;
import ro.amiq.vlogdt.interpreter.factory.systemc.XCPipeProtocol;
import ro.amiq.vlogdt.interpreter.factory.systemc.vpi.XVPIEntity;
import ro.amiq.vlogdt.interpreter.factory.vpi.custom.methods.XAbstractVPIUserMethod;
import ro.amiq.vlogdt.interpreter.factory.vpi.custom.methods.XTypeVPIValue;
import ro.amiq.vlogdt.interpreter.factory.vpi.custom.methods.XVPIBaseConverter;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.STransformer;

public class XVPIPutValue
extends XAbstractVPIUserMethod {
    public static final String VPI_PUT_VALUE = "vpi_put_value";

    public XVPIPutValue(XVlogValueHolderFactory factoryContributor, XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope, int exportIdRequest) {
        super(factoryContributor, xAssociatedType, enclosing, instanceScope, exportIdRequest);
    }

    @Override
    public String getName() {
        return VPI_PUT_VALUE;
    }

    @Override
    public IELParamValue internalExecute(XValueHolder currentScopeEvaluator, HidEvalCenter.MethodCallStatement parentMethodCallStatement) throws Exception {
        XCPipeProtocol pipe = this.getCurrentPipe();
        if (!this.systemCFactory.hasNextInServerPipe()) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        int vpiHandleType = pipe.unpacker.unpackInt();
        if (!this.systemCFactory.hasNextInServerPipe()) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        int vpiHandleId = pipe.unpacker.unpackInt();
        XVPIEntity vpiEntity = this.systemCFactory.getVPIEntity(vpiHandleId);
        ELParamValueScope valueScope = vpiEntity.getValueScope();
        IRfAssociatedTypeElement element = (IRfAssociatedTypeElement)valueScope.getElement();
        XTypeVPIValue vpiValue = new XTypeVPIValue();
        vpiValue.format = pipe.unpacker.unpackInt();
        try {
            switch (vpiValue.format) {
                case 5: {
                    vpiValue.value.scalar = pipe.unpacker.unpackInt();
                    break;
                }
                case 6: {
                    vpiValue.value.integer = pipe.unpacker.unpackInt();
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 8: {
                    vpiValue.value.str = pipe.unpacker.unpackString();
                    break;
                }
                case 9: {
                    vpiValue.value.vector = XVlogDPICTypeMapperManager.getInstance().unpackLogicStream(XUtils.getValue((ELParamValueScope)valueScope), element, this.systemCFactory, pipe);
                    break;
                }
                default: {
                    throw new UnknownMethodEvaluationException("Unsupported format " + vpiValue.format);
                }
            }
        }
        catch (UnknownMethodEvaluationException e) {
            this.factory.logError(DVTStringUtil.appendString((Object[])new Object[]{"Unknown evaluation of vpi_put_value(", vpiEntity != null ? vpiEntity.toString() : Integer.valueOf(vpiHandleId), ", ", vpiValue.format, "). ", e.getMessage()}));
        }
        catch (Exception e) {
            this.factory.logError(DVTStringUtil.appendString((Object[])new Object[]{"Unknown evaluation of vpi_put_value(", vpiEntity != null ? vpiEntity.toString() : Integer.valueOf(vpiHandleId), ", ", vpiValue.format, "). "}));
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        int flags = pipe.unpacker.unpackInt();
        this.body(vpiEntity, vpiValue, flags);
        pipe.packer.packString("dvt_command_result_export_function").packInt(this.exportIdEvaluation).packInt(vpiHandleType).packInt(vpiHandleId).packInt(vpiValue.format).flush();
        try {
            switch (vpiValue.format) {
                case 5: {
                    pipe.packer.packInt(vpiValue.value.scalar).flush();
                    break;
                }
                case 6: {
                    pipe.packer.packInt(vpiValue.value.integer).flush();
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 8: {
                    pipe.packer.packString(vpiValue.value.str).flush();
                    break;
                }
                case 9: {
                    XVlogDPICTypeMapperManager.getInstance().packBitVector(vpiValue.value.vector, IXDVTDPICUtils.getRecursiveResolvedType((IRfNamedElement)element.getResolvedType(true)), pipe.packer, true);
                    break;
                }
                default: {
                    throw new UnknownMethodEvaluationException("Unsupported format " + vpiValue.format);
                }
            }
        }
        catch (UnknownMethodEvaluationException e) {
            this.factory.logError(DVTStringUtil.appendString((Object[])new Object[]{"Unknown evaluation of vpi_put_value(", vpiEntity != null ? vpiEntity.toString() : Integer.valueOf(vpiHandleId), ", ", vpiValue.format, "). ", e.getMessage()}));
        }
        catch (Exception exception) {
            this.factory.logError(DVTStringUtil.appendString((Object[])new Object[]{"Unknown evaluation of vpi_put_value(", vpiEntity != null ? vpiEntity.toString() : Integer.valueOf(vpiHandleId), ", ", vpiValue.format, "). "}));
        }
        pipe.packer.packInt(flags).flush();
        return currentScopeEvaluator;
    }

    private void body(XVPIEntity vpiEntity, XTypeVPIValue vpiValue, int flags) {
        try {
            ELParamValueScope valueScope = vpiEntity.getValueScope();
            IELParamValue value = XUtils.getValue((ELParamValueScope)valueScope);
            BitVectorContext context = BitVectorContext.of((DVTNumber)value.getDVTNumber(), null);
            int nofBits = context.getSize();
            HidImplicit numberImplicit = null;
            XVPIBaseConverter base = XVPIBaseConverter.getBaseByVPIConst(vpiValue.format);
            int radix = base.getRadix();
            if (flags != 6) {
                String implicitText = null;
                int implicitType = IHidImplicitConstants.ImplicitType.QUA_NUMBER.id;
                switch (vpiValue.format) {
                    case 6: {
                        implicitText = String.valueOf(vpiValue.value.integer);
                        break;
                    }
                    case 5: {
                        int scalarValue = vpiValue.value.scalar;
                        implicitText = XDPICSVCustomMethodsUtils.vpiScalarToText(scalarValue);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        implicitText = DVTStringUtil.appendString((Object[])new Object[]{nofBits, base.getVlogBase(), vpiValue.value.str});
                        break;
                    }
                    case 8: {
                        implicitText = DVTStringUtil.appendString((Object[])new Object[]{"\"", vpiValue.value.str, "\""});
                        implicitType = 557;
                        break;
                    }
                    case 9: {
                        implicitText = vpiValue.value.vector.getDVTNumber().toNiceString(context, 2, false, false);
                        break;
                    }
                    default: {
                        throw new UnknownMethodEvaluationException("Unsupported format " + vpiValue.format);
                    }
                }
                boolean isMinus = false;
                if (implicitType == IHidImplicitConstants.ImplicitType.QUA_NUMBER.id && implicitText.startsWith("-")) {
                    implicitText = implicitText.substring("-".length());
                    isMinus = true;
                }
                numberImplicit = STransformer.BUILDERS.buildImplicit(implicitText, implicitType);
                if (isMinus) {
                    numberImplicit = STransformer.BUILDERS.buildOperator((IHidObject)numberImplicit, Collections.emptyList(), 467, IHidOperatorConstants.OperatorKind.UNARY_OPERATOR, "-", HidOperatorOccurrence.DUMMY_OCCURRENCE, 0L);
                }
            }
            switch (flags) {
                case 1: {
                    if (numberImplicit == null) {
                        throw new UnknownMethodEvaluationException("Unable to compute number value");
                    }
                    this.evaluateAssignOperator(valueScope, (IHidObject)numberImplicit, HidQualifierCache.IS_BLOCKING_ASSIGN_QUALIFIER | HidQualifierCache.IS_PROCEDURAL_DEPOSIT_QUALIFIER);
                    return;
                }
                case 5: {
                    if (numberImplicit == null) {
                        throw new UnknownMethodEvaluationException("Unable to compute number value");
                    }
                    this.evaluateAssignOperator(valueScope, (IHidObject)numberImplicit, HidQualifierCache.IS_PROCEDURAL_FORCE_ASSIGN_QUALIFIER);
                    return;
                }
                case 6: {
                    IRfNamedElement element = XUtils.getElement((ELParamValueScope)valueScope);
                    String name = element != null ? element.getName() : XUtils.getElementName((ELParamValueScope)valueScope);
                    IHidObject lhValue = valueScope.getHidObject() != null ? valueScope.getHidObject() : STransformer.BUILDERS.buildHid(name, element, (HidOccurrence)HidOperatorOccurrence.DUMMY_OCCURRENCE, 0L);
                    HidOperator operator = STransformer.BUILDERS.buildOperator(lhValue, Collections.emptyList(), 191, IHidOperatorConstants.OperatorKind.UNARY_OPERATOR, "release", HidOperatorOccurrence.DUMMY_OCCURRENCE, HidQualifierCache.IS_PROCEDURAL_CONTINUOUS_ASSIGN_QUALIFIER);
                    ELUtils.evaluate((IHidObject)operator, (IHidEvaluator)this, null, (IHidEvaluationGuardian)this.factory.getEvaluationGuardian(true));
                    if (lhValue instanceof RfHidAccess) {
                        lhValue = ((RfHidAccess)lhValue).getParentHid();
                    }
                    if (!(lhValue instanceof Hid)) {
                        throw new UnknownMethodEvaluationException("Unable to compute number value");
                    }
                    ELParamValueScope valueAfterRelease = this.getValue((IHid)((Hid)lhValue), null, this.factory.getEvaluationGuardian(true));
                    IELParamValue original = XUtils.getValue((ELParamValueScope)valueAfterRelease);
                    if (ELUtils.isUnsuccessfulEval((IELParamValue)original)) {
                        throw new UnknownMethodEvaluationException("Unable to compute number value");
                    }
                    switch (vpiValue.format) {
                        case 5: {
                            DVTNumber dvtNumber = value.getDVTNumber();
                            vpiValue.value.scalar = XDPICSVCustomMethodsUtils.dvtNumberToVPIScalar(dvtNumber);
                            break;
                        }
                        case 6: {
                            DVTNumber dvtNumber = value.getDVTNumber();
                            vpiValue.value.integer = dvtNumber.bigIntegerValue().intValue();
                            break;
                        }
                        case 7: {
                            DVTNumber dvtNumber = value.getDVTNumber();
                            vpiValue.value.real = dvtNumber.doubleValue();
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            DVTNumber dvtNumber = value.getDVTNumber();
                            if (dvtNumber.hasMask(new MaskType[]{MaskType.Z, MaskType.X})) {
                                vpiValue.value.str = ELUtils.valueToString((IELParamValue)value);
                                break;
                            }
                            vpiValue.value.str = dvtNumber.bigIntegerValue().toString(radix);
                            break;
                        }
                        case 8: {
                            vpiValue.value.str = ELUtils.valueToString((IELParamValue)value);
                            break;
                        }
                        case 9: {
                            vpiValue.value.vector = value;
                            break;
                        }
                        default: {
                            throw new UnknownMethodEvaluationException("Unsupported format " + vpiValue.format);
                        }
                    }
                    return;
                }
            }
        }
        catch (UnknownMethodEvaluationException e) {
            this.factory.logError("Unknown evaluation of vpi_put_value(" + (vpiEntity != null ? vpiEntity.getId() : 0) + ", " + vpiValue.format + "). " + e.getMessage());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            this.factory.logError("Unknown evaluation of vpi_put_value(" + (vpiEntity != null ? vpiEntity.getId() : 0) + ", " + vpiValue.format + ")");
        }
    }

    private void evaluateAssignOperator(ELParamValueScope valueScope, IHidObject numberImplicit, long operatorQualifiers) {
        IRfNamedElement element = XUtils.getElement((ELParamValueScope)valueScope);
        String name = XUtils.getElementName((ELParamValueScope)valueScope);
        if (name == null && element instanceof RfField var7_7 && candidate.isField()) {
            name = element.getName();
        }
        IHidObject lhValue = valueScope.getHidObject() != null ? valueScope.getHidObject() : STransformer.BUILDERS.buildHid(name, element, (HidOccurrence)HidOperatorOccurrence.DUMMY_OCCURRENCE, 0L);
        HidOperator operator = STransformer.BUILDERS.buildOperator(lhValue, Arrays.asList(numberImplicit), 498, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "=", HidOperatorOccurrence.DUMMY_OCCURRENCE, operatorQualifiers);
        XVPIPutValue enclosingValue = this;
        while (enclosingValue instanceof XAbstractVPIUserMethod || enclosingValue instanceof XVlogSystfValueHolder) {
            enclosingValue = ((XMethodValueHolder)enclosingValue).getEnclosingValue();
        }
        ELUtils.evaluate((IHidObject)operator, (IHidEvaluator)enclosingValue, null, (IHidEvaluationGuardian)this.factory.getEvaluationGuardian(true));
    }
}

