/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.utils;

import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.interpreter.IXXVMComponent;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.utils.DVTStringUtil;

public interface IXSerializedModelUtils {
    public static GoToInfo createGoToInfoFromString(String goToInfoString) {
        String goToInfoText;
        if ("N/A".equals(goToInfoString)) {
            return null;
        }
        String[] elements = DVTStringUtil.split((String)"@", (String)goToInfoString);
        if (elements == null) {
            return null;
        }
        if (elements.length == 2) {
            goToInfoText = null;
        } else if (elements.length == 3) {
            goToInfoText = DVTStringUtil.unescapeXMLString((String)elements[2], (boolean)true);
        } else {
            return null;
        }
        return GoToInfo.of((String)elements[1], (int)-1, (int)-1, (int)Integer.parseInt(elements[0]), (String)goToInfoText, (LanguageKind)LanguageKind.VLOG);
    }

    @NotNull
    public static String serializeGoToInfo(GoToInfo goToInfo, boolean serializeText) {
        StringBuilder sb = new StringBuilder().append(goToInfo.line).append("@").append(goToInfo.filePath);
        if (serializeText && goToInfo.text != null && !goToInfo.text.isEmpty()) {
            String sanitizedText = DVTStringUtil.escapeXMLString((String)goToInfo.text, (boolean)true).replace("@", " ");
            sb.append("@").append(sanitizedText);
        }
        return sb.toString();
    }

    @NotNull
    public static String serializeGoToInfo(GoToInfo goToInfo) {
        return IXSerializedModelUtils.serializeGoToInfo(goToInfo, false);
    }

    public static String[] withFullNameFromString(String fullName) {
        if ("".equals(fullName)) {
            return new String[0];
        }
        String[] segments = DVTStringUtil.split((String)".", (String)fullName);
        String[] fName = new String[segments.length];
        int i = 0;
        while (i < segments.length) {
            fName[i] = DVTStringUtil.intern((String)segments[i]);
            ++i;
        }
        return fName;
    }

    public static String replaceXVMTestTopSegment(String original, String actualTestName) {
        Object[] split = DVTStringUtil.split((String)".", (String)original);
        if (split == null || split.length == 0) {
            return null;
        }
        if (!IXXVMComponent.XVM_TEST_TOP_PATTERN.matches(split[0])) {
            return null;
        }
        split[0] = actualTestName;
        return DVTStringUtil.join((Object[])split, (String)".");
    }

    public static String getGoToInfoString(GoToInfo goToInfo) {
        if (goToInfo == null) {
            return "N/A";
        }
        return IXSerializedModelUtils.serializeGoToInfo(goToInfo);
    }
}

