/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.utils;

import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicitConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.predefined.RfBitVectorScalarType;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.STransformer;
import ro.amiq.vlogdt.model.reflection.views.VHHistoryItem;

public interface XVlogContributorUtils {
    public static final String MINUS = "-";
    public static final String BASE_SPECIFIER = "'";

    public static HistoryItem xComputeHistoryItem(IProject project, String className) {
        if (project == null || className == null || "".equals(className)) {
            return null;
        }
        RfProject rfProject = XVlogContributorUtils.xGetRfProject(project);
        if (rfProject == null) {
            return null;
        }
        RfClass[] rfClasses = rfProject.getAllClasses();
        if (rfClasses == null || rfClasses.length == 0) {
            return null;
        }
        RfClass parentClass = rfProject.getClass("uvm_test", false);
        if (parentClass == null) {
            parentClass = rfProject.getClass("ovm_test", false);
        }
        if (parentClass == null) {
            return null;
        }
        RfClass[] rfClassArray = rfClasses;
        int n = rfClasses.length;
        int n2 = 0;
        while (n2 < n) {
            RfClass rfClass = rfClassArray[n2];
            if (rfClass.hasParent(parentClass) && className.equals(rfClass.computeXVMFactoryRegisterId())) {
                RfElementPath elementPath = RfElementPath.path((IRfNamedElement)rfClass);
                return VHHistoryItem.parseHistoryItem(project.getName(), elementPath);
            }
            ++n2;
        }
        return null;
    }

    public static RfProject xGetRfProject(IProject project) {
        RfMixedLangProject mixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(project, false);
        if (mixedLangProject == null) {
            return null;
        }
        return (RfProject)mixedLangProject.getSingleLangProject(LanguageKind.VLOG.NATURE_ID);
    }

    public static IRfNamedElement xGetClass(RfProject rfProject, String className) {
        if (rfProject == null || className == null || className.isEmpty()) {
            return null;
        }
        return rfProject.getClass(className, false);
    }

    public static DVTNumber internalParseNumber(String numberText, IRfNamedElement typeElement, boolean isReal) {
        RfHidImplicit numberImplicit;
        ELParamValueScope evaluate;
        boolean hasBaseSpecified;
        if (numberText == null || "null".equals(numberText)) {
            return null;
        }
        boolean isNegative = false;
        boolean bl = hasBaseSpecified = numberText.indexOf(BASE_SPECIFIER) > -1;
        if (numberText.indexOf(MINUS) > -1) {
            numberText = DVTStringUtil.replace((String)numberText, (String)MINUS, (String)"", (boolean)false);
            isNegative = true;
        }
        BitVectorContext bitVectorContext = BitVectorContext.of((IRfNamedElement)typeElement, (boolean)false);
        if (typeElement instanceof RfBitVectorScalarType) {
            bitVectorContext = ((RfBitVectorScalarType)typeElement).getBitVectorContext(null, null, typeElement);
        }
        if (typeElement instanceof RfStruct && ((RfStruct)typeElement).isEnum()) {
            hasBaseSpecified = true;
        }
        if (!isReal && !hasBaseSpecified && bitVectorContext != null && bitVectorContext.getContextNumber() instanceof VlogBitVector) {
            numberText = String.valueOf(bitVectorContext.getSize()) + "'d" + numberText;
        }
        if ((evaluate = ELUtils.evaluate((IHidObject)(numberImplicit = STransformer.makeStandInImplicit(numberText, IHidImplicitConstants.ImplicitType.QUA_NUMBER.id)), (IHidEvaluator)new IHidEvaluator.NullHidEvaluator(), (BitVectorContext)bitVectorContext, (IHidEvaluationGuardian)IHidEvaluationGuardian.DUMMY_EVAL_GUARDIAN)) == null) {
            throw new IllegalStateException("Unable to evaluate number " + numberText);
        }
        DVTNumber dvtNumber = evaluate.getDVTNumber();
        if (!isNegative) {
            return dvtNumber;
        }
        return DVTNumber.minus((DVTNumber)VlogBitVector.ZERO, (DVTNumber)dvtNumber);
    }

    public static IRfNamedElement xGetPackage(String packageName, XValueHolderFactory factory) {
        if (packageName == null) {
            return null;
        }
        int indexOf = packageName.indexOf("::");
        if (indexOf >= 0) {
            packageName = packageName.substring(0, indexOf);
        }
        return factory.getRfMixedLangProject().getPackageWithPrefix(null, packageName, 1);
    }
}

