/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.view;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.ui.IEditorPart;
import org.w3c.dom.Document;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.debug.core.model.breakpoints.LastExecutedStatementInfo;
import ro.amiq.dvt.diagrams.ch.model.XVMBuildPhaseXMLParser;
import ro.amiq.dvt.interpreter.DVTRunLaunchCache;
import ro.amiq.dvt.interpreter.DVTXRunBuildPhaseUtils;
import ro.amiq.dvt.interpreter.IXContributor;
import ro.amiq.dvt.interpreter.IXUVMElaborationStarter;
import ro.amiq.dvt.interpreter.IXXVMComponent;
import ro.amiq.dvt.interpreter.XUVMElaborationSetup;
import ro.amiq.dvt.interpreter.console.XConsole;
import ro.amiq.dvt.interpreter.console.XConsoleRegistry;
import ro.amiq.dvt.interpreter.dpi.types.IXDPITypeMapperManager;
import ro.amiq.dvt.logviewer.LogViewerContributorUtils;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfClassElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.precompiled.PrecompiledDBUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbViewer;
import ro.amiq.dvt.ui.views.IBuildEventManagerListener;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.UVMRuntimeSettings;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.interpreter.XUVMElaborationJob;
import ro.amiq.vlogdt.interpreter.factory.dpi.XVlogDPICEngine;
import ro.amiq.vlogdt.interpreter.factory.dpi.XVlogDPICTypeMapperManager;
import ro.amiq.vlogdt.interpreter.utils.IXSerializedModelUtils;
import ro.amiq.vlogdt.interpreter.utils.XVlogContributorUtils;
import ro.amiq.vlogdt.interpreter.view.XVlogUVMElaborationStarter;
import ro.amiq.vlogdt.interpreter.view.XXVMBuilder;
import ro.amiq.vlogdt.interpreter.views.verification.hierarchy.XXVMComponent;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.views.VHHistoryItemUVMElabStatus;

public abstract class XVlogUVMElaborationStarterCommon
implements IXUVMElaborationStarter {
    private static final String OVM_TEST = "ovm_test";
    private static final String UVM_TEST = "uvm_test";
    private final Queue<XUVMElaborationJob> jobToStopCandidate = new ConcurrentLinkedDeque<XUVMElaborationJob>(new ArrayList(1));
    private boolean isRunInBatchMode;

    protected XVlogUVMElaborationStarterCommon(boolean isRunInBatchMode) {
        this.isRunInBatchMode = isRunInBatchMode;
    }

    public XUVMElaborationSetup buildSetup(String[] commandAsArguments, IProject project, String projectName, boolean saveModel, boolean stopAfterUVMElaboration, boolean isDebugMode, boolean isLoadSerializedTestMode) {
        if (commandAsArguments == null || commandAsArguments.length == 0) {
            return null;
        }
        List<String> customArgs = Arrays.asList(commandAsArguments);
        String testName = IXUVMElaborationStarter.computeArgumentValue(customArgs, Arrays.asList("+UVM_TESTNAME", "+OVM_TESTNAME"), (boolean)false);
        if (testName == null) {
            this.popUpErrorMessage("Must provide test name!");
            return null;
        }
        return this.getElaborationSetup(project, projectName, saveModel, stopAfterUVMElaboration, isDebugMode, isLoadSerializedTestMode, testName, customArgs);
    }

    public XUVMElaborationSetup buildSetupFromCustomArgs(String[] commandAsArguments, IProject project, String projectName, boolean saveModel, boolean stopAfterUVMElaboration, boolean isDebugMode, boolean isLoadSerializedTestMode) {
        if (commandAsArguments == null || commandAsArguments.length == 0) {
            return null;
        }
        List<String> customArgs = Arrays.asList(commandAsArguments);
        String testName = IXUVMElaborationStarter.computeArgumentValue(customArgs, Arrays.asList("+UVM_TESTNAME", "+OVM_TESTNAME"), (boolean)false);
        if (testName == null && !this.isRunInBatchMode) {
            this.popUpErrorMessage("Must provide test name!");
            return null;
        }
        String verbosity = IXUVMElaborationStarter.computeArgumentValue(customArgs, Arrays.asList("+UVM_VERBOSITY=", "+OVM_VERBOSITY="), (boolean)false);
        String seed = IXUVMElaborationStarter.computeArgumentValue(customArgs, Arrays.asList("+SEED="), (boolean)false);
        String builtinDpic = IXUVMElaborationStarter.computeArgumentValue(customArgs, Arrays.asList("+dvtx_native_jimpl_uvm"), (boolean)false);
        String addArgs = IXUVMElaborationStarter.computeArgumentValue(customArgs, Arrays.asList("+ARGS="), (boolean)false);
        XUVMElaborationSetup uvmElaborationSetup = new XUVMElaborationSetup().withSaveModel(true).withStopAfterElaboration(true).withTestName(testName).withProject(project).withCustomArgs(customArgs).withProjectName(project.getName()).withDebugModeOn(false).withHistoryItem(XVlogContributorUtils.xComputeHistoryItem(project, testName)).withRegistersViewContributor().withVHViewContributor().withConfigDBViewContributor().withFactoryOverridesViewContributor().withVerbosity(verbosity == null ? "" : verbosity).withSeed(seed == null ? "" : seed).withUseBUiltinDPIC(builtinDpic != null).withAdditionalArgs(addArgs == null || addArgs.startsWith("+ARGS=") ? "" : addArgs);
        return uvmElaborationSetup;
    }

    protected XUVMElaborationSetup getElaborationSetup(IProject project, String projectName, boolean saveModel, boolean stopAfterUVMElaboration, boolean isDebugMode, boolean isLoadSerializedTestMode, String testName, List<String> customArgs) {
        return new XUVMElaborationSetup().withSaveModel(saveModel).withStopAfterElaboration(stopAfterUVMElaboration).withTestName(testName).withCustomArgs(customArgs).withProject(project).withProjectName(projectName).withDebugModeOn(isDebugMode).withLoadSerializedTestMode(isLoadSerializedTestMode).withHistoryItem(XVlogContributorUtils.xComputeHistoryItem(project, testName)).withRegistersViewContributor().withVHViewContributor().withFactoryOverridesViewContributor().withConfigDBViewContributor();
    }

    public IStatus generate(IProject project, UVMRuntimeSettings uvmElabInfo) {
        IRfNamedElement namedElement;
        RfElementPath objectQName;
        HistoryItem historyItem;
        if (project == null) {
            return Status.CANCEL_STATUS;
        }
        ArrayList<String> argsList = new ArrayList<String>();
        if (uvmElabInfo.getTestName() != null && (historyItem = uvmElabInfo.getHistoryItem()) != null && (objectQName = historyItem.getObjectQName()) != null && (namedElement = objectQName.toNamedElement(project)) instanceof IRfClassElement) {
            if (((IRfClassElement)namedElement).isChildOf(UVM_TEST, false)) {
                argsList.add("+UVM_TESTNAME=" + uvmElabInfo.getTestName());
            } else if (((IRfClassElement)namedElement).isChildOf(OVM_TEST, false)) {
                argsList.add("+OVM_TESTNAME=" + uvmElabInfo.getTestName());
            }
        }
        if (uvmElabInfo.getVerbosity() != null) {
            argsList.add("+UVM_VERBOSITY=" + uvmElabInfo.getVerbosity());
        }
        if (uvmElabInfo.getSeed() != null) {
            argsList.add("+SEED=" + uvmElabInfo.getSeed());
        }
        if (uvmElabInfo.isUseBuiltinDPIC()) {
            argsList.add("+dvtx_native_jimpl_uvm");
        }
        if (uvmElabInfo.getAddArguments() != null) {
            argsList.add(uvmElabInfo.getAddArguments());
        }
        XUVMElaborationSetup uvmElaborationSetup = this.setUpUvmElaboration(project, uvmElabInfo, argsList);
        Queue launches = DVTRunLaunchCache.getInstance().getLaunches();
        if (launches != null && !launches.isEmpty()) {
            this.popUpElaborationInProgress(uvmElaborationSetup, (ILaunch)launches.peek());
            return Status.OK_STATUS;
        }
        this.start(uvmElaborationSetup);
        return Status.OK_STATUS;
    }

    protected XUVMElaborationSetup setUpUvmElaboration(IProject project, UVMRuntimeSettings uvmElabInfo, List<String> argsList) {
        XUVMElaborationSetup uvmElaborationSetup = new XUVMElaborationSetup().withSaveModel(true).withStopAfterElaboration(true).withTestName(uvmElabInfo.getTestName()).withProject(project).withCustomArgs(argsList).withProjectName(project.getName()).withDebugModeOn(true).withHistoryItem(XVlogContributorUtils.xComputeHistoryItem(project, uvmElabInfo.getTestName())).withRegistersViewContributor().withVHViewContributor().withConfigDBViewContributor().withFactoryOverridesViewContributor().withVerbosity(uvmElabInfo.getVerbosity()).withSeed(uvmElabInfo.getSeed()).withUseBUiltinDPIC(uvmElabInfo.isUseBuiltinDPIC()).withAdditionalArgs(uvmElabInfo.getAddArguments());
        return uvmElaborationSetup;
    }

    public void removeJobStopCandidate(XUVMElaborationJob xuvmElaborationJob) {
        try {
            this.jobToStopCandidate.remove((Object)xuvmElaborationJob);
        }
        catch (Exception exception) {}
    }

    public boolean hasOtherJobsRunning(XUVMElaborationJob xuvmElaborationJob) {
        for (XUVMElaborationJob jobToStop : this.jobToStopCandidate) {
            if (jobToStop == xuvmElaborationJob) continue;
            return true;
        }
        return false;
    }

    public void forceStopCurrentlyUVMRuntimeElaborationJobs() {
        try {
            try {
                Queue launches = DVTRunLaunchCache.getInstance().getLaunches();
                if (launches != null && !launches.isEmpty()) {
                    for (ILaunch launch : launches) {
                        launch.terminate();
                    }
                }
                for (XUVMElaborationJob job : this.jobToStopCandidate) {
                    job.cancel();
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                this.jobToStopCandidate.clear();
                DVTRunLaunchCache.getInstance().clear();
            }
        }
        finally {
            this.jobToStopCandidate.clear();
            DVTRunLaunchCache.getInstance().clear();
        }
    }

    public Queue<XUVMElaborationJob> getJobToStopCandidate() {
        return this.jobToStopCandidate;
    }

    public void notifyContributorsErrorMode(XUVMElaborationSetup uvmElaborationSetUp) {
        if (uvmElaborationSetUp == null) {
            return;
        }
        if (uvmElaborationSetUp.xContributors == null || uvmElaborationSetUp.xContributors.isEmpty()) {
            return;
        }
        if (!this.isRunInBatchMode()) {
            uvmElaborationSetUp.xContributors.forEach(contributor -> contributor.notifyXViewError());
        }
    }

    public void notifyContributorsSuccessMode(XUVMElaborationSetup uvmElaborationSetUp) {
        if (uvmElaborationSetUp == null) {
            throw new IllegalArgumentException("UVM Elaboration set up is null");
        }
        if (uvmElaborationSetUp.xContributors == null || uvmElaborationSetUp.xContributors.isEmpty()) {
            return;
        }
        if (!this.isRunInBatchMode()) {
            uvmElaborationSetUp.xContributors.forEach(contributor -> {
                if (contributor == null) {
                    return;
                }
                contributor.notifyXViewSuccess();
            });
            this.notifyVerificationBreadcrumb(false);
            this.notifyLogviewer(uvmElaborationSetUp.getProject());
        }
    }

    private void notifyLogviewer(IProject project) {
        if (this.isRunInBatchMode) {
            return;
        }
        LogViewerContributorUtils.get().updateHyperlinks(project);
    }

    public void notifyVerificationBreadcrumb(boolean freeze) {
        if (this.isRunInBatchMode) {
            return;
        }
        VHBreadcrumbViewer.setReadOnly((boolean)freeze);
        List visibleEditors = Utils.computeVisibleEditors();
        for (IEditorPart editor : visibleEditors) {
            IDVTBreadcrumbHost bcHost;
            AbstractBreadcrumbViewer bcViewer;
            if (!(editor instanceof IDVTBreadcrumbHost) || !((bcViewer = (bcHost = (IDVTBreadcrumbHost)editor).getBreadcrumbViewer(VHBreadcrumbViewer.class)) instanceof VHBreadcrumbViewer)) continue;
            VHBreadcrumbViewer vhBreadcrumbViewer = (VHBreadcrumbViewer)bcViewer;
            vhBreadcrumbViewer.changeReadOnlyState();
            if (freeze) continue;
            vhBreadcrumbViewer.setModelReady(!freeze);
            bcHost.updateBreadcrumb(VHBreadcrumbViewer.class, null);
        }
    }

    public LanguageKind getLanguageKind() {
        return LanguageKind.VLOG;
    }

    protected String getFullPathModel(XUVMElaborationSetup uvmElaborationSetUp) {
        IProject project = uvmElaborationSetUp.getProject();
        XConsole console = XConsoleRegistry.getConsole((IProject)project, (boolean)false, (boolean)this.isRunInBatchMode());
        String testName = uvmElaborationSetUp.getTestName();
        IFolder modelsFolder = project.getFolder("dvt_uvm_elaboration_models");
        if (modelsFolder == null) {
            console.print(DVTStringUtil.appendString((Object[])new Object[]{System.lineSeparator(), "*** Error: Unable to locate dvt_uvm_elaboration_models \n\u2007\n"}));
            return null;
        }
        if (!modelsFolder.exists()) {
            try {
                modelsFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                console.print(DVTStringUtil.appendString((Object[])new Object[]{System.lineSeparator(), "*** Error: Unable to create folder to serialize models \n\u2007\n"}));
                return null;
            }
        }
        return String.valueOf(modelsFolder.getLocation().toOSString()) + "/" + testName + ".xml";
    }

    protected void computeModelFileContent(StringBuilder result, XUVMElaborationSetup uvmElaborationSetUp, String timeStamp, Map<String, String> sbMap, LastExecutedStatementInfo lastExecStmtInfo) {
        String seed;
        boolean hasFailed = sbMap == null;
        IProject project = uvmElaborationSetUp.getProject();
        XXVMBuilder.appendToSBUtils(result, "<?xml version='1.0' encoding='UTF-8'?>");
        XXVMBuilder.appendToSBUtils(result, "\n", "<", "uvm-elaboration-model", " ", "version", "=", "'", "3", "'", " ", "project-name", "=", "'", project.getName(), "'", " ", "test-name", "=", "'", uvmElaborationSetUp.getTestName(), "'", " ", "timestamp", "=", "'", timeStamp, "'", ">");
        String verbosity = uvmElaborationSetUp.getVerbosity();
        if (verbosity == null || verbosity.isEmpty()) {
            verbosity = "UVM_MEDIUM";
        }
        if ((seed = uvmElaborationSetUp.getSeed()) == null || seed.isEmpty()) {
            seed = "1";
        }
        XXVMBuilder.appendToSBUtils(result, "\n", "<", "runtime-settings", " ", "verbosity", "=", "'", verbosity, "'", " ", "seed", "=", "'", seed, "'", " ", "builtin-dpic", "=", "'", Boolean.toString(uvmElaborationSetUp.isUseBuiltinDPIC()), "'", " ", "additional-args", "=", "'", XXVMBuilder.escapeForXML(uvmElaborationSetUp.getAddArguments()), "'", " ", "/", ">");
        String elabModelStatus = (hasFailed ? VHHistoryItemUVMElabStatus.FAILED : VHHistoryItemUVMElabStatus.SUCCESS).toString();
        if (hasFailed && lastExecStmtInfo != null) {
            XXVMBuilder.appendToSBUtils(result, "\n", "<", "uvm-elaboration-status", " ", "status", "=", "'", elabModelStatus, "'", ">", "\n", "\t", "<", "xvm-last-executed-statement", " ", "path", "=", "'", lastExecStmtInfo.getParserPath(), "'", " ", "line", "=", "'", lastExecStmtInfo.getLine(), "'", "/", ">", "\n", "<", "/", "uvm-elaboration-status", ">");
        } else {
            XXVMBuilder.appendToSBUtils(result, "\n", "<", "uvm-elaboration-status", " ", "status", "=", "'", elabModelStatus, "'", "/", ">");
        }
        if (hasFailed) {
            String declarationClassAttribute;
            String svTypeAttribute;
            String typeAttribute;
            IRfNamedElement elem = uvmElaborationSetUp.getHistoryItem().getObjectQName().toNamedElement(project);
            String nameAttribute = "uvm_test_top";
            String fullNameAttribute = "uvm_test_top";
            if (elem == null) {
                typeAttribute = "";
                svTypeAttribute = "";
                declarationClassAttribute = "";
            } else {
                typeAttribute = elem.getName();
                svTypeAttribute = elem.getName();
                declarationClassAttribute = IXSerializedModelUtils.getGoToInfoString(GoToInfo.sourceOf((IRfNamedElement)elem));
            }
            String namedElementClassAttribute = uvmElaborationSetUp.getHistoryItem().getObjectQName().toString();
            XXVMBuilder.appendToSBUtils(result, "\n", "\t", "<", "component-hierarchy", ">", "\n", "\t", "\t", "<", "xvm-component", " ", "name", "=", "'", nameAttribute, "'", " ", "full-name", "=", "'", fullNameAttribute, "'", " ", "type", "=", "'", typeAttribute, "'", " ", "sv-type", "=", "'", svTypeAttribute, "'", " ", "declaration-class", "=", "'", XXVMBuilder.escapeForXML(declarationClassAttribute), "'", " ", "named-element-class", "=", "'", XXVMBuilder.escapeForXML(namedElementClassAttribute), "'", "/", ">", "\n", "\t", "<", "/", "component-hierarchy", ">");
        } else if (sbMap != null) {
            for (String viewId : this.getViewsIds()) {
                result.append(sbMap.get(viewId));
            }
        }
        XXVMBuilder.appendToSBUtils(result, "\n", "<", "/", "uvm-elaboration-model", ">", "\n");
    }

    public IStatus saveFailedModel(XUVMElaborationSetup uvmElaborationSetUp, String timeStamp, LastExecutedStatementInfo lastExecStmtInfo) {
        if (timeStamp == null) {
            timeStamp = "";
        }
        IProject project = uvmElaborationSetUp.getProject();
        XConsole console = XConsoleRegistry.getConsole((IProject)project, (boolean)false, (boolean)this.isRunInBatchMode());
        HistoryItem historyItem = uvmElaborationSetUp.getHistoryItem();
        if (historyItem == null || historyItem.getObjectQName() == null) {
            console.print(DVTStringUtil.appendString((Object[])new Object[]{System.lineSeparator(), "*** Error: Unable to find the test location internally \n\u2007\n"}));
            return null;
        }
        String fullPathModel = this.getFullPathModel(uvmElaborationSetUp);
        if (fullPathModel == null) {
            return Status.CANCEL_STATUS;
        }
        console.print("\nSaving model preferences into " + fullPathModel + "\n");
        StringBuilder result = new StringBuilder();
        this.computeModelFileContent(result, uvmElaborationSetUp, timeStamp, null, lastExecStmtInfo);
        this.printToFile(project, console, fullPathModel, result);
        return Status.OK_STATUS;
    }

    private void printToFile(IProject project, XConsole console, String fullPathModel, StringBuilder result) {
        try {
            Path path = Paths.get(fullPathModel, new String[0]);
            File file = path.toFile();
            if (file.exists() && !file.canWrite() && !file.setWritable(true, false)) {
                DVTLogger.INSTANCE.logError("Unable to set write permission to " + fullPathModel);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        try {
            Throwable e = null;
            Object var6_10 = null;
            try (BufferedWriter outputStreamWriter = new BufferedWriter(new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(fullPathModel))));){
                outputStreamWriter.write(result.toString());
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException e) {
            console.print(DVTStringUtil.appendString((Object[])new Object[]{"\n*** Error: Saving model failed: ", e, "\u2007\n"}));
        }
        try {
            IFolder modelsFolder = project.getFolder("dvt_uvm_elaboration_models");
            modelsFolder.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public IStatus saveModel(final XUVMElaborationSetup uvmElaborationSetup) {
        IRfNamedElement rfClass;
        List xContributors = uvmElaborationSetup.xContributors;
        if (xContributors == null || xContributors.isEmpty()) {
            return Status.CANCEL_STATUS;
        }
        IProject project = uvmElaborationSetup.getProject();
        IXXVMComponent xvmRootComponent = XXVMBuilder.INSTANCE.getXVMRootComponent();
        if (xvmRootComponent == null) {
            return Status.CANCEL_STATUS;
        }
        if (DVTXRunBuildPhaseUtils.XVM_ROOT.contains(xvmRootComponent.getSanitizedType(LanguageKind.VLOG, false))) {
            List<IXXVMComponent> children = ((XXVMComponent)xvmRootComponent).getChildren();
            if (children == null || children.isEmpty()) {
                return Status.CANCEL_STATUS;
            }
            xvmRootComponent = children.get(0);
        }
        if (!((rfClass = xvmRootComponent.getRfClass()) instanceof RfClass)) {
            throw new IllegalStateException("Unable to serialize model elaborated");
        }
        XConsole console = XConsoleRegistry.getConsole((IProject)project, (boolean)false, (boolean)this.isRunInBatchMode());
        String fullPathModel = this.getFullPathModel(uvmElaborationSetup);
        if (fullPathModel == null) {
            return Status.CANCEL_STATUS;
        }
        console.print("\nSaving model into " + fullPathModel);
        ArrayList<1> jobs = new ArrayList<1>();
        final HashMap<String, String> sbMap = new HashMap<String, String>();
        for (final IXContributor iXContributor : xContributors) {
            Job contribJob = new Job("Job" + iXContributor.getID()){

                protected IStatus run(IProgressMonitor monitor) {
                    iXContributor.serializeModel(sbMap, uvmElaborationSetup.getTestName());
                    return Status.OK_STATUS;
                }
            };
            contribJob.schedule();
            jobs.add(contribJob);
        }
        for (Job job : jobs) {
            try {
                job.join();
            }
            catch (InterruptedException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        if (sbMap == null || sbMap.isEmpty()) {
            console.print(DVTStringUtil.appendString((Object[])new Object[]{"\n*** Error: Saving model failed: empty data\u2007\n"}));
            return Status.CANCEL_STATUS;
        }
        for (String string : this.getViewsIds()) {
            if (sbMap.containsKey(string)) continue;
            console.print(DVTStringUtil.appendString((Object[])new Object[]{"\n*** Error: Saving model failed: Unable to locate data from ", string, "\u2007\n"}));
            return Status.CANCEL_STATUS;
        }
        IXXVMComponent iXXVMComponent = XXVMBuilder.INSTANCE.getXVMRootComponent();
        String timeStamp = "";
        if (iXXVMComponent != null) {
            timeStamp = iXXVMComponent.getTimeStamp();
        }
        StringBuilder result = new StringBuilder();
        this.computeModelFileContent(result, uvmElaborationSetup, timeStamp, sbMap, null);
        this.printToFile(project, console, fullPathModel, result);
        return Status.OK_STATUS;
    }

    public IStatus loadModelAction(IProject finalProject, String testName) {
        List tops = this.getUVMBuildPhaseSerializedModels(finalProject, false);
        if (tops == null || tops.isEmpty()) {
            return Status.CANCEL_STATUS;
        }
        for (File top : tops) {
            Document document;
            try {
                document = XVMBuildPhaseXMLParser.getRuntimeElabDocumentMetadata((File)top);
            }
            catch (IOException | ParserConfigurationException | XMLStreamException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                continue;
            }
            String topTestName = XVMBuildPhaseXMLParser.INSTANCE.getTestName(document);
            if (topTestName == null || !topTestName.equals(testName)) continue;
            this.loadModel(finalProject, top);
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    public UVMRuntimeSettings getRuntimeSettings(IProject project, String elementName) {
        List tops = this.getUVMBuildPhaseSerializedModels(project, false);
        if (tops == null || tops.isEmpty()) {
            return null;
        }
        for (File top : tops) {
            String xvmFactoryRegisterId;
            IRfNamedElement namedElement;
            RfElementPath elementPath;
            Document document;
            try {
                document = XVMBuildPhaseXMLParser.getRuntimeElabDocumentMetadata((File)top);
            }
            catch (IOException | ParserConfigurationException | XMLStreamException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                continue;
            }
            String topTestName = XVMBuildPhaseXMLParser.INSTANCE.getRootElementPath(document);
            if (topTestName == null || (elementPath = RfElementPath.fromString((String)topTestName, XVlogUVMElaborationStarter.class)) == null || !((namedElement = elementPath.toNamedElement(project)) instanceof RfClass) || (xvmFactoryRegisterId = ((RfClass)namedElement).computeXVMFactoryRegisterId()) == null || !xvmFactoryRegisterId.equals(elementName)) continue;
            return XVMBuildPhaseXMLParser.INSTANCE.getUVMRuntimeSettings(document, xvmFactoryRegisterId);
        }
        return null;
    }

    public void loadModel(IProject finalProject, File file) {
        XVMBuildPhaseXMLParser.INSTANCE.parse(file, finalProject);
        try {
            try {
                this.jobToStopCandidate.forEach(job -> {
                    boolean bl = job.cancel();
                });
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                this.jobToStopCandidate.clear();
            }
        }
        finally {
            this.jobToStopCandidate.clear();
        }
    }

    public IBuildEventManagerListener getXModelEventListener() {
        return XXVMBuilder.INSTANCE.getXModelEventListener();
    }

    public void setLoadModelSuccesfully(IProject project, String testName) {
        XXVMBuilder.INSTANCE.setLoadModelSuccesfully(project, testName);
    }

    public IXDPITypeMapperManager getDPICMapperManager() {
        return XVlogDPICTypeMapperManager.getInstance();
    }

    public IStatus generateDPICHeader(IProject project, boolean isSimulatorMode) {
        return new XVlogDPICEngine(project, isSimulatorMode).start();
    }

    public void start(XUVMElaborationSetup uvmElaborationSetup) {
        IProject project = uvmElaborationSetup.getProject();
        if (!uvmElaborationSetup.isLoadSerializedTestMode() && PrecompiledDBUtils.containsPrecompiledInvocation((IProject)project)) {
            ObjectionManager.getInstance().clear(Objection.PRECOMPILATION_LIMITATION_POPUP);
            PrecompiledDBUtils.openFailDialog((String)"UVM Runtime Elaboration Issue", (String)"Cannot perform UVM Runtime Elaboration on projects containing precompiled databases. Build without precompilation when performing UVM Runtime Elaboration.");
            return;
        }
        XUVMElaborationJob job = new XUVMElaborationJob(uvmElaborationSetup, (XVlogUVMElaborationStarter)this);
        this.jobToStopCandidate.add(job);
        job.schedule();
    }

    public List<String> getViewsIds() {
        return Arrays.asList("ro.amiq.dvt.ui.views.VerificationHierarchyView", "ro.amiq.dvt.ui.views.RegistersView", "ro.amiq.dvt.ui.views.ConfigDBView", "ro.amiq.dvt.ui.views.FactoryOverridesView");
    }

    public boolean isRunInBatchMode() {
        return this.isRunInBatchMode;
    }

    protected abstract void popUpErrorMessage(String var1);

    protected abstract void popUpElaborationInProgress(XUVMElaborationSetup var1, ILaunch var2);
}

