/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.view;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.ch.model.XVMBuildPhaseXMLParser;
import ro.amiq.dvt.interpreter.IDVTXModelManager;
import ro.amiq.dvt.interpreter.XUVMElaborationStarters;
import ro.amiq.dvt.interpreter.XUpdateEvent;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.vlogdt.interpreter.utils.XVlogContributorUtils;
import ro.amiq.vlogdt.interpreter.view.XXVMBuilder;
import ro.amiq.vlogdt.model.reflection.views.VHHistoryItem;

public abstract class XVlogXModelEventListenerCommon
implements IDVTXModelManager {
    protected boolean registered;
    protected IProject currentProject;
    protected final Map<IProject, HistoryItem> projectsTops = new HashMap<IProject, HistoryItem>();

    public void notifyFullBuild(IProject project) {
        XXVMBuilder.INSTANCE.deepClean();
    }

    public void notifyIncrementalBuild(IProject project, Map<LanguageKind, Set<FileCompileInfo>> changedFiles, Set<String> updateViewIds) {
    }

    public void notifyCleanBuild(IProject project) {
        XXVMBuilder.INSTANCE.deepClean();
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public boolean isComputed() {
        return XXVMBuilder.INSTANCE.isComputed();
    }

    public HistoryItem getXVHHistoryItem(IProject project) {
        if (this.projectsTops == null || this.projectsTops.isEmpty()) {
            return null;
        }
        return this.projectsTops.get(project);
    }

    public void notifyXModelListenerResourceChanges(IProject project, XUpdateEvent updateEvent) {
        if (updateEvent == XUpdateEvent.PROJECT_CLOSE) {
            this.internalHandleProjectClose(project);
            return;
        }
        if (updateEvent == XUpdateEvent.RESOURCE_SELECTION) {
            this.internalHandleResourceSelection(project);
        }
    }

    protected void internalHandleProjectClose(IProject project) {
        XXVMBuilder.INSTANCE.deepClean();
        this.projectsTops.remove(project);
    }

    protected void internalHandleResourceSelection(IProject newProject) {
        if (this.currentProject == null) {
            return;
        }
        if (this.currentProject.getName().equals(newProject.getName())) {
            return;
        }
        this.currentProject = newProject;
        XXVMBuilder.INSTANCE.deepClean();
        HistoryItem lastModel = this.projectsTops.get(newProject);
        if (!(lastModel instanceof VHHistoryItem)) {
            return;
        }
        RfElementPath objectQName = ((VHHistoryItem)lastModel).getObjectQName();
        if (objectQName == null) {
            throw new IllegalStateException("Unable to compute qualified name for history item " + lastModel.getText());
        }
        String lastModelName = objectQName.getElementName();
        File serializedModel = null;
        List models = XUVMElaborationStarters.getStarter((LanguageKind)LanguageKind.VLOG).getUVMBuildPhaseSerializedModels(newProject, false);
        for (File file : models) {
            if (!FilenameUtils.removeExtension((String)file.getName()).equals(lastModelName)) continue;
            serializedModel = file;
        }
        if (serializedModel == null) {
            return;
        }
        XVMBuildPhaseXMLParser.INSTANCE.parse(serializedModel, newProject, false);
    }

    public void setIsRegistered() {
        this.registered = true;
    }

    public void registerLastModel(IProject project, String testName) {
        HistoryItem historyItem = XVlogContributorUtils.xComputeHistoryItem(project, testName);
        if (historyItem == null) {
            return;
        }
        this.projectsTops.put(project, historyItem.copy(true, true));
        this.currentProject = project;
    }
}

