/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.view;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.debug.core.intrp.model.IntrpDebugTarget;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.DVTRunLaunchCache;
import ro.amiq.dvt.interpreter.DVTXRunBuildPhaseUtils;
import ro.amiq.dvt.interpreter.IDVTXModelManager;
import ro.amiq.dvt.interpreter.IXUVMElaborationBuilder;
import ro.amiq.dvt.interpreter.IXUVMElaborationStarter;
import ro.amiq.dvt.interpreter.IXVHComponent;
import ro.amiq.dvt.interpreter.IXVHObject;
import ro.amiq.dvt.interpreter.IXXVMComponent;
import ro.amiq.dvt.interpreter.IXXVMConfigDBSetGetCallInfo;
import ro.amiq.dvt.interpreter.IXXVMFactoryOverrideElement;
import ro.amiq.dvt.interpreter.IXXVMObject;
import ro.amiq.dvt.interpreter.IXXVMRegBlock;
import ro.amiq.dvt.interpreter.ThreadByViewType;
import ro.amiq.dvt.interpreter.XArrayValueHolder;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.interpreter.XThread;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.interpreter.XViewsThreadCache;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.ui.views.IBuildEventManagerListener;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.config.db.ConfigDBViewFilters;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.vlogdt.interpreter.factory.chs.XModel;
import ro.amiq.vlogdt.interpreter.factory.chs.XVHComponent;
import ro.amiq.vlogdt.interpreter.factory.chs.XVHCustomPortComponent;
import ro.amiq.vlogdt.interpreter.factory.chs.XVHObject;
import ro.amiq.vlogdt.interpreter.factory.chs.XVHPortComponent;
import ro.amiq.vlogdt.interpreter.factory.chs.XVlogCHSValueHolderFactory;
import ro.amiq.vlogdt.interpreter.factory.chs.XXVMConfigDBSetValueHolderCallInfo;
import ro.amiq.vlogdt.interpreter.view.XVlogXModelEventListener;
import ro.amiq.vlogdt.interpreter.views.registers.XXVMRegBlock;
import ro.amiq.vlogdt.interpreter.views.registers.XXVMRegister;
import ro.amiq.vlogdt.interpreter.views.verification.hierarchy.XCustomPortComponent;
import ro.amiq.vlogdt.interpreter.views.verification.hierarchy.XXVMComponent;
import ro.amiq.vlogdt.interpreter.views.verification.hierarchy.XXVMObject;
import ro.amiq.vlogdt.interpreter.views.verification.hierarchy.XXVMPortComponent;
import ro.amiq.vlogdt.model.reflection.RfClass;

public enum XXVMBuilder implements IXUVMElaborationBuilder
{
    INSTANCE;

    private final IBuildEventManagerListener xModelListener = new XVlogXModelEventListener();
    private IXXVMComponent rootComponent;
    private final Map<IXVHComponent, IXXVMComponent> allComponents = new IdentityHashMap<IXVHComponent, IXXVMComponent>();
    private final List<IXXVMRegBlock> rootRegisterComponents = new ArrayList<IXXVMRegBlock>();
    private final Map<String, List<IXXVMFactoryOverrideElement>> allFactoryOverrides = new LinkedHashMap<String, List<IXXVMFactoryOverrideElement>>();
    private final Map<String, IXXVMComponent> xComponents = new LinkedHashMap<String, IXXVMComponent>();
    private final Map<String, IXXVMObject> xObjects = new LinkedHashMap<String, IXXVMObject>();
    private int globalIdXVMConfigDBCallEvaluation = 1;
    private long totalRegistersCount;
    private long totalFactoryOverrides;
    private final Map<String, List<IXXVMConfigDBSetGetCallInfo>> allConfigDBCalls;
    private boolean isComputed;

    private XXVMBuilder() {
        this.allFactoryOverrides.put("Direct", new LinkedList());
        this.allFactoryOverrides.put("Chain", new LinkedList());
        this.allFactoryOverrides.put("Unused", new LinkedList());
        this.allConfigDBCalls = new LinkedHashMap<String, List<IXXVMConfigDBSetGetCallInfo>>();
        Arrays.asList(ConfigDBViewFilters.values()).forEach(configDBType -> {
            if (configDBType != ConfigDBViewFilters.HIDE_READ_ONLY_SETTERS) {
                this.allConfigDBCalls.put(configDBType.getLabel(), new LinkedList());
            }
        });
    }

    public void buildXModel(IXVHComponent rootComponent, XValueHolderFactory factory, List<IXXVMFactoryOverrideElement> factoryOverrides, Map<XValueHolder, IXVHComponent> allComponents, Map<XValueHolder, IXVHObject> allObjects, String xvmPrefix, IRfNamedElement xvmPkgElement, Map<XValueHolder, GoToInfo> allRegistersBlocksGoToInfos, Map<XValueHolder, List<IXXVMConfigDBSetGetCallInfo>> xvmObsoleteResources, Map<XValueHolder, IXXVMConfigDBSetGetCallInfo> xvmAvailableResources, List<IXXVMConfigDBSetGetCallInfo> xvmUnassociatedGetters, IRfSingleLangProject rfProject) {
        if (!(factory.getVlogContributor() instanceof XVlogCHSValueHolderFactory)) {
            throw new IllegalStateException("Unable to compute data from " + factory);
        }
        XVlogCHSValueHolderFactory chsFactory = (XVlogCHSValueHolderFactory)factory.getVlogContributor();
        rootComponent.build((IXUVMElaborationBuilder)this, null, null);
        this.setRootComponentCHDDiagramPath(chsFactory.getUVMDiagramFilename(), chsFactory.getUVMDiagramFileFullPath(), chsFactory.getTimeStamp());
        this.computeXVHObjects(allObjects);
        this.computeFactoryOverrides(factoryOverrides);
        this.computeConnections(allComponents);
        this.computeUVMRegisters(xvmPrefix, xvmPkgElement, factory, allRegistersBlocksGoToInfos);
        this.computeXVMConfigDBSetCalls(xvmObsoleteResources, xvmAvailableResources, xvmUnassociatedGetters, factory, rfProject);
        this.isComputed = true;
        String testNameFromArg = factory.getTestName();
        String fullTestName = this.getActualTestName(testNameFromArg);
        this.registerLastModel(rfProject.getProject(), fullTestName);
    }

    public String getActualTestName(String testNameFromArg) {
        IRfNamedElement rfClass;
        IXXVMComponent xvmRootComp = this.rootComponent;
        if (DVTXRunBuildPhaseUtils.XVM_ROOT.contains(this.rootComponent.getSanitizedType(LanguageKind.VLOG, false))) {
            List<IXXVMComponent> children = ((XXVMComponent)this.rootComponent).getChildren();
            if (children == null || children.isEmpty()) {
                return null;
            }
            for (IXXVMComponent child : children) {
                RfClass childRfClass;
                IRfNamedElement childNamedElement = child.getRfClass();
                if (!(childNamedElement instanceof RfClass) || !(childRfClass = (RfClass)childNamedElement).isSubClass("uvm_test", true) && !childRfClass.isSubClass("ovm_test", true) || testNameFromArg != null && !testNameFromArg.equals(child.getTypeName())) continue;
                xvmRootComp = child;
                break;
            }
        }
        if (!((rfClass = xvmRootComp.getRfClass()) instanceof RfClass)) {
            throw new IllegalStateException("Unable to register last elaborated model");
        }
        return ((RfClass)rfClass).computeXVMFactoryRegisterId();
    }

    void computeXVHObjects(Map<XValueHolder, IXVHObject> allObjects) {
        for (Map.Entry<XValueHolder, IXVHObject> objectEntry : allObjects.entrySet()) {
            XVHObject xvhObject = (XVHObject)objectEntry.getValue();
            List<IXXVMFactoryOverrideElement> factoryOverrides = xvhObject.getFactoryOverrides();
            if (factoryOverrides == null || factoryOverrides.isEmpty()) continue;
            for (IXXVMFactoryOverrideElement override : factoryOverrides) {
                String fullInstPath = xvhObject.getFullInstPath();
                XXVMObject xxvmObject = new XXVMObject(xvhObject, fullInstPath);
                this.xObjects.put(fullInstPath, xxvmObject);
                override.addXXVMAffectedByFactoryOverride((IXXVMObject)xxvmObject);
            }
        }
    }

    public void registerLastModel(IProject project, String testName) {
        ((IDVTXModelManager)this.xModelListener).registerLastModel(project, testName);
    }

    public IXXVMComponent createComponent(IXVHComponent original, IXXVMComponent parent, IXVHComponent originalParent) {
        XXVMComponent component = null;
        if (original instanceof XVHCustomPortComponent) {
            component = new XCustomPortComponent((XVHCustomPortComponent)original, parent);
        } else if (original instanceof XVHPortComponent) {
            component = new XXVMPortComponent((XVHPortComponent)original, parent);
        } else if (original instanceof XVHComponent) {
            component = new XXVMComponent((XVHComponent)original, parent);
        }
        if (component == null) {
            return null;
        }
        if (parent == null) {
            this.rootComponent = component;
        }
        this.allComponents.put(original, component);
        this.addComponent(parent, component);
        component.setNamedElement(this.computeRfElementFromXVMComponent((XVHComponent)original, (XVHComponent)originalParent));
        return component;
    }

    public IXXVMComponent getXVMRootComponent() {
        return this.rootComponent;
    }

    public void addComponent(IXXVMComponent parent, IXXVMComponent child) {
        if (parent == null) {
            return;
        }
        if (child instanceof XXVMComponent && XXVMBuilder.checkIsTLMFifo(((XXVMComponent)child).getSanitizedType(child.getLanguageKind(), false))) {
            parent.addPorts(child);
            return;
        }
        if (child instanceof XXVMPortComponent || child instanceof XCustomPortComponent) {
            parent.addPorts(child);
            return;
        }
        if (child != null) {
            parent.addChildren(child);
        }
    }

    public static boolean checkIsTLMFifo(String sanitizedType) {
        for (String tlm_fifo_pattern : IXXVMComponent.TLM_FIFOS) {
            if (!sanitizedType.startsWith(tlm_fifo_pattern)) continue;
            return true;
        }
        return false;
    }

    protected IRfNamedElement computeRfElementFromXVMComponent(XVHComponent original, XVHComponent originalParent) {
        IELParamValue myPort;
        if (original == null || originalParent == null || original.getValueHolder() == null) {
            return null;
        }
        XValueHolder valueHolder = original.getValueHolder();
        if (valueHolder == null || valueHolder.getValues() == null) {
            return null;
        }
        XValueHolder parentValueHolder = originalParent.getValueHolder();
        if (parentValueHolder == null || parentValueHolder.getValues() == null) {
            return null;
        }
        Map parentValues = parentValueHolder.getValues().getEntries();
        ELParamValues originalValues = valueHolder.getValues();
        if (original instanceof XVHPortComponent && (myPort = ((XVHPortComponent)original).get_m_port()) instanceof XValueHolder) {
            originalValues = ((XValueHolder)myPort).getValues();
        }
        for (Map.Entry entry : parentValues.entrySet()) {
            XValueHolder candidateHolder;
            IELParamValue candidate = (IELParamValue)entry.getValue();
            if (!(candidate instanceof XValueHolder) || (candidateHolder = (XValueHolder)candidate).getValues() != originalValues) continue;
            return candidateHolder.getElement();
        }
        return null;
    }

    public void computeConnections(Map<XValueHolder, IXVHComponent> componentsMap) {
        if (componentsMap == null || componentsMap.isEmpty() || this.allComponents.isEmpty()) {
            return;
        }
        for (Map.Entry<XValueHolder, IXVHComponent> entry : componentsMap.entrySet()) {
            XVHPortComponent port;
            IXXVMComponent source;
            if (!(entry.getValue() instanceof XVHPortComponent) || !((source = this.allComponents.get(port = (XVHPortComponent)entry.getValue())) instanceof XXVMPortComponent)) continue;
            for (XVHPortComponent target : port.getConnectedTo()) {
                IXXVMComponent destination = this.allComponents.get(target);
                if (!(destination instanceof XXVMPortComponent)) continue;
                ((XXVMPortComponent)source).connectedTo((XXVMPortComponent)destination);
            }
        }
        this.allComponents.clear();
    }

    public synchronized void deepCleanVerificationHierarchyElements() {
        if (!(this.rootComponent instanceof XXVMComponent)) {
            return;
        }
        ((XXVMComponent)this.rootComponent).deepClean();
        this.rootComponent = null;
        this.allComponents.clear();
        this.xComponents.clear();
    }

    public synchronized void deepClean() {
        this.isComputed = false;
        this.deepCleanFactoryOverridesElements();
        this.deepCleanRegistersElements();
        this.deepCleanVerificationHierarchyElements();
        this.deepCleanXVMConfigDBElements();
        this.xObjects.clear();
    }

    public synchronized void deepCleanRegistersElements() {
        if (this.rootRegisterComponents == null || this.rootRegisterComponents.isEmpty()) {
            return;
        }
        for (IXXVMRegBlock block : this.rootRegisterComponents) {
            block.deepClean();
        }
        this.rootRegisterComponents.clear();
        this.totalRegistersCount = 0L;
    }

    public List<IXXVMRegBlock> getRootBlockRegisters() {
        return this.rootRegisterComponents;
    }

    public List<XXVMRegister> computeRegistersFlat() {
        ArrayList<XXVMRegister> registers = new ArrayList<XXVMRegister>();
        for (IXXVMRegBlock block : this.rootRegisterComponents) {
            this.depthTraversal(block, registers);
        }
        this.totalRegistersCount = registers.size();
        return registers;
    }

    private void depthTraversal(IXXVMRegBlock block, List<XXVMRegister> registers) {
        if (block instanceof XXVMRegister) {
            registers.add((XXVMRegister)block);
            return;
        }
        for (IXXVMRegBlock childBlock : ((XXVMRegBlock)block).getChildren()) {
            this.depthTraversal(childBlock, registers);
        }
    }

    public void computeUVMRegisters(String xvmPrefix, IRfNamedElement xvmPkgElement, XValueHolderFactory valueHolderFactory, Map<XValueHolder, GoToInfo> allRegistersBlocksGoToInfos) {
        this.totalRegistersCount = 0L;
        if (!(valueHolderFactory.getVlogContributor() instanceof XVlogCHSValueHolderFactory)) {
            throw new IllegalArgumentException("Factory should be XVlogCHSValueHolderFactory type!");
        }
        XVlogCHSValueHolderFactory factoryContributor = (XVlogCHSValueHolderFactory)valueHolderFactory.getVlogContributor();
        String uvmRegBlkRootName = String.valueOf(xvmPrefix) + "_reg_block";
        IRfNamedElement uvmRegBlkElement = xvmPkgElement.getLocalMember(null, uvmRegBlkRootName, null);
        if (uvmRegBlkElement == null) {
            return;
        }
        XNamedElement uvmRegBlkXNamedElement = XNamedElement.create((IRfNamedElement)uvmRegBlkElement, null, (boolean)true, (boolean)false);
        if (uvmRegBlkXNamedElement == null) {
            return;
        }
        XValueHolder uvmRegBlkValue = factoryContributor.getFactory().getStaticValueHolder(uvmRegBlkXNamedElement);
        if (!(uvmRegBlkValue instanceof XValueHolder)) {
            return;
        }
        IELParamValue m_roots_valueDirectly = uvmRegBlkValue.getValueDirectly("m_roots");
        if (!(m_roots_valueDirectly instanceof XArrayValueHolder)) {
            return;
        }
        HashMap<XValueHolder, IXXVMRegBlock> allMappedRegBlocksAndRegs = new HashMap<XValueHolder, IXXVMRegBlock>();
        ((XArrayValueHolder)m_roots_valueDirectly).foreach((key, value) -> {
            this.rootRegisterComponents.add(this.computeMappedRegistersRecursiveFromRoot(key, factoryContributor, allMappedRegBlocksAndRegs));
            return true;
        });
        IRfNamedElement xvmRegBaseClass = xvmPkgElement.getLocalMember(null, String.valueOf(xvmPrefix) + "_reg", null);
        if (xvmRegBaseClass == null) {
            return;
        }
        this.computeGoToInfosForMappedRegisters(allRegistersBlocksGoToInfos, allMappedRegBlocksAndRegs.entrySet().stream().filter(xValueHolderAndRegPair -> ((XValueHolder)xValueHolderAndRegPair.getKey()).getValues() != null).collect(Collectors.toMap(xValueHolderAndRegPair -> ((XValueHolder)xValueHolderAndRegPair.getKey()).getValues(), Map.Entry::getValue, (regBlock1, regBlock2) -> regBlock1, () -> new IdentityHashMap())));
        this.computeUnmappedRegisters(factoryContributor, xvmRegBaseClass, allRegistersBlocksGoToInfos, allMappedRegBlocksAndRegs);
        allMappedRegBlocksAndRegs.clear();
    }

    private void computeGoToInfosForMappedRegisters(Map<XValueHolder, GoToInfo> allRegistersBlocksGoToInfos, Map<ELParamValues, IXXVMRegBlock> allMappedRegBlocksAndRegs) {
        for (Map.Entry<XValueHolder, GoToInfo> xValueHolderAndGoToInfoPair : allRegistersBlocksGoToInfos.entrySet()) {
            IXXVMRegBlock regOrRegBlock;
            ELParamValues valuesToCheck = xValueHolderAndGoToInfoPair.getKey().getValues();
            if (valuesToCheck == null || (regOrRegBlock = (IXXVMRegBlock)allMappedRegBlocksAndRegs.getOrDefault(valuesToCheck, null)) == null) continue;
            ((XXVMRegBlock)regOrRegBlock).setCreateCallGoToInfo(xValueHolderAndGoToInfoPair.getValue());
        }
    }

    private void computeUnmappedRegisters(XVlogCHSValueHolderFactory factoryContributor, IRfNamedElement xvmRegBaseClass, Map<XValueHolder, GoToInfo> allRegistersBlocksGoToInfos, Map<XValueHolder, IXXVMRegBlock> allMappedRegBlocksAndRegs) {
        for (Map.Entry<XValueHolder, GoToInfo> xValueHolderAndGoToInfoPair : allRegistersBlocksGoToInfos.entrySet()) {
            IRfNamedElement namedElement;
            XValueHolder xValueHolder = xValueHolderAndGoToInfoPair.getKey();
            if (allMappedRegBlocksAndRegs.containsKey(xValueHolder) || (namedElement = xValueHolder.getNamedElement()) == null || !namedElement.xCanCastTo(xvmRegBaseClass)) continue;
            this.computeUnmappedRegisterFromXValueHolder(factoryContributor, xValueHolder, allMappedRegBlocksAndRegs, xValueHolderAndGoToInfoPair.getValue());
        }
    }

    private XValueHolder getXValueHolderParent(XVlogCHSValueHolderFactory valueHolderFactory, XValueHolder register, XThread xThread) {
        IELParamValue parentParamValue;
        XModel xModel = valueHolderFactory.getXModel();
        boolean skipTerminateCheck = false;
        if (xModel != null) {
            skipTerminateCheck = xModel.isComputeOnFail();
        }
        if (!((parentParamValue = valueHolderFactory.executeFunctionOnThread(register, "get_parent", null, xThread, skipTerminateCheck)) instanceof XValueHolder)) {
            return null;
        }
        return (XValueHolder)parentParamValue;
    }

    private void computeUnmappedRegisterFromXValueHolder(XVlogCHSValueHolderFactory factoryContributor, XValueHolder xvmRegHolder, Map<XValueHolder, IXXVMRegBlock> allMappedRegBlocksAndRegs, GoToInfo goToInfo) {
        String fullName;
        if (xvmRegHolder == null) {
            return;
        }
        XThread cachedThread = XViewsThreadCache.getInstance().get(factoryContributor.getFactory().getProject(), factoryContributor.getFactory().xSim, ThreadByViewType.REGISTERS_VIEW);
        XValueHolder parentHolder = this.getXValueHolderParent(factoryContributor, xvmRegHolder, cachedThread);
        if (parentHolder == null) {
            return;
        }
        IXXVMRegBlock parentRegBlock = allMappedRegBlocksAndRegs.getOrDefault(parentHolder, null);
        if (parentRegBlock == null) {
            return;
        }
        XModel xModel = factoryContributor.getXModel();
        boolean skipTerminateCheck = false;
        if (xModel != null) {
            skipTerminateCheck = xModel.isComputeOnFail();
        }
        if ((fullName = ELUtils.valueToString((IELParamValue)factoryContributor.executeFunctionOnThread(xvmRegHolder, "get_full_name", null, cachedThread, skipTerminateCheck))) == null) {
            return;
        }
        String mLeafName = ELUtils.valueToString((IELParamValue)xvmRegHolder.getValueDirectly("m_leaf_name"));
        if (mLeafName == null) {
            return;
        }
        IELParamValue addrStartParamValue = ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.ZERO64);
        String rights = "RW";
        XValueHolder namedElementXValueHolder = this.computeNamedElement(xvmRegHolder, mLeafName);
        IRfNamedElement namedElement = null;
        XNamedElement xAssociatedType = null;
        if (namedElementXValueHolder != null) {
            namedElement = namedElementXValueHolder.getElement();
            xAssociatedType = namedElementXValueHolder.getXNamedElement();
        }
        XXVMRegister register = new XXVMRegister(mLeafName, fullName, addrStartParamValue, rights, "", parentRegBlock, namedElement, xAssociatedType);
        ((XXVMRegBlock)register).setCreateCallGoToInfo(goToInfo);
        ((XXVMRegBlock)parentRegBlock).addChildren(register);
        ++this.totalRegistersCount;
    }

    private IXXVMRegBlock computeMappedRegistersRecursiveFromRoot(IELParamValue rootParamValue, XVlogCHSValueHolderFactory factory, Map<XValueHolder, IXXVMRegBlock> allMappedRegBlocksAndRegs) {
        if (!(rootParamValue instanceof XValueHolder)) {
            return null;
        }
        XModel xModel = factory.getXModel();
        boolean skipTerminateCheck = false;
        if (xModel != null) {
            skipTerminateCheck = xModel.isComputeOnFail();
        }
        XThread cachedThread = XViewsThreadCache.getInstance().get(factory.getFactory().getProject(), factory.getFactory().xSim, ThreadByViewType.REGISTERS_VIEW);
        IELParamValue fullNameParamValue = factory.executeFunctionOnThread((XValueHolder)rootParamValue, "get_full_name", null, cachedThread, skipTerminateCheck);
        String full_name = ELUtils.valueToString((IELParamValue)fullNameParamValue);
        XXVMRegBlock block = new XXVMRegBlock(full_name, null);
        allMappedRegBlocksAndRegs.put((XValueHolder)rootParamValue, block);
        IELParamValue default_mapParamValue = factory.executeFunctionOnThread((XValueHolder)rootParamValue, "get_default_map", null, cachedThread, skipTerminateCheck);
        if (!(default_mapParamValue instanceof XValueHolder)) {
            return null;
        }
        this.computeRecursiveSubmapsForDefaultMap((XValueHolder)default_mapParamValue, block, factory, allMappedRegBlocksAndRegs);
        return block;
    }

    private void computeRecursiveSubmapsForDefaultMap(XValueHolder default_map, IXXVMRegBlock parentRegBlock, XVlogCHSValueHolderFactory factory, Map<XValueHolder, IXXVMRegBlock> allMappedRegBlocksAndRegs) {
        this.computeInternalRegistersForDefaulMap(default_map, parentRegBlock, factory, allMappedRegBlocksAndRegs);
        IELParamValue m_submapsParamValue = default_map.getValueDirectly("m_submaps");
        if (!(m_submapsParamValue instanceof XArrayValueHolder)) {
            return;
        }
        XModel xModel = factory.getXModel();
        AtomicBoolean skipTerminateCheck = new AtomicBoolean(false);
        if (xModel != null) {
            skipTerminateCheck.set(xModel.isComputeOnFail());
        }
        ((XArrayValueHolder)m_submapsParamValue).foreach((key, value) -> {
            if (!(key instanceof XValueHolder)) {
                return true;
            }
            XThread cachedThread = XViewsThreadCache.getInstance().get(factory.getFactory().getProject(), xVlogCHSValueHolderFactory.getFactory().xSim, ThreadByViewType.REGISTERS_VIEW);
            IELParamValue parentParamValue = factory.executeFunctionOnThread((XValueHolder)key, "get_parent", null, cachedThread, skipTerminateCheck.get());
            if (!(parentParamValue instanceof XValueHolder)) {
                return true;
            }
            XValueHolder parentHolder = (XValueHolder)parentParamValue;
            IELParamValue m_leaf_name = parentHolder.getValueDirectly("m_leaf_name");
            String parent_name = ELUtils.valueToString((IELParamValue)m_leaf_name);
            if (parent_name == null) {
                return true;
            }
            IXXVMRegBlock newParentRegBlock = this.createNewParentRegBlock(parentHolder, parent_name, parentRegBlock);
            allMappedRegBlocksAndRegs.put(parentHolder, newParentRegBlock);
            ((XXVMRegBlock)parentRegBlock).addChildren(newParentRegBlock);
            this.computeRecursiveSubmapsForDefaultMap((XValueHolder)key, newParentRegBlock, factory, allMappedRegBlocksAndRegs);
            return true;
        });
    }

    private IXXVMRegBlock createNewParentRegBlock(XValueHolder parentHolder, String parentName, IXXVMRegBlock parentRegBlock) {
        XXVMRegBlock newParentRegBlock = new XXVMRegBlock(parentName, parentRegBlock);
        IRfNamedElement parentRfClassNamedElement = parentHolder.getNamedElement();
        IRfNamedElement newParentRegBlockRfNamedElement = null;
        ELParamValues parentValues = parentHolder.getValues();
        if (parentValues != null && !parentValues.isEmpty()) {
            XValueHolder childXValueHolder;
            XValueHolder parentXValueHolder;
            XValueHolder xValueHolder = parentXValueHolder = parentValues.getValue("parent") instanceof XValueHolder ? (XValueHolder)parentValues.getValue("parent") : null;
            if (parentXValueHolder != null && (childXValueHolder = (XValueHolder)parentXValueHolder.getValueDirectly(parentName)) != null) {
                newParentRegBlockRfNamedElement = childXValueHolder.getElement();
            }
        }
        if (parentRfClassNamedElement != null) {
            newParentRegBlock.setRfClass(parentRfClassNamedElement);
        }
        if (newParentRegBlockRfNamedElement != null) {
            newParentRegBlock.setRfNamedElement(newParentRegBlockRfNamedElement);
            newParentRegBlock.setComment(ViewsUtils.trimText((String)newParentRegBlockRfNamedElement.getComment(), (int)100, (boolean)true));
        }
        return newParentRegBlock;
    }

    private void computeInternalRegistersForDefaulMap(XValueHolder default_map, IXXVMRegBlock parentRegBlock, XVlogCHSValueHolderFactory factoryContributor, Map<XValueHolder, IXXVMRegBlock> allMappedRegBlocksAndRegs) {
        XThread cachedThread;
        IELParamValue get_sequencerParamValue;
        IELParamValue m_regs_infoParamValue = default_map.getValueDirectly("m_regs_info");
        if (!(m_regs_infoParamValue instanceof XArrayValueHolder)) {
            return;
        }
        XModel xModel = factoryContributor.getXModel();
        AtomicBoolean skipTerminateCheck = new AtomicBoolean(false);
        if (xModel != null) {
            skipTerminateCheck.set(xModel.isComputeOnFail());
        }
        if (!((get_sequencerParamValue = factoryContributor.executeFunctionOnThread(default_map, "get_sequencer", null, cachedThread = XViewsThreadCache.getInstance().get(factoryContributor.getFactory().getProject(), factoryContributor.getFactory().xSim, ThreadByViewType.REGISTERS_VIEW), skipTerminateCheck.get())) instanceof XValueHolder)) {
            return;
        }
        XValueHolder sequencer = (XValueHolder)get_sequencerParamValue;
        IELParamValue m_nameParamValue = sequencer.getValueDirectly("m_name");
        String sequencerName = ELUtils.valueToString((IELParamValue)m_nameParamValue);
        if (sequencerName == null) {
            return;
        }
        String[] split = DVTStringUtil.split((String)".", (String)sequencerName);
        split[0] = IXUVMElaborationStarter.computeArgumentValue((List)factoryContributor.getFactory().argv, Arrays.asList("+UVM_TESTNAME", "+OVM_TESTNAME"), (boolean)false);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < split.length) {
            sb.append(split[i]);
            if (i != split.length - 1) {
                sb.append(".");
            }
            ++i;
        }
        String seqName = sb.toString();
        ((XArrayValueHolder)m_regs_infoParamValue).foreach((key, value) -> {
            if (!(key instanceof XValueHolder) || !(value instanceof XValueHolder)) {
                return true;
            }
            XValueHolder xvm_reg_map_info = (XValueHolder)value;
            XValueHolder xvm_reg = (XValueHolder)key;
            String full_name = ELUtils.valueToString((IELParamValue)factoryContributor.executeFunctionOnThread(xvm_reg, "get_full_name", null, cachedThread, skipTerminateCheck.get()));
            if (full_name == null) {
                return true;
            }
            String m_leaf_name = ELUtils.valueToString((IELParamValue)xvm_reg.getValueDirectly("m_leaf_name"));
            if (m_leaf_name == null) {
                return true;
            }
            IELParamValue rightsParamValue = xvm_reg_map_info.getValueDirectly("rights");
            if (rightsParamValue == null) {
                return true;
            }
            String rights = ELUtils.valueToString((IELParamValue)rightsParamValue);
            if (rights == null) {
                return true;
            }
            IELParamValue addrParamValue = xvm_reg_map_info.getValueDirectly("addr");
            if (!(addrParamValue instanceof XArrayValueHolder)) {
                return true;
            }
            List addrZValues = ((XArrayValueHolder)addrParamValue).getZValues();
            if (addrZValues == null || addrZValues.isEmpty()) {
                return true;
            }
            IELParamValue addrStartValue = (IELParamValue)addrZValues.get(0);
            XValueHolder namedElementXValueHolder = this.computeNamedElement(xvm_reg, m_leaf_name);
            IRfNamedElement namedElement = null;
            XNamedElement xAssociatedType = null;
            if (namedElementXValueHolder != null) {
                namedElement = namedElementXValueHolder.getElement();
                xAssociatedType = namedElementXValueHolder.getXNamedElement();
            }
            XXVMRegister register = new XXVMRegister(m_leaf_name, full_name, addrStartValue, rights, seqName, parentRegBlock, namedElement, xAssociatedType);
            allMappedRegBlocksAndRegs.put(xvm_reg, register);
            ((XXVMRegBlock)parentRegBlock).addChildren(register);
            ++this.totalRegistersCount;
            return true;
        });
    }

    private XValueHolder computeNamedElement(XValueHolder xvm_reg, String m_leaf_name) {
        if (xvm_reg == null || m_leaf_name == null) {
            return null;
        }
        IELParamValue m_parentParamValue = xvm_reg.getValueDirectly("m_parent");
        if (!(m_parentParamValue instanceof XValueHolder)) {
            return null;
        }
        IELParamValue registerParamValue = ((XValueHolder)m_parentParamValue).getValueDirectly(m_leaf_name);
        if (!(registerParamValue instanceof XValueHolder)) {
            return null;
        }
        return (XValueHolder)registerParamValue;
    }

    public void computeFactoryOverrides(List<IXXVMFactoryOverrideElement> factoryOverrides) {
        this.totalFactoryOverrides = 0L;
        for (IXXVMFactoryOverrideElement override : factoryOverrides) {
            if (override.isChain()) {
                this.allFactoryOverrides.get("Chain").add(override);
                if (override.getAppliedOnComponents().isEmpty()) {
                    this.totalFactoryOverrides += (long)override.getCompsAffectedNames().size();
                    continue;
                }
                this.totalFactoryOverrides += (long)override.getAppliedOnComponents().size();
                continue;
            }
            if (override.getAppliedOnComponents() != null && override.getAppliedOnComponents().isEmpty()) {
                this.allFactoryOverrides.get("Unused").add(override);
                continue;
            }
            this.allFactoryOverrides.get("Direct").add(override);
            if (override.getAppliedOnComponents().isEmpty()) {
                this.totalFactoryOverrides += (long)override.getCompsAffectedNames().size();
                continue;
            }
            this.totalFactoryOverrides += (long)override.getAppliedOnComponents().size();
        }
        this.removeDuplicatedOverrides();
        this.totalFactoryOverrides += (long)this.allFactoryOverrides.get("Unused").size();
    }

    private void removeDuplicatedOverrides() {
        List<IXXVMFactoryOverrideElement> unusedOverrides = this.allFactoryOverrides.get("Unused");
        int i = 0;
        while (i < unusedOverrides.size() - 1) {
            String overrideTypeName;
            IXXVMFactoryOverrideElement ovrd1 = unusedOverrides.get(i);
            String originalTypeName = ovrd1.getOriginalTypeName();
            if (originalTypeName != null && (overrideTypeName = ovrd1.getOverrideTypeName()) != null) {
                int j = i + 1;
                while (j < unusedOverrides.size()) {
                    IXXVMFactoryOverrideElement ovrd2 = unusedOverrides.get(j);
                    if (originalTypeName.equals(ovrd2.getOriginalTypeName()) && overrideTypeName.equals(ovrd2.getOverrideTypeName())) {
                        IXXVMFactoryOverrideElement removed = unusedOverrides.remove(j);
                        ovrd1.addDuplicatedOverride(removed);
                        --j;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public synchronized void deepCleanFactoryOverridesElements() {
        for (Map.Entry<String, List<IXXVMFactoryOverrideElement>> entry : this.allFactoryOverrides.entrySet()) {
            entry.getValue().clear();
        }
        this.totalFactoryOverrides = 0L;
    }

    public Map<String, List<IXXVMFactoryOverrideElement>> getFactoryOverrides() {
        return this.allFactoryOverrides;
    }

    public static String escapeForXML(String input) {
        return StringEscapeUtils.escapeXml((String)input);
    }

    public void setRootComponentCHDDiagramPath(String fileName, String fullPath, String timeStamp) {
        if (!(this.rootComponent instanceof XXVMComponent)) {
            return;
        }
        ((XXVMComponent)this.rootComponent).setCHDFileName(fileName);
        ((XXVMComponent)this.rootComponent).setCHDFullPath(fullPath);
        ((XXVMComponent)this.rootComponent).setTimeStamp(timeStamp);
    }

    public static void appendToSBUtils(StringBuilder comps, String ... elements) {
        String[] stringArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String elem = stringArray[n2];
            comps.append(elem);
            ++n2;
        }
    }

    public void loadRootComponent(IXXVMComponent root) {
        this.rootComponent = root;
    }

    public void loadFactoryOverrides(Map<String, List<IXXVMFactoryOverrideElement>> overrides) {
        for (Map.Entry<String, List<IXXVMFactoryOverrideElement>> entry : this.allFactoryOverrides.entrySet()) {
            entry.getValue().clear();
        }
        this.allFactoryOverrides.clear();
        this.allFactoryOverrides.putAll(overrides);
        this.removeDuplicatedOverrides();
        this.totalFactoryOverrides += (long)this.allFactoryOverrides.get("Unused").size();
    }

    public void loadRegisters(List<IXXVMRegBlock> registers) {
        this.rootRegisterComponents.clear();
        this.rootRegisterComponents.addAll(registers);
    }

    public void loadComponents(Map<String, IXXVMComponent> xComponents) {
        this.xComponents.clear();
        this.xComponents.putAll(xComponents);
    }

    public Map<String, IXXVMComponent> getxComponents() {
        return this.xComponents;
    }

    public void cleanXComponents() {
        this.xComponents.clear();
    }

    public void computeXVMConfigDBSetCalls(Map<XValueHolder, List<IXXVMConfigDBSetGetCallInfo>> obsoleteResources, Map<XValueHolder, IXXVMConfigDBSetGetCallInfo> availableResources, List<IXXVMConfigDBSetGetCallInfo> unassociatedGetters, XValueHolderFactory factory, IRfSingleLangProject rfProject) {
        obsoleteResources.forEach((resource, obsoleteSetters) -> obsoleteSetters.forEach(setter -> {
            if (!(setter instanceof XXVMConfigDBSetValueHolderCallInfo)) {
                throw new IllegalStateException("Unknown to build model for Config DB View");
            }
            setter.xAddToCallType(this.allConfigDBCalls);
            ((XXVMConfigDBSetValueHolderCallInfo)setter).getXAssociatedGetters().forEach(getter -> getter.xAddToCallType(this.allConfigDBCalls));
        }));
        availableResources.forEach((resource, setter) -> {
            if (!(setter instanceof XXVMConfigDBSetValueHolderCallInfo)) {
                throw new IllegalStateException("Unknown to build model for Config DB View");
            }
            setter.xAddToCallType(this.allConfigDBCalls);
            ((XXVMConfigDBSetValueHolderCallInfo)setter).getXAssociatedGetters().forEach(getter -> getter.xAddToCallType(this.allConfigDBCalls));
        });
        unassociatedGetters.forEach(element -> element.xAddToCallType(this.allConfigDBCalls));
    }

    public synchronized void deepCleanXVMConfigDBElements() {
        IDebugTarget debugTarget;
        this.allConfigDBCalls.forEach((type, elements) -> elements.clear());
        ILaunch launch = DVTRunLaunchCache.getInstance().getLaunch();
        IDebugTarget iDebugTarget = debugTarget = launch != null ? launch.getDebugTarget() : null;
        if (debugTarget == null || !((IntrpDebugTarget)debugTarget).isDebugging()) {
            this.globalIdXVMConfigDBCallEvaluation = 1;
        }
    }

    public Map<String, List<IXXVMConfigDBSetGetCallInfo>> getConfigDBCalls() {
        return this.allConfigDBCalls;
    }

    public synchronized int incrementAndGetXVMConfigDBCallIndex() {
        return this.globalIdXVMConfigDBCallEvaluation++;
    }

    public void loadConfigDBCalls(Map<String, List<IXXVMConfigDBSetGetCallInfo>> configCalls) {
        this.allConfigDBCalls.clear();
        this.allConfigDBCalls.putAll(configCalls);
    }

    public IBuildEventManagerListener getXModelEventListener() {
        return this.xModelListener;
    }

    public boolean isComputed() {
        return this.isComputed;
    }

    public void resetIsComputed() {
        this.isComputed = false;
    }

    void setLoadModelSuccesfully(IProject project, String testName) {
        this.isComputed = true;
        ((IDVTXModelManager)this.xModelListener).registerLastModel(project, testName);
    }

    public Map<String, IXXVMObject> getXVMObjectsOverrided() {
        return this.xObjects;
    }

    public void loadXObjects(Map<String, IXXVMObject> xObjects) {
        this.xObjects.clear();
        this.xObjects.putAll(xObjects);
    }

    public long getTotalRegistersCount() {
        return this.totalRegistersCount;
    }

    public long getTotalFactoryOverrides() {
        return this.totalFactoryOverrides;
    }

    public void incrementRegisterCount() {
        ++this.totalRegistersCount;
    }

    public void incrementFactoryOverridesCount() {
        ++this.totalFactoryOverrides;
    }
}

