/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.views.factory.overrides;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.IXXVMFactoryOverrideElement;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownMethodEvaluationException;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.vlogdt.interpreter.factory.XVlogValueHolderFactory;
import ro.amiq.vlogdt.interpreter.factory.dpi.custom.methods.XDPICSVCustomMethodsUtils;
import ro.amiq.vlogdt.interpreter.factory.systemc.XSystemCFactory;
import ro.amiq.vlogdt.interpreter.factory.uvm.methods.XUvmGlobToRe;
import ro.amiq.vlogdt.interpreter.factory.uvm.methods.XUvmReMatch;
import ro.amiq.vlogdt.interpreter.utils.XVlogContributorUtils;
import ro.amiq.vlogdt.interpreter.views.factory.overrides.XXVMFactoryOverrideElement;
import ro.amiq.vlogdt.interpreter.views.factory.overrides.XXVMFactoryOverridesDataHolder;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;

public class XVlogFactoryOverridesUtils {
    public static FactoryOverrideArguments computeFactoryOverrideArguments(String methodCallName) {
        if (methodCallName == null) {
            return null;
        }
        switch (methodCallName) {
            case "set_type_override_by_type": {
                return new FactoryOverrideArguments("original_type", "override_type", "replace");
            }
            case "set_type_override_by_name": {
                return new FactoryOverrideArguments("original_type_name", "override_type_name", "replace");
            }
            case "set_inst_override_by_type": {
                return new FactoryOverrideArguments("original_type", "override_type", "full_inst_path");
            }
            case "set_inst_override_by_name": {
                return new FactoryOverrideArguments("original_type_name", "override_type_name", "full_inst_path");
            }
        }
        return null;
    }

    public static boolean isTypeOverrideFactoryMethodCall(String methodElementName) {
        return "set_type_override_by_type".equals(methodElementName) || "set_type_override_by_name".equals(methodElementName);
    }

    public static boolean isInstOverrideFactoryMethodCall(String methodElementName) {
        return "set_inst_override_by_type".equals(methodElementName) || "set_inst_override_by_name".equals(methodElementName);
    }

    public static void manageSetTypeOverrideMethodCall(ELParamValues values, GoToInfo goToInfo, FactoryOverrideArguments arguments, XXVMFactoryOverridesDataHolder factoryOverridesDataHolder, RfProject rfProject) {
        if (values == null) {
            throw new UnknownMethodEvaluationException("Empty parameters list for set_type_override");
        }
        if (factoryOverridesDataHolder == null) {
            throw new UnknownMethodEvaluationException("Factory overrides data holder is null");
        }
        IELParamValue originalTypeValue = values.getValue(arguments.original_type);
        IELParamValue overrideTypeValue = values.getValue(arguments.override_type);
        IELParamValue replace = values.getValue(arguments.additionalArg);
        if (originalTypeValue == null) {
            throw new UnknownMethodEvaluationException("Unable to compute " + arguments.original_type + " passed parameter to factory override");
        }
        if (overrideTypeValue == null) {
            throw new UnknownMethodEvaluationException("Unable to compute " + arguments.override_type + " passed parameter to factory override");
        }
        if (replace == null) {
            replace = ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.ONE);
        }
        IRfNamedElement originalRfClass = null;
        IRfNamedElement overrideRfClass = null;
        if (originalTypeValue instanceof ELParamValues.ParamValueNumber && overrideTypeValue instanceof ELParamValues.ParamValueNumber) {
            String original_type_name = ELUtils.valueToString((IELParamValue)originalTypeValue);
            String override_type_name = ELUtils.valueToString((IELParamValue)overrideTypeValue);
            originalRfClass = XVlogContributorUtils.xGetClass(rfProject, original_type_name);
            overrideRfClass = XVlogContributorUtils.xGetClass(rfProject, override_type_name);
            if (overrideRfClass == null) {
                return;
            }
        }
        if (originalTypeValue instanceof XValueHolder && overrideTypeValue instanceof XValueHolder) {
            XNamedElement original_type = ((XValueHolder)originalTypeValue).getRefValueHolder().getXNamedElement();
            XNamedElement override_type = ((XValueHolder)overrideTypeValue).getRefValueHolder().getXNamedElement();
            if (original_type == null || override_type == null) {
                throw new UnknownMethodEvaluationException("Unable to compute one of the passed parameter to factory override method call");
            }
            IRfNamedElement origSpecializedClass = original_type.getNamedElement();
            IRfNamedElement overSpecializedClass = override_type.getNamedElement();
            if (!(origSpecializedClass instanceof RfSpecializedClass) || !(overSpecializedClass instanceof RfSpecializedClass)) {
                throw new UnknownMethodEvaluationException("Unable to compute one of the passed parameter to factory override method call");
            }
            originalRfClass = XVlogFactoryOverridesUtils.computeParameterFactoryOverride((IRfScopeElement)origSpecializedClass);
            overrideRfClass = XVlogFactoryOverridesUtils.computeParameterFactoryOverride((IRfScopeElement)overSpecializedClass);
            XVlogFactoryOverridesUtils.registerMethodCallEval(factoryOverridesDataHolder, originalRfClass);
            XVlogFactoryOverridesUtils.registerMethodCallEval(factoryOverridesDataHolder, overrideRfClass);
        }
        if (originalRfClass == null || overrideRfClass == null) {
            throw new UnknownMethodEvaluationException("Unable to compute one of the passed parameters to factory override with \"original_type\" " + originalRfClass + " and \"override_type\" " + overrideRfClass);
        }
        if (originalRfClass.getName().equals(overrideRfClass.getName())) {
            return;
        }
        List<IXXVMFactoryOverrideElement> m_type_overrides = factoryOverridesDataHolder.m_type_overrides;
        XXVMFactoryOverrideElement override = new XXVMFactoryOverrideElement(".*", originalRfClass, overrideRfClass, goToInfo, factoryOverridesDataHolder.getTestName());
        factoryOverridesDataHolder.factoryOverrides.add(override);
        int i = 0;
        while (i < m_type_overrides.size()) {
            IXXVMFactoryOverrideElement typeOverride = m_type_overrides.get(i);
            String typeOverrideOriginalTypeName = typeOverride.getOriginalTypeName();
            if (typeOverrideOriginalTypeName != null && (typeOverrideOriginalTypeName.equals(originalRfClass.getName()) || "<unknown>".equals(typeOverrideOriginalTypeName) || "".equals(typeOverrideOriginalTypeName))) {
                if (!VlogBitVector.ONE.equals((Object)replace.getDVTNumber())) {
                    return;
                }
                ((XXVMFactoryOverrideElement)typeOverride).setObsolete(true);
                m_type_overrides.add(i, override);
                return;
            }
            ++i;
        }
        m_type_overrides.add(override);
    }

    private static void manageSetInstOverrideByName(String originalTypeName, String overrideTypeName, String fullInstPath, RfProject rfProject, XXVMFactoryOverridesDataHolder factoryOverridesDataHolder, GoToInfo goToInfoMethodCall) {
        Map<String, IRfNamedElement> m_type_names = factoryOverridesDataHolder.m_type_names;
        IRfNamedElement originalType = m_type_names.get(originalTypeName);
        IRfNamedElement overrideType = m_type_names.get(overrideTypeName);
        if (overrideType == null) {
            return;
        }
        if (!(overrideType instanceof RfClass)) {
            throw new UnknownMethodEvaluationException("Unable to compute \"override_type\" uvm_object_wrapper passed parameter to factory override method call");
        }
        XXVMFactoryOverrideElement override = null;
        override = originalType == null ? new XXVMFactoryOverrideElement(fullInstPath, originalTypeName, overrideType, goToInfoMethodCall, factoryOverridesDataHolder.getTestName()) : new XXVMFactoryOverrideElement(fullInstPath, originalType, overrideType, goToInfoMethodCall, factoryOverridesDataHolder.getTestName());
        factoryOverridesDataHolder.factoryOverrides.add(override);
        if (originalType instanceof RfClass) {
            if (XVlogFactoryOverridesUtils.checkInstOverrideExists(factoryOverridesDataHolder, originalType, overrideType, fullInstPath)) {
                return;
            }
            Map<IRfNamedElement, List<IXXVMFactoryOverrideElement>> m_inst_override_queues = factoryOverridesDataHolder.m_inst_override_queues;
            if (!m_inst_override_queues.containsKey(originalType)) {
                m_inst_override_queues.put(originalType, new ArrayList());
            }
            m_inst_override_queues.get(originalType).add(override);
            return;
        }
        if (XVlogFactoryOverridesUtils.hasWildcard(originalTypeName)) {
            for (Map.Entry<String, IRfNamedElement> entry : m_type_names.entrySet()) {
                if (!XVlogFactoryOverridesUtils.uvmIsMatch(originalTypeName, entry.getKey(), factoryOverridesDataHolder.factory)) continue;
                XVlogFactoryOverridesUtils.manageSetInstOverrideByName(entry.getKey(), overrideTypeName, fullInstPath, rfProject, factoryOverridesDataHolder, goToInfoMethodCall);
            }
            factoryOverridesDataHolder.m_wildcard_inst_overrides.add(override);
            return;
        }
        Map<String, List<IXXVMFactoryOverrideElement>> m_inst_override_name_queues = factoryOverridesDataHolder.m_inst_override_name_queues;
        if (!m_inst_override_name_queues.containsKey(originalTypeName)) {
            m_inst_override_name_queues.put(originalTypeName, new ArrayList());
        }
        m_inst_override_name_queues.get(originalTypeName).add(override);
    }

    public static void manageRegisterMethodCall(ELParamValues values, XXVMFactoryOverridesDataHolder factoryOverridesDataHolder) {
        if (values == null) {
            throw new UnknownMethodEvaluationException("Empty parameters list for register method call");
        }
        IELParamValue originalTypeValue = values.getValue("obj");
        if (!(originalTypeValue instanceof XValueHolder)) {
            throw new UnknownMethodEvaluationException("Unable to evaluate parameter \"obj\" passed to register method call");
        }
        XNamedElement obj = ((XValueHolder)originalTypeValue).getRefValueHolder().getXNamedElement();
        if (obj == null) {
            throw new UnknownMethodEvaluationException("Unable to evaluate parameter \"obj\" passed to register method call");
        }
        XVlogFactoryOverridesUtils.registerMethodCallEval(factoryOverridesDataHolder, XVlogFactoryOverridesUtils.computeParameterFactoryOverride((IRfScopeElement)obj.getNamedElement()));
    }

    private static void registerMethodCallEval(XXVMFactoryOverridesDataHolder factoryOverridesDataHolder, IRfNamedElement objRfClass) {
        if (!(objRfClass instanceof RfClass)) {
            throw new UnknownMethodEvaluationException("Unable to identify RfClass");
        }
        Map<String, IRfNamedElement> m_type_names = factoryOverridesDataHolder.m_type_names;
        RfClass rfClass = (RfClass)objRfClass;
        if (m_type_names.containsKey(rfClass.getName())) {
            return;
        }
        m_type_names.put(rfClass.getName(), rfClass);
        Set<IRfNamedElement> m_types = factoryOverridesDataHolder.m_types;
        if (m_types.contains(rfClass)) {
            return;
        }
        m_types.add(rfClass);
        Map<String, List<IXXVMFactoryOverrideElement>> m_inst_override_name_queues = factoryOverridesDataHolder.m_inst_override_name_queues;
        Map<IRfNamedElement, List<IXXVMFactoryOverrideElement>> m_inst_override_queues = factoryOverridesDataHolder.m_inst_override_queues;
        if (m_inst_override_name_queues.containsKey(rfClass.getName())) {
            m_inst_override_queues.put(rfClass, m_inst_override_name_queues.get(rfClass.getName()));
            m_inst_override_name_queues.remove(rfClass.getName());
            return;
        }
        List<IXXVMFactoryOverrideElement> m_wildcard_inst_overrides = factoryOverridesDataHolder.m_wildcard_inst_overrides;
        if (m_wildcard_inst_overrides.isEmpty()) {
            return;
        }
        if (!m_inst_override_queues.containsKey(rfClass)) {
            m_inst_override_queues.put(rfClass, new ArrayList());
        }
        for (IXXVMFactoryOverrideElement override : m_wildcard_inst_overrides) {
            if (!XVlogFactoryOverridesUtils.uvmIsMatch(override.getOriginalTypeName(), rfClass.getName(), factoryOverridesDataHolder.factory)) continue;
            m_inst_override_queues.get(rfClass).add(override);
        }
    }

    private static boolean uvmIsMatch(String expr, String str, XVlogValueHolderFactory factory) {
        return XVlogFactoryOverridesUtils.uvmReMatch(expr, str, factory);
    }

    private static boolean uvmReMatch(String expr, String str, XVlogValueHolderFactory factory) {
        if (factory.useDefaultDPICMethods()) {
            return !XUvmReMatch.uvmReMatchDPICMethodEval(factory, str, XVlogFactoryOverridesUtils.uvmGlobToRe(expr, factory));
        }
        XSystemCFactory systemCFactory = factory.getSystemCFactory();
        if (!systemCFactory.canExecuteOnThread(XDPICSVCustomMethodsUtils.getThreadId(factory.getFactory()))) {
            return !XUvmReMatch.uvmReMatchDPICMethodEval(factory, str, XVlogFactoryOverridesUtils.uvmGlobToRe(expr, factory));
        }
        return !XUvmReMatch.uvmReMatchDPICMethodEval(factory, str, XVlogFactoryOverridesUtils.uvmGlobToRe(expr, factory));
    }

    private static String uvmGlobToRe(String expr, XVlogValueHolderFactory factory) {
        if (factory.useDefaultDPICMethods()) {
            return XUvmGlobToRe.uvmGlobToReDPICMethodEval(expr);
        }
        if (!factory.getSystemCFactory().canExecuteOnThread(XDPICSVCustomMethodsUtils.getThreadId(factory.getFactory()))) {
            return XUvmGlobToRe.uvmGlobToReDPICMethodEval(expr);
        }
        return XUvmGlobToRe.uvmGlobToReDPICMethodEval(expr);
    }

    public static void manageSetInstOverrideMethodCall(ELParamValues values, GoToInfo goToInfo, FactoryOverrideArguments arguments, XXVMFactoryOverridesDataHolder factoryOverridesDataHolder, RfProject rfProject) {
        if (values == null) {
            throw new UnknownMethodEvaluationException("Empty parameters list for set_inst_override");
        }
        if (factoryOverridesDataHolder == null) {
            throw new UnknownMethodEvaluationException("Factory overrides data holder is null");
        }
        IELParamValue originalTypeValue = values.getValue(arguments.original_type);
        IELParamValue overrideTypeValue = values.getValue(arguments.override_type);
        IELParamValue fullInstPath = values.getValue(arguments.additionalArg);
        if (!(fullInstPath instanceof ELParamValues.ParamValueNumber)) {
            throw new UnknownMethodEvaluationException("Unable to compute \"full_inst_path\" passed parameter to factory override");
        }
        String fullInstPathString = ELUtils.valueToString((IELParamValue)fullInstPath);
        if (originalTypeValue instanceof XValueHolder && overrideTypeValue instanceof XValueHolder) {
            XNamedElement original_type = ((XValueHolder)originalTypeValue).getRefValueHolder().getXNamedElement();
            XNamedElement override_type = ((XValueHolder)overrideTypeValue).getRefValueHolder().getXNamedElement();
            IRfNamedElement origSpecializedClass = original_type.getNamedElement();
            IRfNamedElement overSpecializedClass = override_type.getNamedElement();
            if (!(origSpecializedClass instanceof RfSpecializedClass) || !(overSpecializedClass instanceof RfSpecializedClass)) {
                throw new UnknownMethodEvaluationException("Unable to compute one of the passed parameter to factory override method call");
            }
            IRfNamedElement originalRfClass = XVlogFactoryOverridesUtils.computeParameterFactoryOverride((IRfScopeElement)origSpecializedClass);
            IRfNamedElement overrideRfClass = XVlogFactoryOverridesUtils.computeParameterFactoryOverride((IRfScopeElement)overSpecializedClass);
            if (originalRfClass == null || overrideRfClass == null) {
                throw new UnknownMethodEvaluationException("Unable to compute one of the passed parameters to factory override with \"original_type\" " + originalRfClass + " and \"override_type\" " + overrideRfClass);
            }
            XVlogFactoryOverridesUtils.registerMethodCallEval(factoryOverridesDataHolder, originalRfClass);
            XVlogFactoryOverridesUtils.registerMethodCallEval(factoryOverridesDataHolder, overrideRfClass);
            if (XVlogFactoryOverridesUtils.checkInstOverrideExists(factoryOverridesDataHolder, originalRfClass, overrideRfClass, fullInstPathString)) {
                return;
            }
            Map<IRfNamedElement, List<IXXVMFactoryOverrideElement>> m_inst_override_queues = factoryOverridesDataHolder.m_inst_override_queues;
            if (!m_inst_override_queues.containsKey(originalRfClass)) {
                m_inst_override_queues.put(originalRfClass, new ArrayList());
            }
            XXVMFactoryOverrideElement override = new XXVMFactoryOverrideElement(fullInstPathString, originalRfClass, overrideRfClass, goToInfo, factoryOverridesDataHolder.getTestName());
            factoryOverridesDataHolder.factoryOverrides.add(override);
            m_inst_override_queues.get(originalRfClass).add(override);
            return;
        }
        if (originalTypeValue instanceof ELParamValues.ParamValueNumber && overrideTypeValue instanceof ELParamValues.ParamValueNumber) {
            String original_type_name = ELUtils.valueToString((IELParamValue)originalTypeValue);
            String override_type_name = ELUtils.valueToString((IELParamValue)overrideTypeValue);
            XVlogFactoryOverridesUtils.manageSetInstOverrideByName(original_type_name, override_type_name, fullInstPathString, rfProject, factoryOverridesDataHolder, goToInfo);
        }
    }

    private static boolean hasWildcard(String original_type_name) {
        return original_type_name.contains("*") || original_type_name.contains("+") || original_type_name.contains("?");
    }

    private static boolean checkInstOverrideExists(XXVMFactoryOverridesDataHolder factoryOverridesDataHolder, IRfNamedElement originalRfClass, IRfNamedElement overrideRfClass, String fullInstPath) {
        Map<IRfNamedElement, List<IXXVMFactoryOverrideElement>> m_inst_override_queues = factoryOverridesDataHolder.m_inst_override_queues;
        List<IXXVMFactoryOverrideElement> overridesWithOriginalType = m_inst_override_queues.get(originalRfClass);
        if (overridesWithOriginalType == null || overridesWithOriginalType.isEmpty()) {
            return false;
        }
        if (overrideRfClass == null || fullInstPath == null) {
            return false;
        }
        for (IXXVMFactoryOverrideElement override : overridesWithOriginalType) {
            if (!override.getOverrideTypeName().equals(overrideRfClass.getName()) || !fullInstPath.equals(override.getFullInstancePath(false))) continue;
            return true;
        }
        return false;
    }

    public static IRfNamedElement computeParameterFactoryOverride(IRfScopeElement componentRegistryWrapperClass) {
        if (!(componentRegistryWrapperClass instanceof RfSpecializedClass)) {
            return null;
        }
        RfSpecializedClass specialized = (RfSpecializedClass)componentRegistryWrapperClass;
        IELParamValue typeParamValue = specialized.getLocalElabConstantValue("T");
        if (ELUtils.isUnsuccessfulEval((IELParamValue)typeParamValue)) {
            if (specialized.getParameterWithPrefix("T", 256, 1, 1) == null) {
                return null;
            }
            throw new UnknownMethodEvaluationException("Unable to identify corresponding parameter value of " + specialized);
        }
        return typeParamValue.getNamedElement();
    }

    public static IRfNamedElement findOverrideByTypeEval(IRfNamedElement requestedType, String fullInstPath, XXVMFactoryOverridesDataHolder factoryOverridesDataHolder, XVlogValueHolderFactory factory, List<IXXVMFactoryOverrideElement> overridesApplied) {
        Map<IRfNamedElement, List<IXXVMFactoryOverrideElement>> m_inst_override_queues = factoryOverridesDataHolder.m_inst_override_queues;
        List<IXXVMFactoryOverrideElement> factoryOverrideListWithRequestedType = m_inst_override_queues.get(requestedType);
        IXXVMFactoryOverrideElement overrideFound = null;
        Object overrideType = null;
        if (!"".equals(fullInstPath) && factoryOverrideListWithRequestedType != null) {
            for (IXXVMFactoryOverrideElement override : factoryOverrideListWithRequestedType) {
                if (override.isObsolete() || !override.getOriginalType().equals(requestedType) && ("<unknown>".equals(override.getOriginalTypeName()) || "".equals(override.getOriginalTypeName()) || !override.getOriginalTypeName().equals(requestedType.getName())) || !XVlogFactoryOverridesUtils.uvmIsMatch(override.getFullInstancePath(false), fullInstPath, factory)) continue;
                if (factoryOverridesDataHolder.m_debug_pass) {
                    overrideFound = override;
                    overrideType = override.getOverrideType();
                    continue;
                }
                overridesApplied.add(override);
                if (override.getOverrideType().equals(requestedType)) {
                    return requestedType;
                }
                return XVlogFactoryOverridesUtils.findOverrideByTypeEval(override.getOverrideType(), fullInstPath, factoryOverridesDataHolder, factory, overridesApplied);
            }
        }
        List<IXXVMFactoryOverrideElement> m_type_overrides = factoryOverridesDataHolder.m_type_overrides;
        for (IXXVMFactoryOverrideElement override : m_type_overrides) {
            if (override.isObsolete() || !override.getOriginalType().equals(requestedType) && ("<unknown>".equals(override.getOriginalTypeName()) || "".equals(override.getOriginalTypeName()) || requestedType == null || !override.getOriginalTypeName().equals(requestedType.getName()))) continue;
            if (factoryOverridesDataHolder.m_debug_pass) {
                if (overrideType != null) continue;
                overrideFound = override;
                overrideType = override.getOverrideType();
                continue;
            }
            overridesApplied.add(override);
            if (override.getOverrideType().equals(requestedType)) {
                return requestedType;
            }
            return XVlogFactoryOverridesUtils.findOverrideByTypeEval(override.getOverrideType(), fullInstPath, factoryOverridesDataHolder, factory, overridesApplied);
        }
        if (overrideFound != null) {
            overridesApplied.add(overrideFound);
        }
        if (factoryOverridesDataHolder.m_debug_pass && overrideType != null) {
            if (overrideType.equals(requestedType)) {
                return requestedType;
            }
            return XVlogFactoryOverridesUtils.findOverrideByTypeEval((IRfNamedElement)overrideType, fullInstPath, factoryOverridesDataHolder, factory, overridesApplied);
        }
        return requestedType;
    }

    public static class FactoryOverrideArguments {
        final String original_type;
        final String override_type;
        final String additionalArg;

        public FactoryOverrideArguments(String original_type, String override_type, String thirdParameter) {
            this.original_type = original_type;
            this.override_type = override_type;
            this.additionalArg = thirdParameter;
        }

        public boolean hasInstancePath() {
            return !"replace".equals(this.additionalArg);
        }
    }
}

