/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.views.factory.overrides;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import ro.amiq.dvt.interpreter.IXXVMComponent;
import ro.amiq.dvt.interpreter.IXXVMFactoryOverrideElement;
import ro.amiq.dvt.interpreter.IXXVMObject;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.interpreter.utils.IXSerializedModelUtils;
import ro.amiq.vlogdt.interpreter.view.XXVMBuilder;

public class XXVMFactoryOverrideElement
implements IXXVMFactoryOverrideElement {
    private String[] fullInstancePath;
    private final IRfNamedElement origTypeRfClass;
    private final IRfNamedElement ovrdTypeRfClass;
    private final GoToInfo methodCallGoToInfo;
    private final String origTypeClassName;
    private boolean isObsolete;
    private final List<IXXVMObject> appliedOnComponents = new ArrayList<IXXVMObject>();
    private final List<IXXVMFactoryOverrideElement> overridesInChain = new ArrayList<IXXVMFactoryOverrideElement>();
    private final List<String> compsAffectedNames = new ArrayList<String>();
    private final String testName;
    private int id = -1;
    private final List<IXXVMFactoryOverrideElement> duplicatedOverride = new LinkedList<IXXVMFactoryOverrideElement>();

    public XXVMFactoryOverrideElement(String path, IRfNamedElement originalType, IRfNamedElement overrideType, GoToInfo methodGoToInfo, String testName) {
        this.computeFullInstancePath(path);
        this.origTypeRfClass = originalType;
        this.ovrdTypeRfClass = overrideType;
        this.methodCallGoToInfo = methodGoToInfo;
        this.origTypeClassName = null;
        this.testName = DVTStringUtil.intern((String)testName);
    }

    public XXVMFactoryOverrideElement(String path, String originalTypeName, IRfNamedElement overrideType, GoToInfo methodGoToInfo, String testName) {
        this.computeFullInstancePath(path);
        this.origTypeRfClass = null;
        this.ovrdTypeRfClass = overrideType;
        this.methodCallGoToInfo = methodGoToInfo;
        this.origTypeClassName = originalTypeName;
        this.testName = DVTStringUtil.intern((String)testName);
    }

    public String getFullInstancePath(boolean isViewFirstColumn) {
        if (this.fullInstancePath == null || this.fullInstancePath.length == 0) {
            return "";
        }
        if ("Override Chain".equals(this.fullInstancePath[0])) {
            return DVTStringUtil.join((Object[])this.fullInstancePath, (String)".");
        }
        StringBuilder sb = new StringBuilder();
        if (isViewFirstColumn) {
            sb.append(this.testName);
            int i = 1;
            while (i < this.fullInstancePath.length) {
                sb.append(".").append(this.fullInstancePath[i]);
                ++i;
            }
            return sb.toString();
        }
        return DVTStringUtil.join((Object[])this.fullInstancePath, (String)".");
    }

    public String getOriginalTypeName() {
        if (this.origTypeRfClass == null) {
            return this.origTypeClassName;
        }
        return this.origTypeRfClass.getName();
    }

    public String getOverrideTypeName() {
        return this.ovrdTypeRfClass.getName();
    }

    public GoToInfo getGoToInfo() {
        return this.methodCallGoToInfo;
    }

    public String toString() {
        return DVTStringUtil.join((Object[])this.fullInstancePath, (String)".") + " " + (this.origTypeRfClass == null ? this.origTypeClassName : this.origTypeRfClass.getName()) + " " + (this.ovrdTypeRfClass == null ? "" : this.ovrdTypeRfClass.getName()) + " ";
    }

    private void computeFullInstancePath(String path) {
        String[] segments = DVTStringUtil.split((String)".", (String)path);
        this.fullInstancePath = new String[segments.length];
        int i = 0;
        while (i < segments.length) {
            this.fullInstancePath[i] = DVTStringUtil.intern((String)segments[i]);
            ++i;
        }
    }

    public List<IXXVMObject> getAppliedOnComponents() {
        return this.appliedOnComponents;
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    public void setObsolete(boolean isReplaced) {
        this.isObsolete = isReplaced;
    }

    public IRfNamedElement getOriginalType() {
        return this.origTypeRfClass;
    }

    public IRfNamedElement getOverrideType() {
        return this.ovrdTypeRfClass;
    }

    public void addXXVMAffectedByFactoryOverride(IXXVMObject xXVMObject) {
        for (IXXVMObject obj : this.appliedOnComponents) {
            if (!obj.getSanitizedFullName().equals(xXVMObject.getSanitizedFullName())) continue;
            return;
        }
        this.appliedOnComponents.add(xXVMObject);
    }

    public void setOverridesInChain(List<IXXVMFactoryOverrideElement> overridesRecursively) {
        this.overridesInChain.addAll(overridesRecursively);
    }

    public List<IXXVMFactoryOverrideElement> getOverridesInChain() {
        return this.overridesInChain;
    }

    public boolean isChain() {
        return this.overridesInChain != null && this.overridesInChain.size() > 1;
    }

    private String getCreateGoToInfoToString() {
        if (this.methodCallGoToInfo == null) {
            return "N/A";
        }
        return IXSerializedModelUtils.serializeGoToInfo(this.methodCallGoToInfo, true);
    }

    public void serializeFactoryOverride(StringBuilder fOverds, String indentation) {
        StringBuilder fOverdsChain = new StringBuilder();
        XXVMBuilder.appendToSBUtils(fOverds, "\n", indentation, "\t", "<", "xvm-factory-override");
        XXVMBuilder.appendToSBUtils(fOverds, " ", "full-instance-path", "=", "'", XXVMBuilder.escapeForXML(DVTStringUtil.join((Object[])this.fullInstancePath, (String)".")), "'");
        XXVMBuilder.appendToSBUtils(fOverds, " ", "original-type-name", "=", "'", XXVMBuilder.escapeForXML(this.origTypeRfClass == null ? this.origTypeClassName : RfElementPath.path((IRfNamedElement)this.origTypeRfClass).toString()), "'");
        XXVMBuilder.appendToSBUtils(fOverds, " ", "override-type-name", "=", "'", XXVMBuilder.escapeForXML(this.ovrdTypeRfClass == null ? "N/A" : RfElementPath.path((IRfNamedElement)this.ovrdTypeRfClass).toString()), "'");
        if (this.methodCallGoToInfo != null) {
            XXVMBuilder.appendToSBUtils(fOverds, " ", "create-call", "=", "'", XXVMBuilder.escapeForXML(this.getCreateGoToInfoToString()), "'");
        }
        XXVMBuilder.appendToSBUtils(fOverds, " ", "obsolete", "=", "'", String.valueOf(this.isObsolete), "'");
        XXVMBuilder.appendToSBUtils(fOverds, " ", "id", "=", "'", String.valueOf(this.id), "'");
        if ((this.overridesInChain == null || this.overridesInChain.isEmpty()) && (this.appliedOnComponents == null || this.appliedOnComponents.isEmpty())) {
            XXVMBuilder.appendToSBUtils(fOverds, "/", ">");
            return;
        }
        XXVMBuilder.appendToSBUtils(fOverds, ">");
        if (this.overridesInChain != null && !this.overridesInChain.isEmpty()) {
            XXVMBuilder.appendToSBUtils(fOverdsChain, "\n", indentation, "\t", "\t", "<", "xvm-factory-override-in-chain", " ", "chain-elements", "=", "'");
            int i = 0;
            while (i < this.overridesInChain.size()) {
                XXVMBuilder.appendToSBUtils(fOverdsChain, String.valueOf(this.overridesInChain.get(i).getId()));
                if (i != this.overridesInChain.size() - 1) {
                    XXVMBuilder.appendToSBUtils(fOverdsChain, "/");
                }
                ++i;
            }
            XXVMBuilder.appendToSBUtils(fOverdsChain, "'", "/", ">");
        }
        if (this.appliedOnComponents != null && !this.appliedOnComponents.isEmpty()) {
            for (IXXVMObject object : this.appliedOnComponents) {
                XXVMBuilder.appendToSBUtils(fOverds, "\n", indentation, "\t", "\t", "<", object instanceof IXXVMComponent ? "xvm-factory-override-applied-on-component" : "xvm-factory-override-applied-on-object", " ", "full-name", "=", "'", XXVMBuilder.escapeForXML(object.getSanitizedFullName()), "'", "/", ">");
            }
        }
        XXVMBuilder.appendToSBUtils(fOverds, fOverdsChain.toString());
        XXVMBuilder.appendToSBUtils(fOverds, "\n", indentation, "\t", "<", "/", "xvm-factory-override", ">");
    }

    public void addAffectedCompName(String fullName) {
        this.compsAffectedNames.add(fullName);
    }

    public List<String> getCompsAffectedNames() {
        return this.compsAffectedNames;
    }

    public void assignSerializationId(int id) {
        this.id = id;
    }

    public int getId() {
        if (this.id == -1) {
            throw new IllegalStateException("Id is not set");
        }
        return this.id;
    }

    public void addDuplicatedOverride(IXXVMFactoryOverrideElement duplicateUnusedOverride) {
        this.duplicatedOverride.add(duplicateUnusedOverride);
    }

    public List<IXXVMFactoryOverrideElement> getDuplicates() {
        return this.duplicatedOverride;
    }
}

