/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.views.registers;

import java.util.ArrayList;
import java.util.List;
import ro.amiq.dvt.interpreter.IXXVMRegBlock;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.lazy.views.registers.IRegistersViewContributor;
import ro.amiq.vlogdt.interpreter.utils.IXSerializedModelUtils;
import ro.amiq.vlogdt.interpreter.view.XXVMBuilder;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmFactory;

public class XXVMRegBlock
implements IXXVMRegBlock {
    protected final String name;
    private final IXXVMRegBlock parent;
    private final List<IXXVMRegBlock> children;
    protected GoToInfo goToInfo;
    protected final List<RfXvmFactory.XVMCreateCall> createCalls = new ArrayList<RfXvmFactory.XVMCreateCall>();
    protected IRfNamedElement rfNamedElement;
    protected IRfNamedElement rfClass;
    protected String comment;

    public XXVMRegBlock(String name, IXXVMRegBlock parentBlock) {
        this.name = name;
        this.parent = parentBlock;
        this.children = new ArrayList<IXXVMRegBlock>();
        this.comment = "";
    }

    public String getName() {
        return this.name;
    }

    public void addChildren(IXXVMRegBlock register) {
        this.children.add(register);
    }

    public List<IXXVMRegBlock> getChildren() {
        return this.children;
    }

    public IXXVMRegBlock getParent() {
        return this.parent;
    }

    public void setCreateCallGoToInfo(GoToInfo createCallGoToInfo) {
        this.goToInfo = createCallGoToInfo;
    }

    public GoToInfo getGoToInfo() {
        return this.goToInfo;
    }

    public String toString() {
        return this.name;
    }

    public String getRights() {
        return "";
    }

    public String getSequencerName() {
        return "";
    }

    public String getRegisterFullName() {
        return this.name;
    }

    public synchronized void deepClean() {
        if (this.children != null && !this.children.isEmpty()) {
            for (IXXVMRegBlock child : this.children) {
                if (!(child instanceof XXVMRegBlock)) continue;
                ((XXVMRegBlock)child).deepClean();
            }
            this.children.clear();
        }
    }

    public IRfNamedElement getNamedElement() {
        return this.rfNamedElement;
    }

    public IRfNamedElement getRfClass() {
        return this.rfClass;
    }

    public String getComment() {
        return this.comment;
    }

    public void setRfNamedElement(IRfNamedElement rfNamedElement) {
        this.rfNamedElement = rfNamedElement;
    }

    public void setRfClass(IRfNamedElement rfClass) {
        this.rfClass = rfClass;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    protected String getCreateGoToInfoString() {
        if (this.goToInfo == null) {
            return "N/A";
        }
        return IXSerializedModelUtils.serializeGoToInfo(this.goToInfo);
    }

    public void serializeRegister(StringBuilder regs, String indentation) {
        XXVMBuilder.appendToSBUtils(regs, "\n", indentation, "<", "xvm-reg-block");
        XXVMBuilder.appendToSBUtils(regs, " ", "name", "=", "'", XXVMBuilder.escapeForXML(this.name), "'");
        XXVMBuilder.appendToSBUtils(regs, " ", "named-element", "=", "'", XXVMBuilder.escapeForXML(RfElementPath.path((IRfNamedElement)this.rfNamedElement).toString()), "'");
        XXVMBuilder.appendToSBUtils(regs, " ", "named-element-class", "=", "'", XXVMBuilder.escapeForXML(RfElementPath.path((IRfNamedElement)this.rfClass).toString()), "'");
        XXVMBuilder.appendToSBUtils(regs, " ", "comment", "=", "'", XXVMBuilder.escapeForXML(ViewsUtils.trimText((String)this.comment, (int)100, (boolean)true)), "'");
        XXVMBuilder.appendToSBUtils(regs, " ", "create-call", "=", "'", XXVMBuilder.escapeForXML(this.getCreateGoToInfoString()), "'");
        if (this.children == null || this.children.isEmpty()) {
            XXVMBuilder.appendToSBUtils(regs, "/", ">");
            return;
        }
        XXVMBuilder.appendToSBUtils(regs, ">");
        IRegistersViewContributor.sortRegistersListByName(this.children);
        for (IXXVMRegBlock child : this.children) {
            child.serializeRegister(regs, String.valueOf(indentation) + "\t");
        }
        XXVMBuilder.appendToSBUtils(regs, "\n", indentation, "<", "/", "xvm-reg-block", ">");
    }

    public boolean isBlockRegisters() {
        return true;
    }

    public List<RfXvmFactory.XVMCreateCall> getCreateCalls() {
        return this.createCalls;
    }

    public void setCreateCalls(List<RfXvmFactory.XVMCreateCall> createCalls) {
        this.createCalls.addAll(createCalls);
    }

    public String getAddressBase16() {
        return "";
    }

    public String getAddressBase10() {
        return "";
    }

    public IXXVMRegBlock.RegisterKind getKind() {
        return IXXVMRegBlock.RegisterKind.BLOCK;
    }
}

