/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.views.registers;

import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.IXXVMRegBlock;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.interpreter.view.XXVMBuilder;
import ro.amiq.vlogdt.interpreter.views.registers.XXVMRegBlock;
import ro.amiq.vlogdt.model.reflection.RfField;

public class XXVMRegister
extends XXVMRegBlock {
    private final IELParamValue address;
    private final String[] fullName;
    private final String rights;
    private final String sequencerName;
    private String addressBase16Text;
    private String addressBase10Text;

    public XXVMRegister(String name, String registerFullName, IELParamValue addrStartValue, String rights, String sequencerName, IXXVMRegBlock parentRegBlock, IRfNamedElement namedElement, XNamedElement xAssociatedType) {
        super(name, parentRegBlock);
        if (registerFullName != null && !registerFullName.isEmpty()) {
            String[] segments = DVTStringUtil.split((String)".", (String)registerFullName);
            this.fullName = new String[segments.length];
            int i = 0;
            while (i < segments.length) {
                this.fullName[i] = DVTStringUtil.intern((String)segments[i]);
                ++i;
            }
        } else {
            this.fullName = new String[0];
        }
        this.address = addrStartValue;
        this.rights = rights;
        this.sequencerName = sequencerName;
        this.rfNamedElement = namedElement;
        this.rfClass = xAssociatedType != null ? xAssociatedType.getNamedElement() : null;
        this.comment = this.rfNamedElement instanceof RfField ? ViewsUtils.trimText((String)((RfField)this.rfNamedElement).getComment(), (int)100, (boolean)true) : "";
    }

    public XXVMRegister(String name, String registerFullName, IELParamValue addrStartValue, String rights, String sequencerName, String comment, IXXVMRegBlock parentRegBlock, IRfNamedElement namedElement, IRfNamedElement rfClass) {
        super(name, parentRegBlock);
        if (registerFullName != null && !registerFullName.isEmpty()) {
            String[] segments = DVTStringUtil.split((String)".", (String)registerFullName);
            this.fullName = new String[segments.length];
            int i = 0;
            while (i < segments.length) {
                this.fullName[i] = DVTStringUtil.intern((String)segments[i]);
                ++i;
            }
        } else {
            this.fullName = new String[0];
        }
        this.address = addrStartValue;
        this.rights = rights;
        this.sequencerName = sequencerName;
        this.comment = comment;
        this.rfNamedElement = namedElement;
        this.rfClass = rfClass;
    }

    @Override
    public String getAddressBase10() {
        if (this.addressBase10Text == null) {
            DVTNumber dvtNumber = this.address.getDVTNumber();
            String addressBase10 = dvtNumber.print(10, true, -1, false, false);
            this.addressBase10Text = String.valueOf(dvtNumber.getSize()) + "'d" + addressBase10;
        }
        return this.addressBase10Text;
    }

    @Override
    public String getAddressBase16() {
        if (this.addressBase16Text == null) {
            DVTNumber dvtNumber = this.address.getDVTNumber();
            String addressBase16 = dvtNumber.print(16, true, -1, false, false);
            this.addressBase16Text = String.valueOf(dvtNumber.getSize()) + "'h" + addressBase16;
        }
        return this.addressBase16Text;
    }

    public IRfNamedElement getRegBlockAssocType() {
        return this.rfClass;
    }

    @Override
    public String getRights() {
        return this.rights;
    }

    @Override
    public String getSequencerName() {
        return this.sequencerName;
    }

    @Override
    public String getRegisterFullName() {
        if (this.fullName == null || this.fullName.length == 0) {
            return "";
        }
        return DVTStringUtil.join((Object[])this.fullName, (String)".");
    }

    @Override
    public void serializeRegister(StringBuilder regs, String indentation) {
        XXVMBuilder.appendToSBUtils(regs, "\n", indentation, "<", "xvm-register");
        XXVMBuilder.appendToSBUtils(regs, " ", "name", "=", "'", XXVMBuilder.escapeForXML(this.name), "'");
        XXVMBuilder.appendToSBUtils(regs, " ", "full-name", "=", "'", XXVMBuilder.escapeForXML(DVTStringUtil.join((Object[])this.fullName, (String)".")), "'");
        XXVMBuilder.appendToSBUtils(regs, " ", "address", "=", "'", XXVMBuilder.escapeForXML(this.getAddressBase16()), "'");
        XXVMBuilder.appendToSBUtils(regs, " ", "rights", "=", "'", XXVMBuilder.escapeForXML(this.rights), "'");
        XXVMBuilder.appendToSBUtils(regs, " ", "sequencer", "=", "'", XXVMBuilder.escapeForXML(this.sequencerName), "'");
        XXVMBuilder.appendToSBUtils(regs, " ", "create-call", "=", "'", XXVMBuilder.escapeForXML(this.getCreateGoToInfoString()), "'");
        XXVMBuilder.appendToSBUtils(regs, " ", "named-element", "=", "'", XXVMBuilder.escapeForXML(RfElementPath.path((IRfNamedElement)this.rfNamedElement).toString()), "'");
        XXVMBuilder.appendToSBUtils(regs, " ", "named-element-class", "=", "'", XXVMBuilder.escapeForXML(RfElementPath.path((IRfNamedElement)this.rfClass).toString()), "'");
        XXVMBuilder.appendToSBUtils(regs, " ", "comment", "=", "'", XXVMBuilder.escapeForXML(this.comment), "'");
        XXVMBuilder.appendToSBUtils(regs, "/", ">");
    }

    @Override
    public boolean isBlockRegisters() {
        return false;
    }

    @Override
    public IXXVMRegBlock.RegisterKind getKind() {
        return IXXVMRegBlock.RegisterKind.REGISTER;
    }
}

