/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.views.verification.hierarchy;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.interpreter.IXVHObject;
import ro.amiq.dvt.interpreter.IXXVMComponent;
import ro.amiq.dvt.interpreter.IXXVMObject;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfVHBreadcrumbElement;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.model.reflection.RfElementPathInProject;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.interpreter.factory.chs.XVHComponent;
import ro.amiq.vlogdt.interpreter.utils.IXSerializedModelUtils;
import ro.amiq.vlogdt.interpreter.view.XXVMBuilder;
import ro.amiq.vlogdt.interpreter.views.verification.hierarchy.XXVMObject;
import ro.amiq.vlogdt.interpreter.views.verification.hierarchy.XXVMPortComponent;
import ro.amiq.vlogdt.model.reflection.RfClass;

public class XXVMComponent
extends XXVMObject
implements IXXVMComponent {
    protected static final Pattern TYPE_PATTERN = Pattern.compile("(?:.*::)?(([a-zA-Z_$][a-zA-Z\\d_$]*_)*+[a-zA-Z_$][a-zA-Z\\d_$]*)#.*");
    protected RfElementPathInProject qualifiedName;
    protected final IXXVMComponent parent;
    protected final List<IXXVMComponent> children;
    protected final List<IXXVMComponent> ports;
    private String chdFileName;
    private String fullPathCHDFile;
    private String timeStamp;
    private final boolean isFactoryOverriden;

    public XXVMComponent(XVHComponent original, IXXVMComponent parentComponent) {
        this.rfClass = IXVHObject.computeRfClass((IXVHObject)original);
        this.rfClassGoToInfo = GoToInfo.sourceOf((IRfNamedElement)this.rfClass);
        this.createCallGoToInfo = original.getCreateCallGoToInfo();
        this.name = original.get_name();
        this.fullName = IXSerializedModelUtils.withFullNameFromString(original.get_full_name());
        this.typeName = original.get_type_name();
        this.svType = original.get_sv_type();
        this.parent = parentComponent;
        this.children = new ArrayList<IXXVMComponent>();
        this.ports = new ArrayList<IXXVMComponent>();
        this.isFactoryOverriden = original.getFactoryOverrides() != null && !original.getFactoryOverrides().isEmpty();
    }

    public XXVMComponent(String name, String[] fullName, String typeName, String svType, GoToInfo createCallGoToInfo, GoToInfo rfClassGoToInfo, RfElementPathInProject qualifiedName, IRfNamedElement rfClass, IXXVMComponent parent, boolean isFactoryOverriden) {
        this.rfClass = rfClass;
        this.rfClassGoToInfo = rfClassGoToInfo;
        this.createCallGoToInfo = createCallGoToInfo;
        this.name = name;
        this.fullName = fullName;
        this.typeName = typeName;
        this.svType = svType;
        this.qualifiedName = qualifiedName;
        this.parent = parent;
        this.isFactoryOverriden = isFactoryOverriden;
        this.children = new ArrayList<IXXVMComponent>();
        this.ports = new ArrayList<IXXVMComponent>();
    }

    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    @Override
    public GoToInfo getCreateCallGoToInfo() {
        return this.createCallGoToInfo;
    }

    @Override
    public GoToInfo getDeclarationTypeGoToInfo() {
        return this.rfClassGoToInfo;
    }

    public void addChildren(IXXVMComponent ixxvmTreeChildlComponent) {
        this.children.add(ixxvmTreeChildlComponent);
    }

    public List<IXXVMComponent> getChildren() {
        return this.children;
    }

    public String getSanitizedType(LanguageKind languageKind, boolean acceptName) {
        if (this.svType == null) {
            return acceptName ? this.name : null;
        }
        if (languageKind == LanguageKind.E || languageKind == LanguageKind.SLN) {
            return this.svType;
        }
        Matcher matcher = TYPE_PATTERN.matcher(this.svType);
        if (!matcher.matches()) {
            return this.svType;
        }
        return matcher.group(1);
    }

    public void addPorts(IXXVMComponent xxvmPortComponent) {
        this.ports.add(xxvmPortComponent);
    }

    public List<IXXVMComponent> getPorts() {
        return this.ports;
    }

    public IRfNamedElement getRfClass() {
        return this.rfClass;
    }

    public IXXVMComponent getParent() {
        return this.parent;
    }

    public IRfScopeElement getEnclosingScope() {
        return null;
    }

    public boolean isInsideTLMFIFO() {
        if (!(this.parent instanceof XXVMComponent)) {
            return false;
        }
        String sanitizedType = this.parent.getSanitizedType(this.getLanguageKind(), false);
        return XXVMBuilder.checkIsTLMFifo(sanitizedType);
    }

    public String toString() {
        return String.valueOf(this.name) + " : " + this.typeName;
    }

    public void setNamedElement(IRfNamedElement element) {
        this.namedElement = element;
        this.qualifiedName = RfElementPath.pathInProject((IRfNamedElement)element);
    }

    public IRfNamedElement getNamedElement() {
        if (this.qualifiedName == null) {
            return null;
        }
        return this.qualifiedName.toNamedElement();
    }

    public IProject getIProject() {
        if (this.qualifiedName == null) {
            return null;
        }
        return this.qualifiedName.project;
    }

    public synchronized void deepClean() {
        if (this.children != null && !this.children.isEmpty()) {
            for (IXXVMComponent child : this.children) {
                if (!(child instanceof XXVMComponent)) continue;
                ((XXVMComponent)child).deepClean();
            }
            this.children.clear();
        }
        if (this.ports != null && !this.ports.isEmpty()) {
            for (IXXVMComponent port : this.ports) {
                if (!(port instanceof XXVMComponent)) continue;
                ((XXVMComponent)port).deepClean();
            }
            this.ports.clear();
        }
    }

    public void collectXML(StringBuilder components, StringBuilder connections, String indentation) {
        components.append("\n" + indentation + "<xvm-component");
        components.append(" name='").append(XXVMBuilder.escapeForXML(this.name)).append("'");
        components.append(" type='").append(XXVMBuilder.escapeForXML(this.typeName)).append("'");
        components.append(" sv-type='").append(XXVMBuilder.escapeForXML(this.svType)).append("'");
        if (this.createCallGoToInfo != null) {
            components.append(" created='").append(XXVMBuilder.escapeForXML(IXSerializedModelUtils.getGoToInfoString(this.createCallGoToInfo))).append("'");
        }
        if ((this.children == null || this.children.isEmpty()) && (this.ports == null || this.ports.isEmpty())) {
            components.append("/>");
        } else if ((this.children == null || this.children.isEmpty()) && this.ports != null && !this.ports.isEmpty()) {
            components.append(">");
            for (IXXVMComponent port : this.ports) {
                port.collectXML(components, connections, String.valueOf(indentation) + "\t");
            }
            components.append("\n" + indentation + "</xvm-component>");
        } else {
            components.append(">");
            ArrayList<IXXVMComponent> childComponents = new ArrayList<IXXVMComponent>();
            childComponents.addAll(this.children);
            if (this.ports != null && !this.ports.isEmpty()) {
                childComponents.addAll(this.ports);
            }
            List sortedComp = childComponents.stream().sorted(Comparator.comparing(IXXVMObject::getName)).collect(Collectors.toList());
            for (IXXVMComponent sortedComponent : sortedComp) {
                if (sortedComponent instanceof XXVMPortComponent) {
                    ((XXVMPortComponent)sortedComponent).collectXML(components, connections, String.valueOf(indentation) + "\t");
                    continue;
                }
                sortedComponent.collectXML(components, connections, String.valueOf(indentation) + "\t");
            }
            components.append("\n" + indentation + "</xvm-component>");
        }
    }

    public String getUVMDiagramFileName() {
        return this.chdFileName;
    }

    public String getUVMDiagramFullPath() {
        return this.fullPathCHDFile;
    }

    public void setCHDFileName(String fileName) {
        this.chdFileName = fileName;
    }

    public void setCHDFullPath(String fullPath) {
        this.fullPathCHDFile = fullPath;
    }

    public void serializeComponent(StringBuilder comps, StringBuilder cons, String indentation) {
        XXVMBuilder.appendToSBUtils(comps, "\n", indentation, "<", "xvm-component");
        this.serializeBasicData(comps);
        if ((this.children == null || this.children.isEmpty()) && (this.ports == null || this.ports.isEmpty())) {
            XXVMBuilder.appendToSBUtils(comps, "/", ">");
            return;
        }
        XXVMBuilder.appendToSBUtils(comps, ">");
        ArrayList<IXXVMComponent> childComps = new ArrayList<IXXVMComponent>();
        if (this.children != null && !this.children.isEmpty()) {
            childComps.addAll(this.children);
        }
        if (this.ports != null && !this.ports.isEmpty()) {
            childComps.addAll(this.ports);
        }
        List sortedComp = childComps.stream().sorted(Comparator.comparing(IXXVMObject::getName)).collect(Collectors.toList());
        for (IXXVMComponent comp : sortedComp) {
            if (comp instanceof XXVMPortComponent) {
                ((XXVMPortComponent)comp).serializeComponent(comps, cons, String.valueOf(indentation) + "\t");
                continue;
            }
            comp.serializeComponent(comps, cons, String.valueOf(indentation) + "\t");
        }
        XXVMBuilder.appendToSBUtils(comps, "\n", indentation, "<", "/", "xvm-component", ">");
    }

    @Override
    public void serializeBasicData(StringBuilder comps) {
        XXVMBuilder.appendToSBUtils(comps, " ", "name", "=", "'", XXVMBuilder.escapeForXML(this.name), "'");
        XXVMBuilder.appendToSBUtils(comps, " ", "full-name", "=", "'", XXVMBuilder.escapeForXML(DVTStringUtil.join((Object[])this.fullName, (String)".")), "'");
        XXVMBuilder.appendToSBUtils(comps, " ", "type", "=", "'", XXVMBuilder.escapeForXML(this.typeName), "'");
        XXVMBuilder.appendToSBUtils(comps, " ", "sv-type", "=", "'", XXVMBuilder.escapeForXML(this.svType), "'");
        XXVMBuilder.appendToSBUtils(comps, " ", "is-factory-overriden", "=", "'", String.valueOf(this.isFactoryOverriden), "'");
        XXVMBuilder.appendToSBUtils(comps, " ", "create-call", "=", "'", XXVMBuilder.escapeForXML(IXSerializedModelUtils.getGoToInfoString(this.createCallGoToInfo)), "'");
        XXVMBuilder.appendToSBUtils(comps, " ", "declaration-class", "=", "'", XXVMBuilder.escapeForXML(IXSerializedModelUtils.getGoToInfoString(this.rfClassGoToInfo)), "'");
        if (this.qualifiedName != null && this.qualifiedName.elementPath instanceof RfElementPath) {
            XXVMBuilder.appendToSBUtils(comps, " ", "named-element", "=", "'", RfElementPath.path((IRfNamedElement)this.namedElement).toString(), "'");
        } else if (this.qualifiedName != null) {
            DVTLogger.INSTANCE.logError("Unknown Serializable Named Element" + this.qualifiedName.getClass());
        }
        if (this.rfClass instanceof RfClass) {
            XXVMBuilder.appendToSBUtils(comps, " ", "named-element-class", "=", "'", RfElementPath.path((IRfNamedElement)this.rfClass).toString(), "'");
        } else if (this.rfClass != null) {
            DVTLogger.INSTANCE.logDebug("Unknown Serializable RfClass Element" + this.rfClass.getClass());
        }
    }

    public void setTimeStamp(String timeStamp) {
        this.timeStamp = timeStamp;
    }

    public String getTimeStamp() {
        return this.timeStamp;
    }

    public boolean getIsFactoryOverriden() {
        return this.isFactoryOverriden;
    }

    @Override
    public String getInternalType() {
        return "component";
    }

    public List<? extends IRfVHBreadcrumbElement> getAllVHChildren() {
        return this.getChildren();
    }
}

