/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.views.verification.hierarchy;

import java.util.List;
import ro.amiq.dvt.interpreter.IXVHObject;
import ro.amiq.dvt.interpreter.IXXVMComponent;
import ro.amiq.dvt.interpreter.IXXVMObject;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.interpreter.factory.chs.XVHObject;
import ro.amiq.vlogdt.interpreter.utils.IXSerializedModelUtils;
import ro.amiq.vlogdt.interpreter.view.XXVMBuilder;
import ro.amiq.vlogdt.interpreter.views.verification.hierarchy.XXVMComponent;
import ro.amiq.vlogdt.model.reflection.RfClass;

public class XXVMObject
implements IXXVMObject {
    protected IRfNamedElement rfClass;
    protected IRfNamedElement namedElement;
    protected GoToInfo createCallGoToInfo;
    protected GoToInfo rfClassGoToInfo;
    protected String name;
    protected String[] fullName;
    protected String typeName;
    protected String svType;

    public XXVMObject() {
    }

    public XXVMObject(String name, String[] fullName, String typeName, String svType, IRfNamedElement namedElement, IRfNamedElement rfClass, GoToInfo createCallGoToInfo, GoToInfo rfClassGoToInfo) {
        this.name = name;
        this.fullName = fullName;
        this.typeName = typeName;
        this.svType = svType;
        this.namedElement = namedElement;
        this.rfClass = rfClass;
        this.createCallGoToInfo = createCallGoToInfo;
        this.rfClassGoToInfo = rfClassGoToInfo;
    }

    public XXVMObject(XVHObject xvhObject, String fullName) {
        this.name = xvhObject.get_name();
        String getFullName = xvhObject.get_full_name();
        if (getFullName != null && getFullName.equals(this.name) && !getFullName.equals(fullName)) {
            getFullName = fullName;
        }
        this.fullName = IXSerializedModelUtils.withFullNameFromString(getFullName);
        this.typeName = xvhObject.get_type_name();
        this.svType = xvhObject.get_sv_type();
        this.rfClass = IXVHObject.computeRfClass((IXVHObject)xvhObject);
        this.createCallGoToInfo = xvhObject.getCreateCallGoToInfo();
        this.rfClassGoToInfo = GoToInfo.sourceOf((IRfNamedElement)this.rfClass);
    }

    public String getSVType() {
        return this.svType;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return DVTStringUtil.join((Object[])this.fullName, (String)".");
    }

    public String getSanitizedFullName() {
        if (this.fullName == null || this.fullName.length == 0) {
            return "";
        }
        IXXVMComponent xvmRootComponent = XXVMBuilder.INSTANCE.getXVMRootComponent();
        if (xvmRootComponent == null) {
            return "";
        }
        List<IXXVMComponent> child = ((XXVMComponent)xvmRootComponent).getChildren();
        if (child == null || child.isEmpty()) {
            return DVTStringUtil.join((Object[])this.fullName, (String)".");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(child.get(0).getRfClass().getName());
        int i = 1;
        while (i < this.fullName.length) {
            sb.append(".").append(this.fullName[i]);
            ++i;
        }
        return sb.toString();
    }

    public GoToInfo getCreateCallGoToInfo() {
        return this.createCallGoToInfo;
    }

    public GoToInfo getDeclarationTypeGoToInfo() {
        return this.rfClassGoToInfo;
    }

    public void serializeBasicData(StringBuilder comps) {
        XXVMBuilder.appendToSBUtils(comps, " ", "name", "=", "'", XXVMBuilder.escapeForXML(this.name), "'");
        XXVMBuilder.appendToSBUtils(comps, " ", "full-name", "=", "'", XXVMBuilder.escapeForXML(DVTStringUtil.join((Object[])this.fullName, (String)".")), "'");
        XXVMBuilder.appendToSBUtils(comps, " ", "type", "=", "'", XXVMBuilder.escapeForXML(this.typeName), "'");
        XXVMBuilder.appendToSBUtils(comps, " ", "sv-type", "=", "'", XXVMBuilder.escapeForXML(this.svType), "'");
        XXVMBuilder.appendToSBUtils(comps, " ", "create-call", "=", "'", XXVMBuilder.escapeForXML(IXSerializedModelUtils.getGoToInfoString(this.createCallGoToInfo)), "'");
        XXVMBuilder.appendToSBUtils(comps, " ", "declaration-class", "=", "'", XXVMBuilder.escapeForXML(IXSerializedModelUtils.getGoToInfoString(this.rfClassGoToInfo)), "'");
        XXVMBuilder.appendToSBUtils(comps, " ", "named-element", "=", "'", RfElementPath.path((IRfNamedElement)this.namedElement).toString(), "'");
        if (this.rfClass instanceof RfClass) {
            XXVMBuilder.appendToSBUtils(comps, " ", "named-element-class", "=", "'", RfElementPath.path((IRfNamedElement)this.rfClass).toString(), "'");
        } else if (this.rfClass != null) {
            DVTLogger.INSTANCE.logDebug("Unknown Serializable RfClass Element" + this.rfClass.getClass());
        }
    }

    public String getInternalType() {
        return "object";
    }
}

