/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.interpreter.views.verification.hierarchy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import ro.amiq.dvt.interpreter.IXXVMComponent;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfElementPathInProject;
import ro.amiq.vlogdt.interpreter.factory.chs.XVHPortComponent;
import ro.amiq.vlogdt.interpreter.utils.IXSerializedModelUtils;
import ro.amiq.vlogdt.interpreter.view.XXVMBuilder;
import ro.amiq.vlogdt.interpreter.views.verification.hierarchy.XXVMComponent;

public class XXVMPortComponent
extends XXVMComponent {
    protected String portKind;
    protected final List<XXVMPortComponent> connectedTo;

    public XXVMPortComponent(XVHPortComponent original, IXXVMComponent parent) {
        super(original, parent);
        this.portKind = original.get_port_kind();
        this.connectedTo = new ArrayList<XXVMPortComponent>();
    }

    public XXVMPortComponent(String name, String[] fullName, String typeName, String svType, GoToInfo createCallGoToInfo, GoToInfo rfClassGoToInfo, RfElementPathInProject qualifiedName, IRfNamedElement rfClass, IXXVMComponent parent, boolean isFactoryOverriden) {
        super(name, fullName, typeName, svType, createCallGoToInfo, rfClassGoToInfo, qualifiedName, rfClass, parent, isFactoryOverriden);
        this.connectedTo = new ArrayList<XXVMPortComponent>();
    }

    public void connectedTo(XXVMPortComponent port) {
        this.connectedTo.add(port);
    }

    public Collection<XXVMPortComponent> getConnectedTo() {
        return this.connectedTo;
    }

    @Override
    public void collectXML(StringBuilder components, StringBuilder connections, String indentation) {
        components.append("\n" + indentation + "<xvm-port");
        components.append(" name='").append(XXVMBuilder.escapeForXML(this.name)).append("'");
        components.append(" type='").append(XXVMBuilder.escapeForXML(this.typeName)).append("'");
        components.append(" kind='").append(XXVMBuilder.escapeForXML(this.portKind)).append("'");
        String sv_type = this.getSVType();
        if (sv_type != null) {
            components.append(" sv-type='").append(XXVMBuilder.escapeForXML(sv_type)).append("'");
        }
        if (this.createCallGoToInfo != null) {
            components.append(" created='").append(XXVMBuilder.escapeForXML(IXSerializedModelUtils.getGoToInfoString(this.createCallGoToInfo))).append("'");
        }
        components.append("/>");
        if (this.connectedTo == null || this.connectedTo.isEmpty()) {
            return;
        }
        for (XXVMPortComponent conTo : this.connectedTo) {
            connections.append("\n\t\t<connection");
            connections.append(" source='").append(XXVMBuilder.escapeForXML(this.getFullName())).append("'");
            connections.append(" destination='").append(XXVMBuilder.escapeForXML(conTo.getFullName())).append("'");
            connections.append(" />");
        }
    }

    @Override
    public void serializeComponent(StringBuilder comps, StringBuilder cons, String indentation) {
        XXVMBuilder.appendToSBUtils(comps, "\n", indentation, "<", "xvm-port");
        this.serializeBasicData(comps);
        XXVMBuilder.appendToSBUtils(comps, "/", ">");
        if (this.connectedTo == null || this.connectedTo.isEmpty()) {
            return;
        }
        for (XXVMPortComponent conTo : this.connectedTo) {
            XXVMBuilder.appendToSBUtils(cons, "\n", "\t", "\t", "\t", "<", "connection");
            XXVMBuilder.appendToSBUtils(cons, " ", "source", "=", "'", XXVMBuilder.escapeForXML(this.getFullName()), "'");
            XXVMBuilder.appendToSBUtils(cons, " ", "destination", "=", "'", XXVMBuilder.escapeForXML(conTo.getFullName()), "'");
            XXVMBuilder.appendToSBUtils(cons, " ", "/", ">");
        }
    }

    @Override
    public String getInternalType() {
        return "port";
    }
}

