/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import ro.amiq.vlogdt.linter.CheckStatus;
import ro.amiq.vlogdt.linter.EditInfo;
import ro.amiq.vlogdt.linter.ErrorInfo;
import ro.amiq.vlogdt.linter.HitInfo;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;

public class CheckInfo {
    private String id;
    private String title;
    private List<String> labels;
    private String name;
    private String version;
    private String description;
    private String status;
    private String severity;
    private String category;
    private String categoryDescription;
    private long runTime;
    private boolean autocorrectable;
    private boolean manualCheck;
    private boolean hasAutocorrectEnabled;
    private List<HitInfo> hits;
    private List<HitInfo> autocorrectedHits;
    private List<HitInfo> nonAutocorrectedHits;
    private List<EditInfo> autocorrectEdits;
    private List<ErrorInfo> autocorrectErrors;
    private Map<String, List<String>> annotations;

    public CheckInfo(String id, String name, String title, String version, Set<RuleLabel> labels, String description, CheckStatus status, CheckStatus severity, long runTime, String category, String categoryDescription, boolean autocorrectable, boolean manualCheck, boolean hasAutocorrectEnabled, Map<String, List<String>> annotations) {
        this.id = id;
        this.name = name;
        this.title = title;
        this.version = version;
        this.labels = labels == null ? Collections.emptyList() : RuleLabel.getValues(labels);
        this.description = description;
        this.status = status == null ? "" : status.name();
        this.severity = severity == null ? "" : severity.name();
        this.runTime = runTime;
        this.category = category;
        this.categoryDescription = categoryDescription;
        this.autocorrectable = autocorrectable;
        this.manualCheck = manualCheck;
        this.hasAutocorrectEnabled = hasAutocorrectEnabled;
        this.annotations = annotations;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public String getStatus() {
        return this.status;
    }

    public String getCategory() {
        return this.category;
    }

    public String getCategoryDescription() {
        return this.categoryDescription;
    }

    public String getSeverity() {
        return this.severity;
    }

    public List<HitInfo> getHits() {
        return this.hits;
    }

    public List<HitInfo> getAutocorrectedHits() {
        return this.autocorrectedHits;
    }

    public List<HitInfo> getNonAutocorrectedHits() {
        return this.nonAutocorrectedHits;
    }

    public long getRunTime() {
        return this.runTime;
    }

    public boolean isAutocorrectable() {
        return this.autocorrectable;
    }

    public boolean isManualCheck() {
        return this.manualCheck;
    }

    public List<EditInfo> getAutocorrectEdits() {
        return this.autocorrectEdits;
    }

    public List<ErrorInfo> getAutocorrectErrors() {
        return this.autocorrectErrors;
    }

    protected void setHits(List<HitInfo> hits) {
        this.hits = hits;
        this.autocorrectedHits = hits.stream().filter(hit -> hit.isAutocorrected()).collect(Collectors.toList());
        this.nonAutocorrectedHits = hits.stream().filter(hit -> !hit.isAutocorrected()).collect(Collectors.toList());
    }

    protected void setAutocorrectEdits(List<EditInfo> edits) {
        this.autocorrectEdits = edits;
    }

    protected void setAutocorrectErrors(List<ErrorInfo> autocorrectErrors) {
        this.autocorrectErrors = autocorrectErrors;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    protected void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public boolean isAutocorrectEnabled() {
        return this.hasAutocorrectEnabled;
    }

    public Map<String, List<String>> getAnnotations() {
        return this.annotations;
    }

    public List<String> getAnnotations(String annotationTitle) {
        return this.annotations.getOrDefault(annotationTitle, new ArrayList());
    }
}

