/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter;

import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Version;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.main.AbstractReportGenerator;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.vlogdt.linter.CheckInfo;
import ro.amiq.vlogdt.linter.CheckStatus;
import ro.amiq.vlogdt.linter.CompareInfo;
import ro.amiq.vlogdt.linter.CustomReportModel;
import ro.amiq.vlogdt.linter.EditInfo;
import ro.amiq.vlogdt.linter.ErrorInfo;
import ro.amiq.vlogdt.linter.FileInfo;
import ro.amiq.vlogdt.linter.HitInfo;
import ro.amiq.vlogdt.linter.LinterSummary;
import ro.amiq.vlogdt.linter.OVMComplianceChecksUtil;
import ro.amiq.vlogdt.linter.PreWaiverInfo;
import ro.amiq.vlogdt.linter.WaiverInfo;
import ro.amiq.vlogdt.linter.annotations.AnnotationResults;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixManager;
import ro.amiq.vlogdt.linter.report.model.RCategory;
import ro.amiq.vlogdt.linter.report.model.RCheck;
import ro.amiq.vlogdt.linter.report.model.REdit;
import ro.amiq.vlogdt.linter.report.model.RError;
import ro.amiq.vlogdt.linter.report.model.RHit;
import ro.amiq.vlogdt.linter.report.model.RInfo;
import ro.amiq.vlogdt.linter.report.model.RPreWaiver;
import ro.amiq.vlogdt.linter.report.model.RReport;
import ro.amiq.vlogdt.linter.report.model.RWaiver;
import ro.amiq.vlogdt.linter.utils.HTMLUtils;

public class CustomReportGenerator
extends AbstractReportGenerator {
    private RReport report;
    private boolean ignoreErrors;
    private boolean ignoreWarnings;
    private boolean ignoreInfos;
    private String failOnSeverity;
    private Map<HitInfo, FileInfo> fileForHitMap;
    private Map<String, FileInfo> pathForFileMap;
    private static final Pattern XVM_FILES = Pattern.compile("uvm_.*|sqr_.*|uvm.svh|base.svh|methodology.svh|ovm_.*|avm_.*|urm_.*|tlm_.*|sqr_.*|ovm.svh|base_compatibility.svh|compatibility.svh|tlm.svh");
    private int nofValidChecks;
    private Comparator<HitInfo> hitInfoComparator = (o1, o2) -> {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return Integer.compare(o1.getLine(), o2.getLine());
    };
    private Comparator<EditInfo> editInfoComparator = (o1, o2) -> {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return Integer.compare(o1.getFileOffset(), o2.getFileOffset());
    };

    public CustomReportGenerator(RReport report, boolean ignoreErrors, boolean ignoreWarnings, boolean ignoreInfos, String failOnSeverity, String customReportLocation) {
        this.freeMarkerConfig = new Configuration();
        this.freeMarkerConfig.setTemplateUpdateDelayMilliseconds(0L);
        BeansWrapper wrapper = new BeansWrapper(new Version(2, 3, 26));
        wrapper.setSimpleMapWrapper(true);
        this.freeMarkerConfig.setObjectWrapper((ObjectWrapper)wrapper);
        this.report = report;
        this.ignoreErrors = ignoreErrors;
        this.ignoreWarnings = ignoreWarnings;
        this.ignoreInfos = ignoreInfos;
        this.failOnSeverity = failOnSeverity;
        this.customReportLocation = customReportLocation;
        this.nofValidChecks = 0;
        this.fileForHitMap = new HashMap<HitInfo, FileInfo>();
        this.pathForFileMap = new HashMap<String, FileInfo>();
    }

    public Map<String, Object> createRootModel() {
        LinkedHashMap<String, Object> root = new LinkedHashMap<String, Object>();
        LinterSummary reportSummary = LinterSummary.create(this.report, this.ignoreErrors, this.ignoreWarnings, this.ignoreInfos, this.failOnSeverity);
        RInfo infoWrapper = this.report.getInfoWrapper();
        Map<String, CheckInfo> allChecks = this.getAllChecks();
        List<HitInfo> allHits = this.getAllHits(allChecks);
        List<EditInfo> allEdits = this.getAllAutocorrectEdits(allChecks);
        List<ErrorInfo> allErrors = this.getAllAutocorrectErrors(allChecks);
        List<FileInfo> allFiles = this.getAllFiles(allHits, allEdits, infoWrapper.getNofCompiledLinesPerFile());
        List<WaiverInfo> allWaivers = this.getAllWaivers(this.report.getPostWaivers(), allChecks);
        List<PreWaiverInfo> allPreWaivers = this.getAllPreWaivers(this.report.getPreWaivers());
        List<FileInfo> files = this.getAllNonXVMFiles(allFiles);
        List<String> annotationTitles = this.getAnnotationsTitles();
        List<CheckInfo> autocorrectEnabledChecks = this.getAutocorrectEnabledChecks(allChecks);
        List<String> autocorrectedFiles = this.getAutocorrectedFiles();
        List<String> versions = this.getVersions();
        List<String> upcomingMajorVersions = this.getUpcomingMajorVersions();
        CustomReportModel model = new CustomReportModel(new ArrayList<CheckInfo>(allChecks.values()), allHits, allFiles, files, allEdits, allErrors, allWaivers, allPreWaivers, autocorrectEnabledChecks, annotationTitles, reportSummary.getChecksSummary(), reportSummary.getHitsSummary(), reportSummary.getCompareSummary(), reportSummary.isPassed(), infoWrapper.getNofCompiledLines(), infoWrapper.getLintRunTime(), infoWrapper.getBuildRunTime(), infoWrapper.getLicenseWaitTime(), autocorrectedFiles, versions, upcomingMajorVersions);
        root.put("linter", model);
        return root;
    }

    public void setTemplatePath(String templatePath, Class<?> templateLocationClass) {
        try {
            if (templateLocationClass != null) {
                this.freeMarkerConfig.setClassForTemplateLoading(templateLocationClass, "");
            } else {
                File file = new File(templatePath);
                this.freeMarkerConfig.setDirectoryForTemplateLoading(file.getCanonicalFile().getParentFile() == null ? new File("") : file.getCanonicalFile().getParentFile());
            }
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError("ERROR: Can't write custom report: " + e.getMessage());
        }
        this.templatePath = templatePath;
    }

    private List<HitInfo> getAllHits(Map<String, CheckInfo> checks) {
        ArrayList<HitInfo> result = new ArrayList<HitInfo>();
        for (CheckInfo check : checks.values()) {
            result.addAll(check.getHits());
        }
        return result;
    }

    private List<EditInfo> getAllAutocorrectEdits(Map<String, CheckInfo> checks) {
        ArrayList<EditInfo> result = new ArrayList<EditInfo>();
        for (CheckInfo check : checks.values()) {
            result.addAll(check.getAutocorrectEdits());
        }
        return result;
    }

    private List<ErrorInfo> getAllAutocorrectErrors(Map<String, CheckInfo> checks) {
        ArrayList<ErrorInfo> result = new ArrayList<ErrorInfo>();
        for (CheckInfo check : checks.values()) {
            result.addAll(check.getAutocorrectErrors());
        }
        return result;
    }

    public List<String> getAnnotationsTitles() {
        ArrayList<String> annotationsTitles = new ArrayList<String>();
        List<AnnotationResults.AnnotationInfo> annotationInfos = this.report.getAnnotationInfos();
        for (AnnotationResults.AnnotationInfo entry : annotationInfos) {
            annotationsTitles.add(entry.getTitle());
        }
        return annotationsTitles;
    }

    public Map<String, CheckInfo> getAllChecks() {
        List<RCheck> checks = this.report.getChecks();
        LinkedHashMap<String, CheckInfo> result = new LinkedHashMap<String, CheckInfo>();
        if (checks == null || checks.isEmpty()) {
            return result;
        }
        for (RCheck check : checks) {
            if (check == null) continue;
            if (!"NONEXISTENT_ID_ERROR".equals(check.getCheckID())) {
                ++this.nofValidChecks;
            }
            Integer categoryIndex = check.getCategoryIndex();
            RCategory rCategory = this.report.getCategories().get(categoryIndex);
            CheckStatus checkStatus = OVMComplianceChecksUtil.getStatus(check);
            List<Set<String>> annotationStrings = this.report.getAnnotationStrings();
            LinkedHashSet<String> annotationNames = new LinkedHashSet<String>();
            if (this.report.getAnnotationInfos() != null) {
                this.report.getAnnotationInfos().stream().forEach(x -> {
                    boolean bl = annotationNames.add(x.getTitle());
                });
            }
            CheckInfo checkInfo = new CheckInfo(check.getCheckID(), check.getCheckName(), check.getCheckTitle(), check.getCheckVersion(), check.getLabels(), HTMLUtils.stripTags(check.getCheckDescription()), checkStatus, check.getSeverity(), check.getRunTime(), rCategory.getName(), HTMLUtils.stripTags(rCategory.getDescription()), check.isAutocorrectable(), check.isManualCheck(), check.isAutocorrectEnabled(), this.getAnnotationValuesToAnnotationTitlesMapping(annotationNames, annotationStrings, check));
            List<HitInfo> hitsInfos = this.getHits(check.getHits(), checkInfo);
            checkInfo.setHits(hitsInfos);
            ArrayList<EditInfo> autocorrectEditsInfos = new ArrayList<EditInfo>();
            ArrayList<ErrorInfo> autocorrectErrorsInfos = new ArrayList<ErrorInfo>();
            for (HitInfo hitInfo : hitsInfos) {
                if (hitInfo.isAutocorrected()) {
                    autocorrectEditsInfos.addAll(hitInfo.getAutocorrectEdits());
                }
                if (!hitInfo.hasAutocorrectError()) continue;
                autocorrectErrorsInfos.add(hitInfo.getAutocorrectError());
            }
            checkInfo.setAutocorrectEdits(autocorrectEditsInfos);
            checkInfo.setAutocorrectErrors(autocorrectErrorsInfos);
            result.put(check.getCheckName(), checkInfo);
        }
        return result;
    }

    private List<HitInfo> getHits(Set<RHit> hits, CheckInfo checkInfo) {
        ArrayList<HitInfo> result = new ArrayList<HitInfo>();
        if (hits == null || hits.isEmpty()) {
            return result;
        }
        List<Set<String>> annotationStrings = this.report.getAnnotationStrings();
        LinkedHashSet<String> annotationNames = new LinkedHashSet<String>();
        if (this.report.getAnnotationInfos() != null) {
            this.report.getAnnotationInfos().stream().forEach(x -> {
                boolean bl = annotationNames.add(x.getTitle());
            });
        }
        for (RHit hit : hits) {
            CompareInfo compareInfo = null;
            if (this.report.getInfoWrapper().isCompareReport()) {
                String originName = hit.getCompareHitOrigin();
                String modifiedStatus = "Missing";
                if (hit.getCompareModifiedStatus() != -1) {
                    modifiedStatus = CheckStatus.getCheckStatus(hit.getCompareModifiedStatus()).name();
                }
                compareInfo = new CompareInfo(new ArrayList<String>(hit.getCompareAnnotations()), modifiedStatus, originName);
            }
            HitInfo hitInfo = new HitInfo(hit.getHitDetails(), hit.getMacroDetails(), CheckStatus.getCheckStatus(hit.getHitSeverity()).name(), hit.getHitLine(), checkInfo, this.getAnnotationValuesToAnnotationTitlesMapping(annotationNames, annotationStrings, hit), compareInfo);
            hitInfo.setParserPath(hit.getFile());
            if (hit.hasAutocorrectEdits()) {
                List<REdit> rEdits = hit.getAutocorrectEdits();
                hitInfo.setAutocorrectEdits(rEdits.stream().map(rEdit -> new EditInfo(checkInfo, hitInfo, (REdit)rEdit)).collect(Collectors.toList()));
            }
            if (hit.hasAutocorrectError()) {
                RError rError = hit.getAutocorrectError();
                hitInfo.setAutocorrectError(new ErrorInfo(hitInfo, rError.getReason(), rError.getAdditionalInformation()));
            }
            result.add(hitInfo);
        }
        return result;
    }

    private Map<String, List<String>> getAnnotationValuesToAnnotationTitlesMapping(Set<String> annotationNames, List<Set<String>> annotationsStrings, Object obj) {
        LinkedHashMap<String, List<String>> annotations = new LinkedHashMap<String, List<String>>();
        List<List<String>> annotationStringsValues = this.getAnnotationsStrings(annotationsStrings, obj);
        if (annotationNames == null || annotationStringsValues == null || annotationNames.size() != annotationStringsValues.size()) {
            return annotations;
        }
        int i = 0;
        for (String annotationName : annotationNames) {
            if (i >= 0 && i < annotationStringsValues.size()) {
                annotations.put(annotationName, annotationStringsValues.get(i));
            } else {
                annotations.put(annotationName, new ArrayList());
            }
            ++i;
        }
        annotations.entrySet().removeIf(x -> ((List)x.getValue()).isEmpty());
        return annotations;
    }

    private List<List<String>> getAnnotationsStrings(List<Set<String>> annotationsStrings, Object obj) {
        if (obj instanceof RHit) {
            return ((RHit)obj).populateAnnotationStringsValues(annotationsStrings) ? ((RHit)obj).getAnnotationStringsValues() : null;
        }
        if (obj instanceof RCheck) {
            return ((RCheck)obj).populateAnnotationStringsValues(annotationsStrings) ? ((RCheck)obj).getAnnotationStringsValues() : null;
        }
        return null;
    }

    private List<FileInfo> getAllFiles(List<HitInfo> allHits, List<EditInfo> allEdits, Map<String, Integer> nofCompiledLinesPerFile) {
        ArrayList<FileInfo> result = new ArrayList<FileInfo>();
        Set<String> files = this.report.getAllImportedFiles();
        LinkedHashMap fileHitsMap = new LinkedHashMap();
        for (String file : files) {
            if (file == null || Path.fromOSString((String)file).lastSegment().startsWith("__vlog__")) continue;
            fileHitsMap.put(file, new ArrayList());
        }
        for (HitInfo hit : allHits) {
            String file = hit.getParserPath();
            ArrayList<HitInfo> hits = (ArrayList<HitInfo>)fileHitsMap.get(file);
            if (hits == null) {
                hits = new ArrayList<HitInfo>();
            }
            hits.add(hit);
            fileHitsMap.put(file, hits);
        }
        HashMap fileEditsMap = new HashMap();
        for (EditInfo edit : allEdits) {
            String file = edit.getPath();
            fileEditsMap.putIfAbsent(file, new ArrayList());
            ((List)fileEditsMap.get(file)).add(edit);
        }
        LinkedHashMap<String, Set<RCheck>> prewaivedFilesForChecksMap = this.report.getPrewaivedFilesForChecks();
        for (Map.Entry entry : fileHitsMap.entrySet()) {
            Set<String> prewaivedFileForChecks;
            List hits = (List)entry.getValue();
            if (hits == null) continue;
            HashSet set = (HashSet)prewaivedFilesForChecksMap.get(entry.getKey());
            if (set == null) {
                set = new HashSet();
            }
            if ((prewaivedFileForChecks = set.stream().map(check -> check.getCheckName()).collect(Collectors.toSet())) == null) {
                prewaivedFileForChecks = new LinkedHashSet();
            }
            hits.sort(this.hitInfoComparator);
            String path = (String)entry.getKey();
            Integer lines = nofCompiledLinesPerFile.get(path);
            if (lines == null) {
                lines = 0;
            }
            FileInfo fileInfo = new FileInfo(path, lines, hits, prewaivedFileForChecks, prewaivedFileForChecks.size() == this.nofValidChecks);
            this.pathForFileMap.put(path, fileInfo);
            ArrayList<ErrorInfo> autocorrectErrors = new ArrayList<ErrorInfo>();
            for (HitInfo hitInfo : hits) {
                hitInfo.setFile(fileInfo);
                this.fileForHitMap.putIfAbsent(hitInfo, fileInfo);
                if (!hitInfo.hasAutocorrectError()) continue;
                autocorrectErrors.add(hitInfo.getAutocorrectError());
            }
            fileInfo.setAutocorrectErrors(autocorrectErrors);
            result.add(fileInfo);
        }
        for (FileInfo fileInfo : result) {
            List edits = (List)fileEditsMap.get(fileInfo.getName());
            if (edits == null) {
                fileInfo.setAutocorrectEdits(new ArrayList<EditInfo>());
                continue;
            }
            edits.sort(this.editInfoComparator);
            fileInfo.setAutocorrectEdits(edits);
        }
        return result;
    }

    private List<FileInfo> getAllNonXVMFiles(List<FileInfo> allFiles) {
        ArrayList<FileInfo> result = new ArrayList<FileInfo>();
        for (FileInfo file : allFiles) {
            if (XVM_FILES.matcher(Path.fromOSString((String)file.getName()).lastSegment()).matches()) continue;
            result.add(file);
        }
        return result;
    }

    private List<WaiverInfo> getAllWaivers(List<RWaiver> postWaivers, Map<String, CheckInfo> allChecks) {
        if (postWaivers == null) {
            return null;
        }
        ArrayList<WaiverInfo> result = new ArrayList<WaiverInfo>();
        for (RWaiver waiver : postWaivers) {
            ArrayList<HitInfo> waivedFailures = new ArrayList<HitInfo>();
            for (RHit hit : waiver.getWaivedFailures()) {
                CheckInfo check = allChecks.get(hit.getCheckName());
                if (check == null) continue;
                HitInfo hitInfo = new HitInfo(hit.getHitDetails(), hit.getMacroDetails(), CheckStatus.getCheckStatus(hit.getHitSeverity()).name(), hit.getHitLine(), check, null, null);
                hitInfo.setParserPath(hit.getFile());
                FileInfo fileInfo = this.fileForHitMap.get(hitInfo);
                if (fileInfo == null) continue;
                hitInfo.setFile(fileInfo);
                waivedFailures.add(hitInfo);
            }
            result.add(new WaiverInfo(waiver.getName(), waiver.getDescription(), waiver.getStatus(), waiver.getApplyOn(), waiver.getPathsApplyOn(), waiver.getCheckNames(), waiver.getPaths(), waiver.getElements(), waiver.getLineRanges(), waiver.getMessagePatterns(), waiver.getWaiverFile(), waivedFailures));
        }
        return result;
    }

    private List<PreWaiverInfo> getAllPreWaivers(List<RPreWaiver> preWaivers) {
        if (preWaivers == null) {
            return null;
        }
        ArrayList<PreWaiverInfo> result = new ArrayList<PreWaiverInfo>();
        for (RPreWaiver waiver : preWaivers) {
            ArrayList<FileInfo> prewaivedFiles = new ArrayList<FileInfo>();
            Set<String> files = waiver.getPrewaivedFiles();
            if (files != null) {
                for (String path : files) {
                    FileInfo fileInfo = this.pathForFileMap.get(path);
                    if (fileInfo == null) continue;
                    prewaivedFiles.add(fileInfo);
                }
            }
            result.add(new PreWaiverInfo(waiver.getName(), waiver.getDescription(), waiver.getApplyOn(), waiver.getPathsApplyOn(), waiver.getCheckNames(), waiver.getPaths(), waiver.getElements(), waiver.getWaiverFile(), prewaivedFiles));
        }
        return result;
    }

    private List<CheckInfo> getAutocorrectEnabledChecks(Map<String, CheckInfo> checks) {
        ArrayList<CheckInfo> result = new ArrayList<CheckInfo>();
        for (CheckInfo check : checks.values()) {
            if (!check.isAutocorrectEnabled()) continue;
            result.add(check);
        }
        return result;
    }

    private List<String> getAutocorrectedFiles() {
        return new ArrayList<String>(VerissimoAutofixManager.getInstance().getAutocorrectedFiles());
    }

    private List<String> getVersions() {
        if (!TestHelper.isTestMode()) {
            return new ArrayList<String>();
        }
        Map versionsMap = DVTUtilsCommon.INSTANCE.getVersionsMap();
        ArrayList<String> versions = new ArrayList<String>(versionsMap.keySet());
        String lastVersion = (String)versions.get(versions.size() - 1);
        String[] lastVersionSplits = DVTStringUtil.split((String)".", (String)lastVersion);
        int lastSplit = Integer.parseInt(lastVersionSplits[lastVersionSplits.length - 1]) + 1;
        lastVersionSplits[lastVersionSplits.length - 1] = Integer.toString(lastSplit);
        StringBuilder presumedNextVersionBuilder = new StringBuilder(lastVersionSplits[0]);
        int i = 1;
        while (i < lastVersionSplits.length) {
            presumedNextVersionBuilder.append(".").append(lastVersionSplits[i]);
            ++i;
        }
        String presumedNextVersion = presumedNextVersionBuilder.toString();
        versions.add(presumedNextVersion);
        return versions;
    }

    private List<String> getUpcomingMajorVersions() {
        if (!TestHelper.isTestMode()) {
            return new ArrayList<String>();
        }
        Map versionsMap = DVTUtilsCommon.INSTANCE.getVersionsMap();
        ArrayList versions = new ArrayList(versionsMap.keySet());
        String lastVersion = (String)versions.get(versions.size() - 1);
        String[] lastVersionSplits = DVTStringUtil.split((String)".", (String)lastVersion);
        int[] nextSplits = new int[]{Integer.parseInt(lastVersionSplits[0]) + 1, Integer.parseInt(lastVersionSplits[1]) + 1, Integer.parseInt(lastVersionSplits[2]) + 1};
        StringBuilder firstOption = new StringBuilder();
        firstOption.append(lastVersionSplits[0]).append(".").append(Integer.toString(nextSplits[1])).append(".").append(Integer.toString(nextSplits[2]));
        StringBuilder secondOption = new StringBuilder();
        secondOption.append(Integer.toString(nextSplits[0])).append(".1.1");
        ArrayList<String> upcomingMajorVersions = new ArrayList<String>();
        upcomingMajorVersions.add(firstOption.toString());
        upcomingMajorVersions.add(secondOption.toString());
        return upcomingMajorVersions;
    }
}

