/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter;

import java.util.List;
import java.util.stream.Collectors;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.vlogdt.linter.CheckInfo;
import ro.amiq.vlogdt.linter.ChecksSummary;
import ro.amiq.vlogdt.linter.CompareSummary;
import ro.amiq.vlogdt.linter.EditInfo;
import ro.amiq.vlogdt.linter.ErrorInfo;
import ro.amiq.vlogdt.linter.FileInfo;
import ro.amiq.vlogdt.linter.HitInfo;
import ro.amiq.vlogdt.linter.HitsSummary;
import ro.amiq.vlogdt.linter.PreWaiverInfo;
import ro.amiq.vlogdt.linter.WaiverInfo;

public class CustomReportModel {
    private List<CheckInfo> checks;
    private List<HitInfo> hits;
    private List<HitInfo> autocorrectedHits;
    private List<HitInfo> nonAutocorrectedHits;
    private List<FileInfo> allFiles;
    private List<FileInfo> files;
    private List<String> annotationNames;
    private ChecksSummary checksSummary;
    private HitsSummary hitsSummary;
    private CompareSummary compareSummary;
    private boolean passed;
    private int nofCompiledLines;
    private long lintRunTime;
    private long buildRunTime;
    private long licenseWaitTime;
    private String version;
    private List<EditInfo> autocorrectEdits;
    private List<ErrorInfo> autocorrectErrors;
    private List<WaiverInfo> waivers;
    private List<PreWaiverInfo> preWaivers;
    private List<CheckInfo> autocorrectEnabledChecks;
    private List<String> autocorrectedFiles;
    private List<String> versions;
    private List<String> upcomingMajorVersions;

    public CustomReportModel(List<CheckInfo> checks, List<HitInfo> hits, List<FileInfo> allFiles, List<FileInfo> files, List<EditInfo> autocorrectEdits, List<ErrorInfo> autocorrectErrors, List<WaiverInfo> waivers, List<PreWaiverInfo> preWaivers, List<CheckInfo> autocorrectEnabledChecks, List<String> annotationTitles, ChecksSummary checksSummary, HitsSummary hitsSummary, CompareSummary compareSummary, boolean passed, int nofCompiledLines, long lintRunTime, long buildRunTime, long licenseWaitTime, List<String> autocorrectedFiles, List<String> versions, List<String> upcomingMajorVersions) {
        this.checks = checks;
        this.hits = hits;
        this.autocorrectedHits = hits.stream().filter(hit -> hit.isAutocorrected()).collect(Collectors.toList());
        this.nonAutocorrectedHits = hits.stream().filter(hit -> !hit.isAutocorrected()).collect(Collectors.toList());
        this.allFiles = allFiles;
        this.files = files;
        this.autocorrectEdits = autocorrectEdits;
        this.autocorrectErrors = autocorrectErrors;
        this.waivers = waivers;
        this.preWaivers = preWaivers;
        this.autocorrectEnabledChecks = autocorrectEnabledChecks;
        this.annotationNames = annotationTitles;
        this.checksSummary = checksSummary;
        this.hitsSummary = hitsSummary;
        this.compareSummary = compareSummary;
        this.passed = passed;
        this.nofCompiledLines = nofCompiledLines;
        this.lintRunTime = lintRunTime;
        this.buildRunTime = buildRunTime;
        this.licenseWaitTime = licenseWaitTime;
        this.version = Utils.getVersion();
        this.autocorrectedFiles = autocorrectedFiles;
        this.versions = versions;
        this.upcomingMajorVersions = upcomingMajorVersions;
    }

    public ChecksSummary getChecksSummary() {
        return this.checksSummary;
    }

    public HitsSummary getHitsSummary() {
        return this.hitsSummary;
    }

    public List<CheckInfo> getChecks() {
        return this.checks;
    }

    public List<HitInfo> getHits() {
        return this.hits;
    }

    public List<HitInfo> getAutocorrectedHits() {
        return this.autocorrectedHits;
    }

    public List<HitInfo> getNonAutocorrectedHits() {
        return this.nonAutocorrectedHits;
    }

    public List<FileInfo> getFiles() {
        return this.files;
    }

    public List<FileInfo> getFiles(boolean includeUVM) {
        if (!includeUVM) {
            return this.files;
        }
        return this.allFiles;
    }

    public List<EditInfo> getAutocorrectEdits() {
        return this.autocorrectEdits;
    }

    public List<ErrorInfo> getAutocorrectErrors() {
        return this.autocorrectErrors;
    }

    public List<WaiverInfo> getWaivers() {
        return this.waivers;
    }

    public List<PreWaiverInfo> getPreWaivers() {
        return this.preWaivers;
    }

    public List<CheckInfo> getAutocorrectEnabledChecks() {
        return this.autocorrectEnabledChecks;
    }

    public boolean isPassed() {
        return this.passed;
    }

    public List<String> getAnnotationNames() {
        return this.annotationNames;
    }

    public String getEnvVar(String variable) {
        return DVTUtilsCommon.INSTANCE.replaceAllSystemVariables((CharSequence)variable, DVTUtilsCommon.ReplaceSysvarsPolicy.LEAVE_UNREPLACED, null);
    }

    public int getNofCompiledLines() {
        return this.nofCompiledLines;
    }

    public String getVersion() {
        return this.version;
    }

    public long getLintRunTime() {
        return this.lintRunTime;
    }

    public long getBuildRunTime() {
        return this.buildRunTime;
    }

    public long getLicenseWaitTime() {
        return this.licenseWaitTime;
    }

    public CompareSummary getCompareSummary() {
        return this.compareSummary;
    }

    public List<String> getAutocorrectedFiles() {
        return this.autocorrectedFiles;
    }

    public List<String> getVersions() {
        return this.versions;
    }

    public List<String> getUpcomingMajorVersions() {
        return this.upcomingMajorVersions;
    }
}

