/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter;

import java.util.List;
import java.util.Set;
import ro.amiq.vlogdt.linter.EditInfo;
import ro.amiq.vlogdt.linter.ErrorInfo;
import ro.amiq.vlogdt.linter.HitInfo;

public class FileInfo {
    private static final String ALL_CHECKS = "ALL_CHECKS";
    private static final String ANY_CHECK = "ANY_CHECK";
    private String name;
    private Integer nofCompiledLines;
    private List<HitInfo> hits;
    private Set<String> prewaivedForChecks;
    private Boolean isPrewaivedForAllChecks;
    private List<EditInfo> autocorrectEdits;
    private List<ErrorInfo> autocorrectErrors;

    public FileInfo(String name, int nofCompiledLines, List<HitInfo> hits, Set<String> prewaivedForChecks, boolean isPrewaivedForAllChecks) {
        this.name = name;
        this.nofCompiledLines = nofCompiledLines;
        this.hits = hits;
        this.prewaivedForChecks = prewaivedForChecks;
        this.isPrewaivedForAllChecks = isPrewaivedForAllChecks;
    }

    public String getName() {
        return this.name;
    }

    public Integer getNofCompiledLines() {
        return this.nofCompiledLines;
    }

    public List<HitInfo> getHits() {
        return this.hits;
    }

    public String isPreWaivedFor(String checkName) {
        if (checkName.equals(ALL_CHECKS)) {
            return this.isPrewaivedForAllChecks.toString();
        }
        if (checkName.equals(ANY_CHECK)) {
            return Boolean.toString(!this.prewaivedForChecks.isEmpty());
        }
        return Boolean.toString(this.prewaivedForChecks.contains(checkName));
    }

    public List<EditInfo> getAutocorrectEdits() {
        return this.autocorrectEdits;
    }

    public List<ErrorInfo> getAutocorrectErrors() {
        return this.autocorrectErrors;
    }

    protected void setHits(List<HitInfo> hits) {
        this.hits = hits;
    }

    protected void setAutocorrectEdits(List<EditInfo> edits) {
        this.autocorrectEdits = edits;
    }

    protected void setAutocorrectErrors(List<ErrorInfo> autocorrectErrors) {
        this.autocorrectErrors = autocorrectErrors;
    }

    public String toString() {
        return this.getName();
    }
}

