/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import ro.amiq.vlogdt.linter.CheckInfo;
import ro.amiq.vlogdt.linter.CompareInfo;
import ro.amiq.vlogdt.linter.EditInfo;
import ro.amiq.vlogdt.linter.ErrorInfo;
import ro.amiq.vlogdt.linter.FileInfo;

public class HitInfo {
    private String details;
    private String macroDetails;
    private String severity;
    private String parserPath;
    private FileInfo file;
    private int line;
    private CheckInfo check;
    private Map<String, List<String>> annotations;
    private CompareInfo compareInfo;
    private List<EditInfo> edits;
    private ErrorInfo error;

    public HitInfo(String details, String macroDetails, String severity, int line, CheckInfo check, Map<String, List<String>> annotations, CompareInfo compareInfo) {
        this.details = details;
        this.macroDetails = macroDetails;
        this.severity = severity;
        this.line = line;
        this.check = check;
        this.annotations = annotations;
        this.compareInfo = compareInfo;
    }

    public String getDetails() {
        return this.details;
    }

    public String getMacroDetails() {
        return this.macroDetails;
    }

    public String getSeverity() {
        return this.severity;
    }

    public FileInfo getFile() {
        return this.file;
    }

    protected void setFile(FileInfo fileInfo) {
        this.file = fileInfo;
    }

    protected String getParserPath() {
        return this.parserPath;
    }

    protected void setParserPath(String parserPath) {
        this.parserPath = parserPath;
    }

    public int getLine() {
        return this.line;
    }

    public CheckInfo getCheck() {
        return this.check;
    }

    public Map<String, List<String>> getAnnotations() {
        return this.annotations;
    }

    public List<String> getAnnotations(String annotationTitle) {
        return this.annotations.getOrDefault(annotationTitle, new ArrayList());
    }

    public CompareInfo getCompareInfo() {
        return this.compareInfo;
    }

    public boolean isAutocorrected() {
        return this.edits != null && !this.edits.isEmpty();
    }

    public List<EditInfo> getAutocorrectEdits() {
        return this.edits;
    }

    protected void setAutocorrectEdits(List<EditInfo> edits) {
        this.edits = edits;
    }

    public boolean hasAutocorrectError() {
        return this.error != null;
    }

    public ErrorInfo getAutocorrectError() {
        return this.error;
    }

    protected void setAutocorrectError(ErrorInfo error) {
        this.error = error;
    }

    public boolean equals(Object anObject) {
        HitInfo anotherHitInfo;
        if (this == anObject) {
            return true;
        }
        return anObject instanceof HitInfo && this.details.equals((anotherHitInfo = (HitInfo)anObject).getDetails()) && this.severity.equals(anotherHitInfo.getSeverity()) && this.parserPath.equals(anotherHitInfo.getParserPath()) && this.line == anotherHitInfo.getLine() && this.check.getName().equals(anotherHitInfo.getCheck().getName()) && Objects.equals(this.macroDetails, anotherHitInfo.macroDetails);
    }

    public int hashCode() {
        return Objects.hash(this.details, this.macroDetails, this.severity, this.parserPath, this.line, this.check.getName());
    }
}

