/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.vlogdt.linter.CheckStatus;
import ro.amiq.vlogdt.linter.ChecksSummary;
import ro.amiq.vlogdt.linter.CompareSummary;
import ro.amiq.vlogdt.linter.HitsSummary;
import ro.amiq.vlogdt.linter.OVMComplianceChecksUtil;
import ro.amiq.vlogdt.linter.report.model.RCategory;
import ro.amiq.vlogdt.linter.report.model.RCheck;
import ro.amiq.vlogdt.linter.report.model.RHit;
import ro.amiq.vlogdt.linter.report.model.RReport;

public class LinterSummary {
    private ChecksSummary checksSummary;
    private CompareSummary compareSummary;
    private HitsSummary hitsSummary;
    private ArrayList<RHit> errorHits = new ArrayList();
    private ArrayList<RHit> warningHits = new ArrayList();
    private ArrayList<RHit> infoHits = new ArrayList();
    private ArrayList<RHit> disabledHits = new ArrayList();
    private ArrayList<RCheck> disabledChecks = new ArrayList();
    private ArrayList<RCheck> nonexistentChecks = new ArrayList();
    private ArrayList<RCheck> duplicateChecks = new ArrayList();
    private boolean isPassed;
    private boolean hasHiddenHits;

    private LinterSummary(ChecksSummary checksSummary, CompareSummary compareSummary, HitsSummary hitsSummary, ArrayList<RHit> errorHits, ArrayList<RHit> warningHits, ArrayList<RHit> infoHits, ArrayList<RHit> disabledHits, ArrayList<RCheck> disabledChecks, ArrayList<RCheck> nonExistentChecks, ArrayList<RCheck> duplicateChecks, boolean isPassed, boolean hasHiddenHits) {
        this.checksSummary = checksSummary;
        this.compareSummary = compareSummary;
        this.hitsSummary = hitsSummary;
        this.errorHits = errorHits;
        this.warningHits = warningHits;
        this.infoHits = infoHits;
        this.disabledHits = disabledHits;
        this.disabledChecks = disabledChecks;
        this.nonexistentChecks = nonExistentChecks;
        this.duplicateChecks = duplicateChecks;
        this.isPassed = isPassed;
        this.hasHiddenHits = hasHiddenHits;
    }

    public ChecksSummary getChecksSummary() {
        return this.checksSummary;
    }

    public CompareSummary getCompareSummary() {
        return this.compareSummary;
    }

    public HitsSummary getHitsSummary() {
        return this.hitsSummary;
    }

    public ArrayList<RHit> getErrorHits() {
        return this.errorHits;
    }

    public ArrayList<RHit> getWarningHits() {
        return this.warningHits;
    }

    public ArrayList<RHit> getInfoHits() {
        return this.infoHits;
    }

    public ArrayList<RHit> getDisabledHits() {
        return this.disabledHits;
    }

    public ArrayList<RCheck> getDisabledChecks() {
        return this.disabledChecks;
    }

    public ArrayList<RCheck> getNonExistentChecks() {
        return this.nonexistentChecks;
    }

    public ArrayList<RCheck> getDuplicatedChecks() {
        return this.duplicateChecks;
    }

    public boolean isPassed() {
        return this.isPassed;
    }

    private int getNofFixed(List<RHit> hits) {
        int nr = 0;
        for (RHit hit : hits) {
            if (!hit.isFixed()) continue;
            ++nr;
        }
        return nr;
    }

    public int getNofFixedErrors() {
        return this.getNofFixed(this.errorHits);
    }

    public int getNofFixedWarnings() {
        return this.getNofFixed(this.warningHits);
    }

    public int getNofFixedInfos() {
        return this.getNofFixed(this.infoHits);
    }

    public boolean hasHiddenHits() {
        return this.hasHiddenHits;
    }

    public static LinterSummary create(RReport report, boolean ignoreErrors, boolean ignoreWarnings, boolean ignoreInfos, String failOnSeverity) {
        ArrayList<RHit> errorHits = new ArrayList<RHit>();
        ArrayList<RHit> warningHits = new ArrayList<RHit>();
        ArrayList<RHit> infoHits = new ArrayList<RHit>();
        ArrayList<RHit> disabledHits = new ArrayList<RHit>();
        ArrayList<RCheck> disabledChecks = new ArrayList<RCheck>();
        ArrayList<RCheck> nonExistentChecks = new ArrayList<RCheck>();
        ArrayList<RCheck> duplicatedChecks = new ArrayList<RCheck>();
        int nofPassedChecks = 0;
        int nofErrorChecks = 0;
        int nofWarningChecks = 0;
        int nofInfoChecks = 0;
        boolean hasHiddenHits = false;
        int[] visibleHitsCounts = new int[5];
        int[] hiddenHitsCounts = new int[5];
        LinkedHashMap allHits = new LinkedHashMap();
        List<RCategory> categories = report.getCategories();
        for (RCategory rCategory : categories) {
            for (RCheck check : rCategory.getChecks()) {
                if ("NONEXISTENT_ID_ERROR".equals(check.getCheckID())) {
                    nonExistentChecks.add(check);
                    continue;
                }
                if ("DUPLICATE_NAME_ERROR".equals(check.getCheckID())) {
                    duplicatedChecks.add(check);
                    continue;
                }
                CheckStatus checkStatus = OVMComplianceChecksUtil.getStatus(check);
                if (checkStatus == CheckStatus.DISABLED) {
                    disabledChecks.add(check);
                } else if (checkStatus == CheckStatus.PASSED) {
                    ++nofPassedChecks;
                } else if (checkStatus == CheckStatus.ERROR) {
                    ++nofErrorChecks;
                } else if (checkStatus == CheckStatus.WARNING) {
                    ++nofWarningChecks;
                } else if (checkStatus == CheckStatus.INFO) {
                    ++nofInfoChecks;
                }
                for (RHit hit : check.getHits()) {
                    String name = check.getCheckName();
                    if (hit.isHidden()) {
                        hasHiddenHits = true;
                    }
                    allHits.putIfAbsent(name, new ArrayList());
                    ((List)allHits.get(name)).add(hit);
                }
            }
        }
        for (Map.Entry entry : allHits.entrySet()) {
            for (RHit hit : (List)entry.getValue()) {
                Integer hitStatus = hit.getHitSeverity();
                if (hitStatus.intValue() == CheckStatus.ERROR.ordinal()) {
                    errorHits.add(hit);
                } else if (hitStatus.intValue() == CheckStatus.WARNING.ordinal()) {
                    warningHits.add(hit);
                } else if (hitStatus.intValue() == CheckStatus.INFO.ordinal()) {
                    infoHits.add(hit);
                } else if (hitStatus.intValue() == CheckStatus.DISABLED.ordinal()) {
                    disabledHits.add(hit);
                }
                if (hit.isHidden()) {
                    int n = hitStatus;
                    hiddenHitsCounts[n] = hiddenHitsCounts[n] + 1;
                    continue;
                }
                int n = hitStatus;
                visibleHitsCounts[n] = visibleHitsCounts[n] + 1;
            }
        }
        LinkedHashMap<String, List<Integer>> linkedHashMap = new LinkedHashMap<String, List<Integer>>();
        linkedHashMap.put("New Failures", Arrays.asList(0, 0, 0, 0, 0));
        linkedHashMap.put("New Fixes", Arrays.asList(0, 0, 0, 0, 0));
        linkedHashMap.put("Added Rules", Arrays.asList(0, 0, 0, 0, 0));
        linkedHashMap.put("Removed Rules", Arrays.asList(0, 0, 0, 0, 0));
        linkedHashMap.put("Common", Arrays.asList(0, 0, 0, 0, 0));
        List<RHit> hits = report.getHits();
        if (hits != null && !hits.isEmpty()) {
            for (RHit hit : hits) {
                for (String compareAnnotation : hit.getCompareAnnotations()) {
                    Integer nofFailures = (Integer)((List)linkedHashMap.get(compareAnnotation)).get(hit.getHitSeverity());
                    ((List)linkedHashMap.get(compareAnnotation)).set(hit.getHitSeverity(), nofFailures + 1);
                }
            }
        }
        boolean isPassed = "error".equals(failOnSeverity) && !ignoreErrors && nofErrorChecks != 0 ? false : ("warning".equals(failOnSeverity) && (!ignoreErrors && nofErrorChecks != 0 || !ignoreWarnings && nofWarningChecks != 0) ? false : !("info".equals(failOnSeverity) && (!ignoreErrors && nofErrorChecks != 0 || !ignoreWarnings && nofWarningChecks != 0 || !ignoreInfos && nofInfoChecks != 0)));
        return new LinterSummary(new ChecksSummary(nofPassedChecks, nofErrorChecks, nofWarningChecks, nofInfoChecks, disabledChecks.size(), nonExistentChecks.size(), duplicatedChecks.size()), new CompareSummary((List)linkedHashMap.get("New Failures"), (List)linkedHashMap.get("New Fixes"), (List)linkedHashMap.get("Added Rules"), (List)linkedHashMap.get("Removed Rules"), (List)linkedHashMap.get("Common")), new HitsSummary(visibleHitsCounts, hiddenHitsCounts), errorHits, warningHits, infoHits, disabledHits, disabledChecks, nonExistentChecks, duplicatedChecks, isPassed, hasHiddenHits);
    }
}

