/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class LintingProgressAndAliveMonitor
implements IProgressMonitor {
    private String fProgressMonitorTaskName;
    private long fLastAliveTimestamp;
    private int fState;
    private static final long UPDATE_DELAY = 500L;
    private static final String[] STATES = new String[]{"  --", "  \\", "  |", "  /"};
    IProgressMonitor fProgressMonitor;

    public LintingProgressAndAliveMonitor(IProgressMonitor progressMonitor) {
        this.fProgressMonitor = progressMonitor != null ? progressMonitor : new NullProgressMonitor();
    }

    public void alive() {
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis - this.fLastAliveTimestamp < 500L) {
            return;
        }
        this.fLastAliveTimestamp = currentTimeMillis;
        ++this.fState;
        if (this.fState >= STATES.length) {
            this.fState = 0;
        }
        this.setTaskName(this.fProgressMonitorTaskName);
    }

    public void worked(int work) {
        this.fProgressMonitor.worked(work);
    }

    public void subTask(String name) {
        this.fProgressMonitor.subTask(name);
        this.setTaskName(name);
    }

    public void beginTask(String name, int totalWork) {
        this.fProgressMonitor.beginTask(name, totalWork);
        this.setTaskName(name);
    }

    public void done() {
        this.fProgressMonitor.done();
    }

    public void internalWorked(double work) {
        this.fProgressMonitor.internalWorked(work);
    }

    public boolean isCanceled() {
        return this.fProgressMonitor.isCanceled();
    }

    public void setCanceled(boolean b) {
        this.fProgressMonitor.setCanceled(b);
    }

    public void setTaskName(String name) {
        this.fProgressMonitorTaskName = name;
        this.fProgressMonitor.setTaskName(String.valueOf(this.fProgressMonitorTaskName) + STATES[this.fState]);
    }

    public String getCurrentTaskName() {
        return this.fProgressMonitorTaskName;
    }
}

