/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import ro.amiq.dvt.utils.XMLErrorHandler;
import ro.amiq.vlogdt.linter.ManualChecksStatusXMLParser1;
import ro.amiq.vlogdt.linter.OVMProject;

public abstract class ManualChecksStatusXMLParser {
    protected static final String TAG_MANUAL_CHECK_STATUSES = "manual-check-statuses";
    protected static final String ATTR_VERSION = "version";
    private final File fFile;
    private static final String LAST_VERSION = "1";

    protected ManualChecksStatusXMLParser(File file) {
        this.fFile = file;
    }

    public void save(OVMProject project) throws Exception {
        if (!this.fFile.exists()) {
            File parent = this.fFile.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            this.fFile.createNewFile();
        }
        this.saveInternal(project);
    }

    public void load(OVMProject project) throws Exception {
        if (!this.fFile.exists()) {
            return;
        }
        this.loadInternal(project);
    }

    public abstract void saveInternal(OVMProject var1) throws Exception;

    public abstract void loadInternal(OVMProject var1) throws Exception;

    public File getFile() {
        return this.fFile;
    }

    public static ManualChecksStatusXMLParser newParser(File file, boolean useLastVersion) throws Exception {
        if (useLastVersion || !file.exists()) {
            return ManualChecksStatusXMLParser.newParser(file, LAST_VERSION);
        }
        String version = ManualChecksStatusXMLParser.detectVersion(file);
        return ManualChecksStatusXMLParser.newParser(file, version);
    }

    private static ManualChecksStatusXMLParser1 newParser(File file, String version) throws Exception {
        if (LAST_VERSION.equals(version)) {
            return new ManualChecksStatusXMLParser1(file);
        }
        throw new IllegalArgumentException("Unknown waivers file version " + version + ".");
    }

    private static String detectVersion(File file) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler((ErrorHandler)XMLErrorHandler.INSTANCE);
        Document document = builder.parse(file);
        NodeList waiversNodes = document.getElementsByTagName(TAG_MANUAL_CHECK_STATUSES);
        if (waiversNodes.getLength() < 1) {
            return null;
        }
        Element waiversNode = (Element)waiversNodes.item(0);
        return waiversNode.getAttribute(ATTR_VERSION);
    }
}

