/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import ro.amiq.dvt.utils.XMLErrorHandler;
import ro.amiq.vlogdt.linter.CheckStatus;
import ro.amiq.vlogdt.linter.ManualChecksStatusXMLParser;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.standard.checks.OVMComplianceManualCheck;

public class ManualChecksStatusXMLParser1
extends ManualChecksStatusXMLParser {
    public static final String VERSION_ID = "1";
    private static final String TAG_STATUS = "status";
    private static final String ATTR_CHECK = "check";

    public ManualChecksStatusXMLParser1(File file) {
        super(file);
    }

    @Override
    public void saveInternal(OVMProject project) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler((ErrorHandler)XMLErrorHandler.INSTANCE);
        Document document = builder.newDocument();
        Element elem = document.createElement("manual-check-statuses");
        document.appendChild(elem);
        elem.setAttribute("version", VERSION_ID);
        this.appendManualCheckStatuses(project, elem, document);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        Throwable throwable = null;
        Object var8_9 = null;
        try (BufferedWriter output = new BufferedWriter(new FileWriter(this.getFile()));){
            StreamResult result = new StreamResult(output);
            DOMSource source = new DOMSource(document);
            transformer.transform(source, result);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void appendManualCheckStatuses(OVMProject project, Element root, Document document) {
        for (OVMComplianceCheck check : project.getChecks()) {
            if (!(check instanceof OVMComplianceManualCheck)) continue;
            Element elem = document.createElement(TAG_STATUS);
            root.appendChild(elem);
            elem.setAttribute(ATTR_CHECK, check.getName());
            Text text = document.createTextNode(((OVMComplianceManualCheck)check).getStatus().name());
            elem.appendChild(text);
        }
    }

    @Override
    public void loadInternal(OVMProject project) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler((ErrorHandler)XMLErrorHandler.INSTANCE);
        Document document = builder.parse(this.getFile());
        NodeList nodes = document.getElementsByTagName(TAG_STATUS);
        int i = 0;
        while (i < nodes.getLength()) {
            String statusString;
            OVMComplianceCheck check;
            Element elem = (Element)nodes.item(i);
            String checkName = elem.getAttribute(ATTR_CHECK);
            if (checkName != null && !checkName.equals("") && (check = project.getCheck(checkName)) != null && check instanceof OVMComplianceManualCheck && (statusString = elem.getTextContent()) != null && !statusString.trim().isEmpty()) {
                ((OVMComplianceManualCheck)check).setStatus(CheckStatus.valueOf(statusString));
            }
            ++i;
        }
    }
}

