/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.model.DVTMixedLangBuilder;
import ro.amiq.dvt.model.IDVTBuildContributor;
import ro.amiq.vlogdt.builders.VlogBuildContributor;
import ro.amiq.vlogdt.linter.ILintingBuildListener;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.launch.LintConfigurationContainer;
import ro.amiq.vlogdt.linter.ruleset.RulesetKind;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfProject;

public class OVMComplianceBuilder {
    private static volatile OVMComplianceBuilder fInstance;
    private static final Object fSyncInstance;
    private HashMap<IProject, OVMProject> fOVMProjects;
    private List<ILintingBuildListener> fListeners = new ArrayList<ILintingBuildListener>();

    static {
        fSyncInstance = new Object();
    }

    public OVMComplianceBuilder() {
        this.fOVMProjects = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OVMComplianceBuilder getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new OVMComplianceBuilder();
            }
        }
        return fInstance;
    }

    public void clearOVMProjects() {
        this.fOVMProjects.clear();
    }

    public OVMProject createOVMProject(LintConfigurationContainer config, boolean lintProject) {
        if (config == null) {
            return null;
        }
        OVMProject ovmProject = new OVMProject(config, false);
        ovmProject.setLintProject(lintProject);
        this.fOVMProjects.put(config.getProject(), ovmProject);
        return ovmProject;
    }

    public void addOVMProject(OVMProject ovmProject) {
        this.fOVMProjects.put(ovmProject.getProject(), ovmProject);
    }

    public OVMProject initializeOVMProject(IProject project) {
        if (project == null) {
            return null;
        }
        OVMProject ovmProject = this.fOVMProjects.get(project);
        if (ovmProject == null) {
            ovmProject = new OVMProject(new LintConfigurationContainer("", project, RulesetKind.getPrefered(), OVMUtils.getPathToPropertyFile(project, "test", "ruleset.xml"), OVMUtils.getPathToPropertyFile(project, "test", "waivers.xml"), OVMUtils.getPathToPropertyFile(project, "test", "manual_checks_status.xml"), null, -1, null, null), false);
            this.fOVMProjects.put(project, ovmProject);
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        ovmProject.initialize(rfProject, true, true);
        rfProject.setOvmProject(ovmProject);
        return ovmProject;
    }

    public void build(IProject project, IProgressMonitor monitor, boolean onlyFailed, Object target) {
        this.build(project, monitor, onlyFailed, target, false);
    }

    public void build(IProject project, IProgressMonitor monitor, boolean onlyFailed, Object target, boolean printAutofixSummary) {
        if (project == null) {
            return;
        }
        OVMProject ovmProject = this.getOVMProject(project);
        if (ovmProject == null) {
            return;
        }
        this.notifyPreBuild(ovmProject);
        int lines = 0;
        Map<String, Integer> linesPerFile = new HashMap<String, Integer>();
        List buildContributors = DVTMixedLangBuilder.getEnabledContributors((IProject)ovmProject.getProject());
        for (IDVTBuildContributor buildContributor : buildContributors) {
            if (!(buildContributor instanceof VlogBuildContributor)) continue;
            lines = ((VlogBuildContributor)buildContributor).getTotalNofLines();
            linesPerFile = ((VlogBuildContributor)buildContributor).getNofCompiledLinesPerFile();
        }
        ovmProject.setNofCompiledLines(lines);
        ovmProject.setNofCompiledLinesPerFile(linesPerFile);
        if (ovmProject.getNofCompiledLines() == 0) {
            ovmProject.computeZeroCompiledLines();
        }
        ovmProject.build(monitor, onlyFailed, target, true, printAutofixSummary);
        this.notifyPostBuild(ovmProject);
    }

    public ArrayList<OVMComplianceCheck> getChecks(IProject project) {
        if (project == null) {
            return null;
        }
        OVMProject ovmProject = this.getOVMProject(project);
        if (ovmProject == null) {
            return null;
        }
        return ovmProject.getChecks();
    }

    public boolean checkErrors(IProject project) {
        if (project == null) {
            return true;
        }
        OVMProject ovmProject = this.getOVMProject(project);
        if (ovmProject == null) {
            return true;
        }
        return !ovmProject.fCheckExceptions.isEmpty();
    }

    public boolean checkTimedoutProcess(IProject project) {
        if (project == null) {
            return false;
        }
        OVMProject ovmProject = this.getOVMProject(project);
        if (ovmProject == null) {
            return false;
        }
        return ovmProject.fTimedOutProcess;
    }

    public boolean checkTimedoutSession(IProject project) {
        if (project == null) {
            return false;
        }
        OVMProject ovmProject = this.getOVMProject(project);
        if (ovmProject == null) {
            return false;
        }
        return ovmProject.fTimedOutSession;
    }

    public boolean checkTimedoutChecks(IProject project) {
        if (project == null) {
            return false;
        }
        OVMProject ovmProject = this.getOVMProject(project);
        if (ovmProject == null) {
            return false;
        }
        return ovmProject.fTimedOutChecks;
    }

    public ArrayList<OVMComplianceCategory> getCategories(IProject project) {
        OVMProject ovmProject = this.getOVMProject(project);
        if (ovmProject == null) {
            return null;
        }
        return ovmProject.getComplianceCategories();
    }

    public OVMComplianceCheck getCheck(String id, IProject project) {
        OVMProject ovmProject = this.getOVMProject(project);
        if (ovmProject == null) {
            return null;
        }
        return ovmProject.getCheck(id);
    }

    public OVMComplianceCategory getCategory(String name, IProject project) {
        OVMProject ovmProject = this.fOVMProjects.get(project);
        if (ovmProject == null) {
            return null;
        }
        return ovmProject.getCategory(name);
    }

    public OVMProject getOVMProject(IProject project) {
        return this.fOVMProjects.get(project);
    }

    public void removeOVMProject(IProject project) {
        this.fOVMProjects.remove(project);
    }

    public void notifyPostBuild(OVMProject ovmProject) {
        for (ILintingBuildListener listener : this.fListeners) {
            listener.postBuild(ovmProject);
        }
    }

    private void notifyPreBuild(OVMProject ovmProject) {
        for (ILintingBuildListener listener : this.fListeners) {
            listener.preBuild(ovmProject);
        }
    }

    public void addListener(ILintingBuildListener listener) {
        this.fListeners.add(listener);
    }

    public void removeListener(ILintingBuildListener listener) {
        this.fListeners.remove(listener);
    }
}

