/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter;

import java.util.ArrayList;
import java.util.Collection;
import ro.amiq.vlogdt.linter.CheckStatus;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.standard.checks.OVMComplianceManualCheck;

public class OVMComplianceCategory {
    private String fName;
    private String fDescription;
    private ArrayList<OVMComplianceCheck> fChecks;
    public static final String MANUAL = "Manual";

    public OVMComplianceCategory(String name, String description) {
        this.fName = name;
        this.fDescription = description;
        this.fChecks = new ArrayList();
    }

    public String getDescription() {
        return this.fDescription;
    }

    public String getName() {
        return this.fName;
    }

    public void addCheck(OVMComplianceCheck check) {
        this.fChecks.add(check);
    }

    public void removeCheck(OVMComplianceCheck check) {
        this.fChecks.remove(check);
    }

    public void removeChecks(Collection<OVMComplianceCheck> checks) {
        this.fChecks.removeAll(checks);
    }

    public boolean hasChecks() {
        return this.fChecks != null && !this.fChecks.isEmpty();
    }

    public ArrayList<OVMComplianceCheck> getChecks() {
        return this.fChecks;
    }

    public int getNofChecks() {
        if (this.fChecks == null) {
            return 0;
        }
        return this.fChecks.size();
    }

    public int getNofEnabledChecks() {
        if (this.fChecks == null) {
            return 0;
        }
        int enabled = 0;
        for (OVMComplianceCheck check : this.fChecks) {
            if (!check.isEnabled()) continue;
            ++enabled;
        }
        return enabled;
    }

    public int getNofFailedManualChecks() {
        if (this.fChecks == null) {
            return 0;
        }
        int failed = 0;
        for (OVMComplianceCheck check : this.fChecks) {
            if (!check.isEnabled() || !(check instanceof OVMComplianceManualCheck) || ((OVMComplianceManualCheck)check).getStatus() != CheckStatus.ERROR) continue;
            ++failed;
        }
        return failed;
    }
}

