/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import ro.amiq.dvt.DVTSplashMLT;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfNamedElementVisitorException;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.precompiled.PrecompiledDBUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.benchmark.StopWatch;
import ro.amiq.vlogdt.linter.CheckStatus;
import ro.amiq.vlogdt.linter.IOVMComplianceCheck;
import ro.amiq.vlogdt.linter.LintingCancelledException;
import ro.amiq.vlogdt.linter.LintingTimedOutException;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.OVMComplianceChecksUtil;
import ro.amiq.vlogdt.linter.OVMComplianceHit;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.UserInputAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofix;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixFactory;
import ro.amiq.vlogdt.linter.base.annotations.AutofixParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.launch.VerissimoAfterCompilationLauncher;
import ro.amiq.vlogdt.linter.report.model.RHit;
import ro.amiq.vlogdt.linter.standard.checks.AbstractCompilationErrorCheck;
import ro.amiq.vlogdt.linter.utils.HTMLUtils;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.waivers.PreWaiver;
import ro.amiq.vlogdt.linter.waivers.WaiverStatus;
import ro.amiq.vlogdt.linter.waivers.WaiverType;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.parser.ReparseInfo;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.parser.VlogMacroInfo;
import ro.amiq.vlogdt.utils.Utils;

public abstract class OVMComplianceCheck
implements IOVMComplianceCheck {
    protected final OVMProject fOVMProject;
    protected final OVMComplianceCategory fCategory;
    private String fName;
    private String fTitle;
    private String fDate;
    private String fVersion;
    private String fDescription;
    private String fDescriptionAppend;
    private Set<RuleLabel> fLabels;
    private CheckStatus fSeverity;
    protected String fLibraryKind;
    private int fEffort;
    private int fTimeout;
    private Map<String, List<String>> fAnnotationsByTagIdMap;
    private CheckStatus fStatus;
    private boolean fAllowOverride;
    protected final Map<String, String> fProperties;
    protected final Map<String, String> fPropertiesAppend;
    private LinkedHashMap<String, OVMComplianceCheckHit> fCheckHits;
    private boolean fConfigurationError;
    private List<String> fConfigurationErrorDetails;
    private List<String> fMandatoryConfigurationErrorDetails;
    protected long fStartTime;
    private long fRunTime;
    private long fFixingTime;
    private long fCheckEndTime;
    protected boolean fRulesetEnabled;
    protected Boolean fWaiverEnabled;
    private boolean fTimedoutCheck;
    private boolean fTimedoutSession;
    private boolean fTimedoutProcess;
    boolean fMemoryMonitorError;
    private PreWaiver fIncludePreWaiver;
    private PreWaiver fExcludePreWaiver;
    private boolean fProfilingActivated;
    private int fProfilingPeriodMS;
    private int fProfilingDelayMS;
    private boolean fHistogramDumpActivated;
    private boolean fAutoCorrectEnabled;
    private boolean fAutoCorrectSkipSanityChecks;
    protected final Map<String, String> fAutoCorrectInput;
    private volatile boolean shouldSkipCheckAlive = false;
    private ArrayList<OVMComplianceCheckHit> fVisibleHits;

    public OVMComplianceCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        this.fOVMProject = oVMProject;
        this.fCategory = category;
        this.fLibraryKind = this.fOVMProject.getLibraryKind() == 1 ? "ovm" : "uvm";
        this.setName(null);
        this.setTitle(null);
        this.setDate(null);
        this.setVersion(null);
        this.setDescription(null);
        this.setLabels(null);
        this.fRulesetEnabled = true;
        this.fWaiverEnabled = null;
        this.fProperties = new LinkedHashMap<String, String>();
        this.fPropertiesAppend = new LinkedHashMap<String, String>();
        this.setAllowOverride(true);
        this.fSeverity = this.getDefaultSeverity();
        this.fCheckHits = new LinkedHashMap();
        this.fConfigurationErrorDetails = new ArrayList<String>();
        this.fMandatoryConfigurationErrorDetails = new ArrayList<String>();
        this.fConfigurationError = false;
        category.addCheck(this);
        this.fAutoCorrectInput = new LinkedHashMap<String, String>();
    }

    protected OVMComplianceCheck(OVMProject oVMProject, OVMComplianceCategory category, CheckStatus severity, String name, String title, String date, String version, Set<RuleLabel> labels, String description) {
        this.fOVMProject = oVMProject;
        this.fCategory = category;
        this.fLibraryKind = this.fOVMProject.getLibraryKind() == 1 ? "ovm" : "uvm";
        this.fName = name;
        this.fTitle = title;
        this.fLabels = labels;
        this.fDate = date;
        this.fVersion = version;
        this.fDescription = description;
        this.fRulesetEnabled = true;
        this.fWaiverEnabled = null;
        this.fProperties = new LinkedHashMap<String, String>();
        this.fPropertiesAppend = new LinkedHashMap<String, String>();
        this.fSeverity = severity;
        this.fCheckHits = new LinkedHashMap();
        this.fConfigurationErrorDetails = new ArrayList<String>();
        this.fMandatoryConfigurationErrorDetails = new ArrayList<String>();
        this.fConfigurationError = false;
        this.fAutoCorrectInput = new LinkedHashMap<String, String>();
        this.fAllowOverride = true;
        category.addCheck(this);
    }

    @Override
    public String getName() {
        return this.fName;
    }

    public void setName(String name) {
        this.fName = name == null ? this.getDefaultName().replace("xvm", this.fLibraryKind).replace("XVM", this.fLibraryKind.toUpperCase()) : name;
    }

    public String getTitle() {
        return this.fTitle;
    }

    public String getDate() {
        return this.fDate;
    }

    public String getVersion() {
        return this.fVersion;
    }

    public void setTitle(String title) {
        this.fTitle = title == null ? this.getDefaultTitle().replace("xvm", this.fLibraryKind).replace("XVM", this.fLibraryKind.toUpperCase()) : title;
    }

    public void setDate(String date) {
        this.fDate = date == null ? this.getDefaultDate(DVTUtilsCommon.INSTANCE.getVersionsMap()) : date;
    }

    public void setVersion(String version) {
        this.fVersion = version == null ? this.getDefaultVersion() : version;
    }

    public String getFullDescription() {
        if (this.fDescriptionAppend != null && this.fDescription != null) {
            return this.fDescription.concat(this.fDescriptionAppend);
        }
        return this.fDescription;
    }

    public String getSimpleDescription() {
        return this.fDescription;
    }

    public String getDescriptionAppend() {
        return this.fDescriptionAppend;
    }

    public void setDescription(String description) {
        this.fDescription = description == null ? this.getDefaultDescription().replace("xvm", this.fLibraryKind).replace("XVM", this.fLibraryKind.toUpperCase()) : description;
    }

    public Set<RuleLabel> getLabels() {
        return this.fLabels;
    }

    public void setLabels(Set<RuleLabel> labels) {
        this.fLabels = labels == null ? this.getDefaultLabels() : labels;
    }

    public void setDescriptionAppend(String description) {
        this.fDescriptionAppend = description;
    }

    public void setEffort(int effort) {
        this.fEffort = effort;
    }

    public int getEffort() {
        return this.fEffort;
    }

    public CheckStatus getSeverity() {
        return this.fSeverity;
    }

    public CheckStatus setSeverity(CheckStatus severity) {
        this.fSeverity = severity;
        return this.fSeverity;
    }

    public CheckStatus getDefaultSeverity() {
        return CheckStatus.ERROR;
    }

    public OVMComplianceCategory getCategory() {
        return this.fCategory;
    }

    public void setRulesetEnabled(boolean enabled) {
        this.fRulesetEnabled = enabled;
    }

    public boolean isRulesetEnabled() {
        return this.fRulesetEnabled;
    }

    public void setWaiverEnabled(Boolean disabled) {
        this.fWaiverEnabled = disabled == null ? null : Boolean.valueOf(disabled == false);
    }

    public Boolean isWaiverEnabled() {
        return this.fWaiverEnabled;
    }

    public boolean isEnabled() {
        if (this.fWaiverEnabled == null) {
            return this.fRulesetEnabled;
        }
        return this.fWaiverEnabled;
    }

    public void setTimeout(int time) {
        this.fTimeout = time;
    }

    public int getTimeout() {
        return this.fTimeout;
    }

    public void setTimedOutCheck() {
        this.fTimedoutCheck = true;
    }

    public void setTimedOutSession() {
        this.fTimedoutSession = true;
    }

    public void setTimedOutProcess() {
        this.fTimedoutProcess = true;
    }

    public void setMemoryMonitorError() {
        this.fMemoryMonitorError = true;
    }

    public long getEndTime() {
        return this.fCheckEndTime;
    }

    public long getRunTime() {
        return this.fRunTime;
    }

    public void setFixingTime(long fFixingTime) {
        this.fFixingTime = fFixingTime;
    }

    public long getFixingTime() {
        return this.fFixingTime;
    }

    public void addConfigurationError(String error) {
        this.fConfigurationErrorDetails.add(error);
    }

    public List<String> getConfigurationErrorDetails() {
        return this.fConfigurationErrorDetails;
    }

    public List<String> getMandatoryConfigurationErrorDetails() {
        return this.fMandatoryConfigurationErrorDetails;
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.fProperties);
    }

    public void setProperty(String key, String value) {
        if (key != null) {
            this.fProperties.put(key, value);
        }
    }

    public String getProperty(String key) {
        if (key != null) {
            return this.fProperties.get(key);
        }
        return null;
    }

    public boolean hasProperty(String key) {
        if (key != null) {
            return this.fProperties.containsKey(key);
        }
        return false;
    }

    public void setPropertyAppend(String key, String value) {
        if (key != null) {
            this.fPropertiesAppend.put(key, value);
        }
    }

    public String getPropertyAppend(String key) {
        if (key != null) {
            return this.fPropertiesAppend.get(key);
        }
        return null;
    }

    public boolean hasPropertyAppend(String key) {
        if (key != null) {
            return this.fPropertiesAppend.containsKey(key);
        }
        return false;
    }

    public LinkedHashMap<String, OVMComplianceCheckHit> getCheckHitsMap() {
        return this.fCheckHits;
    }

    public void setPreWaiver(String include, String exclude) {
        Set excludes;
        Object excludesObject;
        Set includes;
        Object includesObject = CheckParameterType.CSL_REGEX.parse(include);
        if (includesObject instanceof Set && !(includes = (Set)includesObject).isEmpty()) {
            this.fIncludePreWaiver = new PreWaiver();
            this.fIncludePreWaiver.setType(WaiverType.RULESET);
            this.fIncludePreWaiver.addCheckName(this.getName());
            this.fIncludePreWaiver.setName("Include from " + this.getName() + " check");
            this.fIncludePreWaiver.setApplyOn("not-matched");
            for (Object includedPattern : includes) {
                if (!(includedPattern instanceof Pattern) || ((Pattern)includedPattern).pattern().isEmpty()) continue;
                this.fIncludePreWaiver.addMatchedPrewaivedPath(DVTStringUtil.intern((String)ro.amiq.dvt.utils.Utils.canonicPath((String)((Pattern)includedPattern).pattern())));
            }
        }
        if ((excludesObject = CheckParameterType.CSL_REGEX.parse(exclude)) instanceof Set && !(excludes = (Set)excludesObject).isEmpty()) {
            this.fExcludePreWaiver = new PreWaiver();
            this.fExcludePreWaiver.setType(WaiverType.RULESET);
            this.fExcludePreWaiver.addCheckName(this.getName());
            this.fExcludePreWaiver.setName("Exclude from " + this.getName() + " check");
            for (Object excludedPattern : excludes) {
                if (!(excludedPattern instanceof Pattern) || ((Pattern)excludedPattern).pattern().isEmpty()) continue;
                this.fExcludePreWaiver.addMatchedPrewaivedPath(DVTStringUtil.intern((String)ro.amiq.dvt.utils.Utils.canonicPath((String)((Pattern)excludedPattern).pattern())));
            }
        }
    }

    public PreWaiver getExcludePreWaiver() {
        return this.fExcludePreWaiver;
    }

    public PreWaiver getIncludePreWaiver() {
        return this.fIncludePreWaiver;
    }

    public boolean isAutoCorrectEnabled() {
        return this.fAutoCorrectEnabled;
    }

    public void setAutoCorrectEnabled(boolean autoCorrectEnabled) {
        this.fAutoCorrectEnabled = autoCorrectEnabled;
    }

    public boolean isAutoCorrectSkipSanityChecks() {
        return this.fAutoCorrectSkipSanityChecks;
    }

    public void setAutoCorrectSkipSanityChecks(boolean autoCorrectSkipSanityChecks) {
        this.fAutoCorrectSkipSanityChecks = autoCorrectSkipSanityChecks;
    }

    public void setAutoCorrectInput(String key, String value) {
        if (key != null) {
            this.fAutoCorrectInput.put(key, value);
        }
    }

    public Map<String, String> getAutoCorrectInput() {
        return this.fAutoCorrectInput;
    }

    public String getAutoCorrectValue(String key) {
        if (key != null) {
            return this.fAutoCorrectInput.get(key);
        }
        return null;
    }

    public boolean hasAutoCorrectValue(String key) {
        if (key != null) {
            return this.fAutoCorrectInput.containsKey(key);
        }
        return false;
    }

    public void preBuildNotification(RfProject aRfProject) {
    }

    public void performCheck() {
        this.performCheck(null);
    }

    public void performCheck(Set<ParserPath> modifiedFiles) {
        block13: {
            this.resetResultInfo(modifiedFiles);
            this.fRunTime = 0L;
            if (!this.isEnabled()) {
                return;
            }
            this.fStartTime = System.currentTimeMillis();
            int checkTimeout = this.fOVMProject.getConfiguration().getCheckTimeoutValue();
            if (checkTimeout != 0) {
                this.fTimeout = checkTimeout;
            }
            this.fCheckEndTime = this.fStartTime + (long)(this.fTimeout * 1000);
            StopWatch.reset((String)this.fName);
            StopWatch.start((String)this.fName);
            this.notifyCheckAlive();
            if (!PrecompiledDBUtils.containsPrecompiledInvocation((IProject)this.getIProject())) break block13;
            Set paths = this.fOVMProject.getAllImportedFiles().stream().map(p -> p.path).collect(Collectors.toSet());
            if (!PrecompiledDBUtils.isPrecompiledAllFiles((IProject)this.getIProject(), paths)) break block13;
            this.addHit(new ParserPath(this.getBuildConfigPath()), 0, "Error [id:" + this.getID() + ", name:" + this.getName() + "]: " + "The entire project is precompiled, no file was analyzed!", null, false, CheckStatus.ERROR);
            StopWatch.stop((String)this.fName);
            this.fRunTime = TestHelper.isTestMode() ? StopWatch.timeMillisGCInvariant((String)this.fName) : StopWatch.timeMillis((String)this.fName);
            return;
        }
        try {
            try {
                if ((this.fOVMProject.getNofCompiledLines() == 0 || this.fOVMProject.getAllFilesInOrder().isEmpty()) && (modifiedFiles == null || VerissimoAfterCompilationLauncher.getInstance().projectWasFullBuilt(this.getIProject()))) {
                    this.addHit(new ParserPath(this.getBuildConfigPath()), 0, "Configuration Error [id:" + this.getID() + ", name:" + this.getName() + "]: " + "Zero lines compiled!", null, false, CheckStatus.ERROR);
                } else if (!this.fConfigurationErrorDetails.isEmpty() || !this.fMandatoryConfigurationErrorDetails.isEmpty()) {
                    for (String error : this.fConfigurationErrorDetails) {
                        this.addHit(new ParserPath("none"), 0, "Rule Configuration Error [id:" + this.getID() + ", name:" + this.getName() + "]: " + error, null, false, CheckStatus.ERROR);
                    }
                    for (String error : this.fMandatoryConfigurationErrorDetails) {
                        this.addHit(new ParserPath("none"), 0, "Rule Configuration Error [id:" + this.getID() + ", name:" + this.getName() + "]: " + error, null, false, CheckStatus.ERROR);
                    }
                } else {
                    this.configureBeforeRuleImplementation();
                    this.performCheckImpl();
                }
            }
            catch (BuildCancelException | RfNamedElementVisitorException | LintingCancelledException | LintingTimedOutException throwable) {
                StopWatch.stop((String)this.fName);
                this.fRunTime = TestHelper.isTestMode() ? StopWatch.timeMillisGCInvariant((String)this.fName) : StopWatch.timeMillis((String)this.fName);
                return;
            }
        }
        catch (Throwable throwable) {
            StopWatch.stop((String)this.fName);
            this.fRunTime = TestHelper.isTestMode() ? StopWatch.timeMillisGCInvariant((String)this.fName) : StopWatch.timeMillis((String)this.fName);
            throw throwable;
        }
        StopWatch.stop((String)this.fName);
        this.fRunTime = TestHelper.isTestMode() ? StopWatch.timeMillisGCInvariant((String)this.fName) : StopWatch.timeMillis((String)this.fName);
    }

    protected void configureBeforeRuleImplementation() {
    }

    private String getBuildConfigPath() {
        IPath fullPath;
        String errorPath = "none";
        IFile file = BuildConfigManager.getActiveBuildConfigIFile((IProject)this.fOVMProject.getConfiguration().getProject());
        if (file != null && (fullPath = file.getLocation()) != null) {
            errorPath = fullPath.toOSString();
        }
        return errorPath;
    }

    public abstract void performCheckImpl();

    @Override
    public void notifyCheckAlive() {
        if (this.shouldSkipCheckAlive) {
            return;
        }
        this.fOVMProject.notifyCheckAlive();
        this.fOVMProject.hasTimedout(this);
        this.fOVMProject.hasExceededMemory(this);
        if (!DVTSplashMLT.INSTANCE.cc(new String[]{"F73765F6C696E74"})) {
            this.fOVMProject.getLintMonitor().setCanceled(true);
            throw new LintingCancelledException();
        }
        this.shouldSkipCheckAlive = true;
        this.fOVMProject.getCheckAliveDebouncer().schedule(new TimerTask(){

            @Override
            public void run() {
                OVMComplianceCheck.this.shouldSkipCheckAlive = false;
            }
        }, 1000L);
    }

    public Map<String, List<String>> getAnnotationsByTagIdMap() {
        return this.fAnnotationsByTagIdMap;
    }

    public void setAnnotationsByTagIdMap(Map<String, List<String>> annotationsByTagIdMap) {
        this.fAnnotationsByTagIdMap = annotationsByTagIdMap;
    }

    public String getID() {
        CheckID annot = this.getClass().getAnnotation(CheckID.class);
        if (annot != null) {
            return annot.value();
        }
        return null;
    }

    public String getDefaultName() {
        CheckName annot = this.getClass().getAnnotation(CheckName.class);
        if (annot != null) {
            return annot.value();
        }
        return null;
    }

    public String getDefaultDescription() {
        CheckDescription annot = this.getClass().getAnnotation(CheckDescription.class);
        if (annot != null) {
            return annot.value();
        }
        return null;
    }

    public String getDefaultTitle() {
        CheckTitle annot = this.getClass().getAnnotation(CheckTitle.class);
        if (annot != null) {
            return annot.value();
        }
        return null;
    }

    public String getDefaultDate(Map<String, String> versionsMap) {
        CheckVersion annot = this.getClass().getAnnotation(CheckVersion.class);
        if (annot != null) {
            return versionsMap.get(annot.value());
        }
        return null;
    }

    public String getDefaultVersion() {
        CheckVersion annot = this.getClass().getAnnotation(CheckVersion.class);
        if (annot != null) {
            return annot.value();
        }
        return null;
    }

    public Set<RuleLabel> getDefaultLabels() {
        CheckLabel annot = this.getClass().getAnnotation(CheckLabel.class);
        if (annot != null) {
            RuleLabel[] labels = annot.labels();
            if (labels == null) {
                return null;
            }
            return new LinkedHashSet<RuleLabel>(Arrays.asList(labels));
        }
        return null;
    }

    public boolean isAutocorrectable() {
        CheckAutofix annot = this.getClass().getAnnotation(CheckAutofix.class);
        return annot != null;
    }

    public boolean isApplicableAfterIncremental() {
        CheckReapplyDisable annot = this.getClass().getAnnotation(CheckReapplyDisable.class);
        return annot == null;
    }

    protected List<CheckParameterOverride> getOverridenParameters() {
        Class<?> currentClass = this.getClass();
        List<CheckParameterOverride> overridenParameters = Arrays.asList((CheckParameterOverride[])currentClass.getAnnotationsByType(CheckParameterOverride.class));
        return overridenParameters;
    }

    public Map<String, CheckParameter> getAllParameters() {
        Class<?> currentClass = this.getClass();
        HashMap<String, CheckParameter> allParameters = new HashMap<String, CheckParameter>();
        while (currentClass != OVMComplianceCheck.class) {
            Field[] fields;
            Field[] fieldArray = fields = currentClass.getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                CheckParameter annot = field.getAnnotation(CheckParameter.class);
                if (annot != null) {
                    allParameters.put(annot.name(), annot);
                }
                ++n2;
            }
            currentClass = currentClass.getSuperclass();
        }
        return allParameters;
    }

    public Map<String, AutofixParameter> getAllAutocorrectParameters() {
        Field[] fields;
        HashMap<String, AutofixParameter> allParameters = new HashMap<String, AutofixParameter>();
        VerissimoAutofix autofix = VerissimoAutofixFactory.INSTANCE.createAutofix(this, new ArrayList<OVMComplianceCheckHit>(), true);
        if (!(autofix instanceof UserInputAutofix)) {
            return allParameters;
        }
        Class<?> currentClass = autofix.getClass();
        Field[] fieldArray = fields = currentClass.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            AutofixParameter annot = field.getAnnotation(AutofixParameter.class);
            if (annot != null) {
                allParameters.put(annot.name(), annot);
            }
            ++n2;
        }
        return allParameters;
    }

    public Map<String, Object> getRulesetInfo() {
        HashMap<String, Object> infoFromRuleset = new HashMap<String, Object>();
        String xvmPattern = "[oO][vV][mM]|[uU][vV][mM]|XVM";
        String xvmName = this.fName.replaceAll(xvmPattern, "xvm");
        String xvmTitle = this.fTitle.replaceAll(xvmPattern, "xvm");
        String xvmDescription = this.fDescription.replaceAll(xvmPattern, "xvm");
        String xvmDefaultName = this.getDefaultName().replaceAll(xvmPattern, "xvm");
        String xvmDefaultTitle = this.getDefaultTitle().replaceAll(xvmPattern, "xvm");
        String xvmDefaultDescription = this.getDefaultDescription().replaceAll(xvmPattern, "xvm");
        infoFromRuleset.put("hasName", xvmName.equals(xvmDefaultName) ? "false" : "true");
        infoFromRuleset.put("hasTitle", xvmTitle.equals(xvmDefaultTitle) ? "false" : "");
        infoFromRuleset.put("hasDescription", xvmDescription.equals(xvmDefaultDescription) ? "false" : "true");
        infoFromRuleset.put("hasSeverity", this.fSeverity == null || this.fSeverity.equals((Object)this.getDefaultSeverity()) ? "false" : "true");
        infoFromRuleset.put("isAutoCorrectEnabled", this.fAutoCorrectEnabled ? "true" : "false");
        if (this instanceof AbstractCompilationErrorCheck && infoFromRuleset.get("hasSeverity").equals("false")) {
            infoFromRuleset.put("hasSeverity", "null");
        }
        Map<String, String> checkProperties = this.getProperties();
        ArrayList propertyList = new ArrayList();
        Map<String, CheckParameter> allParameters = this.getAllParameters();
        for (Map.Entry<String, String> prop : checkProperties.entrySet()) {
            HashMap<String, String> tempMap = new HashMap<String, String>();
            tempMap.put("name", prop.getKey());
            tempMap.put("value", prop.getValue());
            CheckParameter parameter = allParameters.get(prop.getKey());
            if (parameter == null) continue;
            String description = parameter.description() != null ? parameter.description() : "";
            String required = parameter.required() == CheckParameterRequired.OPTIONAL ? "optional" : "mandatory";
            description = String.valueOf(parameter.name()) + " : [" + required + "] " + description;
            tempMap.put("description", description);
            propertyList.add(tempMap);
        }
        infoFromRuleset.put("properties", propertyList);
        Map<String, String> autoCorrectInput = this.getAutoCorrectInput();
        ArrayList autocorrectInputList = new ArrayList();
        Map<String, AutofixParameter> allAutocorrectParameters = this.getAllAutocorrectParameters();
        for (Map.Entry<String, String> input : autoCorrectInput.entrySet()) {
            HashMap<String, String> tempMap = new HashMap<String, String>();
            tempMap.put("name", input.getKey());
            tempMap.put("value", input.getValue());
            AutofixParameter parameter = allAutocorrectParameters.get(input.getKey());
            if (parameter == null) continue;
            String description = parameter.description() != null ? parameter.description() : "";
            description = String.valueOf(parameter.name()) + " : " + description;
            tempMap.put("description", description);
            autocorrectInputList.add(tempMap);
        }
        infoFromRuleset.put("autocorrectInputs", autocorrectInputList);
        return infoFromRuleset;
    }

    public List<Object> createParameters() {
        Class<?> currentClass = this.getClass();
        List<CheckParameterOverride> overridenParameters = Arrays.asList((CheckParameterOverride[])currentClass.getAnnotationsByType(CheckParameterOverride.class));
        Map<String, CheckParameter> allParameters = this.getAllParameters();
        ArrayList<Object> allParametersList = new ArrayList<Object>();
        TreeSet<String> keys = new TreeSet<String>(allParameters.keySet());
        for (String key : keys) {
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            CheckParameter parameter = allParameters.get(key);
            boolean isVisible = parameter.isVisible();
            String defaultValue = parameter.defaultValue() != null ? parameter.defaultValue() : "";
            String description = parameter.description() != null ? parameter.description() : "";
            for (CheckParameterOverride oParam : overridenParameters) {
                if (parameter.name().equals(oParam.name()) && oParam.isVisible()) {
                    String string = defaultValue = oParam.defaultValue().equals("<<<DVT_INHERITED_PARAMETER_DEFAULT_VALUE>>>") ? parameter.defaultValue() : oParam.defaultValue();
                    if (oParam.description() != null && !oParam.description().isEmpty()) {
                        description = oParam.description().equals("<<<DVT_INHERITED_PARAMETER_DESCRIPTION>>>") ? parameter.description() : oParam.description();
                    }
                    isVisible = true;
                    break;
                }
                if (!parameter.name().equals(oParam.name()) || oParam.isVisible()) continue;
                isVisible = false;
                break;
            }
            if (!isVisible) continue;
            String required = parameter.required() == CheckParameterRequired.OPTIONAL ? "optional" : "mandatory";
            description = String.valueOf(parameter.name()) + " : [" + required + "] " + description;
            parameterMap.put("name", parameter.name());
            parameterMap.put("defaultValue", defaultValue);
            parameterMap.put("description", description);
            parameterMap.put("type", parameter.type().toString());
            parameterMap.put("required", required);
            parameterMap.put("rulesetOverriden", this.fProperties.containsKey(parameter.name()) || this.fPropertiesAppend.containsKey(parameter.name()) ? "true" : "false");
            if ("true".equals(parameterMap.get("rulesetOverriden"))) {
                parameterMap.put("userValue", this.getParameterUserValue(parameter.type(), defaultValue, parameter.name()));
            }
            allParametersList.add(parameterMap);
        }
        return allParametersList;
    }

    private String getParameterUserValue(CheckParameterType parameterType, String defaultValue, String parameterName) {
        if (this.hasPropertyAppend(parameterName)) {
            return this.getPropertyAppend(parameterType, defaultValue, parameterName);
        }
        return this.getProperty(parameterName);
    }

    private String getPropertyAppend(CheckParameterType parameterType, String defaultValue, String parameterName) {
        if (parameterType == CheckParameterType.CSL_REGEX || parameterType == CheckParameterType.CSL_STRING) {
            if (defaultValue != null && !defaultValue.isEmpty()) {
                String propertyAppend = this.getPropertyAppend(parameterName);
                if (!propertyAppend.isEmpty()) {
                    return defaultValue.concat(", " + this.getPropertyAppend(parameterName));
                }
                return defaultValue;
            }
            return this.getPropertyAppend(parameterName);
        }
        return this.getPropertyAppend(parameterName);
    }

    public List<Object> createAutocorrectParameters() {
        ArrayList<Object> allAutocorrectParametersList = new ArrayList<Object>();
        if (!this.isAutocorrectable()) {
            return allAutocorrectParametersList;
        }
        VerissimoAutofix autofix = VerissimoAutofixFactory.INSTANCE.createAutofix(this, new ArrayList<OVMComplianceCheckHit>(), true);
        if (!(autofix instanceof UserInputAutofix)) {
            return allAutocorrectParametersList;
        }
        Class<?> currentClass = autofix.getClass();
        Field[] fieldArray = currentClass.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            AutofixParameter autofixParameter = field.getAnnotation(AutofixParameter.class);
            if (autofixParameter != null) {
                HashMap<String, String> parameterMap = new HashMap<String, String>();
                String defaultValue = autofixParameter.defaultValue() != null ? autofixParameter.defaultValue() : "";
                String description = autofixParameter.description() != null ? autofixParameter.description() : "";
                description = String.valueOf(autofixParameter.name()) + " : " + description;
                parameterMap.put("name", autofixParameter.name());
                parameterMap.put("defaultValue", defaultValue);
                parameterMap.put("description", description);
                parameterMap.put("type", autofixParameter.type().toString());
                parameterMap.put("rulesetOverriden", this.fAutoCorrectInput.containsKey(autofixParameter.name()) ? "true" : "false");
                if ("true".equals(parameterMap.get("rulesetOverriden"))) {
                    parameterMap.put("userValue", this.getAutoCorrectValue(autofixParameter.name()));
                }
                allAutocorrectParametersList.add(parameterMap);
            }
            ++n2;
        }
        return allAutocorrectParametersList;
    }

    public List<Map<String, String>> getParametersToDisplay() {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        List<CheckParameterOverride> overridenParameters = this.getOverridenParameters();
        Map<String, CheckParameter> allParameters = this.getAllParameters();
        TreeSet<String> keys = new TreeSet<String>(allParameters.keySet());
        for (String key : keys) {
            CheckParameter parameter = allParameters.get(key);
            boolean isVisible = parameter.isVisible();
            String defaultValue = "";
            String description = "";
            for (CheckParameterOverride oParam : overridenParameters) {
                if (!parameter.name().equals(oParam.name())) continue;
                isVisible = oParam.isVisible();
                if (!isVisible) break;
                String string = defaultValue = oParam.defaultValue().equals("<<<DVT_INHERITED_PARAMETER_DEFAULT_VALUE>>>") ? parameter.defaultValue() : oParam.defaultValue();
                if (oParam.description() == null || oParam.description().isEmpty()) break;
                description = oParam.description().equals("<<<DVT_INHERITED_PARAMETER_DESCRIPTION>>>") ? parameter.description() : oParam.description();
                break;
            }
            if (!isVisible) continue;
            if (defaultValue.isEmpty()) {
                defaultValue = parameter.defaultValue();
            }
            if (description.isEmpty()) {
                description = parameter.description();
            }
            HashMap<String, String> parameterProperties = new HashMap<String, String>();
            parameterProperties.put("name", parameter.name());
            parameterProperties.put("defaultValue", defaultValue);
            parameterProperties.put("description", description);
            parameterProperties.put("required", parameter.required().name());
            parameterProperties.put("type", parameter.type().name());
            parameterProperties.put("userValue", this.getParameterUserValue(parameter.type(), defaultValue, parameter.name()));
            result.add(parameterProperties);
        }
        return result;
    }

    public List<Map<String, String>> getAutocorrectParametersToDisplay() {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        if (!this.isAutocorrectable()) {
            return result;
        }
        VerissimoAutofix autofix = VerissimoAutofixFactory.INSTANCE.createAutofix(this, new ArrayList<OVMComplianceCheckHit>(), true);
        if (!(autofix instanceof UserInputAutofix)) {
            return result;
        }
        Class<?> currentClass = autofix.getClass();
        Field[] fieldArray = currentClass.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            AutofixParameter annot = field.getAnnotation(AutofixParameter.class);
            if (annot != null) {
                HashMap<String, String> parameterProperties = new HashMap<String, String>();
                parameterProperties.put("name", annot.name());
                parameterProperties.put("defaultValue", annot.defaultValue());
                parameterProperties.put("description", annot.description());
                parameterProperties.put("type", annot.type().name());
                result.add(parameterProperties);
            }
            ++n2;
        }
        return result;
    }

    public String getCheckDescriptionToPrint() {
        String checkParametersDescription = this.getParametersDescription(ParametersDescriptionParser.RULESET_DOC);
        String autocorrectParametersDescription = this.getAutocorrectParametersDescription(ParametersDescriptionParser.RULESET_DOC);
        String parametersDescription = "";
        if (checkParametersDescription != null && !checkParametersDescription.isEmpty()) {
            parametersDescription = String.valueOf(parametersDescription) + "\n\nParameters:\n" + checkParametersDescription;
        }
        if (autocorrectParametersDescription != null && !autocorrectParametersDescription.isEmpty()) {
            if (!parametersDescription.endsWith("\n")) {
                parametersDescription = String.valueOf(parametersDescription) + "\n";
            }
            parametersDescription = String.valueOf(parametersDescription) + "\nAutocorrect parameters:\n" + autocorrectParametersDescription;
        }
        if (this.getLabels() != null && !this.getLabels().isEmpty()) {
            String labelsText = this.getLabels().stream().map(RuleLabel::getValue).collect(Collectors.joining(", "));
            parametersDescription = String.valueOf(parametersDescription) + "\nLabels:\n" + labelsText + "\n";
        }
        return String.valueOf(HTMLUtils.stripTags(this.getFullDescription())) + parametersDescription;
    }

    public String getParametersDescription(ParametersDescriptionParser parametersDescriptionParser) {
        StringBuilder result = new StringBuilder();
        List<Map<String, String>> parametersToDisplay = this.getParametersToDisplay();
        for (Map<String, String> parameterValues : parametersToDisplay) {
            String name = parameterValues.get("name");
            String defaultValue = parameterValues.get("defaultValue");
            String userValue = parameterValues.get("userValue");
            String description = parameterValues.get("description");
            String required = parameterValues.get("required");
            if (parametersDescriptionParser == ParametersDescriptionParser.RULEPOOL_DOC) {
                result.append(this.parseParametersDescriptionForRulepoolDoc(name, defaultValue, description, required.equals("OPTIONAL")));
                continue;
            }
            if (parametersDescriptionParser == ParametersDescriptionParser.RULESET_DOC) {
                result.append(this.parseParametersDescriptionForRulesetDoc(name, defaultValue, userValue, description, required.equals("OPTIONAL")));
                continue;
            }
            if (parametersDescriptionParser == ParametersDescriptionParser.RULEPOOL_XML) {
                result.append(this.parseParametersDescriptionForRulepoolXML(name, defaultValue, description, required.equals("OPTIONAL")));
                continue;
            }
            if (parametersDescriptionParser != ParametersDescriptionParser.RULESET_XML) continue;
            result.append(this.parseParametersDescriptionForRulepoolXML(name, defaultValue, description, required.equals("OPTIONAL")));
        }
        if (parametersDescriptionParser == ParametersDescriptionParser.RULEPOOL_XML || parametersDescriptionParser == ParametersDescriptionParser.RULESET_XML) {
            return result.toString().trim();
        }
        return result.toString();
    }

    protected String parseParametersDescriptionForRulepoolDoc(String parameterName, String defaultValue, String description, boolean isOptional) {
        StringBuilder result = new StringBuilder();
        if (isOptional) {
            result.append(" : [optional] " + description);
        } else {
            result.append(" : [mandatory] " + description + "\n");
        }
        if (!isOptional) {
            return String.valueOf(parameterName) + result.toString().replace("xvm", this.fLibraryKind).replace("XVM", this.fLibraryKind.toUpperCase());
        }
        if (!defaultValue.isEmpty()) {
            result.append(" Default value: " + defaultValue + ".\n");
        } else {
            result.append(" No default value.\n");
        }
        return String.valueOf(parameterName) + result.toString().replace("xvm", this.fLibraryKind).replace("XVM", this.fLibraryKind.toUpperCase());
    }

    protected String parseParametersDescriptionForRulesetDoc(String parameterName, String defaultValue, String description, boolean isOptional) {
        return this.parseParametersDescriptionForRulesetDoc(parameterName, defaultValue, null, description, isOptional);
    }

    protected String parseParametersDescriptionForRulesetDoc(String parameterName, String defaultValue, String userValue, String description, boolean isOptional) {
        StringBuilder result = new StringBuilder();
        if (isOptional) {
            result.append(" : [optional] " + description);
        } else {
            result.append(" : [mandatory] " + description);
        }
        if (!defaultValue.isEmpty()) {
            result.append(" Default value: " + defaultValue + ".");
        } else {
            result.append(" No default value.");
        }
        if (userValue != null) {
            result.append(" User value: " + userValue + ".");
        } else {
            String propertyValue = this.getProperty(parameterName);
            if (propertyValue != null) {
                result.append(" User value: " + propertyValue + ".");
            }
        }
        result.append('\n');
        return String.valueOf(parameterName) + result.toString().replace("xvm", this.fLibraryKind).replace("XVM", this.fLibraryKind.toUpperCase());
    }

    protected String parseParametersDescriptionForRulepoolXML(String parameterName, String defaultValue, String description, boolean isOptional) {
        StringBuilder result = new StringBuilder();
        if (isOptional) {
            result.append("\t\t<!-- " + parameterName + " : " + "[optional] " + description + " -->\n");
        } else {
            result.append("\t\t<!-- " + parameterName + " : " + "[mandatory] " + description + " -->\n");
        }
        result.append("\t\t<!-- <property key=\"" + parameterName + "\" value=\"" + DVTStringUtil.escapeXMLString((String)defaultValue, (boolean)false) + "\" /> -->\n\n");
        return result.toString().replace("xvm", this.fLibraryKind).replace("XVM", this.fLibraryKind.toUpperCase());
    }

    public String getAutocorrectParametersDescription(ParametersDescriptionParser parametersDescriptionParser) {
        StringBuilder result = new StringBuilder();
        List<Map<String, String>> parametersToDisplay = this.getAutocorrectParametersToDisplay();
        for (Map<String, String> parameterValues : parametersToDisplay) {
            String name = parameterValues.get("name");
            String defaultValue = parameterValues.get("defaultValue");
            String description = parameterValues.get("description");
            if (parametersDescriptionParser == ParametersDescriptionParser.RULEPOOL_DOC) {
                result.append(this.parseAutofixParametersDescriptionForRulepoolDoc(name, defaultValue, description));
                continue;
            }
            if (parametersDescriptionParser == ParametersDescriptionParser.RULESET_DOC) {
                result.append(this.parseAutofixParametersDescriptionForRulesetDoc(name, defaultValue, description));
                continue;
            }
            if (parametersDescriptionParser == ParametersDescriptionParser.RULEPOOL_XML) {
                result.append(this.parseAutofixParametersDescriptionForRulepoolXML(name, defaultValue, description));
                continue;
            }
            if (parametersDescriptionParser != ParametersDescriptionParser.RULESET_XML) continue;
            result.append(this.parseAutofixParametersDescriptionForRulepoolXML(name, defaultValue, description));
        }
        if (parametersDescriptionParser == ParametersDescriptionParser.RULEPOOL_XML || parametersDescriptionParser == ParametersDescriptionParser.RULESET_XML) {
            return result.toString().trim();
        }
        return result.toString();
    }

    protected String parseAutofixParametersDescriptionForRulepoolDoc(String parameterName, String defaultValue, String description) {
        StringBuilder result = new StringBuilder();
        result.append(" : " + description);
        if (!defaultValue.isEmpty()) {
            result.append(" Default value: " + defaultValue + ".\n");
        } else {
            result.append(" No default value.\n");
        }
        return String.valueOf(parameterName) + result.toString().replace("xvm", this.fLibraryKind).replace("XVM", this.fLibraryKind.toUpperCase());
    }

    protected String parseAutofixParametersDescriptionForRulesetDoc(String parameterName, String defaultValue, String description) {
        StringBuilder result = new StringBuilder();
        result.append(" : " + description);
        if (!defaultValue.isEmpty()) {
            result.append(" Default value: " + defaultValue + ".");
        } else {
            result.append(" No default value.");
        }
        String propertyValue = this.getAutoCorrectValue(parameterName);
        if (propertyValue != null) {
            result.append(" User value: " + propertyValue + ".");
        }
        result.append('\n');
        return String.valueOf(parameterName) + result.toString().replace("xvm", this.fLibraryKind).replace("XVM", this.fLibraryKind.toUpperCase());
    }

    protected String parseAutofixParametersDescriptionForRulepoolXML(String parameterName, String defaultValue, String description) {
        StringBuilder result = new StringBuilder();
        result.append("\t\t<!-- " + parameterName + " : " + " " + description + " -->\n");
        result.append("\t\t<!-- <autocorrect-input key=\"" + parameterName + "\" value=\"" + DVTStringUtil.escapeXMLString((String)defaultValue, (boolean)false) + "\" /> -->\n\n");
        return result.toString().replace("xvm", this.fLibraryKind).replace("XVM", this.fLibraryKind.toUpperCase());
    }

    public void configure() {
        Class<?> currentClass = this.getClass();
        List<CheckParameterOverride> overridenParameters = Arrays.asList((CheckParameterOverride[])currentClass.getAnnotationsByType(CheckParameterOverride.class));
        while (currentClass != OVMComplianceCheck.class) {
            Field[] fields;
            Field[] fieldArray = fields = currentClass.getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                block22: {
                    Field field = fieldArray[n2];
                    CheckParameter annot = field.getAnnotation(CheckParameter.class);
                    if (annot != null) {
                        CheckParameterRequired required;
                        String propertyName = annot.name();
                        String defaultValue = annot.defaultValue();
                        CheckParameterType propertyType = annot.type();
                        String propertyValue = this.getProperty(propertyName);
                        if (!propertyType.isCompatibleWith(field.getGenericType().getTypeName())) {
                            DVTLogger.INSTANCE.logError("Verissimo check '" + this.getID() + "' contains an incompatible filed - parameter combination '" + field.getDeclaringClass().getCanonicalName() + "," + field.getName() + "' of type '" + field.getGenericType().toString() + "' - '" + propertyType.name() + "'!");
                        }
                        if (this.hasPropertyAppend(propertyName)) {
                            propertyValue = this.getPropertyAppend(propertyType, defaultValue, propertyName);
                        }
                        if (propertyValue == null && overridenParameters != null && !overridenParameters.isEmpty()) {
                            for (CheckParameterOverride oParam : overridenParameters) {
                                if (!oParam.name().equals(propertyName)) continue;
                                if (oParam.defaultValue().equals("<<<DVT_INHERITED_PARAMETER_DEFAULT_VALUE>>>")) break;
                                propertyValue = oParam.defaultValue();
                                break;
                            }
                        }
                        if ((required = annot.required()) == CheckParameterRequired.MANDATORY && propertyValue == null) {
                            this.fMandatoryConfigurationErrorDetails.add("Mandatory parameter '" + propertyName + "' not specified!");
                            this.fConfigurationError = true;
                        } else {
                            if (propertyValue == null) {
                                propertyValue = annot.defaultValue();
                            }
                            propertyValue = propertyValue.replace("xvm", this.fLibraryKind).replace("XVM", this.fLibraryKind.toUpperCase());
                            propertyValue = propertyValue.replace("ovm_tlm_", "tlm_");
                            Object parsedValue = null;
                            try {
                                parsedValue = propertyType.parse(propertyValue);
                            }
                            catch (NumberFormatException numberFormatException) {
                                if (propertyType == CheckParameterType.BOOLEAN) {
                                    this.fConfigurationErrorDetails.add("Parameter '" + propertyName + "' is an invalid boolean!");
                                    this.fConfigurationError = true;
                                } else {
                                    this.fConfigurationErrorDetails.add("Parameter '" + propertyName + "' is an invalid integer!");
                                    this.fConfigurationError = true;
                                }
                                break block22;
                            }
                            catch (PatternSyntaxException patternSyntaxException) {
                                if (propertyType == CheckParameterType.REGEX) {
                                    this.fConfigurationErrorDetails.add("Parameter '" + propertyName + "' is an invalid pattern!");
                                    this.fConfigurationError = true;
                                } else {
                                    this.fConfigurationErrorDetails.add("Parameter '" + propertyName + "' contains an invalid pattern!");
                                    this.fConfigurationError = true;
                                }
                                break block22;
                            }
                            if (parsedValue != null) {
                                try {
                                    field.setAccessible(true);
                                    field.set(this, parsedValue);
                                }
                                catch (IllegalAccessException | IllegalArgumentException e) {
                                    this.fConfigurationErrorDetails.add("Internal error while reading the value of '" + propertyName + "' parameter!");
                                    this.fConfigurationError = true;
                                    DVTLogger.INSTANCE.logError((Throwable)e);
                                }
                            }
                        }
                    }
                }
                ++n2;
            }
            currentClass = currentClass.getSuperclass();
        }
        List<CheckAutofix> autofixAnnotations = Arrays.asList((CheckAutofix[])this.getClass().getAnnotationsByType(CheckAutofix.class));
        if (autofixAnnotations.isEmpty()) {
            return;
        }
        VerissimoAutofix autofix = VerissimoAutofixFactory.INSTANCE.createAutofix(this, new ArrayList<OVMComplianceCheckHit>(), true);
        if (autofix == null) {
            return;
        }
    }

    public ArrayList<OVMComplianceCheckHit> getVisibleHits() {
        return this.getVisibleHits(null, null);
    }

    public ArrayList<OVMComplianceCheckHit> getVisibleHits(EnumMap<CheckStatus, Boolean> filters, RuleLabel labelFilter) {
        if (this.fVisibleHits != null) {
            return this.fVisibleHits;
        }
        this.fVisibleHits = new ArrayList();
        if (!OVMComplianceChecksUtil.applyLabelFiltersOnCheck(labelFilter, this)) {
            return this.fVisibleHits;
        }
        for (OVMComplianceCheckHit hit : this.fCheckHits.values()) {
            if (hit.isHidden() || this.fOVMProject.isChangesHidden(hit) || !OVMComplianceChecksUtil.applyFiltersOnCheck(filters, OVMComplianceChecksUtil.getStatus(hit))) continue;
            this.fVisibleHits.add(hit);
        }
        Collections.sort(this.fVisibleHits, new OVMComplianceCheckComparator());
        return this.fVisibleHits;
    }

    public ArrayList<OVMComplianceCheckHit> getAllHitsForRReport(boolean isChangesReport) {
        this.checkIfTimedout();
        this.checkExceededMemory();
        ArrayList<OVMComplianceCheckHit> resultCandidate = new ArrayList<OVMComplianceCheckHit>(this.fCheckHits.values());
        resultCandidate = new ArrayList(resultCandidate.stream().filter(hit -> !isChangesReport || hit.getCompareAnnotations() == null || !hit.getCompareAnnotations().contains("Common")).collect(Collectors.toList()));
        Collections.sort(resultCandidate, new OVMComplianceCheckComparator());
        return resultCandidate;
    }

    public ArrayList<OVMComplianceCheckHit> getAllAutoCorrectabledHits() {
        this.checkIfTimedout();
        this.checkExceededMemory();
        ArrayList<OVMComplianceCheckHit> resultCandidate = new ArrayList<OVMComplianceCheckHit>();
        Collection<OVMComplianceCheckHit> allHits = this.fCheckHits.values();
        if (allHits == null) {
            return resultCandidate;
        }
        for (OVMComplianceCheckHit hit : allHits) {
            if (hit.getSeverity() == CheckStatus.DISABLED || this.fOVMProject.isChangesHidden(hit)) continue;
            resultCandidate.add(hit);
        }
        Collections.sort(resultCandidate, new OVMComplianceCheckComparator());
        return resultCandidate;
    }

    public String getAutofixDisplayString(OVMComplianceCheckHit hit) {
        String additionalInfoForDisplayString = this.getAdditionalInfoForDisplayString(hit);
        if (additionalInfoForDisplayString == null || additionalInfoForDisplayString.isEmpty()) {
            return "Fix " + this.getName() + " failure";
        }
        return "Fix " + this.getName() + " failure - " + additionalInfoForDisplayString;
    }

    public String getAdditionalInfoForDisplayString(OVMComplianceCheckHit hit) {
        return "";
    }

    public CheckStatus getStatus() {
        if (this.fStatus == null) {
            this.fStatus = OVMComplianceChecksUtil.getStatus(this);
        }
        return this.fStatus;
    }

    protected void resetResultInfo() {
        this.resetResultInfo(null);
    }

    protected void resetResultInfo(Set<ParserPath> modifiedFiles) {
        this.clearVisibleHits();
        if (this.fCheckHits != null) {
            if (modifiedFiles == null || !this.isApplicableAfterIncremental()) {
                this.fCheckHits.clear();
            } else {
                Iterator<Map.Entry<String, OVMComplianceCheckHit>> iterator = this.fCheckHits.entrySet().iterator();
                while (iterator.hasNext()) {
                    List<OVMComplianceHit.DetailsLink> links;
                    boolean removeHit = false;
                    OVMComplianceCheckHit hit = iterator.next().getValue();
                    if (modifiedFiles.contains(hit.getParserPath())) {
                        removeHit = true;
                    }
                    if ((links = hit.getDetailsLinks()) != null && !links.isEmpty()) {
                        for (OVMComplianceHit.DetailsLink link : links) {
                            for (ParserPath file : modifiedFiles) {
                                if (!file.path.equals(link.file)) continue;
                                modifiedFiles.add(file);
                                removeHit = true;
                            }
                        }
                    }
                    if (!removeHit) continue;
                    iterator.remove();
                }
            }
        }
    }

    private void checkIfTimedout() {
        if (this.fTimedoutProcess) {
            this.resetResultInfo();
            this.addHit(new ParserPath("none"), 0, "Process timeout has been exceeded, check was not executed!", null, false, CheckStatus.ERROR);
        }
        if (this.fTimedoutSession) {
            this.resetResultInfo();
            this.addHit(new ParserPath("none"), 0, "Session timeout has been exceeded, check was not executed!", null, false, CheckStatus.ERROR);
        }
        if (this.fTimedoutCheck) {
            this.resetResultInfo();
            this.addHit(new ParserPath("none"), 0, "Check timeout has been exceeded!", null, false, CheckStatus.ERROR);
        }
    }

    private void checkExceededMemory() {
        if (this.fMemoryMonitorError) {
            this.resetResultInfo();
            this.addHit(new ParserPath("none"), 0, "Memory limit has been exceeded, check was not executed!", null, false, CheckStatus.ERROR);
        }
    }

    public int getNofHits() {
        this.checkIfTimedout();
        this.checkExceededMemory();
        return this.fCheckHits.size();
    }

    public int getNofVisibleHits() {
        this.checkIfTimedout();
        this.checkExceededMemory();
        return this.getVisibleHits().size();
    }

    public int getNofWaivedHits() {
        this.checkIfTimedout();
        this.checkExceededMemory();
        int nOfWaivedHits = 0;
        for (Map.Entry<String, OVMComplianceCheckHit> pair : this.fCheckHits.entrySet()) {
            OVMComplianceCheckHit hit = pair.getValue();
            if (hit.getSeverity() != CheckStatus.DISABLED || hit.isHidden() || this.fOVMProject.isChangesHidden(hit)) continue;
            ++nOfWaivedHits;
        }
        return nOfWaivedHits;
    }

    public void reapplyWaivers() {
        Boolean isDisabled = this.fOVMProject.getProjectWaivers().isDisabled(this);
        if (isDisabled != null && isDisabled.booleanValue()) {
            this.resetResultInfo();
            this.setWaiverEnabled(true);
        } else {
            if (this.fCheckHits != null) {
                for (OVMComplianceCheckHit hit : this.fCheckHits.values()) {
                    WaiverStatus status = this.fOVMProject.getProjectWaivers().getStatus(hit);
                    if ((status == null || status.equals((Object)WaiverStatus.NONE)) && this.getSeverity() != null) {
                        hit.setSeverity(this.getSeverity());
                        continue;
                    }
                    if (status == WaiverStatus.DISABLE) {
                        hit.setSeverity(CheckStatus.DISABLED);
                        continue;
                    }
                    if (status == WaiverStatus.ERROR) {
                        hit.setSeverity(CheckStatus.ERROR);
                        continue;
                    }
                    if (status == WaiverStatus.WARNING) {
                        hit.setSeverity(CheckStatus.WARNING);
                        continue;
                    }
                    if (status != WaiverStatus.INFO) continue;
                    hit.setSeverity(CheckStatus.INFO);
                }
            }
            this.setWaiverEnabled(false);
        }
    }

    @Deprecated
    protected void addPassedHit(RfNamedElement elem, String string) {
    }

    @Deprecated
    protected void addPassedHit(ParserPath parserPath, int lineNumber, String string, ReparseInfo reparseInfo) {
    }

    @Deprecated
    protected void addPassedHit(ParserPath parserPath, RfHid hid, String string) {
    }

    protected OVMComplianceHit addHit(RfNamedElement elm, String details) {
        return this.addHit(elm, details, false);
    }

    protected OVMComplianceHit addHit(RfNamedElement elm, String details, VerissimoAutofixAdditionalInfo autofixAdditionalInfo) {
        return this.addHit(elm, details, false, autofixAdditionalInfo);
    }

    protected OVMComplianceHit addHit(VlogMacroInfo elm, String details) {
        if (elm == null) {
            return this.addHit((RfNamedElement)elm, details, false);
        }
        VlogFileInstance fileInstance = elm.getFileInstance();
        if (fileInstance == null) {
            return null;
        }
        ParserPath parserPath = fileInstance.getParserPath();
        if (parserPath == null) {
            return null;
        }
        int line = elm.getLine();
        return this.addHit(parserPath, line, details, null);
    }

    private OVMComplianceHit addHit(RfNamedElement elm, String details, boolean force) {
        return this.addHit(elm, details, force, null);
    }

    private OVMComplianceHit addHit(RfNamedElement elm, String details, boolean force, VerissimoAutofixAdditionalInfo autofixAdditionalInfo) {
        if (elm == null) {
            return this.addHit(new ParserPath("none"), 0, details, null, force, autofixAdditionalInfo);
        }
        if (elm.getFile() != null && elm.getDeclaration() != null) {
            return this.addHit(elm.getFile().getParserPath(), elm.getLine(), details, elm.getDeclaration().getReparseInfo(), force, autofixAdditionalInfo);
        }
        return null;
    }

    protected List<OVMComplianceHit> addHit(ParserPath parserPath, RfHid hid, String message) {
        ArrayList<OVMComplianceHit> result = new ArrayList<OVMComplianceHit>();
        HidOccurrence hidOccurrence = hid.getOccurrence();
        if (hidOccurrence != null) {
            result.add(this.addHit(parserPath, hidOccurrence, message));
        }
        return result;
    }

    protected List<OVMComplianceHit> addHit(ParserPath parserPath, HidOperator hidOperator, long qualifierSet, String message) {
        ArrayList<OVMComplianceHit> result = new ArrayList<OVMComplianceHit>();
        HidOperatorOccurrence hidOccurrence = hidOperator.getOccurrence();
        if (hidOccurrence != null && hidOccurrence.hasQualifier(qualifierSet)) {
            result.add(this.addHit(parserPath, (HidOccurrence)hidOccurrence, message));
        }
        return result;
    }

    protected OVMComplianceHit addHit(ParserPath parserPath, HidOccurrence hidOccurrence, String message) {
        return this.addHit(parserPath, hidOccurrence, message, false);
    }

    protected OVMComplianceHit addHit(ParserPath parserPath, HidOccurrence hidOccurrence, String message, VerissimoAutofixAdditionalInfo autofixAdditionalInfo) {
        return this.addHit(parserPath, hidOccurrence, message, false, autofixAdditionalInfo);
    }

    protected OVMComplianceHit addHit(ParserPath parserPath, HidOccurrence hidOccurrence, String message, boolean force) {
        return this.addHit(parserPath, hidOccurrence, message, force, null);
    }

    private OVMComplianceHit addHit(ParserPath parserPath, HidOccurrence hidOccurrence, String message, boolean force, VerissimoAutofixAdditionalInfo autofixAdditionalInfo) {
        if (hidOccurrence == null) {
            return null;
        }
        return this.addHit(parserPath, hidOccurrence.getLine(), message, (ReparseInfo)hidOccurrence.getReparseInfo(ReparseInfo.class), force, autofixAdditionalInfo);
    }

    protected OVMComplianceHit addHit(ParserPath file, int line, String details, ReparseInfo reparseInfo) {
        return this.addHit(file, line, details, reparseInfo, false);
    }

    protected OVMComplianceHit addHit(ParserPath file, int line, String details, ReparseInfo reparseInfo, VerissimoAutofixAdditionalInfo autofixAdditionalInfo) {
        return this.addHit(file, line, details, reparseInfo, false, autofixAdditionalInfo);
    }

    public OVMComplianceHit addHit(ParserPath file, int line, String details, ReparseInfo reparseInfo, boolean force) {
        CheckStatus status = null;
        return this.addHit(file, line, details, reparseInfo, force, status);
    }

    public OVMComplianceHit addHit(ParserPath file, int line, String details, ReparseInfo reparseInfo, boolean force, CheckStatus severity) {
        return this.addHit(file, line, details, reparseInfo, force, severity, null);
    }

    public OVMComplianceHit addHit(ParserPath file, int line, String details, ReparseInfo reparseInfo, boolean force, VerissimoAutofixAdditionalInfo autofixAdditionalInfo) {
        return this.addHit(file, line, details, reparseInfo, force, autofixAdditionalInfo, false);
    }

    public OVMComplianceHit addHit(ParserPath file, int line, String details, ReparseInfo reparseInfo, boolean force, VerissimoAutofixAdditionalInfo autofixAdditionalInfo, boolean isHidden) {
        return this.addHit(file, line, details, reparseInfo, force, null, autofixAdditionalInfo, isHidden);
    }

    public OVMComplianceHit addHit(ParserPath file, int line, String details, ReparseInfo reparseInfo, boolean force, CheckStatus severity, VerissimoAutofixAdditionalInfo autofixAdditionalInfo) {
        return this.addHit(file, line, details, reparseInfo, force, severity, autofixAdditionalInfo, false);
    }

    public OVMComplianceHit addHit(ParserPath file, int line, String details, ReparseInfo reparseInfo, boolean force, CheckStatus severity, VerissimoAutofixAdditionalInfo autofixAdditionalInfo, boolean isHidden) {
        if (file != null) {
            String shortFileName = LintUtils.getFileShortName(file.path);
            if (this.fOVMProject.isOVMFile(shortFileName)) {
                return null;
            }
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(file, this)) {
                return null;
            }
        }
        String macroInfoText = "";
        ParserPath[] insideMacroPaths = null;
        if (reparseInfo != null && reparseInfo.getReparseStackSize() > 0) {
            ReparseInfo.ReparseElement[] reparseStack = reparseInfo.getReparseStack();
            insideMacroPaths = new ParserPath[reparseStack.length];
            StringBuilder macroInfoSB = new StringBuilder();
            int i = 0;
            while (i < reparseStack.length) {
                ReparseInfo.ReparseElement macroElm = reparseStack[i];
                if (!force && this.fOVMProject.isReparseStackFileInOVM(macroElm)) {
                    return null;
                }
                macroInfoSB.append("\n    ").append(macroElm.toString().trim());
                insideMacroPaths[i] = macroElm.getReparseMacroFile();
                ++i;
            }
            macroInfoText = macroInfoSB.toString();
        }
        OVMComplianceCheckHit newHit = new OVMComplianceCheckHit(file, details, macroInfoText, insideMacroPaths, line, this, autofixAdditionalInfo, isHidden, null, null);
        return this.addHitNoDuplicates(newHit, severity);
    }

    public OVMComplianceHit addHit(ParserPath file, String details, String macroInfoText, ParserPath[] insideMacroPaths, int line, VerissimoAutofixAdditionalInfo autofixAdditionalInfo, boolean isHidden, CheckStatus severity, Set<String> compareAnnotations, List<OVMComplianceHit.DetailsLink> detailsLinks) {
        OVMComplianceCheckHit newHit = new OVMComplianceCheckHit(file, details, macroInfoText, insideMacroPaths, line, this, autofixAdditionalInfo, isHidden, compareAnnotations, detailsLinks);
        return this.addHitNoDuplicates(newHit, severity);
    }

    protected OVMComplianceHit addHitOnFunctionDefinition(RfFunction fun, String details) {
        return this.addHitOnFunctionDefinition(fun, details, null);
    }

    protected OVMComplianceHit addHitOnFunctionDefinition(RfFunction fun, String details, VerissimoAutofixAdditionalInfo autofixAdditionalInfo) {
        Collection defs = fun.getDeclarations();
        for (IRfDefElement def : defs) {
            if (((RfFunctionDef)def).isPrototype() && defs.size() > 1) continue;
            return this.addHit(def.getParserPath(), def.getStartLine(), details, ((RfDefElement)def).getReparseInfo(), false, autofixAdditionalInfo);
        }
        return null;
    }

    private OVMComplianceHit addHitNoDuplicates(OVMComplianceCheckHit newHit, CheckStatus severity) {
        OVMComplianceCheckHit hit;
        String newHitSignature = newHit.getSignature();
        boolean found = false;
        if (newHit.getParserPath() != null && !"none".equals(newHit.getParserPath().path) && (hit = this.fCheckHits.get(newHitSignature)) != null) {
            found = true;
            if (hit.getMacroPath().length() > newHit.getMacroPath().length()) {
                this.fCheckHits.put(newHitSignature, newHit);
            }
        }
        if (!found) {
            WaiverStatus status = this.fOVMProject.getProjectWaivers().getStatus(newHit);
            if (status == null || status.equals((Object)WaiverStatus.NONE)) {
                if (severity == null) {
                    newHit.setSeverity(this.getSeverity());
                } else {
                    newHit.setSeverity(severity);
                }
            } else if (status == WaiverStatus.DISABLE) {
                newHit.setSeverity(CheckStatus.DISABLED);
            } else if (status == WaiverStatus.ERROR) {
                newHit.setSeverity(CheckStatus.ERROR);
            } else if (status == WaiverStatus.WARNING) {
                newHit.setSeverity(CheckStatus.WARNING);
            } else if (status == WaiverStatus.INFO) {
                newHit.setSeverity(CheckStatus.INFO);
            }
            this.fCheckHits.put(newHitSignature, newHit);
            return newHit;
        }
        return null;
    }

    @Override
    public void addInternalErrorHit(Throwable e) {
        this.clearVisibleHits();
        this.fCheckHits.clear();
        ByteArrayOutputStream outputStream = null;
        PrintStream printStream = null;
        outputStream = new ByteArrayOutputStream();
        printStream = new PrintStream(outputStream);
        e.printStackTrace(printStream);
        this.addHit(new ParserPath("none"), 0, "Rule Internal Error [id:" + this.getID() + ", name:" + this.getName() + "]: Internal error occured which prevented successful execution of " + this.fName + "!\n\n" + outputStream.toString(), null, false, CheckStatus.ERROR);
    }

    protected void signalParamError(String message, boolean stopPerformCheck) {
        if (stopPerformCheck) {
            this.fConfigurationErrorDetails.add(message);
        }
        this.fConfigurationError = true;
        message = "Rule Configuration Error [id:" + this.getID() + ", name:" + this.getName() + "]: " + message;
        this.addHit(null, message);
    }

    public String link(String text, String file, int line) {
        return "<link file='" + file + "' line='" + Integer.toString(line) + "'>" + text + "</link>";
    }

    public String link(RfNamedElement namedElement) {
        ParserPath neParserPath;
        if (namedElement == null) {
            return "";
        }
        String result = namedElement.getFullName();
        RfFileDef neFile = namedElement.getFile();
        if (neFile != null && (neParserPath = neFile.getParserPath()) != null) {
            result = this.link(namedElement.getFullName(), neParserPath.toString(), namedElement.getLine());
        }
        return result;
    }

    public String linkActionBlock(RfActionBlock actionBlock) {
        ParserPath neParserPath;
        if (actionBlock == null) {
            return null;
        }
        String result = actionBlock.getExpression();
        RfFileDef neFile = actionBlock.getFile();
        if (neFile != null && (neParserPath = neFile.getParserPath()) != null) {
            result = this.link(actionBlock.getExpression(), neParserPath.toString(), actionBlock.getLine());
        }
        return result;
    }

    protected String addLineFileInfo(RfNamedElement namedElement, String msg) {
        ParserPath parserPath = null;
        RfFileDef neFile = namedElement.getFile();
        if (neFile != null) {
            parserPath = neFile.getParserPath();
        }
        if (namedElement instanceof VlogMacroInfo) {
            parserPath = ((VlogMacroInfo)namedElement).getMacroParserPath();
        }
        if (parserPath != null) {
            int line = namedElement.getLine();
            return String.valueOf(msg) + "in " + this.link(String.valueOf(Utils.getInstance().getFileName(parserPath.path)) + ":" + line, parserPath.path, line);
        }
        return msg;
    }

    public IProject getIProject() {
        return this.fOVMProject.getRfProject().getProject();
    }

    public OVMProject getOVMProject() {
        return this.fOVMProject;
    }

    public void setConfigurationErrors(boolean value) {
        this.fConfigurationError = value;
    }

    public boolean hasConfigurationErrors() {
        return this.fConfigurationError;
    }

    public boolean isValidParameter(String key) {
        Class<?> currentClass = this.getClass();
        boolean found = false;
        while (currentClass != OVMComplianceCheck.class) {
            Field[] fields;
            Field[] fieldArray = fields = currentClass.getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                String propertyName;
                Field field = fieldArray[n2];
                CheckParameter annot = field.getAnnotation(CheckParameter.class);
                if (annot != null && (propertyName = annot.name()) != null && propertyName.equals(key)) {
                    found = true;
                    break;
                }
                ++n2;
            }
            currentClass = currentClass.getSuperclass();
        }
        return found;
    }

    public boolean isValidAutofixParameter(String key) {
        Field[] fields;
        boolean found = false;
        List<CheckAutofix> autofixAnnotations = Arrays.asList((CheckAutofix[])this.getClass().getAnnotationsByType(CheckAutofix.class));
        if (autofixAnnotations.isEmpty()) {
            return found;
        }
        VerissimoAutofix autofix = VerissimoAutofixFactory.INSTANCE.createAutofix(this, new ArrayList<OVMComplianceCheckHit>(), true);
        if (autofix == null) {
            return found;
        }
        Field[] fieldArray = fields = autofix.getClass().getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            String propertyName;
            Field field = fieldArray[n2];
            AutofixParameter annot = field.getAnnotation(AutofixParameter.class);
            if (annot != null && (propertyName = annot.name()) != null && propertyName.equals(key)) {
                found = true;
                break;
            }
            ++n2;
        }
        return found;
    }

    public void activateProfiling(int periodMS, int delayMS) {
        this.fProfilingActivated = true;
        this.fProfilingPeriodMS = periodMS;
        this.fProfilingDelayMS = delayMS;
    }

    public boolean isProfilingActivated() {
        return this.fProfilingActivated;
    }

    public int getProfilingIntervalMS() {
        return this.fProfilingPeriodMS;
    }

    public int getProfilingDelayMS() {
        return this.fProfilingDelayMS;
    }

    public void activateHistogramDump() {
        this.fHistogramDumpActivated = true;
    }

    public boolean isHistogramDumpActivated() {
        return this.fHistogramDumpActivated;
    }

    public boolean isAllowOverride() {
        return this.fAllowOverride;
    }

    public void setAllowOverride(boolean allowOverride) {
        this.fAllowOverride = allowOverride;
    }

    public void clean() {
        this.clearVisibleHits();
        if (this.fCheckHits != null) {
            this.fCheckHits.clear();
        }
        this.fCheckHits = new LinkedHashMap();
    }

    private String getOVMHitSignature(RHit rHit) {
        StringBuilder macroPathString = new StringBuilder();
        if (rHit.getMacroParts() != null && !rHit.getMacroParts().isEmpty()) {
            for (RHit.MacroPathWrapper macroPart : rHit.getMacroParts()) {
                macroPathString.append("\n").append(MessageFormat.format("    inside macro {0} at line {1} in ''{2}''", macroPart.getMacroName(), macroPart.getLine(), macroPart.getFile()));
            }
        }
        String rHitSignature = MessageFormat.format("[file:{0},line:{1},macroPath:{2},details:{3}]", rHit.getFile(), rHit.getHitLine(), macroPathString.toString(), rHit.getHitDetails());
        return rHitSignature;
    }

    public OVMComplianceCheckHit getOVMHit(RHit rHit) {
        String rHitSignature = this.getOVMHitSignature(rHit);
        return this.fCheckHits.get(rHitSignature);
    }

    public void removeOVMHitsByPaths(Set<String> unchangedFiles) {
        this.fCheckHits.values().removeIf(x -> unchangedFiles.contains(x.getParserPath().path));
    }

    public void clearVisibleHits() {
        if (this.fVisibleHits != null) {
            this.fVisibleHits.clear();
        }
        this.fVisibleHits = null;
        this.fStatus = null;
    }

    public void applyFilters(EnumMap<CheckStatus, Boolean> filters, RuleLabel labelFilter) {
        this.clearVisibleHits();
        this.getVisibleHits(filters, labelFilter);
    }

    static class OVMComplianceCheckComparator
    implements Comparator<OVMComplianceCheckHit> {
        OVMComplianceCheckComparator() {
        }

        @Override
        public int compare(OVMComplianceCheckHit o1, OVMComplianceCheckHit o2) {
            int stringCompareResult = o1.getParserPath().compareTo(o2.getParserPath());
            if (stringCompareResult != 0) {
                return stringCompareResult;
            }
            if (o1.getLine() != o2.getLine()) {
                return o1.getLine() - o2.getLine();
            }
            if (!o1.getMacroPath().equals(o2.getMacroPath())) {
                return o1.getMacroPath().compareTo(o2.getMacroPath());
            }
            return o1.getDetails().compareTo(o2.getDetails());
        }
    }

    public static enum ParametersDescriptionParser {
        RULEPOOL_DOC,
        RULESET_DOC,
        RULEPOOL_XML,
        RULESET_XML;

    }
}

