/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;

public final class OVMComplianceCheckFilters {
    private OVMComplianceCheckFilters() {
    }

    public static final Predicate<OVMComplianceCheck> isDateBefore(Date sinceDate) {
        return check -> {
            String value = check.getDate();
            if (value == null || value.isEmpty()) {
                return false;
            }
            boolean result = false;
            try {
                Date checkDate = OVMProject.getDateFormat().parse(value);
                result = checkDate.before(sinceDate);
            }
            catch (ParseException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            return result;
        };
    }

    public static final Predicate<OVMComplianceCheck> isVersionBefore(String sinceVersion) {
        return check -> {
            String value = check.getVersion();
            if (value == null || value.isEmpty()) {
                return false;
            }
            String[] candidateSplits = DVTStringUtil.split((String)".", (String)value);
            String[] sinceSplits = DVTStringUtil.split((String)".", (String)sinceVersion);
            int maxSplits = Math.max(candidateSplits.length, sinceSplits.length);
            Integer candidateVersionValue = null;
            Integer sinceVersionValue = null;
            int i = 0;
            while (i < maxSplits) {
                if (candidateSplits.length <= i) {
                    return true;
                }
                candidateVersionValue = Integer.parseInt(candidateSplits[i]);
                if (sinceSplits.length <= i) {
                    return false;
                }
                sinceVersionValue = Integer.parseInt(sinceSplits[i]);
                if (candidateVersionValue < sinceVersionValue) {
                    return true;
                }
                if (candidateVersionValue > sinceVersionValue) {
                    return false;
                }
                ++i;
            }
            return false;
        };
    }

    public static final Predicate<OVMComplianceCheck> hasLabel(RuleLabel ruleLabel) {
        return check -> {
            Set<RuleLabel> labels = check.getLabels();
            if (ruleLabel == null || labels == null || labels.isEmpty()) {
                return false;
            }
            return labels.contains((Object)ruleLabel);
        };
    }

    public static final Predicate<OVMComplianceCheck> hasLabels(Set<RuleLabel> ruleLabels) {
        return check -> check.getLabels() != null && !Collections.disjoint(check.getLabels(), ruleLabels);
    }

    public static final Predicate<OVMComplianceCheck> isSpecifiedRuleByName(Collection<String> specifiedRules) {
        return check -> check.getName() != null && specifiedRules.contains(check.getName());
    }

    public static final Predicate<OVMComplianceCheck> isSpecifiedRuleById(Collection<String> specifiedRules) {
        return check -> check.getID() != null && specifiedRules.contains(check.getID());
    }

    public static void filterChecks(List<OVMComplianceCheck> checks, Predicate<OVMComplianceCheck> filter) {
        if (checks == null || filter == null) {
            return;
        }
        checks.removeIf(filter);
    }

    public static void filterChecksOfCategories(List<OVMComplianceCategory> categories, Predicate<OVMComplianceCheck> filter) {
        Iterator<OVMComplianceCategory> iterator = categories.iterator();
        while (iterator.hasNext()) {
            ArrayList<OVMComplianceCheck> checksCategory = iterator.next().getChecks();
            OVMComplianceCheckFilters.filterChecks(checksCategory, filter);
            if (!checksCategory.isEmpty()) continue;
            iterator.remove();
        }
    }

    public static void filterCategoriesAndChecks(List<OVMComplianceCategory> categories, List<OVMComplianceCheck> checks, Predicate<OVMComplianceCheck> filter) {
        OVMComplianceCheckFilters.filterChecksOfCategories(categories, filter);
        OVMComplianceCheckFilters.filterChecks(checks, filter);
    }
}

