/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.CheckStatus;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceHit;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.report.model.RHit;

public class OVMComplianceCheckHit
extends OVMComplianceHit {
    private OVMComplianceCheck fCheck;
    private CheckStatus fSeverity;
    private Set<String> fCompareAnnotations;
    private ParserPath[] fInsideMacroPaths;
    private VerissimoAutofixAdditionalInfo fAutofixAdditionalInfo;
    private boolean isFixed;
    private boolean fIsHidden;

    public OVMComplianceCheckHit(ParserPath filePath, String details, String macroPath, ParserPath[] insideMacroPaths, int line, OVMComplianceCheck check, List<OVMComplianceHit.DetailsLink> detailsLinks) {
        this.fParserPath = filePath;
        this.fMacroPath = macroPath == null ? "" : macroPath;
        this.fInsideMacroPaths = insideMacroPaths;
        this.fLine = line;
        OVMComplianceCheckHit.extractLinksFromDetails(this, details);
        if (detailsLinks != null && !detailsLinks.isEmpty()) {
            this.fDetailsLinks = detailsLinks;
        }
        this.fCheck = check;
        this.fSeverity = check.getSeverity();
        this.fCompareAnnotations = new LinkedHashSet<String>();
    }

    public OVMComplianceCheckHit(ParserPath filePath, String details, String macroPath, ParserPath[] insideMacroPaths, int line, OVMComplianceCheck check, VerissimoAutofixAdditionalInfo autofixAdditionalInfo, boolean isHidden, Set<String> compareAnnotations, List<OVMComplianceHit.DetailsLink> detailsLinks) {
        this(filePath, details, macroPath, insideMacroPaths, line, check, detailsLinks);
        this.fAutofixAdditionalInfo = autofixAdditionalInfo;
        this.fIsHidden = isHidden;
        this.fCompareAnnotations = compareAnnotations;
    }

    public OVMComplianceCheck getCheck() {
        return this.fCheck;
    }

    public void setSeverity(CheckStatus serverity) {
        this.fSeverity = serverity;
    }

    public CheckStatus getSeverity() {
        return this.fSeverity;
    }

    public ParserPath[] getInsideMacroPaths() {
        return this.fInsideMacroPaths;
    }

    public VerissimoAutofixAdditionalInfo getAutofixAdditionalInfo() {
        return this.fAutofixAdditionalInfo;
    }

    public boolean isFixed() {
        return this.isFixed;
    }

    public void addCompareAnnotation(String compareAnnotation) {
        if (this.fCompareAnnotations == null) {
            this.fCompareAnnotations = new HashSet<String>();
        }
        this.fCompareAnnotations.add(compareAnnotation);
    }

    public void addCompareAnnotationBasedOnIndex(Integer annotationIndex) {
        Optional<Map.Entry> foundAnnotation = RHit.ANNOTATION_STRING_2_INDEX.entrySet().parallelStream().filter(entry -> annotationIndex.equals(entry.getValue())).findFirst();
        if (foundAnnotation.isPresent()) {
            String compareAnnotation = (String)foundAnnotation.get().getKey();
            this.fCompareAnnotations.add(compareAnnotation);
        }
    }

    public Set<String> getCompareAnnotations() {
        return this.fCompareAnnotations;
    }

    public List<Integer> getCompareAnnotationsIndexes() {
        return this.fCompareAnnotations.stream().map(annotation -> RHit.ANNOTATION_STRING_2_INDEX.get(annotation)).collect(Collectors.toList());
    }

    public void setFixed(boolean isFixed) {
        this.isFixed = isFixed;
    }

    public boolean isHidden() {
        return this.fIsHidden;
    }
}

