/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import ro.amiq.vlogdt.linter.CheckStatus;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.report.model.RCheck;
import ro.amiq.vlogdt.linter.report.model.RHit;
import ro.amiq.vlogdt.linter.standard.checks.OVMComplianceManualCheck;

public class OVMComplianceChecksUtil {
    public static CheckStatus getStatus(RCheck check) {
        if (check.isManualCheck()) {
            if (check.getCheckStatus() == 0) {
                return CheckStatus.ERROR;
            }
            return CheckStatus.PASSED;
        }
        if (check.getCheckStatus().intValue() == CheckStatus.DISABLED.ordinal()) {
            return CheckStatus.DISABLED;
        }
        if (check.getHits().size() - check.getNofFixedHits() - check.getNofWaivedHits() == 0) {
            return CheckStatus.PASSED;
        }
        CheckStatus status = CheckStatus.DISABLED;
        Set<RHit> hits = check.getHits();
        for (RHit hit : hits) {
            status = CheckStatus.getSevereStatus(status, CheckStatus.values()[hit.getHitSeverity()]);
        }
        return status;
    }

    public static CheckStatus getStatus(Object element) {
        if (element instanceof OVMComplianceCategory) {
            OVMComplianceCategory tmpElement = (OVMComplianceCategory)element;
            if (tmpElement.getNofEnabledChecks() == 0) {
                return CheckStatus.DISABLED;
            }
            CheckStatus status = CheckStatus.DISABLED;
            ArrayList<OVMComplianceCheck> checks = tmpElement.getChecks();
            for (OVMComplianceCheck check : checks) {
                status = CheckStatus.getSevereStatus(status, OVMComplianceChecksUtil.getStatus(check));
            }
            return status;
        }
        if (element instanceof OVMComplianceManualCheck) {
            OVMComplianceManualCheck tmpElement = (OVMComplianceManualCheck)element;
            if (!tmpElement.isEnabled()) {
                return CheckStatus.DISABLED;
            }
            return tmpElement.getStatus();
        }
        if (element instanceof OVMComplianceCheck) {
            OVMComplianceCheck tmpElement = (OVMComplianceCheck)element;
            if (!tmpElement.isEnabled()) {
                return CheckStatus.DISABLED;
            }
            if (tmpElement.getNofVisibleHits() == 0) {
                return CheckStatus.PASSED;
            }
            CheckStatus status = CheckStatus.PASSED;
            ArrayList<OVMComplianceCheckHit> hits = tmpElement.getVisibleHits();
            for (OVMComplianceCheckHit hit : hits) {
                if ((status = CheckStatus.getSevereStatus(status, hit.getSeverity())) == CheckStatus.ERROR) break;
            }
            return status;
        }
        if (element instanceof OVMComplianceCheckHit) {
            return ((OVMComplianceCheckHit)element).getSeverity();
        }
        return CheckStatus.ERROR;
    }

    public static boolean applyFiltersOnHits(EnumMap<CheckStatus, Boolean> filters, ArrayList<OVMComplianceCheckHit> hits) {
        if (filters == null) {
            return false;
        }
        OVMProject ovmProject = hits.get(0).getCheck().getOVMProject();
        for (OVMComplianceCheckHit hit : hits) {
            if (ovmProject.isChangesHidden(hit)) continue;
            CheckStatus hitStatus = OVMComplianceChecksUtil.getStatus(hit);
            for (Map.Entry<CheckStatus, Boolean> entry : filters.entrySet()) {
                if (hitStatus != entry.getKey() || entry.getValue().booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean applyLabelFiltersOnCheck(RuleLabel labelFilter, OVMComplianceCheck check) {
        if (labelFilter == null) {
            return true;
        }
        Set<RuleLabel> labels = check.getLabels();
        if (labels == null || labels.isEmpty()) {
            return false;
        }
        return labels.contains((Object)labelFilter);
    }

    public static boolean applyFiltersOnCheck(EnumMap<CheckStatus, Boolean> filters, CheckStatus checkStatus) {
        if (filters == null) {
            return true;
        }
        for (Map.Entry<CheckStatus, Boolean> entry : filters.entrySet()) {
            if (checkStatus != entry.getKey() || !entry.getValue().booleanValue()) continue;
            return false;
        }
        return true;
    }
}

