/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.report.model.RHit;
import ro.amiq.vlogdt.linter.utils.LintUtils;

public class OVMComplianceHit {
    public static final String SIGNATURE_FORMAT = "[file:{0},line:{1},macroPath:{2},details:{3}]";
    private static final Pattern MACRO_PARTS_PATTERN = Pattern.compile("^\\s*inside\\s+macro\\s+(.*)\\s+at\\s+line\\s+(.*)\\s+in\\s+'(.*)'\\s*$");
    private static final Pattern LINK_PATTERN = Pattern.compile("<link\\s+file='([^']+?)'\\s+line='([^']+?)'\\s*>(.+?)</link>");
    protected ParserPath fParserPath;
    protected int fLine;
    protected String fMacroPath;
    protected String fDetails;
    protected List<DetailsLink> fDetailsLinks;

    protected static void extractLinksFromDetails(OVMComplianceHit hit, String details) {
        if (details == null || details.isEmpty()) {
            hit.fDetails = "";
        }
        Matcher matcher = LINK_PATTERN.matcher(details);
        StringBuffer detailsBuffer = new StringBuffer();
        ArrayList<DetailsLink> detailsList = new ArrayList<DetailsLink>();
        while (matcher.find()) {
            matcher.appendReplacement(detailsBuffer, "$3");
            detailsList.add(new DetailsLink(detailsBuffer.length() - matcher.group(3).length(), matcher.group(3).length(), matcher.group(1), matcher.group(2)));
        }
        matcher.appendTail(detailsBuffer);
        hit.fDetails = detailsBuffer.toString();
        if (!detailsList.isEmpty()) {
            hit.fDetailsLinks = detailsList;
        }
    }

    public void setParserPath(ParserPath path) {
        this.fParserPath = path;
    }

    public ParserPath getParserPath() {
        return this.fParserPath;
    }

    public int getLine() {
        return this.fLine;
    }

    public String getMacroPath() {
        return this.fMacroPath;
    }

    public void setMacroPath(String macroPath) {
        this.fMacroPath = macroPath;
    }

    public String getDetails() {
        return this.fDetails;
    }

    public List<DetailsLink> getDetailsLinks() {
        if (this.fDetailsLinks == null) {
            return Collections.emptyList();
        }
        return this.fDetailsLinks;
    }

    public String getShortFileNameAndMacroPath() {
        return String.valueOf(LintUtils.getFileShortName(this.getParserPath().path)) + this.getShortMacroPath();
    }

    public List<String[]> getMacroPathParts() {
        String[] parts;
        if (this.fMacroPath == null || this.fMacroPath.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<String[]> result = new LinkedList<String[]>();
        String[] stringArray = parts = this.fMacroPath.split("\n");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            Matcher matcher = MACRO_PARTS_PATTERN.matcher(part);
            if (matcher.matches()) {
                result.add(new String[]{matcher.group(1), matcher.group(3), matcher.group(2)});
            }
            ++n2;
        }
        if (result.isEmpty()) {
            return Collections.emptyList();
        }
        return result;
    }

    private String getShortMacroPath() {
        String[] macroPathComponents = this.fMacroPath.split("'");
        StringBuilder macroPathResultSB = new StringBuilder();
        int i = 0;
        while (i < macroPathComponents.length) {
            if (i % 2 == 0) {
                macroPathResultSB.append(macroPathComponents[i]);
            } else {
                macroPathResultSB.append("'").append(LintUtils.getFileShortName(macroPathComponents[i])).append("'");
            }
            ++i;
        }
        String macroPathResult = macroPathResultSB.toString();
        return macroPathResult;
    }

    public String getSignature() {
        return MessageFormat.format(SIGNATURE_FORMAT, this.getParserPath(), this.getLine(), this.getMacroPath(), this.getDetails());
    }

    public static class DetailsLink {
        public final int offset;
        public final int length;
        public String file;
        public final String line;

        public DetailsLink(int offset, int length, String file, String line) {
            this.offset = offset;
            this.length = length;
            this.file = file;
            this.line = line;
        }

        public static List<DetailsLink> convertDetailsLinks(List<RHit.DetailsLinkWrapper> detailsLinks, List<String> files) {
            LinkedList<DetailsLink> result = new LinkedList<DetailsLink>();
            for (RHit.DetailsLinkWrapper detailsLink : detailsLinks) {
                result.add(new DetailsLink(detailsLink.getOffset(), detailsLink.getLength(), files.get(detailsLink.getIndex()), detailsLink.getLine()));
            }
            return result;
        }
    }
}

