/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.PlatformUI;
import org.json.JSONException;
import org.xml.sax.SAXException;
import ro.amiq.dvt.builders.DVTBuildConsole;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.memorymonitor.MemoryMonitor;
import ro.amiq.dvt.memorymonitor.MemoryMonitorState;
import ro.amiq.dvt.memorymonitor.MemoryMonitoringType;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTStartupConstants;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.reportissue.DVTHeapHistogramCollector;
import ro.amiq.dvt.ui.reportissue.DVTThreadDumpCollector;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.PathMapper;
import ro.amiq.dvt.utils.ProgressPrinter;
import ro.amiq.dvt.utils.XMLException;
import ro.amiq.vlogdt.linter.CheckStatus;
import ro.amiq.vlogdt.linter.IOVMComplianceCheck;
import ro.amiq.vlogdt.linter.LintingCancelledException;
import ro.amiq.vlogdt.linter.LintingProgressAndAliveMonitor;
import ro.amiq.vlogdt.linter.LintingSemanticHit;
import ro.amiq.vlogdt.linter.LintingTimedOutException;
import ro.amiq.vlogdt.linter.ManualChecksStatusXMLParser;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckFilters;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.OVMComplianceChecksUtil;
import ro.amiq.vlogdt.linter.OVMComplianceHit;
import ro.amiq.vlogdt.linter.ReportManager;
import ro.amiq.vlogdt.linter.annotations.AnnotationLocation;
import ro.amiq.vlogdt.linter.annotations.AnnotationManager;
import ro.amiq.vlogdt.linter.annotations.AnnotationResults;
import ro.amiq.vlogdt.linter.annotations.AnnotationType;
import ro.amiq.vlogdt.linter.api.impl.CustomRuleWrapper;
import ro.amiq.vlogdt.linter.api.impl.factory.APIFactory;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixManager;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixResult;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.flowgraph.ExecutionFlowGraph;
import ro.amiq.vlogdt.linter.launch.LintConfigurationContainer;
import ro.amiq.vlogdt.linter.launch.VerissimoAfterCompilationLauncher;
import ro.amiq.vlogdt.linter.report.VerissimoReportReader;
import ro.amiq.vlogdt.linter.report.model.RCategory;
import ro.amiq.vlogdt.linter.report.model.RCheck;
import ro.amiq.vlogdt.linter.report.model.RHit;
import ro.amiq.vlogdt.linter.report.model.RInfo;
import ro.amiq.vlogdt.linter.report.model.RPreWaiver;
import ro.amiq.vlogdt.linter.report.model.RReport;
import ro.amiq.vlogdt.linter.report.model.RWaiver;
import ro.amiq.vlogdt.linter.ruleset.RuleFactory;
import ro.amiq.vlogdt.linter.ruleset.Ruleset;
import ro.amiq.vlogdt.linter.ruleset.RulesetComponent;
import ro.amiq.vlogdt.linter.ruleset.RulesetConfiguration;
import ro.amiq.vlogdt.linter.ruleset.RulesetKind;
import ro.amiq.vlogdt.linter.standard.checks.OVMComplianceManualCheck;
import ro.amiq.vlogdt.linter.utils.IWhitespaceParserCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.linter.utils.SVTBCharParser;
import ro.amiq.vlogdt.linter.utils.SVTBWhitespaceParser;
import ro.amiq.vlogdt.linter.waivers.MessagePattern;
import ro.amiq.vlogdt.linter.waivers.PathEntry;
import ro.amiq.vlogdt.linter.waivers.PostWaiver;
import ro.amiq.vlogdt.linter.waivers.PreWaiver;
import ro.amiq.vlogdt.linter.waivers.WaiverStatus;
import ro.amiq.vlogdt.linter.waivers.WaiverType;
import ro.amiq.vlogdt.linter.waivers.WaiversModel;
import ro.amiq.vlogdt.model.reflection.ArgInfo;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfChecker;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfClockingBlock;
import ro.amiq.vlogdt.model.reflection.RfConfiguration;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModport;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfPrimitive;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfPropertySequence;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;
import ro.amiq.vlogdt.parser.MacroCallInfo;
import ro.amiq.vlogdt.parser.MacroCallItem;
import ro.amiq.vlogdt.parser.ReparseInfo;
import ro.amiq.vlogdt.parser.SVTBIssues;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.parser.VlogIncludingScope;
import ro.amiq.vlogdt.parser.VlogMacroInfo;
import ro.amiq.vlogdt.parser.VlogPreprocessingInfo;

public class OVMProject {
    public static final String CANCELED_LINT_MESSAGE = "*** Error: Lint has been canceled";
    public static final String WARNING_MESSAGE_FORMAT = "*** Warning: {0}";
    public static final String ERROR_MESSAGE_FORMAT = "*** Error: {0}";
    public static final String CONSOLE_LINT_MESSAGE = "*** LINT CONSOLE OUTPUT";
    private static final String LINT_CUSTOM_RULESET = "Starting linting using custom ruleset ";
    private static final String LINT_PREDEFINED_RULESET = "Starting linting using predefined ruleset ";
    private static final String LINT_WAIVERS = "Starting linting using waivers ";
    public static final String LIBFILE_SUFFIX = ".libfile";
    public static final String TOPFILE_PREFIX = "__vlog__";
    public static final String CHECK_SUMMARY_FORMAT = " Checks: {0,number,#} passed, {1,number,#} errors, {2,number,#} warnings, {3,number,#} infos, {4,number,#} disabled, {5,number,#} nonexistent, {6,number,#} duplicate";
    public static final String HITS_SUMMARY_FORMAT = " Hits:   {0,number,#} errors, {1,number,#} warnings, {2,number,#} infos, {3,number,#} disabled";
    public static final String FIXED_HITS_SUMMARY_FORMAT = " Fixed:  {0,number,#} errors, {1,number,#} warnings, {2,number,#} infos";
    public static final String HIDDEN_HITS_FOUND_BATCH_FORMAT = " Additional hits found due to ignoring the maxHitsPerFile parameter while running auto-correct:\n         {0,number,#} errors, {1,number,#} warnings, {2,number,#} infos";
    public static final String HIDDEN_HITS_SIMILAR_ISSUES_PRESENTED_GUI_FORMAT = "Note: There are {0,number,#} similar issues not presented due to the maxHitsPerFile parameter that will be fixed.";
    private static final String DEPRECATED_PREWAIVER_MESSAGE = "The ruleset pre-waivers for included or excluded paths are deprecated! Instead, use the apply-on attribute of paths from the waivers file for the following rules:" + System.lineSeparator();
    private Pattern fXVMFileNamePattern;
    private Pattern fXVMClassNamePattern;
    private APIFactory fAPIFactory;
    private Map<String, Set<LintingSemanticHit>> fRegisteredSemanticCheckPatterns;
    public RfClass fOvmTest;
    public RfClass fOvmEnv;
    public RfClass fOvmAgent;
    public RfClass fOvmMonitor;
    public RfClass fOvmDriver;
    public RfClass fOvmSequencer;
    public RfClass fOvmSequence;
    public RfClass fOvmSequenceItem;
    public RfClass fOvmSequenceLibrary;
    public RfClass fOvmAnalysisPort;
    public RfClass fOvmScoreboard;
    public RfClass fOvmComponent;
    protected LinkedHashMap<String, Map<String, RfClass>> fCategories;
    public Map<String, RfClass> fTests;
    public Map<String, RfClass> fTestbenches;
    public Map<String, RfClass> fEnvs;
    public Map<String, RfClass> fAgents;
    public Map<String, RfClass> fMonitors;
    public Map<String, RfClass> fDrivers;
    public Map<String, RfClass> fSequencers;
    public Map<String, RfClass> fSequences;
    public Map<String, RfClass> fSequenceItems;
    public Map<String, RfClass> fScoreboards;
    public Map<String, RfClass> fCoverageCollectors;
    public Map<String, RfClass> fActiveComponents;
    public Map<String, RfClass> fReactiveComponents;
    public Map<String, RfClass> fConfigurationObjects;
    private Map<String, RfClass> fDriverSequencers;
    private Map<String, RfClass> fVirtualSequencers;
    private IProject fProject;
    private RfProject fRfProject;
    private WaiversModel fProjectWaivers;
    private Ruleset fRuleset;
    private String fRulesetName;
    private final RulesetConfiguration fRulesetConfiguration;
    private ManualChecksStatusXMLParser fManualChecksStatusXMLParser;
    private NullProtectedList<RfNamedElement> fAllNonXVMClasses;
    private NullProtectedList<RfNamedElement> fAllFields;
    private NullProtectedList<RfNamedElement> fAllFunctions;
    private NullProtectedList<RfNamedElement> fAllFunctionCallContainers;
    private NullProtectedList<RfNamedElement> fAllAssertsExpects;
    private NullProtectedList<RfNamedElement> fAllInterfaces;
    private NullProtectedList<RfNamedElement> fAllTasks;
    private NullProtectedList<RfNamedElement> fAllTypes;
    private NullProtectedList<RfNamedElement> fAllTypedefs;
    private NullProtectedList<RfNamedElement> fAllPorts;
    private NullProtectedList<RfNamedElement> fAllFifos;
    private NullProtectedList<RfNamedElement> fAllModules;
    private NullProtectedList<RfNamedElement> fAllConstraints;
    private NullProtectedList<RfNamedElement> fAllClockingBlocks;
    private NullProtectedList<RfNamedElement> fAllModports;
    private NullProtectedList<RfNamedElement> fAllCovergroups;
    private NullProtectedList<RfNamedElement> fAllInstances;
    private NullProtectedList<RfNamedElement> fAllCheckers;
    private NullProtectedList<RfNamedElement> fAllConfigurations;
    private NullProtectedList<RfNamedElement> fAllPrimitives;
    private NullProtectedList<RfNamedElement> fAllPrograms;
    private NullProtectedList<RfNamedElement> fAllProperties;
    private NullProtectedList<RfNamedElement> fAllSequences;
    private Set<RfNamedElement> fAllNonXVMFunctionCallContainers;
    private NullProtectedList<RfClass> fAllClasses;
    private NullProtectedList<VlogMacroInfo> fAllMacros;
    private HashMap<ParserPath, HashSet<ParserPath>> fAllSequenceListFilesAndImportedSequences;
    private HashSet<ParserPath> fAllSequenceListFilesByName;
    private HashSet<ParserPath> fAllImportedFiles;
    private HashMap<ParserPath, Set<Class<? extends RfNamedElement>>> fAllIncludedFiles;
    private HashMap<ParserPath, HashMap<ParserPath, List<Integer>>> fAllFilesWithIncludes;
    private ArrayList<ParserPath> fAllFilesInIncludeOrder;
    private Map<SVTBCharParser.Config, Map<ParserPath, List<SVTBIssues>>> fAllSVTBCharIssues;
    private Map<String, RfClass> fAllComponents;
    private Map<String, RfClass> fAllObjects;
    private NullProtectedList<RfFunctionCall> fAllCreateCalls;
    private NullProtectedList<RfFunctionCall> fAllNewCalls;
    private NullProtectedList<RfStruct> fAllStructs;
    private NullProtectedList<RfStruct> fAllUnions;
    private Collection<RfPackage> fAllPackages;
    private final ArrayList<OVMComplianceCheck> fChecks;
    private final ArrayList<OVMComplianceCategory> fComplianceCategories;
    public Map<IOVMComplianceCheck, Exception> fCheckExceptions;
    public boolean fTimedOutProcess;
    public boolean fTimedOutSession;
    public boolean fTimedOutChecks;
    public boolean fMemoryMonitorError;
    private final LintConfigurationContainer fConfiguration;
    private final boolean fInBatchMode;
    private int fLibraryKind = 2;
    private boolean fLintLibraryContents;
    private String fAgentBaseClass;
    private String fDriverBaseClass;
    private String fMonitorBaseClass;
    private String fEnvBaseClass;
    private String fScoreboardBaseClass;
    private String fCoverageCollectorBaseClass;
    private String fSequenceItemBaseClass;
    private String fSequencerBaseClass;
    private String fSequenceBaseClass;
    private String fTestBaseClass;
    private String fTestbenchBaseClass;
    private String fConfigurationObjectBaseClass;
    private String fReactiveComponentBaseClass;
    private String fActiveComponentBaseClass;
    private RfClass fEnvClass;
    private RfClass fAgentClass;
    private RfClass fMonitorClass;
    private RfClass fDriverClass;
    private RfClass fSequencerClass;
    private RfClass fSequenceClass;
    private RfClass fSequenceItemClass;
    private RfClass fSequenceLibraryClass;
    private RfClass fScoreboardClass;
    private RfClass fTestClass;
    private RfClass fCoverageCollectorClass;
    private RfClass fTestbenchClass;
    private RfClass fConfigurationObjectClass;
    private RfClass fActiveComponentClass;
    private RfClass fReactiveComponentClass;
    private String fOVMClassPrefixes;
    private String fOVMFilePrefixes;
    private Map<RfClass, Set<RfClass>> fXVMSubclasses;
    private boolean fIncludeHTMLCode;
    private boolean fIncludeCodeDate;
    private boolean fIncludeCreationDate;
    private int fNofCompiledLines;
    private Map<String, Integer> fNofCompiledLinesPerFile;
    private long fLintRunTime;
    private long fFixingTime;
    private long fBuildRunTime;
    private long fLicenseWaitTime;
    private long fSessionEndTime;
    private long fProcessEndTime;
    private boolean fProcessTimeoutReported;
    private boolean fReapplyOrRerun;
    private Map<OVMComplianceCheck, VerissimoAutofixResult> fAutofixResults;
    private VerissimoAutofixResult fLastAutofixResult;
    private IProgressMonitor fProgressMonitor;
    private Timer fCheckAliveDebouncer;
    private static final String TOTAL_LINTING_TIME_MESSAGE = "Total linting time";
    private static final String TOTAL_FIXING_TIME_MESSAGE = "Total fixing time";
    private boolean isCanceledBeforeInitialization;
    private Map<RfNamedElement, ExecutionFlowGraph> fExecutionFlowGraphs;
    private Map<String, StringBuilder> printMessageByRule = new LinkedHashMap<String, StringBuilder>();
    private RulesetKind fTempRulesetkind;
    private Set<String> fDirtyChecks;
    private boolean compilationErrors;
    private RReport fImportedReport;
    private boolean fIsInChangesMode;
    private ReportManager fReportManager;
    private boolean fForceSimpleGUIReport;
    private SVTBWhitespaceParser fWhitespaceParser;
    private int numberOfHits;
    private boolean lintProject = true;
    private boolean startedFromBuildConfig;

    public OVMProject(LintConfigurationContainer config, boolean inBatchMode) {
        this.fProject = config.getProject();
        this.fCheckExceptions = new HashMap<IOVMComplianceCheck, Exception>();
        this.fTimedOutProcess = false;
        this.fTimedOutChecks = false;
        this.fTimedOutSession = false;
        this.fMemoryMonitorError = false;
        this.fChecks = new ArrayList();
        this.fComplianceCategories = new ArrayList();
        this.fDirtyChecks = new HashSet<String>();
        this.fProjectWaivers = new WaiversModel();
        this.fRuleset = new Ruleset();
        this.fRulesetName = null;
        this.fRulesetConfiguration = new RulesetConfiguration();
        this.fRegisteredSemanticCheckPatterns = new HashMap<String, Set<LintingSemanticHit>>();
        this.fTests = new LinkedHashMap<String, RfClass>();
        this.fTestbenches = new LinkedHashMap<String, RfClass>();
        this.fEnvs = new LinkedHashMap<String, RfClass>();
        this.fAgents = new LinkedHashMap<String, RfClass>();
        this.fMonitors = new LinkedHashMap<String, RfClass>();
        this.fDrivers = new LinkedHashMap<String, RfClass>();
        this.fSequencers = new LinkedHashMap<String, RfClass>();
        this.fSequences = new LinkedHashMap<String, RfClass>();
        this.fSequenceItems = new LinkedHashMap<String, RfClass>();
        this.fScoreboards = new LinkedHashMap<String, RfClass>();
        this.fCoverageCollectors = new LinkedHashMap<String, RfClass>();
        this.fConfigurationObjects = new LinkedHashMap<String, RfClass>();
        this.fActiveComponents = new LinkedHashMap<String, RfClass>();
        this.fReactiveComponents = new LinkedHashMap<String, RfClass>();
        this.fAutofixResults = new HashMap<OVMComplianceCheck, VerissimoAutofixResult>();
        this.fLastAutofixResult = null;
        this.fAllSVTBCharIssues = new HashMap<SVTBCharParser.Config, Map<ParserPath, List<SVTBIssues>>>();
        this.fExecutionFlowGraphs = new HashMap<RfNamedElement, ExecutionFlowGraph>();
        this.fCategories = new LinkedHashMap();
        this.fCategories.put("Agents", this.fAgents);
        this.fCategories.put("Drivers", this.fDrivers);
        this.fCategories.put("Environments", this.fEnvs);
        this.fCategories.put("Monitors", this.fMonitors);
        this.fCategories.put("Scoreboards", this.fScoreboards);
        this.fCategories.put("Coverage Collectors", this.fCoverageCollectors);
        this.fCategories.put("Sequence Items", this.fSequenceItems);
        this.fCategories.put("Sequencers", this.fSequencers);
        this.fCategories.put("Sequences", this.fSequences);
        this.fCategories.put("Testbenches", this.fTestbenches);
        this.fCategories.put("Test Classes", this.fTests);
        this.fCategories.put("Configuration Objects", this.fConfigurationObjects);
        this.fCategories.put("Active Components", this.fActiveComponents);
        this.fCategories.put("Reactive Components", this.fReactiveComponents);
        this.fConfiguration = config;
        this.fInBatchMode = inBatchMode;
        this.fProjectWaivers.initialize(this);
        if (config.getLibraryKind() != -1) {
            this.fLibraryKind = config.getLibraryKind();
        }
        this.loadRuleset();
        if (this.fConfiguration.getSpecifiedRules() != null) {
            this.filterChecks();
            this.filterComplianceCategories();
        }
        if (this.fConfiguration.getSpecifiedAutocorrectRules() != null) {
            this.enableAutocorrectChecks();
        }
        this.initManualChecksStatusParser(config.getManualChecksStatusFile());
        this.loadManualChecksStatus();
        if (this.getLibraryKind() == 2) {
            this.setOVMClassPrefixes("uvm_.*");
            this.setOVMFilePrefixes("uvm_.*|sqr_.*|tlm2_.*|uvm.svh|uvm.sv|base.svh|methodology.svh|tlm2.svh");
        } else {
            this.setOVMClassPrefixes("ovm_.*|avm_.*|urm_.*|tlm_.*|sqr_.*");
            this.setOVMFilePrefixes("ovm_.*|avm_.*|urm_.*|tlm_.*|sqr_.*|ovm.svh|base.svh|base_compatibility.svh|compatibility.svh|methodology.svh|tlm.svh");
        }
        if (this.fRulesetConfiguration.getSkipFiles() != null) {
            this.setOVMFilePrefixes(this.fRulesetConfiguration.getSkipFiles());
        }
        if (this.fRulesetConfiguration.getSkipElements() != null) {
            this.setOVMClassPrefixes(this.fRulesetConfiguration.getSkipElements());
        }
        this.setIncludeHTMLCode(config.getIncludeCodeHTMLReport());
        this.fReportManager = new ReportManager();
    }

    public void loadRuleset() {
        this.fRuleset.initialize(this);
        this.fRuleset.load();
    }

    public void filterChecks() {
        List<String> specifiedRules = this.fConfiguration.getSpecifiedRules();
        if (specifiedRules == null) {
            return;
        }
        OVMComplianceCheckFilters.filterChecks(this.fChecks, OVMComplianceCheckFilters.isSpecifiedRuleByName(specifiedRules).negate());
    }

    public void filterComplianceCategories() {
        List<String> specifiedRules = this.fConfiguration.getSpecifiedRules();
        if (specifiedRules == null) {
            return;
        }
        OVMComplianceCheckFilters.filterChecksOfCategories(this.fComplianceCategories, OVMComplianceCheckFilters.isSpecifiedRuleByName(specifiedRules).negate());
    }

    public void enableAutocorrectChecks() {
        List<String> specifiedAutocorrectRules = this.fConfiguration.getSpecifiedAutocorrectRules();
        for (OVMComplianceCheck check : this.fChecks) {
            if (!specifiedAutocorrectRules.contains(check.getName())) continue;
            check.setAutoCorrectEnabled(true);
        }
    }

    public boolean checkRulesExistence(List<String> specifiedRules) {
        String fileName;
        if (specifiedRules == null) {
            return true;
        }
        specifiedRules.removeAll(this.fChecks.stream().map(OVMComplianceCheck::getName).collect(Collectors.toList()));
        File file = this.fConfiguration.getRulesetFile();
        if (file == null || file.getName().isEmpty()) {
            RulesetKind rulesetKind = this.fConfiguration.getRulesetKind();
            fileName = rulesetKind.getName();
        } else {
            fileName = file.getName();
        }
        StringBuilder nonexistentRules = new StringBuilder();
        for (String rule : specifiedRules) {
            nonexistentRules.append(String.valueOf(rule) + ", ");
        }
        if (specifiedRules.isEmpty()) {
            return true;
        }
        nonexistentRules.delete(nonexistentRules.length() - 2, nonexistentRules.length());
        DVTLogger.INSTANCE.logError("ERROR: Rules: {" + nonexistentRules.toString() + "} do not exist in " + fileName + "!");
        return false;
    }

    public boolean checkRulesSupportAutocorrect(List<String> specifiedAutocorrectRules) {
        if (specifiedAutocorrectRules == null || specifiedAutocorrectRules.isEmpty()) {
            return true;
        }
        StringBuilder rulesNotSupportingAutocorrect = new StringBuilder();
        for (OVMComplianceCheck check : this.fChecks) {
            if (!specifiedAutocorrectRules.contains(check.getName()) || check.isAutocorrectable()) continue;
            rulesNotSupportingAutocorrect.append(String.valueOf(check.getName()) + ", ");
        }
        if (rulesNotSupportingAutocorrect.toString().isEmpty()) {
            return true;
        }
        rulesNotSupportingAutocorrect.delete(rulesNotSupportingAutocorrect.length() - 2, rulesNotSupportingAutocorrect.length());
        DVTLogger.INSTANCE.logError("ERROR: Rules: {" + rulesNotSupportingAutocorrect.toString() + "} do not support autocorrecting!");
        return false;
    }

    public ArrayList<OVMComplianceCheck> getChecks() {
        return this.fChecks;
    }

    public void clean(boolean clearChecks, boolean clearWaivers) {
        if (clearWaivers && this.fProjectWaivers != null) {
            this.fProjectWaivers.clean();
        }
        if (clearChecks && this.fChecks != null) {
            this.fChecks.forEach(c -> c.clean());
        }
        this.fReportManager.clear(clearChecks);
        this.fAPIFactory = null;
        this.fCheckExceptions.clear();
        this.fTimedOutProcess = false;
        this.fTimedOutSession = false;
        this.fTimedOutChecks = false;
        this.fMemoryMonitorError = false;
        if (this.fWhitespaceParser != null) {
            this.fWhitespaceParser.clean();
        }
        this.fWhitespaceParser = null;
        this.fTests.clear();
        this.fTestbenches.clear();
        this.fEnvs.clear();
        this.fAgents.clear();
        this.fMonitors.clear();
        this.fDrivers.clear();
        this.fSequencers.clear();
        this.fSequences.clear();
        this.fSequenceItems.clear();
        this.fScoreboards.clear();
        this.fCoverageCollectors.clear();
        this.fConfigurationObjects.clear();
        this.fActiveComponents.clear();
        this.fReactiveComponents.clear();
        if (this.fExecutionFlowGraphs != null) {
            this.fExecutionFlowGraphs.values().forEach(efg -> efg.clean());
            this.fExecutionFlowGraphs.clear();
        }
        this.printMessageByRule.clear();
        if (this.fXVMSubclasses != null) {
            this.fXVMSubclasses.values().forEach(c -> c.clear());
        }
        this.fXVMSubclasses = null;
        this.fAllClasses = null;
        this.fAllNonXVMClasses = null;
        this.fAllComponents = null;
        this.fAllObjects = null;
        this.fAllFields = null;
        this.fAllFunctions = null;
        this.fAllFunctionCallContainers = null;
        this.fAllNonXVMFunctionCallContainers = null;
        this.fAllAssertsExpects = null;
        this.fAllInterfaces = null;
        this.fAllTasks = null;
        this.fAllTypes = null;
        this.fAllTypedefs = null;
        this.fAllPorts = null;
        this.fAllFifos = null;
        this.fAllMacros = null;
        this.fAllCreateCalls = null;
        this.fAllNewCalls = null;
        this.fAllStructs = null;
        this.fAllSequenceListFilesAndImportedSequences = null;
        this.fAllSequenceListFilesByName = null;
        this.fAllImportedFiles = null;
        this.fAllIncludedFiles = null;
        this.fAllFilesInIncludeOrder = null;
        this.fAllFilesWithIncludes = null;
        this.fAllSVTBCharIssues.clear();
        this.fAllPackages = null;
        this.fAllModules = null;
        this.fAllConstraints = null;
        this.fAllClockingBlocks = null;
        this.fAllModports = null;
        this.fAllCovergroups = null;
        this.fAllUnions = null;
        this.fAllInstances = null;
        this.fAllCheckers = null;
        this.fAllConfigurations = null;
        this.fAllPrimitives = null;
        this.fAllPrograms = null;
        this.fAllProperties = null;
        this.fAllSequences = null;
        this.fEnvClass = null;
        this.fAgentClass = null;
        this.fMonitorClass = null;
        this.fDriverClass = null;
        this.fSequencerClass = null;
        this.fSequenceClass = null;
        this.fSequenceItemClass = null;
        this.fSequenceLibraryClass = null;
        this.fScoreboardClass = null;
        this.fTestClass = null;
        this.cleanDriverAndVirtualSequencers();
    }

    private void cleanDriverAndVirtualSequencers() {
        if (this.fDriverSequencers != null) {
            this.fDriverSequencers.clear();
            this.fDriverSequencers = null;
        }
        if (this.fVirtualSequencers != null) {
            this.fVirtualSequencers.clear();
            this.fVirtualSequencers = null;
        }
    }

    public IProject getProject() {
        return this.fProject;
    }

    public LinkedHashMap<String, Map<String, RfClass>> getCategories() {
        return this.fCategories;
    }

    public APIFactory getAPIFactory() {
        if (this.fAPIFactory == null) {
            this.fAPIFactory = new APIFactory(this);
        }
        return this.fAPIFactory;
    }

    public void initialize(RfProject rfProject, boolean clearChecks, boolean clearWaivers) {
        if (this.getConfiguration().getRulesetKind() != RulesetKind.IMPORT_FROM_HTML && !this.fReapplyOrRerun) {
            this.clean(clearChecks, clearWaivers);
        }
        if (this.fReapplyOrRerun) {
            this.clean(false, false);
        }
        this.fRfProject = rfProject;
        if (rfProject == null) {
            return;
        }
        this.fRfProject.initLintExprFactory();
        if (clearWaivers && (this.getConfiguration().getRulesetKind() != RulesetKind.IMPORT_FROM_HTML || this.fReapplyOrRerun)) {
            this.fProjectWaivers.load();
        }
        this.loadManualChecksStatus();
        if (this.fRulesetConfiguration.getArchitecture() != null) {
            for (RulesetComponent component : this.fRulesetConfiguration.getArchitecture().getComponents()) {
                if (component.getType() == RulesetComponent.ComponentType.AGENT) {
                    if (component.getBaseClass() == null) continue;
                    this.fAgentBaseClass = component.getBaseClass();
                    continue;
                }
                if (component.getType() == RulesetComponent.ComponentType.DRIVER) {
                    if (component.getBaseClass() == null) continue;
                    this.fDriverBaseClass = component.getBaseClass();
                    continue;
                }
                if (component.getType() == RulesetComponent.ComponentType.MONITOR) {
                    if (component.getBaseClass() == null) continue;
                    this.fMonitorBaseClass = component.getBaseClass();
                    continue;
                }
                if (component.getType() == RulesetComponent.ComponentType.ENVIRONMENT) {
                    if (component.getBaseClass() == null) continue;
                    this.fEnvBaseClass = component.getBaseClass();
                    continue;
                }
                if (component.getType() == RulesetComponent.ComponentType.SCOREBOARD) {
                    if (component.getBaseClass() == null) continue;
                    this.fScoreboardBaseClass = component.getBaseClass();
                    continue;
                }
                if (component.getType() == RulesetComponent.ComponentType.TEST) {
                    if (component.getBaseClass() == null) continue;
                    this.fTestBaseClass = component.getBaseClass();
                    continue;
                }
                if (component.getType() == RulesetComponent.ComponentType.COVERAGE_COLLECTOR) {
                    if (component.getBaseClass() == null) continue;
                    this.fCoverageCollectorBaseClass = component.getBaseClass();
                    continue;
                }
                if (component.getType() == RulesetComponent.ComponentType.SEQUENCE_ITEM) {
                    if (component.getBaseClass() == null) continue;
                    this.fSequenceItemBaseClass = component.getBaseClass();
                    continue;
                }
                if (component.getType() == RulesetComponent.ComponentType.SEQUENCER) {
                    if (component.getBaseClass() == null) continue;
                    this.fSequencerBaseClass = component.getBaseClass();
                    continue;
                }
                if (component.getType() == RulesetComponent.ComponentType.SEQUENCE) {
                    if (component.getBaseClass() == null) continue;
                    this.fSequenceBaseClass = component.getBaseClass();
                    continue;
                }
                if (component.getType() == RulesetComponent.ComponentType.TESTBENCH) {
                    if (component.getBaseClass() == null) continue;
                    this.fTestbenchBaseClass = component.getBaseClass();
                    continue;
                }
                if (component.getType() == RulesetComponent.ComponentType.CONFIGURATION_OBJECT) {
                    if (component.getBaseClass() == null) continue;
                    this.fConfigurationObjectBaseClass = component.getBaseClass();
                    continue;
                }
                if (component.getType() == RulesetComponent.ComponentType.ACTIVE_COMPONENT) {
                    if (component.getBaseClass() == null) continue;
                    this.fActiveComponentBaseClass = component.getBaseClass();
                    continue;
                }
                if (component.getType() != RulesetComponent.ComponentType.REACTIVE_COMPONENT || component.getBaseClass() == null) continue;
                this.fReactiveComponentBaseClass = component.getBaseClass();
            }
        }
    }

    public void initializeComponents() {
        if (this.fRfProject == null) {
            return;
        }
        NullProtectedList<RfClass> allClasses = this.getAllClasses();
        for (RfClass rfClass : allClasses) {
            if (OVMUtils.prependLibraryPrefixTo(this.fLibraryKind, "_test").equals(rfClass.getName())) {
                this.fOvmTest = rfClass;
            } else if (OVMUtils.prependLibraryPrefixTo(this.fLibraryKind, "_env").equals(rfClass.getName())) {
                this.fOvmEnv = rfClass;
            } else if (OVMUtils.prependLibraryPrefixTo(this.fLibraryKind, "_agent").equals(rfClass.getName())) {
                this.fOvmAgent = rfClass;
            } else if (OVMUtils.prependLibraryPrefixTo(this.fLibraryKind, "_monitor").equals(rfClass.getName())) {
                this.fOvmMonitor = rfClass;
            } else if (OVMUtils.prependLibraryPrefixTo(this.fLibraryKind, "_driver").equals(rfClass.getName())) {
                this.fOvmDriver = rfClass;
            } else if (OVMUtils.prependLibraryPrefixTo(this.fLibraryKind, "_sequencer").equals(rfClass.getName())) {
                this.fOvmSequencer = rfClass;
            } else if (OVMUtils.prependLibraryPrefixTo(this.fLibraryKind, "_sequence").equals(rfClass.getName())) {
                this.fOvmSequence = rfClass;
            } else if (OVMUtils.prependLibraryPrefixTo(this.fLibraryKind, "_sequence_item").equals(rfClass.getName())) {
                this.fOvmSequenceItem = rfClass;
            } else if (OVMUtils.prependLibraryPrefixTo(this.fLibraryKind, "_sequence_library").equals(rfClass.getName())) {
                this.fOvmSequenceLibrary = rfClass;
            } else if (OVMUtils.prependLibraryPrefixTo(this.fLibraryKind, "_analysis_port").equals(rfClass.getName())) {
                this.fOvmAnalysisPort = rfClass;
            } else if (OVMUtils.prependLibraryPrefixTo(this.fLibraryKind, "_scoreboard").equals(rfClass.getName())) {
                this.fOvmScoreboard = rfClass;
            } else if (OVMUtils.prependLibraryPrefixTo(this.fLibraryKind, "_component").equals(rfClass.getName())) {
                this.fOvmComponent = rfClass;
            }
            if (this.fEnvBaseClass != null && this.fEnvBaseClass.equals(rfClass.getName())) {
                this.fEnvClass = rfClass;
            }
            if (this.fAgentBaseClass != null && this.fAgentBaseClass.equals(rfClass.getName())) {
                this.fAgentClass = rfClass;
            }
            if (this.fMonitorBaseClass != null && this.fMonitorBaseClass.equals(rfClass.getName())) {
                this.fMonitorClass = rfClass;
            }
            if (this.fDriverBaseClass != null && this.fDriverBaseClass.equals(rfClass.getName())) {
                this.fDriverClass = rfClass;
            }
            if (this.fSequencerBaseClass != null && this.fSequencerBaseClass.equals(rfClass.getName())) {
                this.fSequencerClass = rfClass;
            }
            if (this.fSequenceBaseClass != null && this.fSequenceBaseClass.equals(rfClass.getName())) {
                this.fSequenceClass = rfClass;
            }
            if (this.fSequenceItemBaseClass != null && this.fSequenceItemBaseClass.equals(rfClass.getName())) {
                this.fSequenceItemClass = rfClass;
            }
            if (this.fScoreboardBaseClass != null && this.fScoreboardBaseClass.equals(rfClass.getName())) {
                this.fScoreboardClass = rfClass;
            }
            if (this.fTestBaseClass != null && this.fTestBaseClass.equals(rfClass.getName())) {
                this.fTestClass = rfClass;
            }
            if (this.fCoverageCollectorBaseClass != null && this.fCoverageCollectorBaseClass.equals(rfClass.getName())) {
                this.fCoverageCollectorClass = rfClass;
            }
            if (this.fTestbenchBaseClass != null && this.fTestbenchBaseClass.equals(rfClass.getName())) {
                this.fTestbenchClass = rfClass;
            }
            if (this.fConfigurationObjectBaseClass != null && this.fConfigurationObjectBaseClass.equals(rfClass.getName())) {
                this.fConfigurationObjectClass = rfClass;
            }
            if (this.fActiveComponentBaseClass != null && this.fActiveComponentBaseClass.equals(rfClass.getName())) {
                this.fActiveComponentClass = rfClass;
            }
            if (this.fReactiveComponentBaseClass == null || !this.fReactiveComponentBaseClass.equals(rfClass.getName())) continue;
            this.fReactiveComponentClass = rfClass;
        }
        if (this.fTestClass == null && this.fTestBaseClass == null) {
            this.fTestClass = this.fOvmTest;
        }
        if (this.fEnvClass == null && this.fEnvBaseClass == null) {
            this.fEnvClass = this.fOvmEnv;
        }
        if (this.fAgentClass == null && this.fAgentBaseClass == null) {
            this.fAgentClass = this.fOvmAgent;
        }
        if (this.fMonitorClass == null && this.fMonitorBaseClass == null) {
            this.fMonitorClass = this.fOvmMonitor;
        }
        if (this.fDriverClass == null && this.fDriverBaseClass == null) {
            this.fDriverClass = this.fOvmDriver;
        }
        if (this.fSequenceClass == null && this.fSequenceBaseClass == null) {
            this.fSequenceClass = this.fOvmSequence;
        }
        if (this.fSequencerClass == null && this.fSequencerBaseClass == null) {
            this.fSequencerClass = this.fOvmSequencer;
        }
        if (this.fSequenceItemClass == null && this.fSequenceItemBaseClass == null) {
            this.fSequenceItemClass = this.fOvmSequenceItem;
        }
        if (this.fSequenceLibraryClass == null) {
            this.fSequenceLibraryClass = this.fOvmSequenceLibrary;
        }
        if (this.fScoreboardClass == null && this.fScoreboardBaseClass == null) {
            this.fScoreboardClass = this.fOvmScoreboard;
        }
        for (RfClass rfClass : allClasses) {
            if (this.fProgressMonitor != null && this.fProgressMonitor.isCanceled()) {
                return;
            }
            if (!rfClass.equals(this.fTestClass) && LintUtils.isSubClassOf(rfClass, this.fTestClass)) {
                this.fTests.put(rfClass.getFullName(), rfClass);
            }
            if (!rfClass.equals(this.fConfigurationObjectClass) && LintUtils.isSubClassOf(rfClass, this.fConfigurationObjectClass)) {
                this.fConfigurationObjects.put(rfClass.getFullName(), rfClass);
            }
            if (!rfClass.equals(this.fTestbenchClass) && LintUtils.isSubClassOf(rfClass, this.fTestbenchClass)) {
                this.fTestbenches.put(rfClass.getFullName(), rfClass);
            } else if (!rfClass.equals(this.fEnvClass) && LintUtils.isSubClassOf(rfClass, this.fEnvClass)) {
                this.fEnvs.put(rfClass.getFullName(), rfClass);
            }
            if (!rfClass.equals(this.fAgentClass) && LintUtils.isSubClassOf(rfClass, this.fAgentClass)) {
                this.fAgents.put(rfClass.getFullName(), rfClass);
            }
            if (!rfClass.equals(this.fMonitorClass) && LintUtils.isSubClassOf(rfClass, this.fMonitorClass)) {
                this.fMonitors.put(rfClass.getFullName(), rfClass);
            }
            if (!rfClass.equals(this.fScoreboardClass) && LintUtils.isSubClassOf(rfClass, this.fScoreboardClass)) {
                this.fScoreboards.put(rfClass.getFullName(), rfClass);
            }
            if (!rfClass.equals(this.fCoverageCollectorClass) && LintUtils.isSubClassOf(rfClass, this.fCoverageCollectorClass)) {
                this.fCoverageCollectors.put(rfClass.getFullName(), rfClass);
            }
            if (!rfClass.equals(this.fDriverClass) && LintUtils.isSubClassOf(rfClass, this.fDriverClass)) {
                this.fDrivers.put(rfClass.getFullName(), rfClass);
            }
            if (!rfClass.equals(this.fSequencerClass) && LintUtils.isSubClassOf(rfClass, this.fSequencerClass)) {
                this.fSequencers.put(rfClass.getFullName(), rfClass);
            }
            if (!rfClass.equals(this.fSequenceClass) && LintUtils.isSubClassOf(rfClass, this.fSequenceClass) && !LintUtils.isSubClassOf(rfClass, this.fSequenceLibraryClass)) {
                this.fSequences.put(rfClass.getFullName(), rfClass);
            } else if (!rfClass.equals(this.fSequenceItemClass) && LintUtils.isSubClassOf(rfClass, this.fSequenceItemClass) && !this.isOVMElement(rfClass)) {
                this.fSequenceItems.put(rfClass.getFullName(), rfClass);
            }
            if (!rfClass.equals(this.fOvmComponent) && LintUtils.isSubClassOf(rfClass, this.fOvmComponent) && !this.isOVMElement(rfClass) && !rfClass.equals(this.fActiveComponentClass) && LintUtils.isSubClassOf(rfClass, this.fActiveComponentClass)) {
                this.fActiveComponents.put(rfClass.getFullName(), rfClass);
            }
            if (rfClass.equals(this.fOvmComponent) || !LintUtils.isSubClassOf(rfClass, this.fOvmComponent) || this.isOVMElement(rfClass) || rfClass.equals(this.fReactiveComponentClass) || !LintUtils.isSubClassOf(rfClass, this.fReactiveComponentClass)) continue;
            this.fReactiveComponents.put(rfClass.getFullName(), rfClass);
        }
        this.cleanDriverAndVirtualSequencers();
    }

    public Map<String, RfClass> getDriverSequencers() {
        if (this.fDriverSequencers != null) {
            return this.fDriverSequencers;
        }
        this.computeDriverSequencers();
        return this.fDriverSequencers;
    }

    public Map<String, RfClass> getVirtualSequencers() {
        if (this.fVirtualSequencers != null) {
            return this.fVirtualSequencers;
        }
        if (this.fDriverSequencers == null) {
            this.computeDriverSequencers();
        }
        this.computeVirtualSequencers();
        return this.fVirtualSequencers;
    }

    public void preFullBuildNotification(RfProject aRfProject) {
        aRfProject.startLintTracking();
        for (OVMComplianceCheck check : this.fChecks) {
            Boolean isDisabled = this.fProjectWaivers.isDisabled(check);
            if (isDisabled == null ? !check.isEnabled() : isDisabled != false) continue;
            check.preBuildNotification(aRfProject);
        }
    }

    public WaiversModel getProjectWaivers() {
        return this.fProjectWaivers;
    }

    public void resetProjectWaivers() {
        this.fProjectWaivers = new WaiversModel();
    }

    public void checkWaivers() {
        this.fProjectWaivers.parseWaiversXML(true);
    }

    private void computeDriverSequencers() {
        this.fDriverSequencers = new LinkedHashMap<String, RfClass>();
        NullProtectedList<RfNamedElement> allComponents = this.getAllTypes();
        for (RfNamedElement component : allComponents) {
            RfClass sequencer;
            String argument;
            List<RfFunctionCall> fctCalls;
            Object fieldType;
            ArrayList localSequencers = new ArrayList();
            ArrayList<RfField> localDrivers = new ArrayList<RfField>();
            List<RfField> candidates = component.getFieldsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            for (RfField candidate : candidates) {
                fieldType = LintUtils.getFieldFinalClassTypeOrNull(candidate);
                if (fieldType == null) continue;
                if (this.isSequencerOrTheOVMSequencer((RfClass)fieldType)) {
                    localSequencers.add(candidate);
                    continue;
                }
                if (!this.isDriver((RfClass)fieldType)) continue;
                localDrivers.add(candidate);
            }
            if (localSequencers.isEmpty() || localDrivers.isEmpty()) continue;
            List<RfFunction> componentFunctions = component.getFunctionsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            fieldType = localSequencers.iterator();
            while (fieldType.hasNext()) {
                RfField sequencerField = (RfField)fieldType.next();
                fctCalls = component.getFunctionCallsWithPrefix(String.valueOf(sequencerField.getName()) + ".seq_item_export.connect", 1);
                fctCalls.addAll(component.getFunctionCallsWithPrefix(String.valueOf(sequencerField.getName()) + ".seq_item_cons_if.connect_if", 1));
                if (componentFunctions != null) {
                    for (RfFunction componentFunction : componentFunctions) {
                        if (this.isOVMElement(componentFunction)) continue;
                        fctCalls.addAll(componentFunction.getFunctionCallsWithPrefix(String.valueOf(sequencerField.getName()) + ".seq_item_export.connect", 1));
                        fctCalls.addAll(componentFunction.getFunctionCallsWithPrefix(String.valueOf(sequencerField.getName()) + ".seq_item_cons_if.connect_if", 1));
                    }
                }
                if (fctCalls.isEmpty()) continue;
                for (RfFunctionCall functionCall : fctCalls) {
                    argument = functionCall.getArgumentValue(0);
                    if (argument == null) continue;
                    for (RfField driverField : localDrivers) {
                        if (!argument.equals(String.valueOf(driverField.getName()) + ".seq_item_port") && !argument.equals(String.valueOf(driverField.getName()) + ".seq_item_prod_if") || (sequencer = LintUtils.getFieldFinalClassTypeOrNull(sequencerField)) == null || this.fDriverSequencers.containsKey(sequencer.getFullName())) continue;
                        this.fDriverSequencers.put(sequencer.getFullName(), sequencer);
                    }
                }
            }
            for (RfField driverField : localDrivers) {
                fctCalls = component.getFunctionCallsWithPrefix(String.valueOf(driverField.getName()) + ".seq_item_port.connect", 1);
                fctCalls.addAll(component.getFunctionCallsWithPrefix(String.valueOf(driverField.getName()) + ".seq_item_prod_if.connect_if", 1));
                if (componentFunctions != null) {
                    for (RfFunction componentFunction : componentFunctions) {
                        if (this.isOVMElement(componentFunction)) continue;
                        fctCalls.addAll(componentFunction.getFunctionCallsWithPrefix(String.valueOf(driverField.getName()) + ".seq_item_port.connect", 1));
                        fctCalls.addAll(componentFunction.getFunctionCallsWithPrefix(String.valueOf(driverField.getName()) + ".seq_item_prod_if.connect_if", 1));
                    }
                }
                if (fctCalls.isEmpty()) continue;
                for (RfFunctionCall functionCall : fctCalls) {
                    argument = functionCall.getArgumentValue(0);
                    if (argument == null) continue;
                    Iterator iterator = localSequencers.iterator();
                    while (iterator.hasNext()) {
                        RfField sequencerField = (RfField)iterator.next();
                        if (!argument.equals(String.valueOf(sequencerField.getName()) + ".seq_item_export") && !argument.equals(String.valueOf(sequencerField.getName()) + ".seq_item_cons_if") || (sequencer = LintUtils.getFieldFinalClassTypeOrNull(sequencerField)) == null || this.fDriverSequencers.containsKey(sequencer.getFullName())) continue;
                        this.fDriverSequencers.put(sequencer.getFullName(), sequencer);
                    }
                }
            }
        }
        String defaultParamValueName = this.fLibraryKind == 2 ? "uvm_sequence_item" : "ovm_sequence_item";
        for (RfClass sequencer : this.fSequencers.values()) {
            ArgInfo argInfo;
            DataType parentDT;
            if (sequencer == null || (parentDT = sequencer.getExtendedType()) == null) continue;
            List<DataType> orderedParams = parentDT.getOrderedParamAssignments();
            Map<String, ArgInfo> namedParams = parentDT.getNamedParamAssignments();
            if (orderedParams != null && !orderedParams.isEmpty()) {
                DataType dataType;
                if (!orderedParams.isEmpty() && (dataType = orderedParams.get(0)) != null && !defaultParamValueName.equals(dataType.getType())) {
                    this.fDriverSequencers.put(sequencer.getFullName(), sequencer);
                }
                if (orderedParams.size() == 2 && (dataType = orderedParams.get(1)) != null && !defaultParamValueName.equals(dataType.getType())) {
                    this.fDriverSequencers.put(sequencer.getFullName(), sequencer);
                }
            }
            if (namedParams == null || namedParams.isEmpty()) continue;
            ArrayList<ArgInfo> namedParamsList = new ArrayList<ArgInfo>(namedParams.values());
            if (!namedParamsList.isEmpty() && (argInfo = (ArgInfo)namedParamsList.get(0)) != null && argInfo.getDataType() != null && !defaultParamValueName.equals(argInfo.getDataType().getType())) {
                this.fDriverSequencers.put(sequencer.getFullName(), sequencer);
            }
            if (namedParamsList.size() != 2 || (argInfo = (ArgInfo)namedParamsList.get(1)) == null || argInfo.getDataType() == null || defaultParamValueName.equals(argInfo.getDataType().getType())) continue;
            this.fDriverSequencers.put(sequencer.getFullName(), sequencer);
        }
        boolean change = true;
        while (change) {
            change = false;
            for (RfClass sequencer : this.fSequencers.values()) {
                RfClass parent;
                if (sequencer == null || this.fDriverSequencers.containsKey(sequencer.getFullName()) || (parent = sequencer.getParent()) == null || !this.fDriverSequencers.containsKey(parent.getFullName())) continue;
                change = true;
                this.fDriverSequencers.put(sequencer.getFullName(), sequencer);
            }
        }
    }

    private void computeVirtualSequencers() {
        this.fVirtualSequencers = new LinkedHashMap<String, RfClass>();
        for (RfClass sequencer : this.fSequencers.values()) {
            if (sequencer == null || this.fDriverSequencers.containsKey(sequencer.getFullName())) continue;
            this.fVirtualSequencers.put(sequencer.getFullName(), sequencer);
        }
    }

    public ExecutionFlowGraph getExecutionFlowGraph(RfNamedElement namedElement, OVMComplianceCheck check, boolean checkInsideMethodCall) {
        ExecutionFlowGraph executionFlowGraph = this.fExecutionFlowGraphs.get(namedElement);
        if (executionFlowGraph == null) {
            executionFlowGraph = new ExecutionFlowGraph(namedElement, check, this.getProjectWaivers(), checkInsideMethodCall);
            this.fExecutionFlowGraphs.put(namedElement, executionFlowGraph);
        } else {
            executionFlowGraph.reset(check);
        }
        return executionFlowGraph;
    }

    public NullProtectedList<RfNamedElement> getAllFields() {
        if (this.fAllFields != null) {
            return this.fAllFields;
        }
        if (this.fRfProject == null) {
            return new NullProtectedList<RfNamedElement>();
        }
        RfField[] allFields = this.fRfProject.getAllFields();
        this.fAllFields = new NullProtectedList();
        if (allFields == null) {
            return this.fAllFields;
        }
        RfField[] rfFieldArray = allFields;
        int n = allFields.length;
        int n2 = 0;
        while (n2 < n) {
            RfNamedElement container;
            RfField elm = rfFieldArray[n2];
            if (!(elm.isPredefined() || elm.getFile() == null || this.isOVMFile(elm.getFile().getName()) || !((container = elm.getClosestTypeContainer()) instanceof RfProject) && this.isOVMElement(container))) {
                this.fAllFields.add(elm);
            }
            ++n2;
        }
        return this.fAllFields;
    }

    public NullProtectedList<RfNamedElement> getAllFunctions() {
        if (this.fAllFunctions != null) {
            return this.fAllFunctions;
        }
        if (this.fRfProject == null) {
            return new NullProtectedList<RfNamedElement>();
        }
        this.fAllFunctions = new NullProtectedList();
        NullProtectedList<RfNamedElement> allTypes = this.getAllTypes();
        for (RfNamedElement type : allTypes) {
            this.fAllFunctions.addAll(this.getAllMethodsFromType(type, false));
        }
        return this.fAllFunctions;
    }

    public List<RfFunction> getAllMethodsFromType(RfNamedElement type, boolean includeTasks) {
        if (this.isOVMElement(type)) {
            return Collections.emptyList();
        }
        List<RfFunction> functions = type.getFunctionsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        functions.addAll(type.getConstructorsWithPrefix("new", 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE));
        if (includeTasks) {
            functions.addAll(type.getTasksWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE));
        }
        ArrayList<RfFunction> result = new ArrayList<RfFunction>();
        for (RfFunction elm : functions) {
            RfNamedElement container;
            if (elm instanceof RfPredefinedFunction || elm.getFile() != null && this.isOVMFile(elm.getFile().getName()) || this.isOVMElement(container = elm.getClosestTypeContainer())) continue;
            result.add(elm);
        }
        return result;
    }

    public NullProtectedList<RfNamedElement> getAllTasks() {
        if (this.fAllTasks != null) {
            return this.fAllTasks;
        }
        if (this.fRfProject == null) {
            return new NullProtectedList<RfNamedElement>();
        }
        this.fAllTasks = new NullProtectedList();
        RfFunction[] rfFunctionArray = this.fRfProject.getAllFunctionsAndTasks();
        int n = rfFunctionArray.length;
        int n2 = 0;
        while (n2 < n) {
            RfFunction elm = rfFunctionArray[n2];
            if (elm != null && elm.isTask() && !elm.isPredefined() && !this.isOVMElement(elm)) {
                this.fAllTasks.add(elm);
            }
            ++n2;
        }
        return this.fAllTasks;
    }

    public NullProtectedList<RfNamedElement> getAllPorts() {
        if (this.fAllPorts != null) {
            return this.fAllPorts;
        }
        if (this.fRfProject == null) {
            return new NullProtectedList<RfNamedElement>();
        }
        this.fAllPorts = new NullProtectedList();
        for (RfNamedElement field : this.getAllFields()) {
            String clazzName;
            RfClass clazz = LintUtils.getFieldFinalClassTypeOrNull((RfField)field);
            if (clazz == null || !this.isOVMElement(clazz) || !(clazzName = clazz.getName()).endsWith("_port") && !clazzName.endsWith("_export")) continue;
            this.fAllPorts.add(field);
        }
        return this.fAllPorts;
    }

    public NullProtectedList<RfNamedElement> getAllFifos() {
        if (this.fAllFifos != null) {
            return this.fAllFifos;
        }
        if (this.fRfProject == null) {
            return new NullProtectedList<RfNamedElement>();
        }
        this.fAllFifos = new NullProtectedList();
        NullProtectedList<RfNamedElement> allFields = this.getAllFields();
        for (RfNamedElement field : allFields) {
            RfClass clazz = LintUtils.getFieldFinalClassTypeOrNull((RfField)field);
            if (clazz == null || !this.isLibraryFifo(clazz)) continue;
            this.fAllFifos.add(field);
        }
        return this.fAllFifos;
    }

    public boolean isLibraryFifo(RfClass clazz) {
        return this.isOVMElement(clazz) && clazz.getName().endsWith("_fifo");
    }

    public NullProtectedList<VlogMacroInfo> getAllMacros() {
        if (this.fAllMacros != null) {
            return this.fAllMacros;
        }
        if (this.fRfProject == null) {
            return new NullProtectedList<VlogMacroInfo>();
        }
        this.fAllMacros = new NullProtectedList();
        List<VlogMacroInfo> allMacros = this.fRfProject.getAllMacros();
        for (VlogMacroInfo macro : allMacros) {
            VlogFileInstance fileInstance;
            if (macro == null || macro.isPredefined() || (fileInstance = macro.getFileInstance()) == null || this.isOVMFile(fileInstance.getShortFileName()) || fileInstance.getShortFileName().startsWith(TOPFILE_PREFIX)) continue;
            this.fAllMacros.add(macro);
        }
        return this.fAllMacros;
    }

    public NullProtectedList<RfNamedElement> getAllCovergroups() {
        if (this.fAllCovergroups != null) {
            return this.fAllCovergroups;
        }
        if (this.fRfProject == null) {
            return new NullProtectedList<RfNamedElement>();
        }
        RfCovergroup[] allCovergroups = this.fRfProject.getAllCovergroups();
        this.fAllCovergroups = new NullProtectedList();
        RfCovergroup[] rfCovergroupArray = allCovergroups;
        int n = allCovergroups.length;
        int n2 = 0;
        while (n2 < n) {
            RfCovergroup elm = rfCovergroupArray[n2];
            if (!this.isOVMElement(elm)) {
                this.fAllCovergroups.add(elm);
            }
            ++n2;
        }
        return this.fAllCovergroups;
    }

    public List<MacroCallItem> getAllMacroCallsInClass(RfClass aClass) {
        ArrayList<MacroCallItem> result = new ArrayList<MacroCallItem>();
        MacroCallInfo macroCallInfo = aClass.getMacroCallInfo();
        if (macroCallInfo == null) {
            return result;
        }
        List<MacroCallItem> macroCallItems = macroCallInfo.getItems();
        if (macroCallItems == null || macroCallItems.isEmpty()) {
            return result;
        }
        for (MacroCallItem macroCallItem : macroCallItems) {
            if (macroCallItem == null || this.isOVMFile(macroCallItem.getParserPath().path)) continue;
            result.add(macroCallItem);
        }
        return result;
    }

    public String isFirstMacroArgumentTheClass(MacroCallItem aMacroCallItem, RfClass aRfClass, boolean aSharpIsMandatoryForParameterizedClass, Set<String> validTypeDefs) {
        String firstMacroArgument;
        if (aMacroCallItem == null || aRfClass == null) {
            return "";
        }
        String className = aRfClass.getName();
        String classNameWithPackage = null;
        if (aRfClass.getEnclosingScope() instanceof RfPackage) {
            classNameWithPackage = String.valueOf(aRfClass.getEnclosingScope().getName()) + "::" + aRfClass.getName();
        }
        if ((firstMacroArgument = aMacroCallItem.getMacroParameters()[0]) == null) {
            return "No macro argument found!";
        }
        if (validTypeDefs != null && validTypeDefs.contains(firstMacroArgument) && aMacroCallItem.getName().contains("param")) {
            return null;
        }
        if (aRfClass.hasPortListParameters()) {
            if (aSharpIsMandatoryForParameterizedClass) {
                String firstArgumentTail = null;
                if (firstMacroArgument.startsWith(className)) {
                    firstArgumentTail = firstMacroArgument.substring(className.length());
                } else if (classNameWithPackage != null && firstMacroArgument.startsWith(classNameWithPackage)) {
                    firstArgumentTail = firstMacroArgument.substring(classNameWithPackage.length());
                } else {
                    return "First macro argument should be the class name!";
                }
                if (firstArgumentTail == null) {
                    return "Class name should be followed by #(parameters assignment) in the first macro argument!";
                }
                if ((firstArgumentTail = firstArgumentTail.trim()).startsWith("#")) {
                    return this.checkParameters(aRfClass, aMacroCallItem);
                }
                return "Class name should be followed by #(parameters assignment) in the first macro argument!";
            }
            String firstArgumentTail = null;
            if (firstMacroArgument.startsWith(className)) {
                firstArgumentTail = firstMacroArgument.substring(className.length());
            } else if (classNameWithPackage != null && firstMacroArgument.startsWith(classNameWithPackage)) {
                firstArgumentTail = firstMacroArgument.substring(classNameWithPackage.length());
            } else {
                return "First macro argument should be the class name!";
            }
            if (firstArgumentTail == null) {
                return null;
            }
            if ((firstArgumentTail = firstArgumentTail.trim()).isEmpty() || firstArgumentTail.startsWith("#")) {
                return null;
            }
            return "Class name should be followed by #(parameters assignment) in the first macro argument!";
        }
        if (firstMacroArgument.equals(className)) {
            return null;
        }
        if (classNameWithPackage != null && firstMacroArgument.equals(classNameWithPackage)) {
            return null;
        }
        return "First macro argument should be the class name!";
    }

    private String checkParameters(RfClass aRfClass, MacroCallItem aMacroCallItem) {
        List<RfTypeAlias> typeIds = aRfClass.getTypeAliasesWithPrefix("type_id", 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        List<RfField> parameters = aRfClass.getParametersWithPrefix("", 384, 2, 1);
        ArrayList<String> paramNames = new ArrayList<String>();
        if (parameters != null) {
            for (RfField param : parameters) {
                if (!param.isInParameterPortList()) continue;
                paramNames.add(param.getName());
            }
        }
        if (typeIds == null || typeIds.isEmpty()) {
            return "Incorrect parameter assignments";
        }
        for (RfTypeAlias typeID : typeIds) {
            Map<String, ArgInfo> namedParamAssignments;
            ReparseInfo reparseInfo;
            ReparseInfo.ReparseElement firstElement;
            IRfNamedElement translatedType;
            if (typeID == null || !((translatedType = typeID.getTranslatedType()) instanceof RfSpecializedClass) || typeID.getDeclaration() == null || typeID.getDeclaration().getReparseInfo() == null || (firstElement = (reparseInfo = typeID.getDeclaration().getReparseInfo()).getReparseStack()[0]) == null || !aMacroCallItem.getName().equals("`" + firstElement.getReparseMacroName())) continue;
            DataType translatedDataType = typeID.getTranslatedDataType();
            List<DataType> orderedParamAssignments = translatedDataType.getOrderedParamAssignments();
            if (orderedParamAssignments != null) {
                for (DataType paramDataType : orderedParamAssignments) {
                    if (!paramDataType.getTypeName(null, null).equals(aRfClass.getName())) continue;
                    if (this.checkParametersOrder(paramDataType.getOrderedParamAssignments(), paramDataType.getNamedParamAssignments(), paramNames)) {
                        return null;
                    }
                    return "Incorrect parameter assignments!";
                }
            }
            if ((namedParamAssignments = translatedDataType.getNamedParamAssignments()) == null) continue;
            for (Map.Entry<String, ArgInfo> namedParamAssignment : namedParamAssignments.entrySet()) {
                DataType paramDataType = namedParamAssignment.getValue().getDataType();
                if (paramDataType == null || !paramDataType.getTypeName("", "").equals(aRfClass.getName())) continue;
                if (this.checkParametersOrder(paramDataType.getOrderedParamAssignments(), paramDataType.getNamedParamAssignments(), paramNames)) {
                    return null;
                }
                return "Incorrect parameter assignments!";
            }
        }
        return null;
    }

    private boolean checkParametersOrder(List<DataType> orderedParamAssignments, Map<String, ArgInfo> namedParamAssignments, List<String> paramNames) {
        if (!(paramNames != null && !paramNames.isEmpty() || namedParamAssignments != null && !namedParamAssignments.isEmpty() || orderedParamAssignments != null && !orderedParamAssignments.isEmpty())) {
            return true;
        }
        if (paramNames == null || paramNames.isEmpty()) {
            if (namedParamAssignments != null && !namedParamAssignments.isEmpty()) {
                return false;
            }
            if (orderedParamAssignments != null && !orderedParamAssignments.isEmpty()) {
                return false;
            }
        } else {
            if ((namedParamAssignments == null || namedParamAssignments.isEmpty()) && (orderedParamAssignments == null || orderedParamAssignments.isEmpty())) {
                return false;
            }
            if (orderedParamAssignments != null && !orderedParamAssignments.isEmpty() && orderedParamAssignments.size() == paramNames.size()) {
                int i = 0;
                for (String paramName : paramNames) {
                    if (paramName == null) {
                        return false;
                    }
                    if (i >= orderedParamAssignments.size() || orderedParamAssignments.get(i) == null) {
                        return false;
                    }
                    if (orderedParamAssignments.get(i).getType() == null) {
                        return false;
                    }
                    if (!orderedParamAssignments.get(i).getType().equals(paramName)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            if (namedParamAssignments != null && !namedParamAssignments.isEmpty() && namedParamAssignments.size() == paramNames.size()) {
                for (Map.Entry<String, ArgInfo> entry : namedParamAssignments.entrySet()) {
                    if (entry.getKey() == null) {
                        return false;
                    }
                    if (entry.getValue() == null || entry.getValue().getDataType() == null) {
                        return false;
                    }
                    if (entry.getKey().equals(entry.getValue().getDataType().getType())) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public boolean isOVMElement(RfNamedElement elm) {
        ReparseInfo reparseInfo;
        String file;
        if (this.fLintLibraryContents) {
            return false;
        }
        if (elm.getFile() != null && this.isOVMFile(file = elm.getFile().getName())) {
            return true;
        }
        if (elm.getDeclaration() != null && (reparseInfo = elm.getDeclaration().getReparseInfo()) != null && reparseInfo.getReparseStackSize() > 0) {
            ReparseInfo.ReparseElement[] reparseStack;
            ReparseInfo.ReparseElement[] reparseElementArray = reparseStack = reparseInfo.getReparseStack();
            int n = reparseStack.length;
            int n2 = 0;
            while (n2 < n) {
                String macroFile;
                ReparseInfo.ReparseElement macroElm = reparseElementArray[n2];
                VlogMacroInfo macroInfo = macroElm.getTransientReparseMacroInfo();
                if (macroInfo != null && macroInfo.getFileInstance() != null && macroInfo.getFileInstance().getParserPath() != null && this.isOVMFile(macroFile = LintUtils.getFileShortName(macroInfo.getFileInstance().getParserPath().path))) {
                    return true;
                }
                ++n2;
            }
        }
        if (elm.getFile() == null) {
            return false;
        }
        RfPackage enclosingPackage = elm.getEnclosingScope(RfPackage.class);
        if (enclosingPackage != null && this.fXVMClassNamePattern.matcher(enclosingPackage.getName()).matches()) {
            return true;
        }
        RfClass enclosingClass = elm.getEnclosingScope(RfClass.class);
        if (enclosingClass != null && this.fXVMClassNamePattern.matcher(enclosingClass.getName()).matches()) {
            return true;
        }
        return this.fRulesetConfiguration.getSkipElements() != null && this.fXVMClassNamePattern.matcher(elm.getName()).matches();
    }

    public boolean isOVMFile(String fileName) {
        return OVMUtils.isOVMFile(fileName, this.fLintLibraryContents, this.fXVMFileNamePattern);
    }

    public boolean isReparseStackInOVMFile(ReparseInfo aReparseInfo) {
        ReparseInfo.ReparseElement[] reparseStack;
        if (this.fLintLibraryContents) {
            return false;
        }
        if (aReparseInfo == null || aReparseInfo.getReparseStackSize() == 0) {
            return false;
        }
        ReparseInfo.ReparseElement[] reparseElementArray = reparseStack = aReparseInfo.getReparseStack();
        int n = reparseStack.length;
        int n2 = 0;
        while (n2 < n) {
            ReparseInfo.ReparseElement reparseStackItem = reparseElementArray[n2];
            if (this.isReparseStackFileInOVM(reparseStackItem)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isReparseStackFileInOVM(ReparseInfo.ReparseElement reparseElm) {
        if (this.fLintLibraryContents) {
            return false;
        }
        ParserPath macroFile = reparseElm.getReparseMacroFile();
        if (macroFile != null && macroFile.path != null) {
            String shortFileName = LintUtils.getFileShortName(macroFile.path);
            return this.isOVMFile(shortFileName);
        }
        return false;
    }

    public NullProtectedList<RfClass> getAllClasses() {
        if (this.fAllClasses != null) {
            return this.fAllClasses;
        }
        if (this.fRfProject == null) {
            return new NullProtectedList<RfClass>();
        }
        RfClass[] allClasses = this.fRfProject.getAllClasses();
        this.fAllClasses = new NullProtectedList();
        RfClass[] rfClassArray = allClasses;
        int n = allClasses.length;
        int n2 = 0;
        while (n2 < n) {
            RfClass elm = rfClassArray[n2];
            if (elm != null && elm instanceof RfClass) {
                this.fAllClasses.add(elm);
            }
            ++n2;
        }
        return this.fAllClasses;
    }

    public NullProtectedList<RfNamedElement> getAllNonXVMClasses() {
        if (this.fAllNonXVMClasses != null) {
            return this.fAllNonXVMClasses;
        }
        if (this.fRfProject == null) {
            return new NullProtectedList<RfNamedElement>();
        }
        RfClass[] allClasses = this.fRfProject.getAllClasses();
        this.fAllNonXVMClasses = new NullProtectedList();
        RfClass[] rfClassArray = allClasses;
        int n = allClasses.length;
        int n2 = 0;
        while (n2 < n) {
            RfClass elm = rfClassArray[n2];
            if (!this.isOVMElement(elm)) {
                this.fAllNonXVMClasses.add(elm);
            }
            ++n2;
        }
        return this.fAllNonXVMClasses;
    }

    public Map<String, RfClass> getAllComponents() {
        RfClass[] allProjectClasses;
        if (this.fAllComponents != null) {
            return this.fAllComponents;
        }
        if (this.fRfProject == null) {
            return new LinkedHashMap<String, RfClass>();
        }
        this.fAllComponents = new LinkedHashMap<String, RfClass>();
        RfClass[] rfClassArray = allProjectClasses = this.fRfProject.getAllClasses();
        int n = allProjectClasses.length;
        int n2 = 0;
        while (n2 < n) {
            RfClass elm = rfClassArray[n2];
            if (elm != null && !this.isOVMElement(elm) && elm.isSubClass(OVMUtils.prependLibraryPrefixTo(this.fLibraryKind, "_component"), true)) {
                this.fAllComponents.put(elm.getFullName(), elm);
            }
            ++n2;
        }
        return this.fAllComponents;
    }

    public Map<String, RfClass> getAllObjects() {
        RfClass[] allProjectClasses;
        if (this.fAllObjects != null) {
            return this.fAllObjects;
        }
        if (this.fRfProject == null) {
            return new LinkedHashMap<String, RfClass>();
        }
        this.fAllObjects = new LinkedHashMap<String, RfClass>();
        RfClass[] rfClassArray = allProjectClasses = this.fRfProject.getAllClasses();
        int n = allProjectClasses.length;
        int n2 = 0;
        while (n2 < n) {
            RfClass elm = rfClassArray[n2];
            if (elm != null && !this.isOVMElement(elm) && elm.isSubClass(OVMUtils.prependLibraryPrefixTo(this.fLibraryKind, "_object"), true) && !elm.isSubClass(OVMUtils.prependLibraryPrefixTo(this.fLibraryKind, "_component"), true)) {
                this.fAllObjects.put(elm.getFullName(), elm);
            }
            ++n2;
        }
        return this.fAllObjects;
    }

    public NullProtectedList<RfNamedElement> getAllFunctionCallContainers() {
        if (this.fAllFunctionCallContainers != null) {
            return this.fAllFunctionCallContainers;
        }
        if (this.fRfProject == null) {
            return new NullProtectedList<RfNamedElement>();
        }
        RfNamedElement[] allFunctionCallContainers = this.fRfProject.getAllFunctionCallContainers();
        this.fAllFunctionCallContainers = new NullProtectedList();
        RfNamedElement[] rfNamedElementArray = allFunctionCallContainers;
        int n = allFunctionCallContainers.length;
        int n2 = 0;
        while (n2 < n) {
            RfNamedElement elm = rfNamedElementArray[n2];
            if (!elm.isPredefined()) {
                this.fAllFunctionCallContainers.add(elm);
            }
            ++n2;
        }
        return this.fAllFunctionCallContainers;
    }

    public Set<RfNamedElement> getAllNonXVMFunctionCallContainers() {
        if (this.fAllNonXVMFunctionCallContainers != null) {
            return this.fAllNonXVMFunctionCallContainers;
        }
        if (this.fRfProject == null) {
            return new LinkedHashSet<RfNamedElement>();
        }
        RfNamedElement[] allFunctionCallContainers = this.fRfProject.getAllFunctionCallContainers();
        this.fAllNonXVMFunctionCallContainers = new LinkedHashSet<RfNamedElement>();
        RfNamedElement[] rfNamedElementArray = allFunctionCallContainers;
        int n = allFunctionCallContainers.length;
        int n2 = 0;
        while (n2 < n) {
            RfNamedElement container;
            RfNamedElement elm = rfNamedElementArray[n2];
            if (!(elm.isPredefined() || elm.getFile() != null && this.isOVMFile(elm.getFile().getName()) || this.isOVMElement(container = elm.getClosestTypeContainer()))) {
                this.fAllNonXVMFunctionCallContainers.add(elm);
            }
            ++n2;
        }
        return this.fAllNonXVMFunctionCallContainers;
    }

    public NullProtectedList<RfFunctionCall> getAllCreateCalls() {
        if (this.fAllCreateCalls != null) {
            return this.fAllCreateCalls;
        }
        if (this.fRfProject == null) {
            return new NullProtectedList<RfFunctionCall>();
        }
        this.fAllCreateCalls = new NullProtectedList();
        for (RfNamedElement elm : this.getAllNonXVMFunctionCallContainers()) {
            List<RfFunctionCall> calls = elm.getFunctionCallsWithPrefix("", 2);
            if (calls == null) continue;
            for (RfFunctionCall call : calls) {
                if (!call.getName().endsWith("::type_id::create")) continue;
                this.fAllCreateCalls.add(call);
            }
        }
        return this.fAllCreateCalls;
    }

    public NullProtectedList<RfFunctionCall> getAllNewCalls() {
        if (this.fAllNewCalls != null) {
            return this.fAllNewCalls;
        }
        if (this.fRfProject == null) {
            return new NullProtectedList<RfFunctionCall>();
        }
        this.fAllNewCalls = new NullProtectedList();
        for (RfNamedElement elm : this.getAllNonXVMFunctionCallContainers()) {
            List<RfFunctionCall> calls = elm.getFunctionCallsWithPrefix("new", 1);
            if (calls == null) continue;
            for (RfFunctionCall call : calls) {
                RfNamedElement container;
                if (call == null || call.getFile() == null || this.isOVMFile(call.getFile().getName()) || this.isOVMElement(container = call.getClosestTypeContainer())) continue;
                this.fAllNewCalls.add(call);
            }
        }
        return this.fAllNewCalls;
    }

    public NullProtectedList<RfNamedElement> getAllAssertsExpects() {
        if (this.fAllAssertsExpects != null) {
            return this.fAllAssertsExpects;
        }
        this.fAllAssertsExpects = new NullProtectedList();
        for (RfNamedElement elm : this.getAllNonXVMFunctionCallContainers()) {
            this.fAllAssertsExpects.addAll(elm.getAssertsExpectsWithPrefix("", 2, 1));
        }
        return this.fAllAssertsExpects;
    }

    public NullProtectedList<RfStruct> getAllStructs() {
        if (this.fAllStructs != null) {
            return this.fAllStructs;
        }
        if (this.fRfProject == null) {
            return new NullProtectedList<RfStruct>();
        }
        this.fAllStructs = new NullProtectedList();
        for (RfNamedElement elm : this.getAllNonXVMFunctionCallContainers()) {
            this.getAllStructsUnionsInContainer(elm, false);
        }
        return this.fAllStructs;
    }

    public NullProtectedList<RfStruct> getAllUnions() {
        if (this.fAllUnions != null) {
            return this.fAllUnions;
        }
        if (this.fRfProject == null) {
            return new NullProtectedList<RfStruct>();
        }
        this.fAllUnions = new NullProtectedList();
        for (RfNamedElement elm : this.getAllNonXVMFunctionCallContainers()) {
            this.getAllStructsUnionsInContainer(elm, true);
        }
        return this.fAllUnions;
    }

    private void getAllStructsUnionsInContainer(RfNamedElement container, boolean collectUnions) {
        List<RfActionBlock> actionBlocks;
        String prefix = collectUnions ? "union" : "struct";
        List<RfStruct> structs = container.getStructsUnionsWithPrefix(prefix, 2, 1);
        if (structs != null) {
            for (RfStruct struct : structs) {
                RfNamedElement closestContainer;
                if (struct.isPredefined() || this.isOVMFile(struct.getFile().getName()) || this.isOVMElement(closestContainer = struct.getClosestTypeContainer())) continue;
                if (collectUnions) {
                    this.fAllUnions.add(struct);
                    continue;
                }
                this.fAllStructs.add(struct);
            }
        }
        if ((actionBlocks = container.getLocalMembers(RfActionBlock.class)) == null || actionBlocks.isEmpty()) {
            return;
        }
        for (RfActionBlock block : actionBlocks) {
            this.getAllStructsUnionsInContainer(block, collectUnions);
        }
    }

    public NullProtectedList<RfNamedElement> getAllInterfaces() {
        if (this.fAllInterfaces != null) {
            return this.fAllInterfaces;
        }
        if (this.fRfProject == null) {
            return new NullProtectedList<RfNamedElement>();
        }
        this.fAllInterfaces = new NullProtectedList();
        RfInterface[] rfInterfaceArray = this.fRfProject.getAllInterfaces();
        int n = rfInterfaceArray.length;
        int n2 = 0;
        while (n2 < n) {
            RfInterface elm = rfInterfaceArray[n2];
            if (!this.isOVMElement(elm)) {
                this.fAllInterfaces.add(elm);
            }
            ++n2;
        }
        return this.fAllInterfaces;
    }

    public Collection<RfPackage> getAllPackages() {
        if (this.fAllPackages != null) {
            return this.fAllPackages;
        }
        if (this.fRfProject == null) {
            return new ArrayList<RfPackage>();
        }
        this.fAllPackages = new ArrayList<RfPackage>();
        for (RfPackage elm : this.fRfProject.getAllPackages(false)) {
            if (this.isOVMElement(elm)) continue;
            this.fAllPackages.add(elm);
        }
        return this.fAllPackages;
    }

    public NullProtectedList<RfNamedElement> getAllTypes() {
        if (this.fAllTypes != null) {
            return this.fAllTypes;
        }
        if (this.fRfProject == null) {
            return new NullProtectedList<RfNamedElement>();
        }
        this.fAllTypes = new NullProtectedList();
        RfNamedElement[] rfNamedElementArray = this.fRfProject.getAllTypes(false, true);
        int n = rfNamedElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            RfNamedElement elm = rfNamedElementArray[n2];
            if (!this.isOVMElement(elm)) {
                this.fAllTypes.add(elm);
            }
            ++n2;
        }
        return this.fAllTypes;
    }

    public NullProtectedList<RfNamedElement> getAllTypedefs() {
        if (this.fAllTypedefs != null) {
            return this.fAllTypedefs;
        }
        if (this.fRfProject == null) {
            return new NullProtectedList<RfNamedElement>();
        }
        this.fAllTypedefs = new NullProtectedList();
        RfNamedElement[] rfNamedElementArray = this.fRfProject.getAllTypedefs(true);
        int n = rfNamedElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            RfNamedElement elm = rfNamedElementArray[n2];
            if (elm != null && !this.isOVMElement(elm)) {
                this.fAllTypedefs.add(elm);
            }
            ++n2;
        }
        return this.fAllTypedefs;
    }

    public NullProtectedList<RfNamedElement> getAllModules() {
        if (this.fAllModules != null) {
            return this.fAllModules;
        }
        if (this.fRfProject == null) {
            return new NullProtectedList<RfNamedElement>();
        }
        this.fAllModules = new NullProtectedList();
        RfModule[] rfModuleArray = this.fRfProject.getAllModules();
        int n = rfModuleArray.length;
        int n2 = 0;
        while (n2 < n) {
            RfModule elm = rfModuleArray[n2];
            if (!this.isOVMElement(elm)) {
                this.fAllModules.add(elm);
            }
            ++n2;
        }
        return this.fAllModules;
    }

    public NullProtectedList<RfNamedElement> getAllConstraints() {
        if (this.fAllConstraints != null) {
            return this.fAllConstraints;
        }
        if (this.fRfProject == null) {
            return new NullProtectedList<RfNamedElement>();
        }
        this.fAllConstraints = new NullProtectedList();
        RfConstraint[] rfConstraintArray = this.fRfProject.getAllConstraints();
        int n = rfConstraintArray.length;
        int n2 = 0;
        while (n2 < n) {
            RfConstraint elm = rfConstraintArray[n2];
            if (!this.isOVMElement(elm)) {
                this.fAllConstraints.add(elm);
            }
            ++n2;
        }
        return this.fAllConstraints;
    }

    public NullProtectedList<RfNamedElement> getAllClockingBlocks() {
        if (this.fAllClockingBlocks != null) {
            return this.fAllClockingBlocks;
        }
        if (this.fRfProject == null) {
            return new NullProtectedList<RfNamedElement>();
        }
        this.fAllClockingBlocks = new NullProtectedList();
        RfClockingBlock[] rfClockingBlockArray = this.fRfProject.getAllClockingBlocks();
        int n = rfClockingBlockArray.length;
        int n2 = 0;
        while (n2 < n) {
            RfClockingBlock elm = rfClockingBlockArray[n2];
            if (!this.isOVMElement(elm)) {
                this.fAllClockingBlocks.add(elm);
            }
            ++n2;
        }
        return this.fAllClockingBlocks;
    }

    public NullProtectedList<RfNamedElement> getAllModports() {
        if (this.fAllModports != null) {
            return this.fAllModports;
        }
        if (this.fRfProject == null) {
            return new NullProtectedList<RfNamedElement>();
        }
        this.fAllModports = new NullProtectedList();
        RfModport[] rfModportArray = this.fRfProject.getAllModports();
        int n = rfModportArray.length;
        int n2 = 0;
        while (n2 < n) {
            RfModport elm = rfModportArray[n2];
            if (!this.isOVMElement(elm)) {
                this.fAllModports.add(elm);
            }
            ++n2;
        }
        return this.fAllModports;
    }

    public NullProtectedList<RfNamedElement> getAllInstances() {
        if (this.fAllInstances != null) {
            return this.fAllInstances;
        }
        if (this.fRfProject == null) {
            return new NullProtectedList<RfNamedElement>();
        }
        this.fAllInstances = new NullProtectedList();
        NullProtectedList<RfNamedElement> allModulesAndInterfaces = new NullProtectedList<RfNamedElement>();
        allModulesAndInterfaces.addAll(this.getAllModules());
        allModulesAndInterfaces.addAll(this.getAllInterfaces());
        for (RfNamedElement modIntf : allModulesAndInterfaces) {
            if (!(modIntf instanceof IRfDesignElement)) continue;
            ArrayList instances = new ArrayList();
            DesignUtils.getInstancesIncludingGenerate(instances, (IRfDesignElement)((IRfDesignElement)modIntf), (boolean)false);
            for (IRfInstanceElement instance : instances) {
                if (this.isOVMElement((RfNamedElement)instance)) continue;
                this.fAllInstances.add((RfNamedElement)instance);
            }
        }
        return this.fAllInstances;
    }

    public NullProtectedList<RfNamedElement> getAllCheckers() {
        if (this.fAllCheckers != null) {
            return this.fAllCheckers;
        }
        if (this.fRfProject == null) {
            return new NullProtectedList<RfNamedElement>();
        }
        this.fAllCheckers = new NullProtectedList();
        RfChecker[] rfCheckerArray = this.fRfProject.getAllCheckers();
        int n = rfCheckerArray.length;
        int n2 = 0;
        while (n2 < n) {
            RfChecker elm = rfCheckerArray[n2];
            if (!this.isOVMElement(elm)) {
                this.fAllCheckers.add(elm);
            }
            ++n2;
        }
        return this.fAllCheckers;
    }

    public NullProtectedList<RfNamedElement> getAllConfigurations() {
        if (this.fAllConfigurations != null) {
            return this.fAllConfigurations;
        }
        if (this.fRfProject == null) {
            return new NullProtectedList<RfNamedElement>();
        }
        this.fAllConfigurations = new NullProtectedList();
        RfConfiguration[] rfConfigurationArray = this.fRfProject.getAllConfigurations();
        int n = rfConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            RfConfiguration elm = rfConfigurationArray[n2];
            if (!this.isOVMElement(elm)) {
                this.fAllConfigurations.add(elm);
            }
            ++n2;
        }
        return this.fAllConfigurations;
    }

    public NullProtectedList<RfNamedElement> getAllPrimitives() {
        if (this.fAllPrimitives != null) {
            return this.fAllPrimitives;
        }
        if (this.fRfProject == null) {
            return new NullProtectedList<RfNamedElement>();
        }
        this.fAllPrimitives = new NullProtectedList();
        RfPrimitive[] rfPrimitiveArray = this.fRfProject.getAllPrimitives();
        int n = rfPrimitiveArray.length;
        int n2 = 0;
        while (n2 < n) {
            RfPrimitive elm = rfPrimitiveArray[n2];
            if (!this.isOVMElement(elm)) {
                this.fAllPrimitives.add(elm);
            }
            ++n2;
        }
        return this.fAllPrimitives;
    }

    public NullProtectedList<RfNamedElement> getAllPrograms() {
        if (this.fAllPrograms != null) {
            return this.fAllPrograms;
        }
        if (this.fRfProject == null) {
            return new NullProtectedList<RfNamedElement>();
        }
        this.fAllPrograms = new NullProtectedList();
        RfProgram[] rfProgramArray = this.fRfProject.getAllPrograms();
        int n = rfProgramArray.length;
        int n2 = 0;
        while (n2 < n) {
            RfProgram elm = rfProgramArray[n2];
            if (!this.isOVMElement(elm)) {
                this.fAllPrograms.add(elm);
            }
            ++n2;
        }
        return this.fAllPrograms;
    }

    public NullProtectedList<RfNamedElement> getAllProperties() {
        if (this.fAllProperties != null) {
            return this.fAllProperties;
        }
        if (this.fRfProject == null) {
            return new NullProtectedList<RfNamedElement>();
        }
        this.fAllProperties = new NullProtectedList();
        RfPropertySequence[] rfPropertySequenceArray = this.fRfProject.getAllProperties();
        int n = rfPropertySequenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            RfPropertySequence elm = rfPropertySequenceArray[n2];
            if (!this.isOVMElement(elm)) {
                this.fAllProperties.add(elm);
            }
            ++n2;
        }
        return this.fAllProperties;
    }

    public NullProtectedList<RfNamedElement> getAllSequences() {
        if (this.fAllSequences != null) {
            return this.fAllSequences;
        }
        if (this.fRfProject == null) {
            return new NullProtectedList<RfNamedElement>();
        }
        this.fAllSequences = new NullProtectedList();
        RfPropertySequence[] rfPropertySequenceArray = this.fRfProject.getAllSequences();
        int n = rfPropertySequenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            RfPropertySequence elm = rfPropertySequenceArray[n2];
            if (!this.isOVMElement(elm)) {
                this.fAllSequences.add(elm);
            }
            ++n2;
        }
        return this.fAllSequences;
    }

    public boolean isEnv(RfClass rfClass) {
        if (rfClass == null) {
            return false;
        }
        return this.fEnvs.containsKey(rfClass.getFullName());
    }

    public boolean isAgent(RfClass rfClass) {
        if (rfClass == null) {
            return false;
        }
        return this.fAgents.containsKey(rfClass.getFullName());
    }

    public boolean isMonitor(RfClass rfClass) {
        if (rfClass == null) {
            return false;
        }
        return this.fMonitors.containsKey(rfClass.getFullName());
    }

    public boolean isDriver(RfClass rfClass) {
        if (rfClass == null) {
            return false;
        }
        return this.fDrivers.containsKey(rfClass.getFullName());
    }

    public boolean isDriverSequencer(RfClass rfClass) {
        if (rfClass == null) {
            return false;
        }
        return this.getDriverSequencers().containsKey(rfClass.getFullName());
    }

    public boolean isSequenceOrTheSequenceBaseClass(RfClass rfClass) {
        if (rfClass == null) {
            return false;
        }
        return this.fSequences.containsKey(rfClass.getFullName()) || rfClass.checkEquals(this.fSequenceClass);
    }

    public boolean isSequencer(RfClass rfClass) {
        if (rfClass == null) {
            return false;
        }
        return this.fSequencers.containsKey(rfClass.getFullName());
    }

    public boolean isSequencerOrTheSequencerBaseClass(RfClass rfClass) {
        if (rfClass == null) {
            return false;
        }
        return this.fSequencers.containsKey(rfClass.getFullName()) || rfClass.checkEquals(this.fSequencerClass);
    }

    public boolean isSequencerOrTheOVMSequencer(RfClass rfClass) {
        if (rfClass == null) {
            return false;
        }
        return this.fSequencers.containsKey(rfClass.getFullName()) || rfClass.checkEquals(this.fOvmSequencer);
    }

    public boolean isSequenceItem(RfClass rfClass) {
        if (rfClass == null) {
            return false;
        }
        return this.fSequenceItems.containsKey(rfClass.getFullName()) || rfClass.isSubClass(OVMUtils.prependLibraryPrefixTo(this.fLibraryKind, "_sequence_item"), true);
    }

    public HashMap<ParserPath, HashSet<ParserPath>> getAllSequenceListFilesAndImportedSequences() {
        if (this.fAllSequenceListFilesAndImportedSequences != null) {
            return this.fAllSequenceListFilesAndImportedSequences;
        }
        this.fAllSequenceListFilesAndImportedSequences = new HashMap();
        VlogPreprocessingInfo preprocessingTable = this.fRfProject.getPreprocessingTable();
        VlogFileInstance topFile = preprocessingTable.getTopFileInstance();
        for (RfClass sequence : this.fSequences.values()) {
            if (sequence.isPredefined() || this.isOVMElement(sequence)) continue;
            ParserPath parserPath = sequence.getFile().getParserPath();
            List<VlogFileInstance> sequenceFiles = topFile.getFileInstances(parserPath);
            for (VlogFileInstance sequenceFile : sequenceFiles) {
                ParserPath includingFile = sequenceFile.getIncludingFileInfo().getParserPath();
                if (new File(includingFile.path).getName().startsWith(TOPFILE_PREFIX)) continue;
                HashSet<Object> sequences = this.fAllSequenceListFilesAndImportedSequences.get(includingFile);
                if (sequences == null) {
                    sequences = new HashSet();
                    this.fAllSequenceListFilesAndImportedSequences.put(includingFile, sequences);
                }
                sequences.add(parserPath);
            }
        }
        return this.fAllSequenceListFilesAndImportedSequences;
    }

    public HashSet<ParserPath> getAllSequenceListFilesByName() {
        if (this.fAllSequenceListFilesByName != null) {
            return this.fAllSequenceListFilesByName;
        }
        this.fAllSequenceListFilesByName = new HashSet();
        HashSet<ParserPath> allImportedFiles = this.getAllImportedFiles();
        for (ParserPath importedFile : allImportedFiles) {
            if (importedFile == null || importedFile.isEmpty() || !importedFile.path.endsWith("_seq_list.sv")) continue;
            this.fAllSequenceListFilesByName.add(importedFile);
        }
        return this.fAllSequenceListFilesByName;
    }

    public Set<RfClass> getAllXVMSubClasses(RfClass baseClass) {
        Set<RfClass> childClasses;
        if (this.fXVMSubclasses == null) {
            this.fXVMSubclasses = new HashMap<RfClass, Set<RfClass>>();
        }
        if ((childClasses = this.fXVMSubclasses.get(baseClass)) != null) {
            return childClasses;
        }
        childClasses = this.calculateChildrenOfClass(baseClass);
        this.fXVMSubclasses.put(baseClass, childClasses);
        return childClasses;
    }

    private Set<RfClass> calculateChildrenOfClass(RfClass baseClass) {
        LinkedHashSet<RfClass> result = new LinkedHashSet<RfClass>();
        for (RfNamedElement element : this.getAllNonXVMClasses()) {
            RfClass clazz;
            if (!(element instanceof RfClass) || !LintUtils.isSubClassOf((clazz = (RfClass)element).getDefaultSpecialization(null), baseClass)) continue;
            result.add(clazz);
        }
        return result;
    }

    public HashSet<ParserPath> getAllImportedFiles() {
        if (this.fAllImportedFiles != null) {
            return this.fAllImportedFiles;
        }
        this.fAllImportedFiles = new LinkedHashSet<ParserPath>();
        VlogPreprocessingInfo preprocessingTable = this.fRfProject.getPreprocessingTable();
        VlogFileInstance topFile = preprocessingTable.getTopFileInstance();
        if (topFile == null) {
            return this.fAllImportedFiles;
        }
        ArrayList<VlogFileInstance> files = new ArrayList<VlogFileInstance>();
        files.addAll(topFile.getIncludedInstances());
        int i = 0;
        while (i < files.size()) {
            File file = new File(((VlogFileInstance)files.get((int)i)).getParserPath().path);
            String name = ((VlogFileInstance)files.get(i)).getShortFileName();
            if (name.startsWith(TOPFILE_PREFIX) && name.endsWith(LIBFILE_SUFFIX)) {
                files.addAll(((VlogFileInstance)files.get(i)).getIncludedInstances());
            }
            if (file.exists()) {
                this.fAllImportedFiles.add(((VlogFileInstance)files.get(i)).getParserPath());
                files.addAll(((VlogFileInstance)files.get(i)).getIncludedInstances());
            }
            ++i;
        }
        return this.fAllImportedFiles;
    }

    public HashSet<ParserPath> getAllTopFiles() {
        LinkedHashSet<ParserPath> allTopFiles = new LinkedHashSet<ParserPath>();
        VlogPreprocessingInfo preprocessingTable = this.fRfProject.getPreprocessingTable();
        VlogFileInstance rootTopFile = preprocessingTable.getTopFileInstance();
        for (VlogFileInstance vf : rootTopFile.getIncludedInstances()) {
            File file = new File(vf.getParserPath().path);
            if (!file.exists()) continue;
            allTopFiles.add(vf.getParserPath());
        }
        return allTopFiles;
    }

    public HashMap<ParserPath, Set<Class<? extends RfNamedElement>>> getAllIncludedFiles() {
        if (this.fAllIncludedFiles != null) {
            return this.fAllIncludedFiles;
        }
        this.fAllIncludedFiles = new LinkedHashMap<ParserPath, Set<Class<? extends RfNamedElement>>>();
        VlogPreprocessingInfo preprocessingTable = this.fRfProject.getPreprocessingTable();
        VlogFileInstance topFile = preprocessingTable.getTopFileInstance();
        if (topFile == null) {
            return this.fAllIncludedFiles;
        }
        ArrayList<VlogFileInstance> includedfiles = new ArrayList<VlogFileInstance>();
        for (VlogFileInstance tFile : topFile.getIncludedInstances()) {
            includedfiles.addAll(tFile.getIncludedInstances());
        }
        int i = 0;
        while (i < includedfiles.size()) {
            VlogFileInstance includedFile = (VlogFileInstance)includedfiles.get(i);
            File file = new File(includedFile.getParserPath().path);
            String name = includedFile.getShortFileName();
            if (name.startsWith(TOPFILE_PREFIX) && name.endsWith(LIBFILE_SUFFIX)) {
                includedfiles.addAll(includedFile.getIncludedInstances());
            }
            if (file.exists()) {
                Set<Class<? extends RfNamedElement>> fileScopes = this.fAllIncludedFiles.get(includedFile.getParserPath());
                if (fileScopes == null) {
                    fileScopes = new HashSet<Class<? extends RfNamedElement>>();
                    this.fAllIncludedFiles.put(includedFile.getParserPath(), fileScopes);
                }
                fileScopes.add(includedFile.getSemanticScope().getClass());
                includedfiles.addAll(includedFile.getIncludedInstances());
            }
            ++i;
        }
        return this.fAllIncludedFiles;
    }

    public HashMap<ParserPath, HashMap<ParserPath, List<Integer>>> getAllFilesWithIncludes() {
        if (this.fAllFilesWithIncludes != null) {
            return this.fAllFilesWithIncludes;
        }
        this.fAllFilesWithIncludes = new HashMap();
        VlogPreprocessingInfo preprocessingTable = this.fRfProject.getPreprocessingTable();
        VlogFileInstance topFile = preprocessingTable.getTopFileInstance();
        if (topFile == null) {
            return this.fAllFilesWithIncludes;
        }
        this.addFilesWithIncludes(topFile);
        return this.fAllFilesWithIncludes;
    }

    private void addFilesWithIncludes(VlogFileInstance root) {
        VlogIncludingScope includingScope;
        if (this.fAllFilesWithIncludes == null) {
            return;
        }
        List<VlogFileInstance> files = root.getIncludedInstances();
        if (files != null && !files.isEmpty()) {
            for (VlogFileInstance file : files) {
                this.addFilesWithIncludes(file);
            }
        }
        if ((includingScope = root.getIncludingScope()) == null) {
            return;
        }
        VlogFileInstance includingInstance = includingScope.getIncludingInstance();
        if (includingInstance == null) {
            return;
        }
        HashMap<Object, List<Integer>> entry = this.fAllFilesWithIncludes.get(includingInstance.getParserPath());
        if (entry == null) {
            entry = new HashMap();
            entry.put(root.getParserPath(), new ArrayList<Integer>(Arrays.asList(includingScope.getIncludingLine())));
            this.fAllFilesWithIncludes.put(includingInstance.getParserPath(), entry);
        } else {
            List<Integer> lines = entry.get(root.getParserPath());
            if (lines == null) {
                entry.put(root.getParserPath(), new ArrayList<Integer>(Arrays.asList(includingScope.getIncludingLine())));
            } else {
                lines.add(includingScope.getIncludingLine());
            }
        }
    }

    public List<ParserPath> getAllFilesInOrder() {
        if (this.fAllFilesInIncludeOrder != null) {
            return this.fAllFilesInIncludeOrder;
        }
        this.fAllFilesInIncludeOrder = new ArrayList();
        VlogPreprocessingInfo preprocessingTable = this.fRfProject.getPreprocessingTable();
        VlogFileInstance topFile = preprocessingTable.getTopFileInstance();
        if (topFile == null) {
            return this.fAllFilesInIncludeOrder;
        }
        this.addFilesInBottomUpOrder(topFile);
        return this.fAllFilesInIncludeOrder;
    }

    private void addFilesInBottomUpOrder(VlogFileInstance root) {
        if (this.fAllFilesInIncludeOrder == null) {
            return;
        }
        List<VlogFileInstance> files = root.getIncludedInstances();
        if (files != null && !files.isEmpty()) {
            for (VlogFileInstance file : files) {
                this.addFilesInBottomUpOrder(file);
            }
        }
        if (root.getParserPath() != null) {
            this.fAllFilesInIncludeOrder.add(root.getParserPath());
        }
    }

    private Map<ParserPath, List<SVTBIssues>> getAllSVTBCharIssues(SVTBCharParser.Config config, OVMComplianceCheck check) {
        Map<ParserPath, List<SVTBIssues>> allSVTBCharIssuers = this.fAllSVTBCharIssues.get(config);
        if (allSVTBCharIssuers != null) {
            return allSVTBCharIssuers;
        }
        HashSet<ParserPath> fileNames = this.getAllImportedFiles();
        try {
            allSVTBCharIssuers = SVTBCharParser.getAllCharIssues(this, fileNames, config, check);
            this.fAllSVTBCharIssues.put(config, allSVTBCharIssuers);
        }
        catch (IOException e) {
            this.notifyCheckException(check, e);
            DVTLogger.INSTANCE.logError((Throwable)e);
            this.fAllSVTBCharIssues = new HashMap<SVTBCharParser.Config, Map<ParserPath, List<SVTBIssues>>>();
        }
        return allSVTBCharIssuers;
    }

    public Map<ParserPath, List<SVTBIssues>> getSVTBCharIssuesWithKind(SVTBCharParser.Config config, int kind, boolean withXVM, OVMComplianceCheck check) {
        return this.filterSVTBIssuesByKind(this.getAllSVTBCharIssues(config, check), kind, withXVM, null);
    }

    public Map<ParserPath, List<SVTBIssues>> getSVTBCharIssuesWithKind(SVTBCharParser.Config config, int kind, OVMComplianceCheck check) {
        return this.filterSVTBIssuesByKind(this.getAllSVTBCharIssues(config, check), kind, null);
    }

    public Map<ParserPath, List<SVTBIssues>> getSVTBIssuesWithKind(int kind, boolean withXVM) {
        return this.getSVTBIssuesWithKind(kind, withXVM, null);
    }

    public Map<ParserPath, List<SVTBIssues>> getSVTBIssuesWithKind(int kind) {
        return this.getSVTBIssuesWithKind(kind, false, null);
    }

    public Map<ParserPath, List<SVTBIssues>> getSVTBIssuesWithKind(int kind, boolean withXVM, int ... carrys) {
        Map<ParserPath, List<SVTBIssues>> svtbIssues = this.getRfProject().getPreprocessingTable().getSVTBIssuesMap();
        HashMap<ParserPath, List<SVTBIssues>> workingCopy = new HashMap<ParserPath, List<SVTBIssues>>(svtbIssues);
        return this.filterSVTBIssuesByKind(workingCopy, kind, withXVM, carrys);
    }

    public Map<ParserPath, List<SVTBIssues>> filterSVTBIssuesByKind(Map<ParserPath, List<SVTBIssues>> allSVTBIssues, int kind, int ... carrys) {
        return this.filterSVTBIssuesByKind(allSVTBIssues, kind, false, carrys);
    }

    private Map<ParserPath, List<SVTBIssues>> filterSVTBIssuesByKind(Map<ParserPath, List<SVTBIssues>> allSVTBIssues, int kind, boolean withXVM, int ... carrys) {
        HashMap<ParserPath, List<SVTBIssues>> candidates = new HashMap<ParserPath, List<SVTBIssues>>();
        for (Map.Entry<ParserPath, List<SVTBIssues>> entry : allSVTBIssues.entrySet()) {
            ParserPath file = entry.getKey();
            String shortFileName = LintUtils.getFileShortName(file.path);
            if (!withXVM && this.isOVMFile(shortFileName)) continue;
            List<SVTBIssues> issues = entry.getValue();
            for (SVTBIssues issue : issues) {
                boolean isValid;
                if (issue.getKind() != kind) continue;
                boolean bl = isValid = carrys == null || carrys.length == 0;
                if (!isValid && carrys != null) {
                    int[] nArray = carrys;
                    int n = carrys.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int carry = nArray[n2];
                        isValid |= issue.getCarry() == carry;
                        ++n2;
                    }
                }
                if (!isValid) continue;
                ArrayList<SVTBIssues> list = (ArrayList<SVTBIssues>)candidates.get(file);
                if (list == null) {
                    list = new ArrayList<SVTBIssues>();
                    candidates.put(file, list);
                }
                list.add(issue);
            }
        }
        return candidates;
    }

    public RfProject getRfProject() {
        return this.fRfProject;
    }

    public OVMComplianceCategory getCategory(String name) {
        if (name == null) {
            return null;
        }
        for (OVMComplianceCategory categ : this.fComplianceCategories) {
            if (!name.equals(categ.getName())) continue;
            return categ;
        }
        return null;
    }

    public ArrayList<OVMComplianceCategory> getComplianceCategories() {
        return this.fComplianceCategories;
    }

    public void build(IProgressMonitor monitor, boolean onlyFailed, Object target) {
        this.build(monitor, onlyFailed, target, true, false);
    }

    public void build(IProgressMonitor monitor, boolean onlyFailed, Object target, boolean printLintSummary, boolean printAutofixSummary) {
        if (!onlyFailed && target == null) {
            this.build(monitor, false, printLintSummary, printAutofixSummary, null);
            return;
        }
        this.fProgressMonitor = this.isStartedFromBuildConfig() ? monitor : new LintingProgressAndAliveMonitor(monitor);
        this.initializeComponents();
        ArrayList<OVMComplianceCheck> checks = null;
        ArrayList<OVMComplianceCheck> failedChecks = new ArrayList<OVMComplianceCheck>();
        HashSet modifiedFiles = null;
        if (target == null) {
            checks = this.fChecks;
        } else {
            checks = new ArrayList();
            if (target instanceof OVMComplianceCheck) {
                checks.add((OVMComplianceCheck)target);
            } else if (target instanceof OVMComplianceCategory) {
                checks.addAll(((OVMComplianceCategory)target).getChecks());
            } else if (target instanceof ArrayList) {
                checks = (ArrayList)target;
            } else if (target instanceof HashSet) {
                checks = this.fChecks;
                modifiedFiles = (HashSet)target;
            }
        }
        MemoryMonitor.getInstance().startMemoryMonitor(MemoryMonitoringType.LINT, this.fProject == null ? null : this.fProject.getName());
        this.fLintRunTime = 0L;
        int timeout = this.fConfiguration.getSessionTimeoutValue();
        if (timeout == 0) {
            timeout = this.getRulesetConfiguration().getSessionTimeout();
        }
        this.fSessionEndTime = System.currentTimeMillis() + (long)(timeout * 1000);
        PreWaiver modifiedFilesPrewaiver = null;
        if (modifiedFiles != null) {
            modifiedFilesPrewaiver = this.fProjectWaivers.createPrewaiverForFiles(modifiedFiles, checks);
        }
        boolean projectWasRestored = !VerissimoAfterCompilationLauncher.getInstance().projectWasFullBuilt(this.fProject);
        boolean isIncrementalLinting = this.isStartedFromBuildConfig() && modifiedFiles != null;
        for (OVMComplianceCheck oVMComplianceCheck : checks) {
            CheckStatus status;
            String message;
            boolean ignoreCheck = false;
            if (isIncrementalLinting) {
                if (oVMComplianceCheck instanceof CustomRuleWrapper || oVMComplianceCheck instanceof OVMComplianceManualCheck) {
                    ignoreCheck = true;
                }
                if (projectWasRestored && !oVMComplianceCheck.isApplicableAfterIncremental()) {
                    ignoreCheck = true;
                }
            }
            if (ignoreCheck) {
                message = "Bypassing " + oVMComplianceCheck.getName();
                ProgressPrinter.INSTANCE.printProgress(this.getProject(), String.valueOf(message) + LintUtils.createRunTimeMessage(0L, message.length(), this.isInBatchMode()), false);
                continue;
            }
            message = "Running " + oVMComplianceCheck.getName();
            Boolean isDisabled = this.fProjectWaivers.isDisabled(oVMComplianceCheck);
            oVMComplianceCheck.setWaiverEnabled(isDisabled);
            if (onlyFailed && (status = OVMComplianceChecksUtil.getStatus(oVMComplianceCheck)) != CheckStatus.ERROR) {
                oVMComplianceCheck.reapplyWaivers();
                continue;
            }
            if (this.fProgressMonitor.isCanceled()) {
                DVTBuildConsoleRegistry.getConsole((IProject)this.getProject()).printSection("Total linting time [" + this.fLintRunTime + "ms]");
                if (printAutofixSummary && this.fLastAutofixResult != null) {
                    DVTBuildConsoleRegistry.getConsole((IProject)this.getProject()).printSection("Total fixing time for " + this.fLastAutofixResult.getCheck().getName() + " [" + this.fLastAutofixResult.getCheck().getFixingTime() + "ms]");
                }
                if (!this.isInBatchMode()) {
                    for (Map.Entry<String, StringBuilder> entry : this.getPrintMessageByRule().entrySet()) {
                        DVTBuildConsoleRegistry.getConsole((IProject)this.getProject()).print("*** LINT CONSOLE OUTPUT " + entry.getKey() + " ***");
                        DVTBuildConsoleRegistry.getConsole((IProject)this.getProject()).print(entry.getValue().toString());
                    }
                }
                DVTBuildConsoleRegistry.getConsole((IProject)this.getProject()).print(CANCELED_LINT_MESSAGE);
                this.setReapplyOrRerun(false);
                MemoryMonitor.getInstance().stopMemoryMonitor();
                return;
            }
            this.fProgressMonitor.subTask(oVMComplianceCheck.getName());
            this.fProgressMonitor.setTaskName(oVMComplianceCheck.getName());
            try {
                oVMComplianceCheck.performCheck(modifiedFiles);
                failedChecks.add(oVMComplianceCheck);
            }
            catch (Throwable e) {
                this.notifyCheckException(oVMComplianceCheck, e instanceof Exception ? (Exception)e : new Exception(e));
                DVTLogger.INSTANCE.logError(e);
            }
            this.removeDirty(oVMComplianceCheck.getName());
            ProgressPrinter.INSTANCE.printProgress(this.getProject(), String.valueOf(message) + LintUtils.createRunTimeMessage(oVMComplianceCheck.getRunTime(), message.length(), this.isInBatchMode()), false);
            this.fLintRunTime += oVMComplianceCheck.getRunTime();
            this.fProgressMonitor.worked(1);
        }
        this.fProjectWaivers.removeWaiver(modifiedFilesPrewaiver);
        for (Map.Entry entry : this.fCheckExceptions.entrySet()) {
            ((IOVMComplianceCheck)entry.getKey()).addInternalErrorHit((Throwable)entry.getValue());
        }
        DVTBuildConsoleRegistry.getConsole((IProject)this.getProject()).printSection("Total linting time [" + this.fLintRunTime + "ms]");
        if (printAutofixSummary && this.fLastAutofixResult != null) {
            DVTBuildConsoleRegistry.getConsole((IProject)this.getProject()).printSection("Total fixing time for " + this.fLastAutofixResult.getCheck().getName() + " [" + this.fLastAutofixResult.getCheck().getFixingTime() + "ms]");
        }
        if (!this.isInBatchMode()) {
            for (Map.Entry entry : this.getPrintMessageByRule().entrySet()) {
                DVTBuildConsoleRegistry.getConsole((IProject)this.getProject()).print("*** LINT CONSOLE OUTPUT " + (String)entry.getKey() + " ***");
                DVTBuildConsoleRegistry.getConsole((IProject)this.getProject()).print(((StringBuilder)entry.getValue()).toString());
            }
        }
        if (!this.fReapplyOrRerun && this.isCompare() && !this.isInChangesMode()) {
            this.switchModes();
        }
        if (this.getRulesetConfiguration().getAnnotationManager() == null) {
            this.getRulesetConfiguration().setAnnotationManager(new AnnotationManager());
        }
        if (!this.getRulesetConfiguration().getAnnotationManager().getAnnotations().stream().anyMatch(x -> x.getType().equals((Object)AnnotationType.LABEL))) {
            this.getRulesetConfiguration().getAnnotationManager().addAnnotation("Labels", AnnotationType.LABEL, AnnotationLocation.from(""), new Object[0]);
        }
        ReportManager.setReports(this.fProgressMonitor, this);
        this.fProgressMonitor.done();
        StringBuilder stringBuilder = new StringBuilder();
        for (OVMComplianceCheck check : this.fChecks) {
            if (check.getIncludePreWaiver() == null && check.getExcludePreWaiver() == null) continue;
            stringBuilder.append(check.getName()).append(", ");
        }
        if (!stringBuilder.isEmpty()) {
            stringBuilder.setLength(stringBuilder.length() - 2);
            DVTBuildConsoleRegistry.getConsole((IProject)this.getProject()).print(MessageFormat.format(WARNING_MESSAGE_FORMAT, String.valueOf(DEPRECATED_PREWAIVER_MESSAGE) + stringBuilder.toString()));
        }
        if (printLintSummary) {
            ProgressPrinter.INSTANCE.printProgress(this.getProject(), this.createLinterSummary(failedChecks, printAutofixSummary), true);
        }
        this.setReapplyOrRerun(false);
        MemoryMonitor.getInstance().stopMemoryMonitor();
    }

    public void build(IProgressMonitor monitor, boolean printLintSummary) {
        this.build(monitor, false, printLintSummary, false, null);
    }

    public void build(IProgressMonitor monitor, boolean printLintSummary, Set<ParserPath> modifiedFiles) {
        this.build(monitor, false, printLintSummary, false, modifiedFiles);
    }

    public void build(IProgressMonitor monitor, boolean doAutofixing, boolean printLintSummary, boolean printAutofixSummary, Set<ParserPath> modifiedFiles) {
        this.fProgressMonitor = this.isStartedFromBuildConfig() ? monitor : new LintingProgressAndAliveMonitor(monitor);
        try {
            this.initializeComponents();
        }
        catch (BuildCancelException buildCancelException) {}
        this.performChecks(doAutofixing, printLintSummary, printAutofixSummary, modifiedFiles);
    }

    public OVMComplianceCheck getCheck(String name) {
        if (name == null) {
            return null;
        }
        for (OVMComplianceCheck check : this.fChecks) {
            if (!name.equals(check.getName())) continue;
            return check;
        }
        return null;
    }

    public void setStopBeforeInitialization(Boolean stop) {
        this.isCanceledBeforeInitialization = stop;
    }

    public void performChecks(boolean doAutofixing, boolean printLintSummary, boolean printAutofixSummary, Set<ParserPath> modifiedFiles) {
        boolean shouldCollectHistograms;
        boolean isIncrementalLinting;
        for (OVMComplianceCheck check2 : this.fChecks) {
            Boolean isDisabled = this.fProjectWaivers.isDisabled(check2);
            check2.setWaiverEnabled(isDisabled);
        }
        if (this.isCanceledBeforeInitialization) {
            this.fProgressMonitor.setCanceled(true);
            this.isCanceledBeforeInitialization = false;
        }
        MemoryMonitor.getInstance().startMemoryMonitor(MemoryMonitoringType.LINT, this.fProject == null ? null : this.fProject.getName());
        this.fLintRunTime = 0L;
        this.fFixingTime = 0L;
        int timeout = this.fConfiguration.getSessionTimeoutValue();
        if (timeout == 0) {
            timeout = this.getRulesetConfiguration().getSessionTimeout();
        }
        this.fSessionEndTime = System.currentTimeMillis() + (long)(timeout * 1000);
        boolean inBatchMode = this.isInBatchMode();
        boolean isInLSMode = DVTStartupConstants.isLSRunning.get();
        if (!(this.fReapplyOrRerun || inBatchMode && !isInLSMode)) {
            if (this.getConfiguration().getRulesetKind().isPredefined()) {
                DVTBuildConsoleRegistry.getConsole((IProject)this.getProject()).printStartSection(LINT_PREDEFINED_RULESET + this.getConfiguration().getRulesetKind().toString());
            } else {
                DVTBuildConsoleRegistry.getConsole((IProject)this.getProject()).printStartSection(LINT_CUSTOM_RULESET + this.getConfiguration().getRulesetFile().getPath());
            }
            File waiversFile = this.getConfiguration().getWaiversFile();
            if (waiversFile != null && waiversFile.exists()) {
                DVTBuildConsoleRegistry.getConsole((IProject)this.getProject()).printSection(LINT_WAIVERS + waiversFile.getPath());
            }
        }
        PreWaiver modifiedFilesPrewaiver = null;
        if (modifiedFiles != null) {
            modifiedFilesPrewaiver = this.fProjectWaivers.createPrewaiverForFiles(modifiedFiles, this.fChecks);
        }
        boolean projectWasRestored = !VerissimoAfterCompilationLauncher.getInstance().projectWasFullBuilt(this.fProject);
        boolean bl = isIncrementalLinting = this.isStartedFromBuildConfig() && modifiedFiles != null;
        if (this.fChecks.stream().filter(check -> check.isProfilingActivated()).findAny().isPresent()) {
            DVTThreadDumpCollector.with().prefix("verissimo").path("verissimo").start();
        }
        if (shouldCollectHistograms = this.fChecks.stream().filter(check -> check.isHistogramDumpActivated()).findAny().isPresent()) {
            DVTHeapHistogramCollector.getInstance().startSession("verissimo", true);
        }
        for (OVMComplianceCheck oVMComplianceCheck : this.fChecks) {
            if (this.fProgressMonitor.isCanceled()) {
                DVTBuildConsoleRegistry.getConsole((IProject)this.getProject()).printSection("Total linting time [" + this.fLintRunTime + "ms]");
                if (doAutofixing) {
                    DVTBuildConsoleRegistry.getConsole((IProject)this.getProject()).printSection("Total fixing time [" + this.fFixingTime + "ms]");
                }
                if (printAutofixSummary && this.fLastAutofixResult != null) {
                    DVTBuildConsoleRegistry.getConsole((IProject)this.getProject()).printSection("Total fixing time for " + this.fLastAutofixResult.getCheck().getName() + " [" + this.fLastAutofixResult.getCheck().getFixingTime() + "ms]");
                }
                if (!inBatchMode) {
                    for (Map.Entry<String, StringBuilder> entry : this.getPrintMessageByRule().entrySet()) {
                        DVTBuildConsoleRegistry.getConsole((IProject)this.getProject()).print("*** LINT CONSOLE OUTPUT " + entry.getKey() + " ***");
                        DVTBuildConsoleRegistry.getConsole((IProject)this.getProject()).print(entry.getValue().toString());
                    }
                }
                DVTBuildConsoleRegistry.getConsole((IProject)this.getProject()).print(CANCELED_LINT_MESSAGE);
                this.setReapplyOrRerun(false);
                String path = DVTThreadDumpCollector.stop();
                if (!path.isEmpty()) {
                    DVTBuildConsoleRegistry.getConsole((IProject)this.getProject()).printSection("Thread dump generated at: " + path);
                }
                MemoryMonitor.getInstance().stopMemoryMonitor();
                return;
            }
            this.fProgressMonitor.subTask(oVMComplianceCheck.getName());
            String message = "Running " + oVMComplianceCheck.getName();
            this.fProgressMonitor.setTaskName(message);
            boolean ignoreCheck = false;
            if (isIncrementalLinting) {
                if (oVMComplianceCheck instanceof CustomRuleWrapper || oVMComplianceCheck instanceof OVMComplianceManualCheck) {
                    ignoreCheck = true;
                }
                if (projectWasRestored && !oVMComplianceCheck.isApplicableAfterIncremental()) {
                    ignoreCheck = true;
                }
            }
            if (ignoreCheck) {
                message = "Bypassing " + oVMComplianceCheck.getName();
                if (inBatchMode) {
                    ProgressPrinter.INSTANCE.printProgress(this.getProject(), message, false);
                }
                ProgressPrinter.INSTANCE.printProgress(this.getProject(), LintUtils.createRunTimeMessage(oVMComplianceCheck.getRunTime(), message.length(), inBatchMode), false);
                continue;
            }
            if (inBatchMode) {
                ProgressPrinter.INSTANCE.printProgress(this.getProject(), message, false);
            }
            try {
                if (oVMComplianceCheck.isProfilingActivated()) {
                    String event = "Start profiling: " + oVMComplianceCheck.getName() + " Interval: " + oVMComplianceCheck.getProfilingIntervalMS() + "MS Delay: " + oVMComplianceCheck.getProfilingDelayMS() + "MS";
                    DVTThreadDumpCollector.with().interval((long)oVMComplianceCheck.getProfilingIntervalMS()).delay((long)oVMComplianceCheck.getProfilingDelayMS()).event(event).resume();
                }
                Thread monitorThread = null;
                if (oVMComplianceCheck.isHistogramDumpActivated()) {
                    DVTHeapHistogramCollector.getInstance().collectHistogram(String.valueOf(oVMComplianceCheck.getName()) + "_ at _START");
                    monitorThread = new Thread(() -> {
                        try {
                            MemoryMonitorState initialState = MemoryMonitor.getInstance().getMonitorState();
                            Object object = MemoryMonitor.getInstance().getMonitorStateLock();
                            synchronized (object) {
                                while (MemoryMonitor.getInstance().getMonitorState() == initialState) {
                                    MemoryMonitor.getInstance().getMonitorStateLock().wait();
                                }
                                DVTHeapHistogramCollector.getInstance().collectHistogram(String.valueOf(check3.getName()) + "_ at _WARNING");
                            }
                        }
                        catch (InterruptedException interruptedException) {}
                    });
                    monitorThread.start();
                }
                oVMComplianceCheck.setAutoCorrectEnabled(oVMComplianceCheck.isAutoCorrectEnabled() && doAutofixing);
                oVMComplianceCheck.performCheck(modifiedFiles);
                if (oVMComplianceCheck.isHistogramDumpActivated() && monitorThread != null && monitorThread.isAlive()) {
                    monitorThread.interrupt();
                    DVTHeapHistogramCollector.getInstance().collectHistogram(String.valueOf(oVMComplianceCheck.getName()) + "_ at _FINISH");
                }
                MemoryMonitor.getInstance().updateSaveForLaterMemory(oVMComplianceCheck.getNofHits(), 100);
                if (oVMComplianceCheck.isProfilingActivated()) {
                    DVTThreadDumpCollector.pause((String)oVMComplianceCheck.getName());
                }
            }
            catch (Throwable e) {
                this.notifyCheckException(oVMComplianceCheck, e instanceof Exception ? (Exception)e : new Exception(e));
                if (TestHelper.isTestMode() && inBatchMode) {
                    DVTLogger.INSTANCE.logError(System.lineSeparator());
                }
                DVTLogger.INSTANCE.logError(e);
            }
            this.removeDirty(oVMComplianceCheck.getName());
            if (inBatchMode) {
                ProgressPrinter.INSTANCE.printProgress(this.getProject(), LintUtils.createRunTimeMessage(oVMComplianceCheck.getRunTime(), message.length(), inBatchMode), false);
            } else {
                ProgressPrinter.INSTANCE.printProgress(this.getProject(), String.valueOf(message) + LintUtils.createRunTimeMessage(oVMComplianceCheck.getRunTime(), message.length(), inBatchMode), false);
            }
            this.fLintRunTime += oVMComplianceCheck.getRunTime();
            this.fProgressMonitor.worked(1);
            if (!inBatchMode || !doAutofixing || !oVMComplianceCheck.isAutocorrectable() || !oVMComplianceCheck.isAutoCorrectEnabled()) continue;
            VerissimoAutofixManager.getInstance().fixCheckFailures(oVMComplianceCheck, inBatchMode, this);
            this.fFixingTime += oVMComplianceCheck.getFixingTime();
        }
        this.fProjectWaivers.removeWaiver(modifiedFilesPrewaiver);
        for (Map.Entry entry : this.fCheckExceptions.entrySet()) {
            ((IOVMComplianceCheck)entry.getKey()).addInternalErrorHit((Throwable)entry.getValue());
        }
        if (inBatchMode && !isInLSMode) {
            ProgressPrinter.INSTANCE.printProgress(this.getProject(), TOTAL_LINTING_TIME_MESSAGE + LintUtils.createRunTimeMessage(this.fLintRunTime, TOTAL_LINTING_TIME_MESSAGE.length(), inBatchMode), false);
            if (doAutofixing) {
                ProgressPrinter.INSTANCE.printProgress(this.getProject(), TOTAL_FIXING_TIME_MESSAGE + LintUtils.createRunTimeMessage(this.fFixingTime, TOTAL_FIXING_TIME_MESSAGE.length(), inBatchMode), false);
            }
        } else {
            DVTBuildConsoleRegistry.getConsole((IProject)this.getProject()).printSection("Total linting time [" + this.fLintRunTime + "ms]");
            if (printAutofixSummary && this.fLastAutofixResult != null) {
                DVTBuildConsoleRegistry.getConsole((IProject)this.getProject()).printSection("Total fixing time for " + this.fLastAutofixResult.getCheck().getName() + " [" + this.fLastAutofixResult.getCheck().getFixingTime() + "ms]");
            }
            for (Map.Entry entry : this.getPrintMessageByRule().entrySet()) {
                DVTBuildConsoleRegistry.getConsole((IProject)this.getProject()).print("*** LINT CONSOLE OUTPUT " + (String)entry.getKey() + " ***");
                DVTBuildConsoleRegistry.getConsole((IProject)this.getProject()).print(((StringBuilder)entry.getValue()).toString());
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (OVMComplianceCheck check4 : this.fChecks) {
            if (check4.getIncludePreWaiver() == null && check4.getExcludePreWaiver() == null) continue;
            stringBuilder.append(check4.getName()).append(", ");
        }
        if (!stringBuilder.isEmpty()) {
            stringBuilder.setLength(stringBuilder.length() - 2);
            DVTBuildConsoleRegistry.getConsole((IProject)this.getProject()).print(MessageFormat.format(WARNING_MESSAGE_FORMAT, String.valueOf(DEPRECATED_PREWAIVER_MESSAGE) + stringBuilder.toString()));
        }
        if (this.getRulesetConfiguration().getAnnotationManager() == null) {
            this.getRulesetConfiguration().setAnnotationManager(new AnnotationManager());
        }
        if (!this.getRulesetConfiguration().getAnnotationManager().getAnnotations().stream().anyMatch(x -> x.getType().equals((Object)AnnotationType.LABEL))) {
            this.getRulesetConfiguration().getAnnotationManager().addAnnotation("Labels", AnnotationType.LABEL, AnnotationLocation.from(""), new Object[0]);
        }
        ReportManager.setReports(this.fProgressMonitor, this);
        this.fProgressMonitor.done();
        if (!this.fReapplyOrRerun && this.isCompare() && !this.isInChangesMode()) {
            this.switchModes();
        }
        if (printLintSummary) {
            ProgressPrinter.INSTANCE.printProgress(this.getProject(), this.createLinterSummary(this.getChecks(), printAutofixSummary), true);
        }
        this.setReapplyOrRerun(false);
        String path = DVTThreadDumpCollector.stop();
        if (!path.isEmpty()) {
            DVTBuildConsoleRegistry.getConsole((IProject)this.getProject()).printSection("Thread dump generated at: " + path);
        }
        if (shouldCollectHistograms) {
            DVTHeapHistogramCollector.getInstance().endSession();
        }
        MemoryMonitor.getInstance().stopMemoryMonitor();
    }

    public void readRReport() {
        String reportLocation = this.fConfiguration.getHTMLImportLocation();
        if (reportLocation == null || reportLocation.isEmpty()) {
            return;
        }
        RReport report = null;
        try {
            report = VerissimoReportReader.readReportFiles(reportLocation);
        }
        catch (IOException | JSONException e) {
            DVTLogger.INSTANCE.logError(e);
        }
        this.fImportedReport = report;
        if (report != null) {
            RInfo infoWrapper = report.getInfoWrapper();
            if (infoWrapper.isCompareReport()) {
                this.fReportManager.setBaselineReport(new RReport(report));
                this.fIsInChangesMode = true;
            }
            this.fNofCompiledLinesPerFile = infoWrapper.getNofCompiledLinesPerFile();
            LinkedHashMap<Integer, OVMComplianceCategory> tempCategories = new LinkedHashMap<Integer, OVMComplianceCategory>();
            this.fChecks.clear();
            this.fComplianceCategories.clear();
            this.numberOfHits = report.getHits().size();
            String waiversFileString = report.getWaiversFile();
            RulesetKind rulesetKind = report.getRulesetKind();
            String rulesetFileString = report.getRulesetFile();
            if (rulesetKind == null) {
                MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Report error", null, "The report contains an invalid ruleset kind", 1, new String[]{"Ok"}, 0){};
                dialog.open();
                return;
            }
            LintConfigurationContainer config = this.getConfiguration();
            if (waiversFileString != null && !waiversFileString.isEmpty()) {
                config.setWaiversFile(new File(waiversFileString));
            }
            this.setTempRulesetkind(rulesetKind);
            if (rulesetKind.isPredefined()) {
                config.setRulesetFile(new File(OVMUtils.getDefaultRulesetURL(rulesetKind).getFile()));
            }
            if (rulesetFileString != null && !rulesetFileString.isEmpty() && !rulesetKind.isPredefined()) {
                config.setRulesetFile(new File(rulesetFileString));
            }
            this.getProjectWaivers().initialize(this);
            this.getProjectWaivers().parseWaiversXML(false);
            this.fRuleset.setRulesetFile(config.getRulesetFile());
            List<RCheck> checks = report.getChecks();
            ArrayList<OVMComplianceCheck> ovmChecks = new ArrayList<OVMComplianceCheck>();
            for (RCheck check : checks) {
                Set<String> checkCompareAnnotations = check.getCompareAnnotations();
                if (checkCompareAnnotations != null && !checkCompareAnnotations.isEmpty() && !checkCompareAnnotations.contains("Common") && !checkCompareAnnotations.contains("Added Checks")) continue;
                Integer n = check.getCategoryIndex();
                Iterator<RPreWaiver> category = report.getCategories().get(n);
                OVMComplianceCategory ovmCategory = (OVMComplianceCategory)tempCategories.get(n);
                if (ovmCategory == null) {
                    ovmCategory = new OVMComplianceCategory(((RCategory)((Object)category)).getName(), ((RCategory)((Object)category)).getDescription());
                    tempCategories.put(n, ovmCategory);
                }
                String id = check.getCheckID();
                OVMComplianceCheck ovmCheck = RuleFactory.INSTANCE.createRule(id, this, ovmCategory);
                ovmCheck.setSeverity(check.getSeverity());
                ovmCheck.setName(check.getCheckName());
                ovmCheck.setTitle(check.getCheckTitle());
                String parameterString = "\n\nParameters:\n";
                String description = check.getCheckDescription();
                Integer n2 = description.indexOf(parameterString);
                if (n2 != -1) {
                    String string = description.substring(0, n2);
                    Integer n3 = n2 + parameterString.length();
                    String parametersFromDescription = description.substring(n3);
                    String[] stringArray = parameterStrings = DVTStringUtil.split((String)".\n", (String)parametersFromDescription);
                    int n4 = parameterStrings.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        String tempParameterString = stringArray[n5];
                        this.setParameterFromDescription(tempParameterString, ovmCheck);
                        ++n5;
                    }
                    ovmCheck.setDescription(string);
                } else {
                    List<List<String>> list = check.getParameters();
                    parameterStrings = list.iterator();
                    while (parameterStrings.hasNext()) {
                        List<String> parameterFields = parameterStrings.next();
                        ovmCheck.setProperty(parameterFields.get(0), parameterFields.get(3));
                    }
                    List<List<String>> autocorrectParameters = check.getAutocorrectParameters();
                    for (List<String> autocorrectParameterFields : autocorrectParameters) {
                        ovmCheck.setAutoCorrectInput(autocorrectParameterFields.get(0), autocorrectParameterFields.get(3));
                    }
                    ovmCheck.setDescription(description);
                }
                for (RHit rHit : check.getHits()) {
                    Set<String> hitCompareAnnotations;
                    if (ovmCheck.getAnnotationsByTagIdMap() == null) {
                        LinkedHashMap<String, List<String>> annotationMap = new LinkedHashMap<String, List<String>>();
                        int i = 0;
                        while (i < rHit.getAnnotationStringsValues().size()) {
                            if (!rHit.getAnnotationStringsValues().get(i).isEmpty() && report.getAnnotationInfos().get(i).getType() == AnnotationType.TAG.ordinal()) {
                                annotationMap.put(report.getAnnotationInfos().get(i).getTitle(), rHit.getAnnotationStringsValues().get(i));
                            }
                            ++i;
                        }
                        ovmCheck.setAnnotationsByTagIdMap(annotationMap);
                    }
                    if ((hitCompareAnnotations = rHit.getCompareAnnotations()) != null && !hitCompareAnnotations.isEmpty() && !rHit.getCompareHitOrigin().equals("Current")) continue;
                    ParserPath path = new ParserPath(rHit.getFile());
                    List<RHit.MacroPathWrapper> macroParts = rHit.getMacroParts();
                    if (macroParts == null) {
                        macroParts = new ArrayList<RHit.MacroPathWrapper>();
                    }
                    StringBuilder macroInfoText = new StringBuilder();
                    ParserPath[] insideMacroPaths = new ParserPath[macroParts.size()];
                    int i = -1;
                    for (RHit.MacroPathWrapper wrapper : macroParts) {
                        ++i;
                        String macroName = wrapper.getMacroName();
                        String line = wrapper.getLine();
                        String file = wrapper.getFile();
                        ParserPath macroPath = new ParserPath(file);
                        macroInfoText.append("\n").append(MessageFormat.format("    inside macro {0} at line {1} in ''{2}''", macroName, line, macroPath.path));
                        insideMacroPaths[i] = macroPath;
                    }
                    ArrayList<String> stringsList = new ArrayList<String>(report.getFiles());
                    ovmCheck.addHit(path, rHit.getHitDetails(), macroInfoText.toString(), insideMacroPaths, rHit.getHitLine(), null, false, rHit.getSeverity(), hitCompareAnnotations, OVMComplianceHit.DetailsLink.convertDetailsLinks(rHit.getDetailsLinks(), stringsList));
                }
                ovmCheck.configure();
                ovmChecks.add(ovmCheck);
                this.addDirty(ovmCheck.getName());
            }
            this.fComplianceCategories.addAll(tempCategories.values());
            this.setChecks(ovmChecks);
            this.getConfiguration().setBaselineReportLocation(report.getBaselineReportLocation() != null ? report.getBaselineReportLocation() : "");
            WaiversModel projectWaivers = this.getProjectWaivers();
            List<RWaiver> postWaivers = report.getPostWaivers();
            List<RPreWaiver> preWaivers = report.getPreWaivers();
            if (postWaivers == null) {
                postWaivers = new ArrayList<RWaiver>();
            }
            if (preWaivers == null) {
                preWaivers = new ArrayList<RPreWaiver>();
            }
            for (RWaiver rWaiver : postWaivers) {
                PostWaiver postWaiver = new PostWaiver();
                postWaiver.setName(rWaiver.getName());
                postWaiver.setDescription(rWaiver.getDescription());
                postWaiver.setStatus(WaiverStatus.from(rWaiver.getStatus()));
                postWaiver.setApplyOn(rWaiver.getApplyOn());
                postWaiver.setPathsApplyOn(rWaiver.getPathsApplyOn());
                postWaiver.setMessageRegexType(rWaiver.getMessageRegexType());
                postWaiver.setFilePath(rWaiver.getWaiverFile());
                postWaiver.setPathRegexType(rWaiver.getPathsRegexType());
                rWaiver.getCheckNames().forEach(postWaiver::addCheckName);
                rWaiver.setPathsRegexType(postWaiver.getPathRegexType());
                rWaiver.getPaths().forEach(postWaiver::addPath);
                rWaiver.getPaths().forEach(postWaiver::addRawPath);
                for (Map.Entry<String, String> entry : rWaiver.getElements().entrySet()) {
                    postWaiver.addElement(entry.getKey(), entry.getValue());
                }
                rWaiver.getLineRanges().forEach(postWaiver::addLineRange);
                postWaiver.setLineNoInXMLFile(rWaiver.getLineNoInXMLFile());
                for (String string : rWaiver.getMessagePatterns()) {
                    postWaiver.addMessagePattern(new MessagePattern(string, postWaiver.getMessageRegexType().equals("simple")));
                }
                projectWaivers.addPostWaiver(postWaiver);
            }
            for (RPreWaiver rPreWaiver : preWaivers) {
                if (!this.getConfiguration().isPrewaivedUnchanged()) {
                    this.getConfiguration().setPrewaivedUnchanged("Prewaiver generated by prewaive_unchanged_files".equals(rPreWaiver.getName()));
                }
                PreWaiver prewaiver = new PreWaiver();
                prewaiver.setName(rPreWaiver.getName());
                prewaiver.setDescription(rPreWaiver.getDescription());
                prewaiver.setApplyOn(rPreWaiver.getApplyOn());
                prewaiver.setPathsApplyOn(rPreWaiver.getPathsApplyOn());
                prewaiver.setType(rPreWaiver.getType().equals(WaiverType.READ_ONLY.name()) ? WaiverType.READ_ONLY : WaiverType.FILE);
                prewaiver.setPathRegexType(rPreWaiver.getPathRegexType());
                prewaiver.setFilePath(rPreWaiver.getWaiverFile());
                rPreWaiver.getCheckNames().forEach(prewaiver::addCheckName);
                rPreWaiver.getPaths().forEach(prewaiver::addPath);
                rPreWaiver.getPaths().forEach(prewaiver::addRawPath);
                for (Map.Entry<String, String> entry : rPreWaiver.getElements().entrySet()) {
                    prewaiver.addElement(entry.getKey(), entry.getValue());
                }
                projectWaivers.addPreWaiver(prewaiver);
            }
            projectWaivers.computePrewaivedPaths();
            if (infoWrapper.isCompareReport()) {
                this.removeNonBaselineCategories(this.fReportManager.getBaselineReport());
                if (report.getAllBaselineFilesHashesMap() != null && !report.getAllBaselineFilesHashesMap().isEmpty()) {
                    this.fReportManager.getBaselineReport().setAllFilesHashesMap(report.getAllBaselineFilesHashesMap());
                } else {
                    this.getConfiguration().setPrewaivedUnchanged(false);
                }
            } else if (report.getBaselineReportLocation() != null && !report.getBaselineReportLocation().isEmpty()) {
                this.setForceSimpleGUIReport(true);
            }
            AnnotationManager annotationManager = new AnnotationManager();
            this.getRulesetConfiguration().setAnnotationManager(annotationManager);
            for (AnnotationResults.AnnotationInfo annotationInfo : report.getAnnotationInfos()) {
                if (annotationInfo.getType() != AnnotationType.LABEL.ordinal() && annotationInfo.getType() != AnnotationType.TAG.ordinal()) continue;
                annotationManager.addAnnotation(annotationInfo.getTitle(), AnnotationType.from(annotationInfo.getType()), AnnotationLocation.from(annotationInfo.getLocations()), new Object[0]);
            }
            if (!this.getRulesetConfiguration().getAnnotationManager().getAnnotations().stream().anyMatch(x -> x.getType().equals((Object)AnnotationType.LABEL))) {
                this.getRulesetConfiguration().getAnnotationManager().addAnnotation("Labels", AnnotationType.LABEL, AnnotationLocation.from(""), new Object[0]);
            }
        }
    }

    private void removeNonBaselineCategories(RReport report) {
        List<RCheck> checks = report.getChecks();
        ArrayList<RCheck> nonBaselineChecks = new ArrayList<RCheck>();
        List<RCategory> categories = report.getCategories();
        for (RCheck check : checks) {
            Set<String> checkCompareAnnotations = check.getCompareAnnotations();
            RCategory category = categories.get(check.getCategoryIndex());
            Set<RCheck> categoryChecks = category.getChecks();
            if (!checkCompareAnnotations.contains("Common") && !checkCompareAnnotations.contains("Removed Checks")) {
                nonBaselineChecks.add(check);
                categoryChecks.remove(check);
                continue;
            }
            checkCompareAnnotations = new HashSet<String>();
            HashSet<RHit> nonBaselineHits = new HashSet<RHit>();
            for (RHit hit : check.getHits()) {
                Set<String> hitCompareAnnotations = hit.getCompareAnnotations();
                if (hitCompareAnnotations == null || hitCompareAnnotations.isEmpty()) continue;
                if (!hit.getCompareHitOrigin().equals("Baseline")) {
                    nonBaselineHits.add(hit);
                    continue;
                }
                if (hit.getCompareAnnotations().contains("Hidden")) {
                    hit.setHiddenCompare(true);
                }
                hit.setCompareAnnotations(new HashSet<String>());
            }
            Set<RHit> checkHits = check.getHits();
            checkHits.removeAll(nonBaselineHits);
        }
        checks.removeAll(nonBaselineChecks);
        Map<Integer, String> sourcesLocation = report.getSourcesLocations();
        for (Map.Entry<Integer, String> entry : sourcesLocation.entrySet()) {
            if (entry.getKey() == 0) continue;
            sourcesLocation.remove(entry.getKey());
        }
    }

    public int getNumberOfHits() {
        return this.numberOfHits;
    }

    public void setChecks(ArrayList<OVMComplianceCheck> checks) {
        this.fChecks.clear();
        this.fChecks.addAll(checks);
    }

    private void setParameterFromDescription(String parameterString, OVMComplianceCheck ovmCheck) {
        String userValue = "User value: ";
        int index = parameterString.indexOf(":");
        if (index == -1) {
            return;
        }
        String parameterName = parameterString.substring(0, index - 1);
        index = parameterString.indexOf(userValue);
        if (index != -1) {
            String parameterValue = parameterString.substring(index + userValue.length(), parameterString.length());
            if (parameterName != null && parameterValue != null && !parameterName.isEmpty() && !parameterValue.isEmpty()) {
                ovmCheck.setProperty(parameterName, parameterValue);
            }
        }
    }

    private String createLinterSummary(ArrayList<OVMComplianceCheck> checks, boolean printAutofixSummary) {
        int nofPassedChecks = 0;
        int nofErrorChecks = 0;
        int nofWarningChecks = 0;
        int nofInfoChecks = 0;
        int nofDisabledChecks = 0;
        int nofNonExistentChecks = 0;
        int nofDuplicatedChecks = 0;
        int nofErrorHits = 0;
        int nofWarningHits = 0;
        int nofInfoHits = 0;
        int nofDisabledHits = 0;
        for (OVMComplianceCheck check : checks) {
            if ("NONEXISTENT_ID_ERROR".equals(check.getID())) {
                ++nofNonExistentChecks;
                continue;
            }
            if ("DUPLICATE_NAME_ERROR".equals(check.getID())) {
                ++nofDuplicatedChecks;
                continue;
            }
            CheckStatus checkStatus = check.getStatus();
            if (checkStatus == CheckStatus.DISABLED) {
                ++nofDisabledChecks;
            } else if (checkStatus == CheckStatus.PASSED) {
                ++nofPassedChecks;
            } else if (checkStatus == CheckStatus.ERROR) {
                ++nofErrorChecks;
            } else if (checkStatus == CheckStatus.WARNING) {
                ++nofWarningChecks;
            } else if (checkStatus == CheckStatus.INFO) {
                ++nofInfoChecks;
            }
            ArrayList<OVMComplianceCheckHit> hits = check.getVisibleHits();
            for (OVMComplianceCheckHit hit : hits) {
                CheckStatus hitStatus = hit.getSeverity();
                if (hitStatus == CheckStatus.ERROR) {
                    ++nofErrorHits;
                    continue;
                }
                if (hitStatus == CheckStatus.WARNING) {
                    ++nofWarningHits;
                    continue;
                }
                if (hitStatus == CheckStatus.INFO) {
                    ++nofInfoHits;
                    continue;
                }
                if (hitStatus != CheckStatus.DISABLED) continue;
                ++nofDisabledHits;
            }
        }
        String lineSeparator = System.lineSeparator();
        StringBuilder summarySB = new StringBuilder();
        summarySB.append("SUMMARY:").append(lineSeparator).append(MessageFormat.format(CHECK_SUMMARY_FORMAT, nofPassedChecks, nofErrorChecks, nofWarningChecks, nofInfoChecks, nofDisabledChecks, nofNonExistentChecks, nofDuplicatedChecks)).append(lineSeparator).append(MessageFormat.format(HITS_SUMMARY_FORMAT, nofErrorHits, nofWarningHits, nofInfoHits, nofDisabledHits));
        if (printAutofixSummary && this.fLastAutofixResult != null) {
            Set<OVMComplianceCheckHit> hits = this.fLastAutofixResult.getEdits().keySet();
            int nofFixedErrors = 0;
            int nofFixedWarnings = 0;
            int nofFixedInfos = 0;
            int nofFixedHiddenErrors = 0;
            int nofFixedHiddenWarnings = 0;
            int nofFixedHiddenInfos = 0;
            if (hits != null) {
                for (OVMComplianceCheckHit hit : hits) {
                    switch (hit.getSeverity()) {
                        case ERROR: {
                            ++nofFixedErrors;
                            if (!hit.isHidden()) break;
                            ++nofFixedHiddenErrors;
                            break;
                        }
                        case WARNING: {
                            ++nofFixedWarnings;
                            if (!hit.isHidden()) break;
                            ++nofFixedHiddenWarnings;
                            break;
                        }
                        case INFO: {
                            ++nofFixedInfos;
                            if (!hit.isHidden()) break;
                            ++nofFixedHiddenInfos;
                            break;
                        }
                    }
                }
            }
            if (nofFixedHiddenErrors > 0 || nofFixedHiddenWarnings > 0 || nofFixedHiddenInfos > 0) {
                summarySB.append(lineSeparator).append(MessageFormat.format(HIDDEN_HITS_FOUND_BATCH_FORMAT, nofFixedHiddenErrors, nofFixedHiddenWarnings, nofFixedHiddenInfos));
            }
            summarySB.append(lineSeparator).append(MessageFormat.format(FIXED_HITS_SUMMARY_FORMAT, nofFixedErrors, nofFixedWarnings, nofFixedInfos));
        }
        String summary = summarySB.toString();
        return summary;
    }

    public long getLintRunTime() {
        return this.fLintRunTime;
    }

    public void notifyCheckException(IOVMComplianceCheck check, Exception e) {
        this.fCheckExceptions.put(check, e);
    }

    public void notifyTimedOutProcess() {
        this.fTimedOutProcess = true;
    }

    public void notifyTimedOutSession() {
        this.fTimedOutSession = true;
    }

    public void notifyTimedOutChecks() {
        this.fTimedOutChecks = true;
    }

    public void notifyExceededMemory() {
        this.fMemoryMonitorError = true;
    }

    public int getLibraryKind() {
        return this.fLibraryKind;
    }

    public void setLibraryKind(int libraryKind) {
        this.fLibraryKind = libraryKind;
    }

    public String[] getLibraryKindPrefixes() {
        if (this.fLibraryKind == 2) {
            return new String[]{"uvm", "UVM"};
        }
        return new String[]{"ovm", "OVM"};
    }

    public void setLintLibraryContents(boolean lintLibraryContents) {
        this.fLintLibraryContents = lintLibraryContents;
    }

    public LintConfigurationContainer getConfiguration() {
        return this.fConfiguration;
    }

    public void setRulesetName(String rulesetName) {
        this.fRulesetName = rulesetName;
    }

    public String getRulesetName() {
        return this.fRulesetName;
    }

    public String getRulesetFile() {
        File rulesetFile;
        block4: {
            if (this.fRuleset == null) {
                return "";
            }
            try {
                rulesetFile = this.fRuleset.getRulesetFile();
                if (rulesetFile != null) break block4;
                return "";
            }
            catch (IOException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return "";
            }
        }
        return rulesetFile.getCanonicalPath();
    }

    void notifyCheckAlive() {
        if (this.fProgressMonitor == null) {
            return;
        }
        if (this.fProgressMonitor.isCanceled()) {
            throw new LintingCancelledException();
        }
        if (this.fProgressMonitor instanceof LintingProgressAndAliveMonitor) {
            ((LintingProgressAndAliveMonitor)this.fProgressMonitor).alive();
        }
    }

    private void initManualChecksStatusParser(File file) {
        if (file == null) {
            return;
        }
        try {
            this.fManualChecksStatusXMLParser = ManualChecksStatusXMLParser.newParser(file, true);
        }
        catch (IllegalArgumentException | SAXException e) {
            throw new XMLException((Throwable)e, this.fManualChecksStatusXMLParser.getFile().getAbsolutePath());
        }
        catch (IOException e) {
            OVMUtils.ioWriteError(e, this.fManualChecksStatusXMLParser.getFile().getName());
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void saveManualChecksStatus() {
        if (this.fManualChecksStatusXMLParser == null) {
            return;
        }
        try {
            this.fManualChecksStatusXMLParser.save(this);
        }
        catch (IllegalArgumentException | SAXException e) {
            throw new XMLException((Throwable)e, this.fManualChecksStatusXMLParser.getFile().getAbsolutePath());
        }
        catch (IOException e) {
            OVMUtils.ioWriteError(e, this.fManualChecksStatusXMLParser.getFile().getName());
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void loadManualChecksStatus() {
        if (this.fManualChecksStatusXMLParser == null) {
            return;
        }
        try {
            this.fManualChecksStatusXMLParser.load(this);
        }
        catch (IllegalArgumentException | SAXException e) {
            throw new XMLException((Throwable)e, this.fManualChecksStatusXMLParser.getFile().getAbsolutePath());
        }
        catch (IOException e) {
            OVMUtils.ioWriteError(e, this.fManualChecksStatusXMLParser.getFile().getName());
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public boolean isOVMLib() {
        return this.getLibraryKind() == 1;
    }

    public String getBuildPhaseMethodName() {
        if (this.isOVMLib()) {
            return "build";
        }
        return "build_phase";
    }

    public String getConnectPhaseMethodName() {
        if (this.isOVMLib()) {
            return "connect";
        }
        return "connect_phase";
    }

    public String getRunPhaseMethodName() {
        if (this.isOVMLib()) {
            return "run";
        }
        return "run_phase";
    }

    public RulesetConfiguration getRulesetConfiguration() {
        return this.fRulesetConfiguration;
    }

    public boolean isInBatchMode() {
        return this.fInBatchMode;
    }

    public String getOVMFilePattern() {
        return this.fOVMFilePrefixes;
    }

    public boolean getLintLibraryContents() {
        return this.fLintLibraryContents;
    }

    public Pattern getXVMFileNamePattern() {
        return this.fXVMFileNamePattern;
    }

    public void setOVMFilePrefixes(String OVMFilePrefixes) {
        this.fOVMFilePrefixes = OVMFilePrefixes;
        try {
            this.fXVMFileNamePattern = Pattern.compile(this.fOVMFilePrefixes);
        }
        catch (Exception exception) {}
    }

    public String getOVMClassPattern() {
        return this.fOVMClassPrefixes;
    }

    public void setOVMClassPrefixes(String OVMClassPrefixes) {
        this.fOVMClassPrefixes = OVMClassPrefixes;
        try {
            this.fXVMClassNamePattern = Pattern.compile(this.fOVMClassPrefixes);
        }
        catch (Exception exception) {}
    }

    public int getNofCompiledLines() {
        return this.fNofCompiledLines;
    }

    public void setNofCompiledLines(int fNofCompiledLines) {
        this.fNofCompiledLines = fNofCompiledLines;
    }

    public Map<String, Integer> getNofCompiledLinesPerFile() {
        return this.fNofCompiledLinesPerFile;
    }

    public void setNofCompiledLinesPerFile(Map<String, Integer> nofCompiledLinesPerFile) {
        this.fNofCompiledLinesPerFile = nofCompiledLinesPerFile;
    }

    public boolean isOVMFunctionOverride(RfFunction function) {
        if (function != null && function.isVirtual()) {
            RfClass enclosingClass = function.getEnclosingScope(RfClass.class);
            RfClass parent = enclosingClass.getParent();
            while (parent != null) {
                if (this.isOVMElement(parent) && parent.getFunctionWithPrefix(function.getName(), 1, 1, IRfNamedElement.AccessModifier.SHOW_PROTECTED) != null) {
                    return true;
                }
                parent = parent.getParent();
            }
        }
        return false;
    }

    public void setBuildRunTime(long buildRunTime) {
        this.fBuildRunTime = buildRunTime;
    }

    public long getBuildRunTime() {
        return this.fBuildRunTime;
    }

    public void setLicenseWaitTime(long licenseWaitTime) {
        this.fLicenseWaitTime = licenseWaitTime;
    }

    public long getLicenseWaitTime() {
        return this.fLicenseWaitTime;
    }

    public void setIncludeHTMLCode(boolean include) {
        this.fIncludeHTMLCode = include;
    }

    public boolean getIncludeHTMLCode() {
        return this.fIncludeHTMLCode;
    }

    public void setIncludeCodeDate(boolean include) {
        this.fIncludeCodeDate = include;
    }

    public boolean getIncludeCodeDate() {
        return this.fIncludeCodeDate;
    }

    public void setIncludeCreationDate(boolean include) {
        this.fIncludeCreationDate = include;
    }

    public boolean getIncludeCreationDate() {
        return this.fIncludeCreationDate;
    }

    public VerissimoAutofixResult getAutofixResult(OVMComplianceCheck check) {
        return this.fAutofixResults.get(check);
    }

    public void addAutofixResult(VerissimoAutofixResult autofixResult) {
        this.fAutofixResults.put(autofixResult.getCheck(), autofixResult);
        this.fLastAutofixResult = autofixResult;
    }

    public void removeAutofixResult(VerissimoAutofixResult autofixResult) {
        this.fAutofixResults.remove(autofixResult.getCheck(), autofixResult);
    }

    public void hasTimedout(OVMComplianceCheck check) {
        int processTimeoutValue;
        long currentTime = System.currentTimeMillis();
        if (check.getTimeout() != 0 && currentTime > check.getEndTime()) {
            this.notifyTimedOutChecks();
            check.setTimedOutCheck();
            throw new LintingTimedOutException();
        }
        int sessionTimeout = this.fConfiguration.getSessionTimeoutValue();
        if (sessionTimeout == 0) {
            sessionTimeout = this.getRulesetConfiguration().getSessionTimeout();
        }
        if ((processTimeoutValue = this.fConfiguration.getProcessTimeoutValue()) == 0) {
            processTimeoutValue = this.getRulesetConfiguration().getProcessTimeout();
        }
        if (sessionTimeout != 0 && currentTime > this.fSessionEndTime) {
            this.notifyTimedOutSession();
            check.setTimedOutSession();
            throw new LintingTimedOutException();
        }
        if (processTimeoutValue != 0 && currentTime > this.fProcessEndTime) {
            this.notifyTimedOutProcess();
            check.setTimedOutProcess();
            throw new LintingTimedOutException();
        }
    }

    public void hasExceededMemory(OVMComplianceCheck check) {
        if (MemoryMonitorState.ERROR.equals((Object)MemoryMonitor.getInstance().getMonitorState())) {
            this.notifyExceededMemory();
            check.setMemoryMonitorError();
            throw new LintingCancelledException();
        }
    }

    public Timer getCheckAliveDebouncer() {
        if (this.fCheckAliveDebouncer == null) {
            this.fCheckAliveDebouncer = new Timer("Verissimo Check Alive Debouncer", true);
        }
        return this.fCheckAliveDebouncer;
    }

    public void filterSince(Date sinceDate) {
        if (sinceDate == null) {
            return;
        }
        OVMComplianceCheckFilters.filterCategoriesAndChecks(this.fComplianceCategories, this.fChecks, OVMComplianceCheckFilters.isDateBefore(sinceDate));
    }

    public void filterSince(String sinceVersion) {
        if (sinceVersion == null) {
            return;
        }
        OVMComplianceCheckFilters.filterCategoriesAndChecks(this.fComplianceCategories, this.fChecks, OVMComplianceCheckFilters.isVersionBefore(sinceVersion));
    }

    public void filterUsedRules(Set<String> rulesetChecks) {
        if (rulesetChecks == null) {
            return;
        }
        OVMComplianceCheckFilters.filterCategoriesAndChecks(this.fComplianceCategories, this.fChecks, OVMComplianceCheckFilters.isSpecifiedRuleById(rulesetChecks));
    }

    public void filterLabels(Set<RuleLabel> labels) {
        if (labels == null || labels.isEmpty()) {
            return;
        }
        OVMComplianceCheckFilters.filterCategoriesAndChecks(this.fComplianceCategories, this.fChecks, OVMComplianceCheckFilters.hasLabels(labels).negate());
    }

    public void setReapplyOrRerun(boolean fReapplyOrRerun) {
        this.fReapplyOrRerun = fReapplyOrRerun;
    }

    public boolean hasManualChecks() {
        for (OVMComplianceCheck check : this.getChecks()) {
            if (!(check instanceof OVMComplianceManualCheck)) continue;
            return true;
        }
        return false;
    }

    public IProgressMonitor getLintMonitor() {
        return this.fProgressMonitor;
    }

    public static SimpleDateFormat getDateFormat() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        format.setLenient(false);
        return format;
    }

    public RReport getImportedReport() {
        return this.fImportedReport;
    }

    public void addLintingSemanticError(int severity, String pattern, int line, ParserPath parserPath, Object[] arguments) {
        if (!this.fRegisteredSemanticCheckPatterns.containsKey(pattern)) {
            return;
        }
        Set<LintingSemanticHit> hits = this.fRegisteredSemanticCheckPatterns.get(pattern);
        if (hits == null) {
            return;
        }
        CheckStatus hitSeverity = CheckStatus.ERROR;
        if (severity == 1) {
            hitSeverity = CheckStatus.ERROR;
        }
        if (severity == 2) {
            hitSeverity = CheckStatus.WARNING;
        }
        String message = MessageFormat.format(pattern, arguments);
        LintingSemanticHit hit = new LintingSemanticHit(parserPath, message, line, hitSeverity);
        hits.add(hit);
        this.fRegisteredSemanticCheckPatterns.put(pattern, hits);
    }

    public void cleanLintingSemanticErrors() {
        for (Map.Entry<String, Set<LintingSemanticHit>> entry : this.fRegisteredSemanticCheckPatterns.entrySet()) {
            this.fRegisteredSemanticCheckPatterns.put(entry.getKey(), new HashSet());
        }
    }

    public void cleanLintingSemanticErrors(Set<ParserPath> parserPaths) {
        for (Set<LintingSemanticHit> hits : this.fRegisteredSemanticCheckPatterns.values()) {
            hits.removeIf(hit -> parserPaths.contains(hit.getParserPath()));
        }
    }

    public Map<String, Set<LintingSemanticHit>> getSemanticCheckPatterns() {
        return this.fRegisteredSemanticCheckPatterns;
    }

    public Set<LintingSemanticHit> getSemanticCheckPatternHits(String pattern) {
        return this.fRegisteredSemanticCheckPatterns.get(pattern);
    }

    public void registerSemanticCheck(String pattern) {
        Set<LintingSemanticHit> hits = this.fRegisteredSemanticCheckPatterns.get(pattern);
        if (hits == null) {
            hits = new HashSet<LintingSemanticHit>();
        }
        this.fRegisteredSemanticCheckPatterns.put(pattern, hits);
    }

    public RulesetKind getTempRulesetkind() {
        return this.fTempRulesetkind;
    }

    public void setTempRulesetkind(RulesetKind rulesetkind) {
        this.fTempRulesetkind = rulesetkind;
    }

    public boolean isDirty() {
        return !this.fDirtyChecks.isEmpty();
    }

    public boolean isDirty(String checkName) {
        return this.fDirtyChecks.contains(checkName);
    }

    public void addDirty(String checkName) {
        this.fDirtyChecks.add(checkName);
    }

    public void removeDirty(String checkName) {
        this.fDirtyChecks.remove(checkName);
    }

    public void setDirty(Set<String> checkName) {
        this.fDirtyChecks.addAll(checkName);
    }

    public ReportManager getReportManager() {
        return this.fReportManager;
    }

    public void setReportManager(ReportManager reportManager) {
        this.fReportManager = reportManager;
    }

    public boolean isForceSimpleGUIReport() {
        return this.fForceSimpleGUIReport;
    }

    public void setForceSimpleGUIReport(boolean forceSimpleGUIReport) {
        this.fForceSimpleGUIReport = forceSimpleGUIReport;
    }

    public void clearDirty() {
        this.fDirtyChecks.clear();
    }

    public void registerMessage(String key, String message) {
        StringBuilder finalMessage = this.printMessageByRule.get(key);
        if (finalMessage == null) {
            finalMessage = new StringBuilder();
        }
        finalMessage.append(message);
        this.printMessageByRule.put(key, finalMessage);
    }

    public Map<String, StringBuilder> getPrintMessageByRule() {
        return this.printMessageByRule;
    }

    public SVTBWhitespaceParser initAndGetWhitespaceParser(IWhitespaceParserCheck check) {
        if (this.fWhitespaceParser == null) {
            this.fWhitespaceParser = new SVTBWhitespaceParser();
        }
        this.fWhitespaceParser.initLazy(this, check);
        return this.fWhitespaceParser;
    }

    public void setCompilationErrors(boolean compilationErrors) {
        this.compilationErrors = compilationErrors;
    }

    public boolean hasCompilationErrors() {
        return this.compilationErrors;
    }

    public void initializeProcessEndTime() {
        int processTimeoutValue = this.fConfiguration.getProcessTimeoutValue();
        if (processTimeoutValue == 0) {
            processTimeoutValue = this.getRulesetConfiguration().getProcessTimeout();
        }
        if (processTimeoutValue != 0) {
            this.fProcessEndTime = System.currentTimeMillis() + (long)(processTimeoutValue * 1000);
        }
    }

    public boolean hasTimedOutDuringBuild() {
        int processTimeout = this.fConfiguration.getProcessTimeoutValue();
        if (processTimeout == 0) {
            processTimeout = this.getRulesetConfiguration().getProcessTimeout();
        }
        if (processTimeout != 0 && System.currentTimeMillis() - this.fProcessEndTime > 0L) {
            if (!this.fProcessTimeoutReported) {
                DVTBuildConsole console = DVTBuildConsoleRegistry.getConsole((IProject)RfMixedLangManager.getInstance().getProject());
                console.print(String.valueOf(System.lineSeparator()) + "*** Error: Linting timedout!" + System.lineSeparator());
                this.notifyTimedOutSession();
                this.fProcessTimeoutReported = true;
            }
            return true;
        }
        return false;
    }

    public boolean compiledFilesChangedOnImport(RReport report) {
        if (report == null) {
            return false;
        }
        LinkedHashMap<String, String> allFilesHashesMap = report.getAllFilesHashesMap();
        HashSet<ParserPath> allFiles = this.getAllImportedFiles();
        Set<String> allBaselineReportFiles = report.getAllImportedFiles();
        Set allCurrentReportFiles = this.getAllImportedFiles().stream().map(e -> e.path).collect(Collectors.toSet());
        PathMapper.Result mappingResult = PathMapper.map(allCurrentReportFiles, allBaselineReportFiles, null);
        for (ParserPath parserPath : allFiles) {
            byte[] md5;
            if (parserPath.path.indexOf(TOPFILE_PREFIX) != -1 || (md5 = parserPath.getMd5()) == null) continue;
            if (mappingResult.isUnmappedA(parserPath.path)) {
                return true;
            }
            String baseReportLinePath = mappingResult.getB(parserPath.path);
            String reportFileHash = allFilesHashesMap.get(baseReportLinePath);
            if (reportFileHash == null || reportFileHash.equals(DVTStringUtil.bytes2hex((byte[])md5).toUpperCase())) continue;
            return true;
        }
        return false;
    }

    public boolean lintProject() {
        return this.lintProject;
    }

    public void setLintProject(boolean lintProject) {
        this.lintProject = lintProject;
    }

    public boolean isCompare() {
        return this.fReportManager.getBaselineReport() != null && !this.fForceSimpleGUIReport;
    }

    public boolean isInChangesMode() {
        return this.fIsInChangesMode;
    }

    public void switchModes() {
        this.fIsInChangesMode = !this.fIsInChangesMode;
        this.getChecks().forEach(c -> c.clearVisibleHits());
    }

    public boolean isChangesHidden(OVMComplianceCheckHit hit) {
        Set<String> compareAnnotations = hit.getCompareAnnotations();
        return this.isInChangesMode() && compareAnnotations != null && compareAnnotations.contains("Common");
    }

    public boolean isStartedFromBuildConfig() {
        return this.startedFromBuildConfig;
    }

    public void setStartedFromBuildConfig(boolean startedFromBuildConfig) {
        this.startedFromBuildConfig = startedFromBuildConfig;
    }

    public boolean isImportHTML() {
        return this.getConfiguration().getRulesetKind() == RulesetKind.IMPORT_FROM_HTML;
    }

    public void updateHitFilesAfterImport() {
        if (this.fImportedReport == null) {
            return;
        }
        Set<String> allBaselineReportFiles = this.fImportedReport.getAllImportedFiles();
        Set allCurrentReportFiles = this.getAllImportedFiles().stream().map(e -> e.path).collect(Collectors.toSet());
        PathMapper.Result mappingResult = PathMapper.map(allBaselineReportFiles, allCurrentReportFiles, null);
        for (OVMComplianceCheck check : this.fChecks) {
            for (OVMComplianceHit oVMComplianceHit : check.getAllHitsForRReport(false)) {
                List<OVMComplianceHit.DetailsLink> list;
                List<String[]> macroPathParts;
                ParserPath hitPath = oVMComplianceHit.getParserPath();
                if (!hitPath.path.equals("none") && !mappingResult.isUnmappedA(hitPath.path) && mappingResult.getB(hitPath.path) != null) {
                    oVMComplianceHit.setParserPath(new ParserPath(mappingResult.getB(hitPath.path)));
                }
                if ((macroPathParts = oVMComplianceHit.getMacroPathParts()) != null && !macroPathParts.isEmpty()) {
                    for (String[] stringArray : macroPathParts) {
                        if (stringArray.length <= 2 || mappingResult.isUnmappedA(stringArray[1]) || mappingResult.getB(stringArray[1]) == null) continue;
                        oVMComplianceHit.setMacroPath(oVMComplianceHit.getMacroPath().replace(stringArray[1], mappingResult.getB(stringArray[1])));
                    }
                }
                if ((list = oVMComplianceHit.getDetailsLinks()) == null || list.isEmpty()) continue;
                for (OVMComplianceHit.DetailsLink detailsLink : list) {
                    if (mappingResult.isUnmappedA(detailsLink.file) || mappingResult.getB(detailsLink.file) == null) continue;
                    detailsLink.file = mappingResult.getB(detailsLink.file);
                }
            }
        }
        Map<String, Integer> nofCompiledLinesPerFile = this.getNofCompiledLinesPerFile();
        HashMap<String, Integer> newCompiledLines = new HashMap<String, Integer>();
        for (Map.Entry entry : nofCompiledLinesPerFile.entrySet()) {
            if (!mappingResult.isUnmappedA((String)entry.getKey()) && mappingResult.getB((String)entry.getKey()) != null) {
                newCompiledLines.put(mappingResult.getB((String)entry.getKey()), (Integer)entry.getValue());
                continue;
            }
            newCompiledLines.put((String)entry.getKey(), (Integer)entry.getValue());
        }
        this.setNofCompiledLinesPerFile(newCompiledLines);
        for (PreWaiver preWaiver : this.getProjectWaivers().getPreWaivers()) {
            if (!"Prewaiver generated by prewaive_unchanged_files".equals(preWaiver.getName())) continue;
            LinkedHashMap<String, PathEntry> mappedPrewaivedFiles = new LinkedHashMap<String, PathEntry>();
            LinkedHashMap<String, PathEntry> prewaivedPaths = preWaiver.getPrewaivedPaths();
            for (Map.Entry entry : prewaivedPaths.entrySet()) {
                String file = (String)entry.getKey();
                if (!mappingResult.isUnmappedA(file) && mappingResult.getB(file) != null) {
                    file = mappingResult.getB(file);
                }
                mappedPrewaivedFiles.put(file, new PathEntry(file, preWaiver.getPathRegexType().equals("simple")));
            }
            preWaiver.setPrewaivedPaths(mappedPrewaivedFiles);
        }
    }

    public void removeOVMHitsByPaths(Set<String> unchangedFiles) {
        for (OVMComplianceCheck check : this.fChecks) {
            check.removeOVMHitsByPaths(unchangedFiles);
        }
    }

    public void setAutocorrectSkipSanityChecks(List<String> specifiedAutocorrectSkipSanityChecks) {
        if (specifiedAutocorrectSkipSanityChecks != null && !specifiedAutocorrectSkipSanityChecks.isEmpty()) {
            for (String bypassRule : specifiedAutocorrectSkipSanityChecks) {
                OVMComplianceCheck check = this.getCheck(bypassRule);
                if (check == null) continue;
                check.setAutoCorrectSkipSanityChecks(true);
            }
        }
    }

    public void computeZeroCompiledLines() {
        int lines = 0;
        HashMap<String, Integer> linesPerFile = new HashMap<String, Integer>();
        for (ParserPath parserPath : this.getAllImportedFiles()) {
            RfFileDef file = this.getRfProject().getFile(parserPath);
            if (file == null) continue;
            int nofLines = file.getEndLine();
            lines += nofLines;
            linesPerFile.put(parserPath.path, nofLines);
        }
        this.setNofCompiledLines(lines);
        this.setNofCompiledLinesPerFile(linesPerFile);
    }
}

