/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import ro.amiq.vlogdt.linter.OVMComplianceBuilder;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;

public class OVMReportInfoProvider
implements IAdaptable {
    private OVMComplianceBuilder fOVMBuilder = OVMComplianceBuilder.getInstance();
    private IProject fProject;

    public OVMReportInfoProvider(IProject project) {
        this.fProject = project;
    }

    public String getOutputPath() {
        if (this.fProject == null) {
            return "";
        }
        return this.fProject.getLocation().toOSString();
    }

    public ArrayList<OVMComplianceCategory> getCategories() {
        ArrayList<OVMComplianceCategory> cats = new ArrayList<OVMComplianceCategory>();
        for (OVMComplianceCategory cat : this.fOVMBuilder.getCategories(this.fProject)) {
            cats.add(cat);
        }
        return cats;
    }

    public String getProjectName() {
        if (this.fProject == null) {
            return "";
        }
        return this.fProject.getName();
    }

    public ArrayList<OVMComplianceCheck> getComplianceChecks(String categoryID) {
        OVMComplianceCategory category = this.fOVMBuilder.getCategory(categoryID, this.fProject);
        if (category == null) {
            return null;
        }
        return category.getChecks();
    }

    public OVMProject getOVMProject() {
        return this.fOVMBuilder.getOVMProject(this.fProject);
    }

    public Object getAdapter(Class adapter) {
        if (IResource.class.equals((Object)adapter) && this.fProject != null) {
            return this.fProject;
        }
        return null;
    }
}

