/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.PathMapper;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.report.VerissimoReportConverterCommon;
import ro.amiq.vlogdt.linter.report.VerissimoReportReader;
import ro.amiq.vlogdt.linter.report.VerissimoReportWriter;
import ro.amiq.vlogdt.linter.report.model.RCategory;
import ro.amiq.vlogdt.linter.report.model.RCheck;
import ro.amiq.vlogdt.linter.report.model.RHit;
import ro.amiq.vlogdt.linter.report.model.RReport;
import ro.amiq.vlogdt.linter.ui.HTML5ReportGenerator;
import ro.amiq.vlogdt.linter.ui.HTML5ReportMerger;
import ro.amiq.vlogdt.linter.waivers.PreWaiver;
import ro.amiq.vlogdt.linter.waivers.WaiverType;

public class ReportManager {
    private static boolean dirtyReports;
    private RReport fBaselineReport;
    private RReport fCurrentReport;
    private RReport fCompareReport;
    private RReport fChangesReport;

    public RReport getBaselineReport() {
        return this.fBaselineReport;
    }

    public void setBaselineReport(RReport baselineReport) {
        this.fBaselineReport = baselineReport;
    }

    public RReport getCurrentReport() {
        return this.fCurrentReport;
    }

    public void setCurrentReport(RReport currentReport) {
        this.fCurrentReport = currentReport;
    }

    public RReport getCompareReport() {
        return this.fCompareReport;
    }

    public void setCompareReport(RReport compareReport) {
        this.fCompareReport = compareReport;
    }

    public RReport getChangesReport() {
        return this.fChangesReport;
    }

    public void setChangesReport(RReport changesReport) {
        this.fChangesReport = changesReport;
    }

    public void clear(boolean clearBaselineReport) {
        if (clearBaselineReport) {
            this.fBaselineReport = null;
        }
        this.fChangesReport = null;
        this.fCompareReport = null;
        this.fCurrentReport = null;
    }

    public static boolean isDirtyReports() {
        return dirtyReports;
    }

    public static void setDirtyReports(boolean dirtyReports) {
        ReportManager.dirtyReports = dirtyReports;
    }

    public static Set<String> getUnchangedFiles(RReport baselineReportInfo, RReport currentReportInfo) {
        if (baselineReportInfo == null || currentReportInfo == null) {
            DVTLogger.INSTANCE.logError("ERROR: No project specified!");
            return null;
        }
        Set<String> allBaselineReportFiles = baselineReportInfo.getAllImportedFiles();
        Set<String> allCurrentReportFiles = currentReportInfo.getAllImportedFiles();
        LinkedHashMap<String, String> baselineFilesHashesMap = baselineReportInfo.getAllFilesHashesMap();
        LinkedHashMap<String, String> currentFilesHashesMap = currentReportInfo.getAllFilesHashesMap();
        PathMapper.Result mappingResult = PathMapper.map(allCurrentReportFiles, allBaselineReportFiles, null);
        LinkedHashSet<String> preWaivers = new LinkedHashSet<String>();
        for (Map.Entry<String, String> parserPath : currentFilesHashesMap.entrySet()) {
            String baselinePath = parserPath.getKey();
            if (mappingResult.isUnmappedA(parserPath.getKey()) || !baselineFilesHashesMap.containsKey(baselinePath = mappingResult.getB(parserPath.getKey())) || !baselineFilesHashesMap.get(baselinePath).equals(parserPath.getValue())) continue;
            preWaivers.add(parserPath.getKey());
        }
        return preWaivers;
    }

    public static void removeHitsFromReportsByFiles(RReport report, Set<String> unchangedFiles) {
        if (report == null) {
            return;
        }
        Set<String> allReportFiles = report.getAllImportedFiles();
        PathMapper.Result mappingResult = PathMapper.map(allReportFiles, unchangedFiles, null);
        for (RCategory category : report.getCategories()) {
            for (RCheck check : category.getChecks()) {
                check.getHits().stream().forEach(x -> {
                    x.setHiddenCompare(false);
                    x.setCompareAnnotations(new LinkedHashSet<String>());
                });
                check.getHits().stream().filter(x -> !mappingResult.isUnmappedA(x.getFile()) && unchangedFiles.contains(mappingResult.getB(x.getFile()))).forEach(x -> x.setHiddenCompare(true));
            }
        }
        report.getHits().stream().forEach(x -> {
            x.setHiddenCompare(false);
            x.setCompareAnnotations(new LinkedHashSet<String>());
        });
        report.getHits().stream().filter(x -> !mappingResult.isUnmappedA(x.getFile()) && unchangedFiles.contains(mappingResult.getB(x.getFile()))).forEach(x -> x.setHiddenCompare(true));
    }

    public static boolean createPreWaiversWithBaselineReport(RReport reportInfo, OVMProject XVMProject) {
        if (reportInfo == null || XVMProject == null) {
            DVTLogger.INSTANCE.logError("ERROR: No project specified!");
            return false;
        }
        LinkedHashMap<String, String> allFilesHashesMap = reportInfo.getAllFilesHashesMap();
        HashSet<ParserPath> allFiles = XVMProject.getAllImportedFiles();
        Set<String> allBaselineReportFiles = reportInfo.getAllImportedFiles();
        Set allCurrentReportFiles = XVMProject.getAllImportedFiles().stream().map(e -> e.path).collect(Collectors.toSet());
        PathMapper.Result mappingResult = PathMapper.map(allCurrentReportFiles, allBaselineReportFiles, null);
        PreWaiver preWaiver = new PreWaiver();
        preWaiver.setType(WaiverType.READ_ONLY);
        preWaiver.setName("Prewaiver generated by prewaive_unchanged_files");
        preWaiver.setPathRegexType("simple");
        for (ParserPath parserPath : allFiles) {
            String baseReportLinePath;
            String reportFileHash;
            byte[] md5;
            if (parserPath.path.indexOf("__vlog__") != -1 || (md5 = parserPath.getMd5()) == null || mappingResult.isUnmappedA(parserPath.path) || (reportFileHash = allFilesHashesMap.get(baseReportLinePath = mappingResult.getB(parserPath.path))) == null) continue;
            if (reportFileHash.isEmpty()) {
                DVTLogger.INSTANCE.logError("ERROR: Older reports and reports generated with compare, merge or diff cannot be used as baseline!");
                return false;
            }
            if (!reportFileHash.equals(DVTStringUtil.bytes2hex((byte[])md5).toUpperCase())) continue;
            String path = DVTStringUtil.intern((String)Utils.canonicPath((String)parserPath.path));
            preWaiver.addPath(path);
            preWaiver.addRawPath(path);
        }
        XVMProject.getProjectWaivers().addPreWaiver(preWaiver);
        XVMProject.getProjectWaivers().computePrewaivedPaths();
        return true;
    }

    public static void setReports(IProgressMonitor monitor, OVMProject ovmProject) {
        ReportManager.setDirtyReports(false);
        RReport currentReport = VerissimoReportConverterCommon.convertToRReport(ovmProject, HTML5ReportGenerator.collectInfo(ovmProject), null, monitor, HTML5ReportGenerator::subprogressMonitorSuplier, false, true);
        currentReport.setBaselineReportLocation("");
        ovmProject.getReportManager().setCurrentReport(currentReport);
        if (ovmProject.isCompare()) {
            ReportManager.removeBaselineChecksAndCategories(monitor, ovmProject);
        } else if (ovmProject.getConfiguration().getBaselineReportLocation() != null && !ovmProject.getConfiguration().getBaselineReportLocation().isEmpty()) {
            ReportManager.compareReportWithBaseline(monitor, ovmProject);
        }
    }

    private static void removeBaselineChecksAndCategories(IProgressMonitor monitor, OVMProject ovmProject) {
        RReport currentReport = VerissimoReportConverterCommon.convertToRReport(ovmProject, HTML5ReportGenerator.collectInfo(ovmProject), null, monitor, HTML5ReportGenerator::subprogressMonitorSuplier, false, true);
        ArrayList<String> commonSegmentsInfo = new ArrayList<String>(Arrays.asList("0"));
        currentReport.getInfoWrapper().setCommonSegmentsInfo(commonSegmentsInfo);
        if (ovmProject.getConfiguration().isPrewaivedUnchanged()) {
            ReportManager.removeHitsFromReportsByFiles(ovmProject.getReportManager().getBaselineReport(), ReportManager.getUnchangedFiles(ovmProject.getReportManager().getBaselineReport(), currentReport));
        }
        RReport compareReport = HTML5ReportMerger.compareReportsWithMapping(currentReport, new RReport(ovmProject.getReportManager().getBaselineReport()), null);
        ReportManager.filterUsingCompareReport(compareReport, ovmProject);
        ovmProject.getReportManager().setCompareReport(compareReport);
        ovmProject.getReportManager().setChangesReport(VerissimoReportConverterCommon.convertToRReport(ovmProject, HTML5ReportGenerator.collectInfo(ovmProject), null, monitor, HTML5ReportGenerator::subprogressMonitorSuplier, true));
    }

    private static void compareReportWithBaseline(IProgressMonitor monitor, OVMProject ovmProject) {
        try {
            ovmProject.getReportManager().setBaselineReport(VerissimoReportReader.readReportFiles(ovmProject.getConfiguration().getBaselineReportLocation()));
        }
        catch (Exception e) {
            DVTBuildConsoleRegistry.getConsole((IProject)ovmProject.getProject()).print(MessageFormat.format("*** Error: {0}", "Could not read baseline report for comparison."));
            DVTLogger.INSTANCE.logError("ERROR: Could not read baseline report for comparison. " + e.getMessage() + "\n");
            return;
        }
        if (ovmProject.isForceSimpleGUIReport() && !ovmProject.isInChangesMode()) {
            ovmProject.switchModes();
        }
        RReport currentReport = VerissimoReportConverterCommon.convertToRReport(ovmProject, HTML5ReportGenerator.collectInfo(ovmProject), null, monitor, HTML5ReportGenerator::subprogressMonitorSuplier, false, true);
        ArrayList<String> commonSegmentsInfo = new ArrayList<String>(Arrays.asList("0"));
        currentReport.getInfoWrapper().setCommonSegmentsInfo(commonSegmentsInfo);
        File codeFolder = new File(ovmProject.getConfiguration().getBaselineReportLocation(), "code");
        if (codeFolder.exists() && codeFolder.isDirectory()) {
            if (ovmProject.getConfiguration().isPrewaivedUnchanged()) {
                ReportManager.removeHitsFromReportsByFiles(ovmProject.getReportManager().getBaselineReport(), ReportManager.getUnchangedFiles(ovmProject.getReportManager().getBaselineReport(), currentReport));
            }
            RReport compareReport = HTML5ReportMerger.compareReportsWithMapping(currentReport, new RReport(ovmProject.getReportManager().getBaselineReport()), null);
            ReportManager.filterUsingCompareReport(compareReport, ovmProject);
            ovmProject.getReportManager().setCompareReport(compareReport);
        } else {
            ovmProject.setForceSimpleGUIReport(true);
            ovmProject.removeOVMHitsByPaths(ReportManager.getUnchangedFiles(ovmProject.getReportManager().getBaselineReport(), currentReport));
            DVTBuildConsoleRegistry.getConsole((IProject)ovmProject.getProject()).print(MessageFormat.format("*** Warning: {0}", "No valid code folder found in location '" + ovmProject.getConfiguration().getBaselineReportLocation() + "'. \nInclude the source files in the HTML report when generating the baseline report, otherwise Verissimo will only pre-waive unchanged files without comparing.\n"));
        }
    }

    private static void filterUsingCompareReport(RReport compareReport, OVMProject ovmProject) {
        Map checkNameMap = compareReport.getChecks().stream().collect(Collectors.toMap(RCheck::getCheckName, RCheck::getSelf, (e1, e2) -> e1, HashMap::new));
        for (OVMComplianceCheck check : ovmProject.getChecks()) {
            RCheck rCheck = (RCheck)checkNameMap.get(check.getName());
            Set<RHit> rHits = rCheck.getHits();
            Set rCurrentHits = rHits.stream().filter(hit -> hit.getCompareHitOrigin().equals("Current")).collect(Collectors.toSet());
            for (RHit rCurrentHit : rCurrentHits) {
                OVMComplianceCheckHit ovmHit = check.getOVMHit(rCurrentHit);
                if (ovmHit == null) continue;
                if (!rCurrentHit.getCompareAnnotations().contains("New Failures") && !rCurrentHit.getCompareAnnotations().contains("Added Rules")) {
                    ovmHit.addCompareAnnotation("Common");
                    continue;
                }
                rCurrentHit.getCompareAnnotations().stream().forEach(x -> ovmHit.addCompareAnnotation((String)x));
            }
        }
    }

    public static File generateCompareReport(String location, RReport report, IProgressMonitor monitor, boolean createReportFolder) {
        File indexFile = HTML5ReportMerger.generateMergedReport(location, report, false, false, createReportFolder, ReportType.COMPARE);
        if (indexFile != null) {
            File reportFolder = indexFile.getParentFile();
            File[] reportFolderArr = new File[]{reportFolder};
            VerissimoReportWriter.writeHtmlCodeFiles(reportFolderArr, report, HTML5ReportGenerator::errorHandler, monitor);
        }
        return indexFile;
    }

    public static enum ReportType {
        COMPARE("Compare"),
        CHANGES("Changes"),
        CURRENT("Current");

        private final String fReportName;

        private ReportType(String reportName) {
            this.fReportName = reportName;
        }

        public String getReportName() {
            return this.fReportName;
        }

        public static ReportType from(String reportType) {
            switch (reportType) {
                case "Compare": {
                    return COMPARE;
                }
                case "Changes": {
                    return CHANGES;
                }
                case "Current": {
                    return CURRENT;
                }
            }
            return CURRENT;
        }
    }
}

