/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.vlogdt.linter.OVMComplianceBuilder;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.SingleFileLintingBuilderCommon;
import ro.amiq.vlogdt.linter.ui.LintingProblemsManager;

public class SingleFileLintingBuilder
extends SingleFileLintingBuilderCommon {
    private static SingleFileLintingBuilder fInstance;
    private static final Object fSyncInstance;

    static {
        fSyncInstance = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SingleFileLintingBuilder getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new SingleFileLintingBuilder();
            }
        }
        return fInstance;
    }

    @Override
    public IFile getSelectedFile() {
        IResource resource = DVTPlugin.getSelectionManager().getLastSelectedResource();
        if (!(resource instanceof IFile)) {
            return null;
        }
        return (IFile)resource;
    }

    public static void clearMarkers(IProject project) {
        SingleFileLintingBuilder.getInstance().clearLintingMarkers(project);
    }

    @Override
    protected void openErrorMessage(String title, String message) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> new MessageDialog(DVTUiUtils.getActiveWorkbenchWindow().getShell(), title, null, message, 1, new String[]{IDialogConstants.OK_LABEL}, 0).open());
    }

    @Override
    protected OVMProject getOvmProject(IProject project) {
        return OVMComplianceBuilder.getInstance().getOVMProject(project);
    }

    @Override
    protected void lint(final IProject project, final boolean printAutofixSummary) throws Exception {
        ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        try {
            progressDialog.run(true, true, (IRunnableWithProgress)new WorkspaceModifyOperation(null){

                protected void execute(IProgressMonitor monitor) {
                    try {
                        ArrayList<OVMComplianceCheck> checks = OVMComplianceBuilder.getInstance().getChecks(project);
                        if (checks != null) {
                            monitor.beginTask("Running: ", checks.size());
                            OVMComplianceBuilder.getInstance().build(project, monitor, false, null, printAutofixSummary);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    protected void clearLintingMarkers(IProject project) {
        LintingProblemsManager.getInstance().clearMarkers(project);
        OVMProject ovmProject = OVMComplianceBuilder.getInstance().getOVMProject(project);
        if (ovmProject != null && !ovmProject.lintProject()) {
            OVMComplianceBuilder.getInstance().removeOVMProject(project);
        }
    }
}

