/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.model.IDVTReparseListener;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.dvt.ui.views.BuildEventManager;
import ro.amiq.dvt.ui.views.IBuildEventManagerListener;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixManager;
import ro.amiq.vlogdt.linter.waivers.PreWaiver;
import ro.amiq.vlogdt.linter.waivers.WaiverType;
import ro.amiq.vlogdt.model.IVlogModule;
import ro.amiq.vlogdt.model.VlogModelManager;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfProject;

public abstract class SingleFileLintingBuilderCommon
implements IDVTReparseListener {
    protected IFile selectedFile = null;
    protected boolean postIncremental;
    protected boolean reparsedResource;

    protected SingleFileLintingBuilderCommon() {
    }

    public void startSingleFileIncrementalAndLinting(IProject project) throws Exception {
        this.startSingleFileIncrementalAndLinting(project, false);
    }

    public void startSingleFileIncrementalAndLinting(IProject project, boolean printAutofixSummary) throws Exception {
        this.postIncremental = false;
        this.reparsedResource = false;
        VlogModelManager.getInstance().addReparseListener(this);
        this.selectedFile = this.getSelectedFile();
        OVMProject ovmProject = this.getOvmProject(project);
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return;
        }
        ovmProject.initialize(rfProject, true, true);
        ovmProject.initializeComponents();
        if (this.selectedFile != null) {
            if (DVTFileUtils.getInstance().resource2parser((IResource)this.selectedFile) == null) {
                this.openErrorMessage("Linting failed", "Unable to identify an open file. Please open a file you would like to lint!");
                return;
            }
            ovmProject.preFullBuildNotification(ovmProject.getRfProject());
            IBuildEventManagerListener buildListener = this.createBuildListener();
            BuildEventManager.getInstance().registerListener(buildListener);
            IVlogModule module = VlogModelManager.getInstance().getVlogModel().getOrCreateVlogModule(this.selectedFile);
            DocumentManager docManager = new DocumentManager();
            IDocument document = null;
            try {
                docManager.activate();
                document = docManager.getDocument(DVTFileUtils.getInstance().resource2parser((IResource)this.selectedFile), project);
            }
            finally {
                docManager.deactivate();
            }
            if (module == null || document == null) {
                BuildEventManager.getInstance().unregisterListener(buildListener);
                return;
            }
            module.setDirty(true);
            module.scheduleReparse(false, true, 0L, document, false);
            long incrementalStartTime = System.currentTimeMillis();
            while (!this.reparsedResource || !this.postIncremental) {
                if ((System.currentTimeMillis() - incrementalStartTime) / 1000L > 10L) {
                    this.openErrorMessage("Linting timed out", "Linting the current file has timed out!");
                    module.cancelReparse();
                    BuildEventManager.getInstance().unregisterListener(buildListener);
                    return;
                }
                if (Display.getDefault().readAndDispatch()) continue;
                Display.getDefault().sleep();
            }
            BuildEventManager.getInstance().unregisterListener(buildListener);
            this.createPrewaiverForCurrentFile(ovmProject);
        }
        if (this.selectedFile != null && this.reparsedResource && this.postIncremental) {
            this.lint(project, printAutofixSummary);
        }
    }

    private IBuildEventManagerListener createBuildListener() {
        return new IBuildEventManagerListener(){

            public void notifyCleanBuild(IProject project) {
            }

            public void notifyFullBuild(IProject project) {
            }

            public void notifyIncrementalBuild(IProject project, Map<LanguageKind, Set<FileCompileInfo>> changedFiles, Set<String> updateViewIds) {
                if (changedFiles == null) {
                    return;
                }
                for (Map.Entry<LanguageKind, Set<FileCompileInfo>> entry : changedFiles.entrySet()) {
                    Set<FileCompileInfo> changedFilesKind;
                    if (entry.getKey() != LanguageKind.VLOG || (changedFilesKind = entry.getValue()).size() != 1) continue;
                    FileCompileInfo changedFile = changedFilesKind.iterator().next();
                    IFile selectedFile = SingleFileLintingBuilderCommon.this.getSelectedFile();
                    if (selectedFile == null || changedFile == null || !selectedFile.equals((Object)changedFile.getFile())) continue;
                    SingleFileLintingBuilderCommon.this.postIncremental = true;
                    return;
                }
            }
        };
    }

    private void createPrewaiverForCurrentFile(OVMProject ovmProject) {
        String path = DVTStringUtil.intern((String)Utils.canonicPath((String)DVTFileUtils.getInstance().resource2parser((IResource)this.selectedFile).path));
        PreWaiver preWaiver = new PreWaiver();
        preWaiver.setType(WaiverType.READ_ONLY);
        preWaiver.setName("Lint current file");
        preWaiver.setPathRegexType("simple");
        preWaiver.setApplyOn("not-matched");
        preWaiver.addPath(path);
        preWaiver.addRawPath(path);
        ovmProject.getProjectWaivers().addPreWaiver(preWaiver);
        ovmProject.getProjectWaivers().computePrewaivedPaths();
    }

    public void reparsed(int buildKind, int type, IResource resource, List errors, List warnings, List tasks) {
        if (buildKind != 0) {
            return;
        }
        if (resource != null && !resource.equals((Object)this.selectedFile)) {
            return;
        }
        this.reparsedResource = true;
    }

    public void clearResults(IProject project) {
        OVMProject ovmProject = this.getOvmProject(project);
        if (ovmProject == null || ovmProject.lintProject()) {
            return;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject != null) {
            rfProject.stopLintTracking();
        }
        ovmProject.clean(true, true);
        VerissimoAutofixManager.getInstance().cleanCanonicalPathsCache();
        this.clearLintingMarkers(project);
    }

    public boolean isEnabled(IProject project) {
        OVMProject ovmProject = this.getOvmProject(project);
        if (ovmProject == null) {
            return false;
        }
        return !ovmProject.lintProject();
    }

    protected abstract void clearLintingMarkers(IProject var1);

    protected abstract void openErrorMessage(String var1, String var2);

    protected abstract IFile getSelectedFile();

    protected abstract OVMProject getOvmProject(IProject var1);

    protected abstract void lint(IProject var1, boolean var2) throws Exception;
}

