/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.annotations;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.vlogdt.linter.annotations.Annotation;
import ro.amiq.vlogdt.linter.annotations.AnnotationCcField;
import ro.amiq.vlogdt.linter.annotations.AnnotationLineProcessor;
import ro.amiq.vlogdt.linter.annotations.AnnotationResults;

public enum AnnotationCcProcessor implements AnnotationLineProcessor
{
    INSTANCE;

    private static final String START = "START";
    private static final String CODE = "CODE";

    @Override
    public void process(List<Annotation> annotations, Map<String, List<Integer>> lineByFileMap, AnnotationResults results, IProgressMonitor monitor) {
        try {
            int iterations = lineByFileMap.size();
            monitor.beginTask("Gathering clearcase annotate information...", iterations);
            if (monitor.isCanceled()) {
                return;
            }
            EnumMap indexesByFieldMap = new EnumMap(AnnotationCcField.class);
            HashMap fieldsByNameMap = new HashMap();
            this.extractMapsFromAnnotationArgs(annotations, 0, indexesByFieldMap, fieldsByNameMap);
            String[] stringFields = this.getStringFields();
            AtomicInteger iteration = new AtomicInteger(0);
            lineByFileMap.entrySet().parallelStream().forEach(lineByFileEntry -> {
                if (monitor.isCanceled()) {
                    return;
                }
                monitor.subTask("Running clearcase annotate (" + iteration.incrementAndGet() + "/" + iterations + ") " + (String)lineByFileEntry.getKey());
                this.processFile((String)lineByFileEntry.getKey(), (List)lineByFileEntry.getValue(), indexesByFieldMap, fieldsByNameMap, stringFields, results);
                monitor.worked(1);
            });
        }
        finally {
            monitor.done();
        }
    }

    void processFile(String file, List<Integer> lines, Map<AnnotationCcField, Set<Integer>> indexesByFieldMap, Map<String, AnnotationCcField> fieldsByNameMap, String[] stringFields, AnnotationResults results) {
        block18: {
            ArrayList<String> command = new ArrayList<String>();
            command.add("cleartool");
            command.add("annotate");
            command.add("-nheader");
            command.add("-force");
            command.add("-fmt");
            command.add("START\\nCOMMENT\\n%c\\nUSERNAME\\n%u\\nFULL_USERNAME\\n%Fu\\nDATE\\n%Nd\\nCODE\\n");
            command.add("-out");
            command.add("-");
            command.add(file);
            Process process = null;
            BufferedReader reader = null;
            try {
                process = DVTUtilsCommon.INSTANCE.startProcess(command, new File(file).getParentFile());
                reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.ISO_8859_1));
                int lineNo = 0;
                String line = reader.readLine();
                while (line != null) {
                    if (!(line = line.trim()).equals(START)) {
                        if (line.startsWith("cleartool: Error:")) {
                            throw new IllegalArgumentException(new StringBuilder(256).append("Annotation processor error!").append('\n').append("Command: ").append(String.join((CharSequence)" ", command)).append('\n').append("Output: ").append(line).toString());
                        }
                        throw new IllegalArgumentException("Annotation processor error! Couldn't process clearcase annotate output!" + '\n' + ("Line = " + (lineNo + 1)) + '\n' + ("Expected 'START' and got '" + line + "'!") + '\n');
                    }
                    if (!lines.contains(++lineNo)) {
                        line = this.skipLine(reader);
                        continue;
                    }
                    line = reader.readLine();
                    if (line != null) {
                        line = line.trim();
                        String[] annotationStrings = new String[results.getInfos().length];
                        String valueOfField = null;
                        String currentField = null;
                        String nextField = null;
                        int i = 0;
                        while (i < stringFields.length - 1) {
                            currentField = stringFields[i];
                            nextField = stringFields[i + 1];
                            if (line != null && !line.equals(currentField)) {
                                throw new IllegalArgumentException("Annotation processor error! Couldn't process clearcase annotate output!" + '\n' + ("Line = " + lineNo) + '\n' + ("Expected '" + currentField + "' and got '" + line + "'!") + '\n');
                            }
                            StringBuilder valueOfFieldBuffer = new StringBuilder();
                            line = reader.readLine();
                            while (line != null && !line.trim().equals(nextField)) {
                                valueOfFieldBuffer.append(line);
                                line = reader.readLine();
                            }
                            valueOfField = valueOfFieldBuffer.toString().trim();
                            AnnotationCcField field = fieldsByNameMap.get(currentField.toLowerCase().replace('_', '-'));
                            if (field != null && valueOfField != null) {
                                for (Integer index : indexesByFieldMap.get(field)) {
                                    annotationStrings[index.intValue()] = field.prettify(valueOfField);
                                }
                            }
                            ++i;
                        }
                        results.addStrings(file, lineNo, annotationStrings);
                        if (line != null) {
                            continue;
                        }
                    }
                    break;
                }
            }
            catch (IOException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                DVTUtilsCommon.INSTANCE.closeClosable(reader);
                DVTUtilsCommon.INSTANCE.killProcess(process);
                break block18;
            }
            catch (IllegalArgumentException e) {
                try {
                    DVTLogger.INSTANCE.logDebug(e.getMessage());
                }
                catch (Throwable throwable) {
                    DVTUtilsCommon.INSTANCE.closeClosable(reader);
                    DVTUtilsCommon.INSTANCE.killProcess(process);
                    throw throwable;
                }
                DVTUtilsCommon.INSTANCE.closeClosable(reader);
                DVTUtilsCommon.INSTANCE.killProcess(process);
                break block18;
            }
            DVTUtilsCommon.INSTANCE.closeClosable((Closeable)reader);
            DVTUtilsCommon.INSTANCE.killProcess(process);
        }
    }

    public String skipLine(BufferedReader reader) throws IOException {
        String line = null;
        while ((line = reader.readLine()) != null && !line.trim().equals(START)) {
        }
        return line;
    }

    private String[] getStringFields() {
        AnnotationCcField[] fields = AnnotationCcField.values();
        String[] stringFields = new String[fields.length + 2];
        int i = 0;
        while (i < fields.length) {
            stringFields[i] = fields[i].name();
            ++i;
        }
        stringFields[fields.length] = CODE;
        stringFields[fields.length + 1] = START;
        return stringFields;
    }
}

