/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.annotations;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import ro.amiq.vlogdt.linter.annotations.AnnotationField;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum AnnotationFsField implements AnnotationField
{
    LAST_MODIFIED{

        @Override
        public String prettify(String string) {
            try {
                return Instant.ofEpochMilli(Long.parseLong(string)).atZone(ZoneId.of("UTC")).format(DEFAULT_DATE_FORMATTER);
            }
            catch (DateTimeParseException dateTimeParseException) {
                return string;
            }
        }
    };


    public String toString() {
        return this.name().replace('_', '-').toLowerCase();
    }
}

