/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.annotations;

import java.io.File;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.vlogdt.linter.annotations.Annotation;
import ro.amiq.vlogdt.linter.annotations.AnnotationFsField;
import ro.amiq.vlogdt.linter.annotations.AnnotationLineProcessor;
import ro.amiq.vlogdt.linter.annotations.AnnotationResults;

public enum AnnotationFsProcessor implements AnnotationLineProcessor
{
    INSTANCE;


    @Override
    public void process(List<Annotation> annotations, Map<String, List<Integer>> lineByFileMap, AnnotationResults results, IProgressMonitor monitor) {
        try {
            int iterations = lineByFileMap.size();
            monitor.beginTask("Gathering file system date information...", iterations);
            if (monitor.isCanceled()) {
                return;
            }
            EnumMap indexesByFieldMap = new EnumMap(AnnotationFsField.class);
            HashMap fieldsByNameMap = new HashMap();
            this.extractMapsFromAnnotationArgs(annotations, 0, indexesByFieldMap, fieldsByNameMap);
            AtomicInteger iteration = new AtomicInteger(0);
            lineByFileMap.entrySet().parallelStream().forEach(lineByFileEntry -> {
                if (monitor.isCanceled()) {
                    return;
                }
                monitor.subTask("Extracting file information (" + iteration.incrementAndGet() + "/" + iterations + ") " + (String)lineByFileEntry.getKey());
                this.processFile((String)lineByFileEntry.getKey(), (List)lineByFileEntry.getValue(), indexesByFieldMap, results);
                monitor.worked(1);
            });
        }
        finally {
            monitor.done();
        }
    }

    private void processFile(String file, List<Integer> lines, Map<AnnotationFsField, Set<Integer>> indexByFieldMap, AnnotationResults results) {
        File fsFile = new File(file);
        String[] annotationStrings = new String[results.getInfos().length];
        Set<Integer> indeces = indexByFieldMap.get(AnnotationFsField.LAST_MODIFIED);
        if (indeces != null && !indeces.isEmpty()) {
            long lastModified = fsFile.lastModified();
            if (lastModified <= 0L) {
                return;
            }
            String string = AnnotationFsField.LAST_MODIFIED.prettify(Long.toString(lastModified));
            for (Integer index : indeces) {
                annotationStrings[index.intValue()] = string;
            }
            for (Integer line : lines) {
                results.addStrings(file, line, annotationStrings);
            }
        }
    }
}

