/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.annotations;

import java.time.Instant;
import java.time.ZoneId;
import ro.amiq.vlogdt.linter.annotations.AnnotationField;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum AnnotationGitField implements AnnotationField
{
    SHA1,
    AUTHOR,
    AUTHOR_MAIL{

        @Override
        public String prettify(String string) {
            return AnnotationGitField.removeAngulars(string);
        }
    }
    ,
    AUTHOR_TIME{

        @Override
        public String prettify(String string) {
            return AnnotationGitField.convertEpochSecondToDate(string);
        }
    }
    ,
    COMMITTER,
    COMMITTER_MAIL{

        @Override
        public String prettify(String string) {
            return AnnotationGitField.removeAngulars(string);
        }
    }
    ,
    COMMITTER_TIME{

        @Override
        public String prettify(String string) {
            return AnnotationGitField.convertEpochSecondToDate(string);
        }
    }
    ,
    SUMMARY;


    public String toString() {
        return this.name().replace('_', '-').toLowerCase();
    }

    private static String convertEpochSecondToDate(String string) {
        try {
            return Instant.ofEpochSecond(Long.parseLong(string)).atZone(ZoneId.of("UTC")).format(DEFAULT_DATE_FORMATTER);
        }
        catch (NumberFormatException numberFormatException) {
            return string;
        }
    }

    private static String removeAngulars(String string) {
        return string.substring(string.charAt(0) == '<' ? 1 : 0, string.charAt(string.length() - 1) == '>' ? string.length() - 1 : string.length());
    }
}

