/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.annotations;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.osgi.framework.Version;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.vlogdt.linter.annotations.Annotation;
import ro.amiq.vlogdt.linter.annotations.AnnotationGitField;
import ro.amiq.vlogdt.linter.annotations.AnnotationLineProcessor;
import ro.amiq.vlogdt.linter.annotations.AnnotationResults;

public enum AnnotationGitProcessor implements AnnotationLineProcessor
{
    INSTANCE;

    private static final String GIT_VERSION_STRING = "git version ";
    private static final Version GIT_BLAME_MULTI_LINES_VERSION;
    private static final Pattern SHA_PATTERN;

    static {
        GIT_BLAME_MULTI_LINES_VERSION = new Version(1, 8, 5);
        SHA_PATTERN = Pattern.compile("[0-9a-f]+");
    }

    @Override
    public void process(List<Annotation> annotations, Map<String, List<Integer>> lineByFileMap, AnnotationResults results, IProgressMonitor monitor) {
        try {
            int iterations = lineByFileMap.size();
            monitor.beginTask("Gathering git blame information...", iterations);
            Version version = this.getGitVersion();
            if (version == null) {
                return;
            }
            if (monitor.isCanceled()) {
                return;
            }
            EnumMap indexesByFieldMap = new EnumMap(AnnotationGitField.class);
            HashMap fieldsByNameMap = new HashMap();
            this.extractMapsFromAnnotationArgs(annotations, 0, indexesByFieldMap, fieldsByNameMap);
            boolean multiLines = GIT_BLAME_MULTI_LINES_VERSION.compareTo(version) <= 0;
            AtomicInteger iteration = new AtomicInteger(0);
            lineByFileMap.entrySet().parallelStream().forEach(lineByFileEntry -> {
                if (monitor.isCanceled()) {
                    return;
                }
                monitor.subTask("Running git blame (" + iteration.incrementAndGet() + "/" + iterations + ") " + (String)lineByFileEntry.getKey());
                this.processFile((String)lineByFileEntry.getKey(), (List)lineByFileEntry.getValue(), multiLines, indexesByFieldMap, fieldsByNameMap, results);
                monitor.worked(1);
            });
        }
        finally {
            monitor.done();
        }
    }

    private void processFile(String file, List<Integer> lines, boolean multiLines, Map<AnnotationGitField, Set<Integer>> indexByFieldMap, Map<String, AnnotationGitField> fieldsByNameMap, AnnotationResults results) {
        block19: {
            ArrayList<String> command = new ArrayList<String>();
            command.add("git");
            command.add("blame");
            command.add("--incremental");
            if (multiLines) {
                int startLine = lines.get(0);
                int endLine = lines.get(0);
                int i = 1;
                while (i < lines.size()) {
                    int line = lines.get(i);
                    if (line - endLine > 1 || i == lines.size() - 1) {
                        command.add("-L " + startLine + "," + endLine);
                        startLine = endLine = line;
                    } else {
                        endLine = line;
                    }
                    ++i;
                }
                command.add("-L " + startLine + "," + endLine);
            }
            command.add(file);
            Process process = null;
            BufferedReader reader = null;
            try {
                process = DVTUtilsCommon.INSTANCE.startProcess(command, new File(file).getParentFile());
                reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                StreamTokenizer tokenizer = new StreamTokenizer(reader);
                tokenizer.resetSyntax();
                tokenizer.wordChars(0, 255);
                tokenizer.whitespaceChars(0, 32);
                tokenizer.eolIsSignificant(true);
                String[] annotationStrings = new String[results.getInfos().length];
                int[] lineRange = null;
                int token = -4;
                while ((token = tokenizer.nextToken()) != -1) {
                    if (token != -3) continue;
                    if (tokenizer.sval.startsWith("fatal:") || tokenizer.sval.startsWith("error:")) {
                        throw new IllegalArgumentException(new StringBuilder(128).append("Annotation processor error!").append('\n').append("Command: ").append(String.join((CharSequence)" ", command)).append('\n').append("Output: ").append(tokenizer.sval).append(' ').append(this.readStringLine(tokenizer)).toString());
                    }
                    AnnotationGitField field = fieldsByNameMap.get(tokenizer.sval);
                    if (field != null) {
                        String string = field.prettify(this.readStringLine(tokenizer));
                        for (Integer index : indexByFieldMap.get(field)) {
                            annotationStrings[index.intValue()] = string;
                        }
                        continue;
                    }
                    if (tokenizer.sval.equals("filename")) {
                        this.skipLine(tokenizer);
                        if (lineRange == null) continue;
                        void i = lineRange[0];
                        while (i < lineRange[0] + lineRange[1]) {
                            results.addStrings(file, (int)i, annotationStrings);
                            ++i;
                        }
                        lineRange = null;
                        continue;
                    }
                    if (tokenizer.sval.length() == 40 && DVTStringUtil.matches((Pattern)SHA_PATTERN, (CharSequence)tokenizer.sval)) {
                        Set<Integer> sha1Indexes = indexByFieldMap.get(AnnotationGitField.SHA1);
                        if (sha1Indexes != null) {
                            for (Integer index : sha1Indexes) {
                                annotationStrings[index.intValue()] = tokenizer.sval;
                            }
                        }
                        lineRange = this.readIntLine(tokenizer);
                        continue;
                    }
                    this.skipLine(tokenizer);
                }
            }
            catch (IOException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                DVTUtilsCommon.INSTANCE.closeClosable(reader);
                DVTUtilsCommon.INSTANCE.killProcess(process);
                break block19;
            }
            catch (IllegalArgumentException e) {
                try {
                    DVTLogger.INSTANCE.logDebug(e.getMessage());
                }
                catch (Throwable throwable) {
                    DVTUtilsCommon.INSTANCE.closeClosable(reader);
                    DVTUtilsCommon.INSTANCE.killProcess(process);
                    throw throwable;
                }
                DVTUtilsCommon.INSTANCE.closeClosable(reader);
                DVTUtilsCommon.INSTANCE.killProcess(process);
                break block19;
            }
            DVTUtilsCommon.INSTANCE.closeClosable((Closeable)reader);
            DVTUtilsCommon.INSTANCE.killProcess(process);
        }
    }

    private int[] readIntLine(StreamTokenizer tokenizer) throws IOException {
        String[] buffer = new String[2];
        int token = -4;
        while ((token = tokenizer.nextToken()) != 10 && token != -1) {
            if (token != -3) continue;
            buffer[0] = buffer[1];
            buffer[1] = tokenizer.sval;
        }
        try {
            return new int[]{Integer.parseInt(buffer[0]), Integer.parseInt(buffer[1])};
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private String readStringLine(StreamTokenizer tokenizer) throws IOException {
        StringBuilder sb = new StringBuilder(64);
        int token = -4;
        while ((token = tokenizer.nextToken()) != 10 && token != -1) {
            if (token != -3) continue;
            sb.append(tokenizer.sval).append(' ');
        }
        if (sb.charAt(sb.length() - 1) == ' ') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private Version getGitVersion() {
        Version version;
        block9: {
            version = null;
            Process process = null;
            BufferedReader reader = null;
            try {
                try {
                    process = DVTUtilsCommon.INSTANCE.startProcess(Arrays.asList("git", "--version"), null);
                    reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    String output = reader.lines().collect(Collectors.joining("\n"));
                    if (output.startsWith(GIT_VERSION_STRING)) {
                        try {
                            version = new Version(output.substring(GIT_VERSION_STRING.length()));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            version = null;
                        }
                    }
                    if (version == null) {
                        throw new IllegalArgumentException(new StringBuilder(128).append("Unknown git version!").append('\n').append("Output: ").append(output).toString());
                    }
                }
                catch (IOException | IllegalArgumentException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    DVTUtilsCommon.INSTANCE.closeClosable(reader);
                    DVTUtilsCommon.INSTANCE.killProcess(process);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DVTUtilsCommon.INSTANCE.closeClosable(reader);
                DVTUtilsCommon.INSTANCE.killProcess(process);
                throw throwable;
            }
            DVTUtilsCommon.INSTANCE.closeClosable((Closeable)reader);
            DVTUtilsCommon.INSTANCE.killProcess(process);
        }
        return version;
    }

    /*
     * Loose catch block
     */
    public String getCommiterDate() {
        block7: {
            String string;
            ArrayList<String> command = new ArrayList<String>();
            command.add("git");
            command.add("show");
            command.add("-s");
            command.add("--pretty=%cD");
            Process process = null;
            BufferedReader reader = null;
            try {
                process = DVTUtilsCommon.INSTANCE.startProcess(command, null);
                reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                string = reader.readLine();
                DVTUtilsCommon.INSTANCE.closeClosable((Closeable)reader);
            }
            catch (IOException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                break block7;
            }
            catch (IllegalArgumentException e2) {
                DVTLogger.INSTANCE.logDebug(e2.getMessage());
                break block7;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                DVTUtilsCommon.INSTANCE.closeClosable(reader);
                DVTUtilsCommon.INSTANCE.killProcess(process);
            }
            DVTUtilsCommon.INSTANCE.killProcess(process);
            return string;
        }
        return "";
    }
}

