/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.annotations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceHit;
import ro.amiq.vlogdt.linter.annotations.Annotation;
import ro.amiq.vlogdt.linter.annotations.AnnotationHitProcessor;
import ro.amiq.vlogdt.linter.annotations.AnnotationLineProcessor;
import ro.amiq.vlogdt.linter.annotations.AnnotationLocation;
import ro.amiq.vlogdt.linter.annotations.AnnotationProcessor;
import ro.amiq.vlogdt.linter.annotations.AnnotationResults;
import ro.amiq.vlogdt.linter.annotations.AnnotationType;

public class AnnotationManager {
    private final Set<Annotation> annotations = new LinkedHashSet<Annotation>();

    public void addAnnotation(String name, AnnotationType type, Set<AnnotationLocation> locations, Object ... args) {
        if (name == null) {
            return;
        }
        this.annotations.add(new Annotation(this.annotations.size(), name, type, locations, args));
    }

    public void addAnnotations(Set<Annotation> newAnnotations) {
        for (Annotation annotation : newAnnotations) {
            this.annotations.add(new Annotation(this.annotations.size(), annotation.getName(), annotation.getType(), annotation.getLocations(), annotation.getArgs()));
        }
    }

    public Set<Annotation> getAnnotations() {
        return this.annotations;
    }

    public Set<Annotation> getAnnotationOfType(AnnotationType type) {
        HashSet<Annotation> result = new HashSet<Annotation>();
        for (Annotation annotation : this.annotations) {
            if (!annotation.getType().equals((Object)type)) continue;
            result.add(annotation);
        }
        return result;
    }

    public AnnotationResults process(List<OVMComplianceCategory> categories, IProgressMonitor monitor) {
        AnnotationResults results = new AnnotationResults(this.annotations.size());
        EnumMap<AnnotationType, ArrayList<Annotation>> annotationsByTypeMap = new EnumMap<AnnotationType, ArrayList<Annotation>>(AnnotationType.class);
        int index = 0;
        for (Annotation annotation : this.annotations) {
            AnnotationType type2 = annotation.getType();
            ArrayList<Annotation> annotationsList = (ArrayList<Annotation>)annotationsByTypeMap.get((Object)type2);
            if (annotationsList == null) {
                annotationsList = new ArrayList<Annotation>();
                annotationsByTypeMap.put(type2, annotationsList);
            }
            annotationsList.add(annotation);
            results.addInfo(index, annotation.getName(), annotation.getLocations(), type2.ordinal());
            ++index;
        }
        HashMap<String, List<Integer>> linesByFileMap = new HashMap<String, List<Integer>>();
        if (annotationsByTypeMap.keySet().stream().anyMatch(type -> type.getProcessor() instanceof AnnotationLineProcessor)) {
            for (OVMComplianceCategory oVMComplianceCategory : categories) {
                for (OVMComplianceCheck check : oVMComplianceCategory.getChecks()) {
                    for (OVMComplianceHit oVMComplianceHit : check.getVisibleHits()) {
                        int line;
                        String file;
                        ParserPath parsrPath = oVMComplianceHit.getParserPath();
                        if (parsrPath == null || (file = parsrPath.path) == null || file.equals("none") || (line = oVMComplianceHit.getLine()) < 1) continue;
                        ArrayList<Integer> linesList = (ArrayList<Integer>)linesByFileMap.get(file);
                        if (linesList == null) {
                            linesList = new ArrayList<Integer>();
                            linesByFileMap.put(file, linesList);
                        }
                        linesList.add(line);
                    }
                }
            }
            for (List list : linesByFileMap.values()) {
                Collections.sort(list);
            }
        }
        for (Map.Entry entry : annotationsByTypeMap.entrySet()) {
            if (((AnnotationType)((Object)entry.getKey())).equals((Object)AnnotationType.LABEL)) continue;
            AnnotationProcessor processor = ((AnnotationType)((Object)entry.getKey())).getProcessor();
            if (processor instanceof AnnotationLineProcessor) {
                ((AnnotationLineProcessor)processor).process((List)entry.getValue(), linesByFileMap, results, monitor);
                continue;
            }
            if (!(processor instanceof AnnotationHitProcessor)) continue;
            ((AnnotationHitProcessor)processor).process((List)entry.getValue(), categories, results, monitor);
        }
        return results;
    }
}

