/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.annotations;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import ro.amiq.vlogdt.linter.annotations.AnnotationField;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum AnnotationP4Field implements AnnotationField
{
    REVISION_NUMBER{

        @Override
        public String prettify(String string) {
            return string.endsWith(":") ? string.substring(0, string.length() - 1) : string;
        }
    }
    ,
    AUTHOR,
    DATE{

        @Override
        public String prettify(String string) {
            try {
                return LocalDate.parse(string, P4_DATE_FORMATER).format(DEFAULT_DATE_FORMATTER);
            }
            catch (NumberFormatException numberFormatException) {
                return string;
            }
        }
    };

    private static final DateTimeFormatter P4_DATE_FORMATER;

    static {
        P4_DATE_FORMATER = DateTimeFormatter.ofPattern("yyyy/MM/dd");
    }

    public String toString() {
        return this.name().replace('_', '-').toLowerCase();
    }
}

