/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.annotations;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.vlogdt.linter.annotations.Annotation;
import ro.amiq.vlogdt.linter.annotations.AnnotationLineProcessor;
import ro.amiq.vlogdt.linter.annotations.AnnotationP4Field;
import ro.amiq.vlogdt.linter.annotations.AnnotationResults;

public enum AnnotationP4Processor implements AnnotationLineProcessor
{
    INSTANCE;


    @Override
    public void process(List<Annotation> annotations, Map<String, List<Integer>> lineByFileMap, AnnotationResults results, IProgressMonitor monitor) {
        try {
            int iterations = lineByFileMap.size();
            monitor.beginTask("Gathering P4 annotate information...", iterations);
            if (monitor.isCanceled()) {
                return;
            }
            EnumMap indexesByFieldMap = new EnumMap(AnnotationP4Field.class);
            HashMap fieldsByNameMap = new HashMap();
            this.extractMapsFromAnnotationArgs(annotations, 0, indexesByFieldMap, fieldsByNameMap);
            AtomicInteger iteration = new AtomicInteger(0);
            lineByFileMap.entrySet().parallelStream().forEach(lineByFileEntry -> {
                if (monitor.isCanceled()) {
                    return;
                }
                monitor.subTask("Running P4 annotate (" + iteration.incrementAndGet() + "/" + iterations + ") " + (String)lineByFileEntry.getKey());
                this.processFile((String)lineByFileEntry.getKey(), (List)lineByFileEntry.getValue(), indexesByFieldMap, results);
                monitor.worked(1);
            });
        }
        finally {
            monitor.done();
        }
    }

    private void processFile(String file, List<Integer> lines, Map<AnnotationP4Field, Set<Integer>> indexByFieldMap, AnnotationResults results) {
        block8: {
            ArrayList<String> command = new ArrayList<String>();
            command.add("p4");
            command.add("annotate");
            command.add("-qu");
            command.add(file);
            Process process = null;
            BufferedReader reader = null;
            try {
                process = DVTUtilsCommon.INSTANCE.startProcess(command, new File(file).getParentFile());
                reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                StreamTokenizer tokenizer = new StreamTokenizer(reader);
                tokenizer.resetSyntax();
                tokenizer.wordChars(0, 255);
                tokenizer.whitespaceChars(0, 32);
                tokenizer.eolIsSignificant(true);
                int currentLine = 0;
                int lastLine = lines.get(lines.size() - 1);
                while (currentLine <= lastLine) {
                    if (!lines.contains(currentLine)) {
                        this.skipLine(tokenizer);
                        ++currentLine;
                        continue;
                    }
                    String[] annotationStrings = new String[results.getInfos().length];
                    tokenizer.nextToken();
                    this.createResultString(indexByFieldMap, AnnotationP4Field.REVISION_NUMBER, tokenizer.sval, annotationStrings);
                    tokenizer.nextToken();
                    this.createResultString(indexByFieldMap, AnnotationP4Field.AUTHOR, tokenizer.sval, annotationStrings);
                    tokenizer.nextToken();
                    this.createResultString(indexByFieldMap, AnnotationP4Field.DATE, tokenizer.sval, annotationStrings);
                    results.addStrings(file, currentLine, annotationStrings);
                    this.skipLine(tokenizer);
                    ++currentLine;
                }
            }
            catch (IOException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                DVTUtilsCommon.INSTANCE.closeClosable(reader);
                DVTUtilsCommon.INSTANCE.killProcess(process);
                break block8;
            }
            catch (IllegalArgumentException e) {
                try {
                    DVTLogger.INSTANCE.logDebug(e.getMessage());
                }
                catch (Throwable throwable) {
                    DVTUtilsCommon.INSTANCE.closeClosable(reader);
                    DVTUtilsCommon.INSTANCE.killProcess(process);
                    throw throwable;
                }
                DVTUtilsCommon.INSTANCE.closeClosable(reader);
                DVTUtilsCommon.INSTANCE.killProcess(process);
                break block8;
            }
            DVTUtilsCommon.INSTANCE.closeClosable((Closeable)reader);
            DVTUtilsCommon.INSTANCE.killProcess(process);
        }
    }

    private void createResultString(Map<AnnotationP4Field, Set<Integer>> indexByFieldMap, AnnotationP4Field field, String string, String[] annotationStrings) {
        Set<Integer> indexes = indexByFieldMap.get(field);
        if (indexes != null) {
            for (Integer index : indexes) {
                annotationStrings[index.intValue()] = field.prettify(string);
            }
        }
    }

    public String getP4ClientRoot() {
        String clientRoot;
        block8: {
            Process process = null;
            clientRoot = null;
            BufferedReader reader = null;
            try {
                try {
                    process = DVTUtilsCommon.INSTANCE.startProcess(Arrays.asList("p4", "info"), null);
                    reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    StreamTokenizer tokenizer = new StreamTokenizer(reader);
                    tokenizer.resetSyntax();
                    tokenizer.wordChars(0, 255);
                    tokenizer.whitespaceChars(0, 32);
                    tokenizer.eolIsSignificant(true);
                    int token = -4;
                    while ((token = tokenizer.nextToken()) != -1) {
                        if (token != -3) continue;
                        if (tokenizer.sval.startsWith("Client")) {
                            token = tokenizer.nextToken();
                            if (tokenizer.sval.startsWith("root")) {
                                token = tokenizer.nextToken();
                                clientRoot = tokenizer.sval;
                            }
                        }
                        this.skipLine(tokenizer);
                    }
                }
                catch (IOException | IllegalArgumentException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    DVTUtilsCommon.INSTANCE.closeClosable(reader);
                    DVTUtilsCommon.INSTANCE.killProcess(process);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DVTUtilsCommon.INSTANCE.closeClosable(reader);
                DVTUtilsCommon.INSTANCE.killProcess(process);
                throw throwable;
            }
            DVTUtilsCommon.INSTANCE.closeClosable((Closeable)reader);
            DVTUtilsCommon.INSTANCE.killProcess(process);
        }
        return clientRoot;
    }
}

